% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bspline.R
\name{bsp}
\alias{bsp}
\title{Calculate B-spline values from their coefficients qw and knots xk}
\usage{
bsp(x, xk, qw, n = 3L)
}
\arguments{
\item{x}{Numeric vector, abscissa points at which B-splines should be calculated.
They are supposed to be non decreasing.}

\item{xk}{Numeric vector, knots of the B-splines. They are supposed to be non decreasing.}

\item{qw}{Numeric vector or matrix, coefficients of B-splines. \code{NROW(qw)}
must be equal to \code{length(xk)-n-1} where \code{n} is the next parameter}

\item{n}{Integer scalar, polynomial order of B-splines, by default cubic splines
are calculated.}
}
\value{
Numeric matrix (column number depends on qw dimensions), B-spline values on x.
}
\description{
Calculate B-spline values from their coefficients qw and knots xk
}
\details{
This function does nothing else than calculate a dot-product between
  a B-spline basis matrix calculated by \code{bsc()} and coefficients \code{qw}.
  If qw is a matrix, each
  column corresponds to a separate set of coefficients.
  For x values falling outside of xk range, the B-splines values are set to 0.
  To get a function calculating spline values at arbitrary points from \code{xk}
  and \code{qw}, cf. \code{par2bsp()}.
}
\seealso{
{bsc}, {par2bsp}
}
