% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/log_read.R
\name{log_read}
\alias{log_read}
\title{Read a log.}
\usage{
log_read(
  path,
  units_cpu = c("percentage", "fraction"),
  units_memory = c("megabytes", "bytes", "kilobytes", "gigabytes"),
  units_time = c("seconds", "minutes", "hours", "days"),
  hidden = FALSE
)
}
\arguments{
\item{path}{Character vector of paths to files and/or directories
of logs to read.}

\item{units_cpu}{Character string with the units of the \code{cpu} field.
Defaults to \code{"percentage"} and must be in \code{c("percentage", "fraction")}.}

\item{units_memory}{Character string with the units of the
\code{memory} field. Defaults to \code{"megabytes"} and must be in
\code{c("megabytes", "bytes", "kilobytes", "gigabytes")}.}

\item{units_time}{Character string, units of the \code{time} field.
Defaults to \code{"seconds"} and must be in
\code{c("seconds", "minutes", "hours", "days")}.}

\item{hidden}{\code{TRUE} to include hidden files in the files and directories
listed in \code{path}, \code{FALSE} to omit.}
}
\value{
A data frame of metrics from the log with one row per log entry
and columns with metadata and resource usage metrics.
\code{\link[=log_read]{log_read()}} automatically converts the data into the units
chosen with arguments \code{units_time}, \code{units_cpu}, and \code{units_memory}.
The returned data frame has the following columns:
\itemize{
\item \code{version}: Version of the package used to write the log entry.
\item \code{pid}: Process ID monitored.
\item \code{status}: A status code for the log entry. Status 0 means
logging succeeded. A status code not equal to 0 indicates
something went wrong and the metrics should not be trusted.
\item \code{time}: numeric time stamp at which the entry was logged.
\code{\link[=log_read]{log_read()}} automatically recenters this column so that time 0
indicates the first logged entry.
Use the \code{units_time} argument to customize the units of this field.
\item \code{core}: CPU load of the process scaled relative to a single
CPU core. Measures the amount of time the process spends running
during a given interval of elapsed time.

On Mac OS, the package uses native system calls to get CPU core usage.
On Linux and Windows, the package calculates it manually using.
user + kernel clock cycles that ran during a sampling interval.
It measures the clock cycles that the process executed during
the interval, converts the clock cycles into seconds,
then divides the result by the elapsed time of the interval.
The length of the sampling interval is the \code{seconds} argument
supplied to \code{\link[=log_start]{log_start()}}, or length of time between
calls to \code{\link[=log_print]{log_print()}}.
The first \code{core} measurement is 0 to reflect that a full sampling
interval has not elapsed yet.

\code{core} can be read in as a percentage or fraction, depending on
the \code{units_cpu} argument.
\item \code{cpu}: \code{core} divided by the number of logical CPU cores.
This metric measures the load on the machine as a whole,
not just the CPU core it runs on.
Use the \code{units_cpu} argument to customize the units of this field.
\item \code{rss}: resident set size, the total amount of memory used by the
process at the time of logging. This include the memory unique
to the process (unique set size USS) and shared memory.
Use the \code{units_memory} argument to customize the units of this field.
\item \code{virtual}: total virtual memory available to the process.
The process does not necessarily use all this memory, but
it can request more virtual memory throughout its life cycle.
Use the \code{units_memory} argument to customize the units of this field.
}
}
\description{
Read a log file into R.
}
\details{
\code{\link[=log_read]{log_read()}} is capable of reading a log file where both
\code{autometric} and other processes have printed. Whenever \code{autometric}
writes to a log, it bounds the beginning and end of the text
with the keyword  \code{"__AUTOMETRIC__"}.
that way, \code{\link[=log_read]{log_read()}} knows to only read and process the correct
lines of the file.

In addition, it automatically converts the log data
into the units  \code{units_time},
\code{units_cpu}, and \code{units_memory} arguments.
}
\examples{
  path <- tempfile()
  log_start(seconds = 0.5, path = path)
  Sys.sleep(2)
  log_stop()
  Sys.sleep(2)
  log_read(path)
  unlink(path)
}
