% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-matrix.R, R/is-matrix.R
\name{assert_is_identity_matrix}
\alias{assert_is_identity_matrix}
\alias{is_identity_matrix}
\title{Is the matrix an identity matrix?}
\usage{
assert_is_identity_matrix(x, tol = 100 * .Machine$double.eps,
  severity = getOption("assertive.severity", "stop"))

is_identity_matrix(x, tol = 100 * .Machine$double.eps,
  .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{tol}{Abolute deviations from the expected values smaller than 
\code{tol} are not considered.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{TRUE} if the input is all zeroes (after coercion to be a 
matrix).
}
\description{
Checks that the input is an identity matrix.
}
\examples{
x <- diag(3)
is_identity_matrix(x)
x[1, 2] <- 100 * .Machine$double.eps
is_identity_matrix(x)
x[2, 3] <- 101 * .Machine$double.eps
is_identity_matrix(x)
}
