% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcgBallPivoting.r
\name{vcgBallPivoting}
\alias{vcgBallPivoting}
\title{Ball pivoting surface reconstruction}
\usage{
vcgBallPivoting(
  x,
  radius = 0,
  clustering = 0.2,
  angle = pi/2,
  deleteFaces = FALSE
)
}
\arguments{
\item{x}{k x 3 matrix or object of class mesh3d}

\item{radius}{The radius of the ball pivoting (rolling) over the set of points. Gaps that are larger than the ball radius will not be filled; similarly the small pits that are smaller than the ball radius will be filled. 0 = autoguess.}

\item{clustering}{Clustering radius (fraction of ball radius). To avoid the creation of too small triangles, if a vertex is found too close to a previous one, it is clustered/merged with it.}

\item{angle}{Angle threshold (radians). If we encounter a crease angle that is too large we should stop the ball rolling.}

\item{deleteFaces}{in case x is a mesh and \code{deleteFaces=TRUE}, existing faces will be deleted beforehand.}
}
\value{
triangular face of class mesh3d
}
\description{
Ball pivoting surface reconstruction
}
\examples{
if (requireNamespace("Morpho", quietly = TRUE)) {
require(Morpho)
data(nose)
nosereko <- vcgBallPivoting(shortnose.lm)
}

}
