% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{effect.ivpml}
\alias{effect.ivpml}
\alias{summary.effect.ivpml}
\alias{print.effect.ivpml}
\alias{print.summary.effect.ivpml}
\title{Get average marginal effects for IV Probit model.}
\usage{
\method{effect}{ivpml}(
  object,
  vcov = NULL,
  asf = TRUE,
  digits = max(3, getOption("digits") - 2),
  ...
)

\method{summary}{effect.ivpml}(object, ...)

\method{print}{effect.ivpml}(x, ...)

\method{print}{summary.effect.ivpml}(x, digits = max(3, getOption("digits") - 3), ...)
}
\arguments{
\item{object}{an object of class \code{ivpml} and \code{effect.ivpml} for \code{summary} and \code{print} method.}

\item{vcov}{an estimate of the asymptotic variance-covariance matrix of the parameters for a \code{ivpml} object.}

\item{asf}{if \code{TRUE}, the average structural function is used.}

\item{digits}{the number of digits.}

\item{...}{further arguments.Ignored.}

\item{x}{an object of class \code{effect.ivpml}.}
}
\value{
An object of class \code{effect.ivpml}.
}
\description{
Obtain the average marginal effects from \code{ivpml} class model.
}
\details{
This function allows to obtain the average marginal effects (not the marginal effects at the mean). The standard errors are computed using Delta Method.
}
\examples{
\donttest{ 
# Data
library("AER")
data("PSID1976")
PSID1976$lfp  <- as.numeric(PSID1976$participation == "yes")
PSID1976$kids <- with(PSID1976, factor((youngkids + oldkids) > 0,
                                      levels = c(FALSE, TRUE), 
                                      labels = c("no", "yes")))
                                      
# Average marginal effects for IV probit model 
# (nwincome is endogenous and heducation is the additional instrument)
PSID1976$nwincome <- with(PSID1976, (fincome - hours * wage)/1000)
fiml.probit <- ivpml(lfp ~  education + experience + I(experience^2) + age + 
                            youngkids + oldkids + nwincome |
                            education + experience + I(experience^2) + age + 
                            youngkids + oldkids + heducation, 
                     data = PSID1976)
summary(effect(fiml.probit))
summary(effect(fiml.probit, asf = FALSE))
} 
}
\author{
Mauricio Sarrias.
}
