% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTrace.R
\name{tracePlot}
\alias{tracePlot}
\title{Trace plot for MCMC class}
\usage{
tracePlot(sampler, thin = "auto", ...)
}
\arguments{
\item{sampler}{an object of class MCMC sampler}

\item{thin}{determines the thinning intervall of the chain}

\item{...}{additional parameters to pass on to the \code{\link{getSample}}, for example parametersOnly =F, or start = 1000}
}
\description{
Trace plot for MCMC class
}
\examples{
# set up and run the MCMC
ll <- function(x) sum(dnorm(x, log = TRUE))
setup <- createBayesianSetup(likelihood = ll, lower = c(-10, -10), upper = c(10,10))
settings <- list(iterations = 2000)
out <- runMCMC(bayesianSetup = setup, settings = settings, sampler = "Metropolis")

# plot the trace
tracePlot(sampler = out, thin = 10)
tracePlot(sampler = out, thin = 50)

# additional parameters can be passed on to getSample (see help)
tracePlot(sampler = out, thin = 10, start = 500)
# select parameter by index
tracePlot(sampler = out, thin = 10, start = 500, whichParameters = 2)
}
\seealso{
\code{\link{marginalPlot}} \cr
\code{\link{plotTimeSeries}} \cr
\code{\link{correlationPlot}}
}
