\name{getProbeData_1lq}
\alias{getProbeData_1lq}
\title{Read a 1lq file for an Affymetrix genechip}
\description{Read a 1lq file for an Affymetrix genechip}
\usage{
getProbeData_1lq(arraytype, datafile, pkgname = NULL)
}
\arguments{
  \item{arraytype}{Character. Array type (e.g. 'Scerevisiaetiling)}
  \item{datafile}{Character. The filename of the input data file.
    If omitted a default name is constructed from \code{arraytype}
    (see this function's source code).}
  \item{pkgname}{Character. Package name. If NULL the name is derived
    from \code{arraytype}.}
}
\details{This function serves as an interface between
  the (1) representation of array probe information data in the packages
  that are generated by \code{\link{makeProbePackage}} and (2) the
  vendor- and possibly version-specific way the data are represented
  in \code{datafile}.
}

\value{A list with three components
    \item{dataEnv}{an environment which contains the data frame with the
      probe sequences and the other probe data.}
    \item{symVal}{a named list of symbol value substitutions which can
      be used to customize the man pages. See
      \code{\link[Biobase:createPackage]{createPackage}}.}
    \item{pkgname}{a character with the package name; will be the same
      as the function parameter \code{pkgname} if it was specified;
      otherwise, the name is constructed from the parameter \code{arraytype}.}
}

\seealso{makeProbePackage}
\examples{
## makeProbePackage(
##    arraytype = "Scerevisiaetiling",
##    maintainer= "Wolfgang Huber <huber@ebi.ac.uk>",
##    version   = "1.1.0",
##    datafile  = "S.cerevisiae_tiling.1lq",
##    importfun = "getProbeData_1lq")
}
\keyword{IO}
\keyword{utilities}
