#include "core/formula.h"

using namespace std;
using namespace tex;

map<wstring, wstring> Formula::_predefinedTeXFormulasAsString{
  {L"qquad",              L"\\quad\\quad"},
  {L" ",                  L"\\nbsp"},
  {L"ne",                 L"\\not\\equals"},
  {L"neq",                L"\\not\\equals"},
  {L"ldots",              L"\\mathinner{\\ldotp\\ldotp\\ldotp}"},
  {L"dotsc",              L"\\ldots"},
  {L"dots",               L"\\ldots"},
  {L"cdots",              L"\\mathinner{\\cdotp\\cdotp\\cdotp}"},
  {L"dotsb",              L"\\cdots"},
  {L"dotso",              L"\\ldots"},
  {L"dotsi",              L"\\!\\cdots"},
  {L"bowtie",             L"\\mathrel\\triangleright\\joinrel\\mathrel\\triangleleft"},
  {L"models",             L"\\mathrel|\\joinrel\\equals"},
  {L"Doteq",              L"\\doteqdot"},
  {L"{",                  L"\\lbrace"},
  {L"}",                  L"\\rbrace"},
  {L"|",                  L"\\Vert"},
  {L"&",                  L"\\textampersand"},
  {L"%",                  L"\\textpercent"},
  {L"_",                  L"\\underscore"},
  {L"$",                  L"\\textdollar"},
  {L"@",                  L"\\matharobase"},
  {L"#",                  L"\\mathsharp"},
  {L"relbar",             L"\\mathrel{\\smash-}"},
  {L"hookrightarrow",     L"\\lhook\\joinrel\\joinrel\\joinrel\\rightarrow"},
  {L"hookleftarrow",      L"\\leftarrow\\joinrel\\joinrel\\joinrel\\rhook"},
  {L"Longrightarrow",     L"\\Relbar\\joinrel\\Rightarrow"},
  {L"longrightarrow",     L"\\relbar\\joinrel\\rightarrow"},
  {L"Longleftarrow",      L"\\Leftarrow\\joinrel\\Relbar"},
  {L"longleftarrow",      L"\\leftarrow\\joinrel\\relbar"},
  {L"Longleftrightarrow", L"\\Leftarrow\\joinrel\\Rightarrow"},
  {L"longleftrightarrow", L"\\leftarrow\\joinrel\\rightarrow"},
  {L"iff",                L"\\;\\Longleftrightarrow\\;"},
  {L"implies",            L"\\;\\Longrightarrow\\;"},
  {L"impliedby",          L"\\;\\Longleftarrow\\;"},
  {L"mapsto",             L"\\mapstochar\\rightarrow"},
  {L"longmapsto",         L"\\mapstochar\\longrightarrow"},
  {L"log",                L"\\mathop{\\mathrm{log}}\\nolimits"},
  {L"lg",                 L"\\mathop{\\mathrm{lg}}\\nolimits"},
  {L"ln",                 L"\\mathop{\\mathrm{ln}}\\nolimits"},
  {L"ln",                 L"\\mathop{\\mathrm{ln}}\\nolimits"},
  {L"lim",                L"\\mathop{\\mathrm{lim}}"},
  {L"limsup",             L"\\mathop{\\mathrm{lim\\,sup}}"},
  {L"liminf",             L"\\mathop{\\mathrm{lim\\,inf}}"},
  {L"injlim",             L"\\mathop{\\mathrm{inj\\,lim}}"},
  {L"projlim",            L"\\mathop{\\mathrm{proj\\,lim}}"},
  {L"varinjlim",          L"\\mathop{\\underrightarrow{\\mathrm{lim}}}"},
  {L"varprojlim",         L"\\mathop{\\underleftarrow{\\mathrm{lim}}}"},
  {L"varliminf",          L"\\mathop{\\underline{\\mathrm{lim}}}"},
  {L"varlimsup",          L"\\mathop{\\overline{\\mathrm{lim}}}"},
  {L"sin",                L"\\mathop{\\mathrm{sin}}\\nolimits"},
  {L"arcsin",             L"\\mathop{\\mathrm{arcsin}}\\nolimits"},
  {L"sinh",               L"\\mathop{\\mathrm{sinh}}\\nolimits"},
  {L"cos",                L"\\mathop{\\mathrm{cos}}\\nolimits"},
  {L"arccos",             L"\\mathop{\\mathrm{arccos}}\\nolimits"},
  {L"cot",                L"\\mathop{\\mathrm{cot}}\\nolimits"},
  {L"arccot",             L"\\mathop{\\mathrm{arccot}}\\nolimits"},
  {L"cosh",               L"\\mathop{\\mathrm{cosh}}\\nolimits"},
  {L"tan",                L"\\mathop{\\mathrm{tan}}\\nolimits"},
  {L"arctan",             L"\\mathop{\\mathrm{arctan}}\\nolimits"},
  {L"tanh",               L"\\mathop{\\mathrm{tanh}}\\nolimits"},
  {L"coth",               L"\\mathop{\\mathrm{coth}}\\nolimits"},
  {L"sec",                L"\\mathop{\\mathrm{sec}}\\nolimits"},
  {L"arcsec",             L"\\mathop{\\mathrm{arcsec}}\\nolimits"},
  {L"arccsc",             L"\\mathop{\\mathrm{arccsc}}\\nolimits"},
  {L"sech",               L"\\mathop{\\mathrm{sech}}\\nolimits"},
  {L"csc",                L"\\mathop{\\mathrm{csc}}\\nolimits"},
  {L"csch",               L"\\mathop{\\mathrm{csch}}\\nolimits"},
  {L"max",                L"\\mathop{\\mathrm{max}}"},
  {L"min",                L"\\mathop{\\mathrm{min}}"},
  {L"sup",                L"\\mathop{\\mathrm{sup}}"},
  {L"inf",                L"\\mathop{\\mathrm{inf}}"},
  {L"arg",                L"\\mathop{\\mathrm{arg}}\\nolimits"},
  {L"ker",                L"\\mathop{\\mathrm{ker}}\\nolimits"},
  {L"dim",                L"\\mathop{\\mathrm{dim}}\\nolimits"},
  {L"hom",                L"\\mathop{\\mathrm{hom}}\\nolimits"},
  {L"det",                L"\\mathop{\\mathrm{det}}"},
  {L"exp",                L"\\mathop{\\mathrm{exp}}\\nolimits"},
  {L"Pr",                 L"\\mathop{\\mathrm{Pr}}"},
  {L"gcd",                L"\\mathop{\\mathrm{gcd}}"},
  {L"deg",                L"\\mathop{\\mathrm{deg}}\\nolimits"},
  {L"bmod",               L"\\:\\mathbin{\\mathrm{mod}}\\:"},
  {L"Mapsto",             L"\\Mapstochar\\Rightarrow"},
  {L"mapsfrom",           L"\\leftarrow\\mapsfromchar"},
  {L"Mapsfrom",           L"\\Leftarrow\\Mapsfromchar"},
  {L"Longmapsto",         L"\\Mapstochar\\Longrightarrow"},
  {L"longmapsfrom",       L"\\longleftarrow\\mapsfromchar"},
  {L"Longmapsfrom",       L"\\Longleftarrow\\Mapsfromchar"},
  {L"arrowvert",          L"\\vert"},
  {L"Arrowvert",          L"\\Vert"},
  {L"aa",                 L"\\mathring{a}"},
  {L"AA",                 L"\\mathring{A}"},
  {L"ddag",               L"\\ddagger"},
  {L"dag",                L"\\dagger"},
  {L"Doteq",              L"\\doteqdot"},
  {L"doublecup",          L"\\Cup"},
  {L"doublecap",          L"\\Cap"},
  {L"llless",             L"\\lll"},
  {L"gggtr",              L"\\ggg"},
  {L"Alpha",              L"\\mathord{\\mathrm{A}}"},
  {L"Beta",               L"\\mathord{\\mathrm{B}}"},
  {L"Epsilon",            L"\\mathord{\\mathrm{E}}"},
  {L"Zeta",               L"\\mathord{\\mathrm{Z}}"},
  {L"Eta",                L"\\mathord{\\mathrm{H}}"},
  {L"Iota",               L"\\mathord{\\mathrm{I}}"},
  {L"Kappa",              L"\\mathord{\\mathrm{K}}"},
  {L"Mu",                 L"\\mathord{\\mathrm{M}}"},
  {L"Nu",                 L"\\mathord{\\mathrm{N}}"},
  {L"Omicron",            L"\\mathord{\\mathrm{O}}"},
  {L"Rho",                L"\\mathord{\\mathrm{P}}"},
  {L"Tau",                L"\\mathord{\\mathrm{T}}"},
  {L"Chi",                L"\\mathord{\\mathrm{X}}"},
  {L"hdots",              L"\\ldots"},
  {L"restriction",        L"\\upharpoonright"},
  {L"celsius",            L"\\mathord{{}^\\circ\\mathrm{C}}"},
  {L"micro",              L"\\textmu"},
  {L"marker",             L"\\kern{0.25ex}\\rule{0.5ex}{1.2ex}\\kern{0.25ex}"},
  {L"hybull",             L"\\rule[0.6ex]{1ex}{0.2ex}"},
  {L"block",              L"\\rule{1ex}{1.2ex}"},
  {L"uhblk",              L"\\rule[0.6ex]{1ex}{0.6ex}"},
  {L"lhblk",              L"\\rule{1ex}{0.6ex}"},
  {L"notin",              L"\\not\\in"},
  {L"rVert",              L"\\Vert"},
  {L"lVert",              L"\\Vert"},
  {L"lvert",              L"\\vert"},
  {L"rvert",              L"\\vert"},
  {L"Android",            L"\\Huge{\\android}\\normalsize"},
  {L"AndroidTeX",         L"\\Android\\large{\\dT\\dE\\dX}\\normalsize"},
  {L"TeX",                L"\\large{\\dT\\dE\\dX}\\normalsize"},
  {L"LaTeX",              L"\\text{L\\kern-0.4em\\raisebox{.45ex}{\\scalebox{0.7}{A}}\\kern-.2em T\\kern-.15em\\raisebox{-.5ex}{E}\\kern-.15em X}"},
};
