'\"
'\" Generated from file 'yaml\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2008 KATO Kanryu <kanryu6@users\&.sourceforge\&.net>
'\"
.TH "yaml" n 0\&.3\&.9 tcllib "YAML processing"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
yaml \- YAML Format Encoder/Decoder
.SH SYNOPSIS
package require \fBTcl  8\&.4\fR
.sp
package require \fByaml  ?0\&.3\&.9?\fR
.sp
\fB::yaml::yaml2dict\fR ?\fIoptions\fR? \fItxt\fR
.sp
\fB::yaml::yaml2huddle\fR ?\fIoptions\fR? \fItxt\fR
.sp
\fB::yaml::setOption\fR ?\fIoptions\fR?
.sp
\fB::yaml::dict2yaml\fR \fIdict\fR ?\fIindent\fR? ?\fIwordwrap\fR?
.sp
\fB::yaml::list2yaml\fR \fIlist\fR ?\fIindent\fR? ?\fIwordwrap\fR?
.sp
\fB::yaml::huddle2yaml\fR \fIhuddle\fR ?\fIindent\fR? ?\fIwordwrap\fR?
.sp
.BE
.SH DESCRIPTION
.PP
The \fByaml\fR package provides a simple Tcl-only library for parsing the
YAML \fIhttp://www\&.yaml\&.org/\fR data exchange format as specified in
\fIhttp://www\&.yaml\&.org/spec/1\&.1/\fR\&.
.PP
The \fByaml\fR package returns
data as a Tcl \fBdict\fR\&.  Either the \fBdict\fR package or Tcl 8\&.5 is
required for use\&.
.SH COMMANDS
.TP
\fB::yaml::yaml2dict\fR ?\fIoptions\fR? \fItxt\fR
.TP
\fB::yaml::yaml2huddle\fR ?\fIoptions\fR? \fItxt\fR
Parse yaml formatted text \fItxt\fR into a Tcl dict/huddle and return the value\&.
.RS
.TP
\fB\fB-file\fR\fR
\fItxt\fR is a filename of YAML-stream\&.
.TP
\fB\fB-stream\fR\fR
\fItxt\fR is just a YAML-stream\&.
.TP
\fB\fB-types\fR \fIlist\fR\fR
The \fIlist\fR is a type list for the yaml-scalar types\&.(e\&.g\&. !!str !!timestamp !!integer !!true \&.\&.\&.)
.CS

 -types {timestamp integer null true false}
.CE
.IP
In this case, if a string matched "timestamp", converted to the TCL internal timestamp\&.(e\&.g\&. "2001-12-15T02:59:43\&.1Z" => 1008385183)
.TP
\fB\fB-m:true\fR \fIparam\fR\fR
The \fIparam\fR is two elements of list for the value of true, and considered strings\&.
.CS

 -m:true {1 {true on + yes y}}
.CE
.IP
In this case, the string "yes" found in YAML Stream, automatically converted 1\&.
.TP
\fB\fB-m:false\fR \fIparam\fR\fR
The \fIparam\fR is two elements of list for the value of false, and considered strings\&.
.CS

 -m:false {0 {false off - no n}}
.CE
.TP
\fB\fB-m:null\fR \fIparam\fR\fR
The \fIparam\fR is two elements of list for the value of null, and considered strings\&.
.CS

 -m:null {"" {null nil "" ~}}
.CE
.TP
\fB\fB-validate\fR\fR
Experiment,old: Output stream contains YAML's-tag, each node\&.
.CS

% puts [::yaml::load -validate {[aaa, bbb]}]
=>
!!seq {{!!str aaa} {!!str bbb}}

.CE
.RE
.TP
\fB::yaml::setOption\fR ?\fIoptions\fR?
Change implicit options for the library\&.
Now, the params are the same as \fB::yaml::yaml2dict\fR\&.
Arguments of\fB::yaml::yaml2dict\fR is more priority than this setting\&.
.TP
\fB::yaml::dict2yaml\fR \fIdict\fR ?\fIindent\fR? ?\fIwordwrap\fR?
.TP
\fB::yaml::list2yaml\fR \fIlist\fR ?\fIindent\fR? ?\fIwordwrap\fR?
.TP
\fB::yaml::huddle2yaml\fR \fIhuddle\fR ?\fIindent\fR? ?\fIwordwrap\fR?
Convert a dict/list/huddle object into YAML stream\&.
.RS
.TP
indent
spaces indent of each block node\&.
currently default is 2\&.
.TP
wordwrap
word wrap for YAML stream\&.
currently default is 40\&.
.RE
.PP
.PP
.SH EXAMPLES
.PP
An example of a yaml stream converted to Tcl\&.  A yaml stream is returned as a
single item with multiple elements\&.
.PP
.CS

{
--- !<tag:clarkevans\&.com,2002:invoice>
invoice: 34843
date   : 2001-01-23
bill-to: &id001
    given  : Chris
    family : Dumars
    address:
        lines: |
            458 Walkman Dr\&.
            Suite #292
        city    : Royal Oak
        state   : MI
        postal  : 48046
ship-to: *id001
product:
    - sku         : BL394D
      quantity    : 4
      description : Basketball
      price       : 450\&.00
    - sku         : BL4438H
      quantity    : 1
      description : Super Hoop
      price       : 2392\&.00
tax  : 251\&.42
total: 4443\&.52
comments:
    Late afternoon is best\&.
    Backup contact is Nancy
    Billsmer @ 338-4338\&.
}
=>
invoice 34843 date 2001-01-23 bill-to {given Chris family Dumars address {lines {458 Walkman Dr\&.
Suite #292
} city {Royal Oak} state MI postal 48046}} ship-to {given Chris family Dumars address {lines {458 Walkman Dr\&.
Suite #292
} city {Royal Oak} state MI postal 48046}} product {{sku BL394D quantity 4 description Basketball price 450\&.00} {sku BL4438H quantity 1 description {Super Hoop} price 2392\&.00}} tax 251\&.42 total 4443\&.52 comments {Late afternoon is best\&. Backup contact is Nancy Billsmer @ 338-4338\&.}
.CE
.PP
An example of a yaml object converted to Tcl\&.  A yaml object is returned as a
multi-element list (a dict)\&.
.PP
.CS

{
---
- [name        , hr, avg  ]
- [Mark McGwire, 65, 0\&.278]
- [Sammy Sosa  , 63, 0\&.288]
-
  Mark McGwire: {hr: 65, avg: 0\&.278}
  Sammy Sosa: { hr: 63, avg: 0\&.288}
}
=>
{name hr avg} {{Mark McGwire} 65 0\&.278} {{Sammy Sosa} 63 0\&.288} {{Mark McGwire} {hr 65 avg 0\&.278} {Sammy Sosa} {hr 63 avg 0\&.288}}

.CE
.SH LIMITATIONS
.PP
tag parser not implemented\&. currentry, tags are merely ignored\&.
.PP
Only Anchor => Aliases ordering\&. back alias-referring is not supported\&.
.PP
Too many braces, or too few braces\&.
.PP
Not enough character set of line feeds\&. Please use only "\\n" as line breaks\&.
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIyaml\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH "SEE ALSO"
base64, huddle, json
.SH KEYWORDS
data exchange, huddle, parsing, text processing, yaml
.SH COPYRIGHT
.nf
Copyright (c) 2008 KATO Kanryu <kanryu6@users\&.sourceforge\&.net>

.fi