'\"
'\" Generated from file 'pt_rdengine\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>
'\"
.TH "pt::rde" n 1\&.1 tcllib "Parser Tools"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
pt::rde \- Parsing Runtime Support, PARAM based
.SH SYNOPSIS
package require \fBTcl  8\&.5\fR
.sp
package require \fBpt::rde  ?1\&.1?\fR
.sp
package require \fBsnit \fR
.sp
package require \fBstruct::stack  1\&.5\fR
.sp
package require \fBpt::ast  1\&.1\fR
.sp
\fB::pt::rde\fR \fIobjectName\fR
.sp
\fIobjectName\fR \fBdestroy\fR
.sp
\fIobjectName\fR \fBreset\fR \fIchan\fR
.sp
\fIobjectName\fR \fBcomplete\fR
.sp
\fIobjectName\fR \fBchan\fR
.sp
\fIobjectName\fR \fBline\fR
.sp
\fIobjectName\fR \fBcolumn\fR
.sp
\fIobjectName\fR \fBcurrent\fR
.sp
\fIobjectName\fR \fBlocation\fR
.sp
\fIobjectName\fR \fBlocations\fR
.sp
\fIobjectName\fR \fBok\fR
.sp
\fIobjectName\fR \fBvalue\fR
.sp
\fIobjectName\fR \fBerror\fR
.sp
\fIobjectName\fR \fBerrors\fR
.sp
\fIobjectName\fR \fBtokens\fR ?\fIfrom\fR ?\fIto\fR??
.sp
\fIobjectName\fR \fBsymbols\fR
.sp
\fIobjectName\fR \fBknown\fR
.sp
\fIobjectName\fR \fBreducible\fR
.sp
\fIobjectName\fR \fBasts\fR
.sp
\fIobjectName\fR \fBast\fR
.sp
\fIobjectName\fR \fBposition\fR \fIloc\fR
.sp
\fIobjectName\fR \fBi_input_next\fR \fImsg\fR
.sp
\fIobjectName\fR \fBi_test_alnum\fR
.sp
\fIobjectName\fR \fBi_test_alpha\fR
.sp
\fIobjectName\fR \fBi_test_ascii\fR
.sp
\fIobjectName\fR \fBi_test_char\fR \fIchar\fR
.sp
\fIobjectName\fR \fBi_test_ddigit\fR
.sp
\fIobjectName\fR \fBi_test_digit\fR
.sp
\fIobjectName\fR \fBi_test_graph\fR
.sp
\fIobjectName\fR \fBi_test_lower\fR
.sp
\fIobjectName\fR \fBi_test_print\fR
.sp
\fIobjectName\fR \fBi_test_punct\fR
.sp
\fIobjectName\fR \fBi_test_range\fR \fIchars\fR \fIchare\fR
.sp
\fIobjectName\fR \fBi_test_space\fR
.sp
\fIobjectName\fR \fBi_test_upper\fR
.sp
\fIobjectName\fR \fBi_test_wordchar\fR
.sp
\fIobjectName\fR \fBi_test_xdigit\fR
.sp
\fIobjectName\fR \fBi_error_clear\fR
.sp
\fIobjectName\fR \fBi_error_push\fR
.sp
\fIobjectName\fR \fBi_error_pop_merge\fR
.sp
\fIobjectName\fR \fBi_error_nonterminal\fR \fIsymbol\fR
.sp
\fIobjectName\fR \fBi_status_ok\fR
.sp
\fIobjectName\fR \fBi_status_fail\fR
.sp
\fIobjectName\fR \fBi_status_negate\fR
.sp
\fIobjectName\fR \fBi_loc_push\fR
.sp
\fIobjectName\fR \fBi_loc_pop_discard\fR
.sp
\fIobjectName\fR \fBi_loc_pop_rewind\fR
.sp
\fIobjectName\fR \fBi:ok_loc_pop_rewind\fR
.sp
\fIobjectName\fR \fBi_loc_pop_rewind/discard\fR
.sp
\fIobjectName\fR \fBi_symbol_restore\fR \fIsymbol\fR
.sp
\fIobjectName\fR \fBi_symbol_save\fR \fIsymbol\fR
.sp
\fIobjectName\fR \fBi_value_clear\fR
.sp
\fIobjectName\fR \fBi_value_clear/leaf\fR
.sp
\fIobjectName\fR \fBi_value_clear/reduce\fR
.sp
\fIobjectName\fR \fBi:ok_ast_value_push\fR
.sp
\fIobjectName\fR \fBi_ast_push\fR
.sp
\fIobjectName\fR \fBi_ast_pop_rewind\fR
.sp
\fIobjectName\fR \fBi:fail_ast_pop_rewind\fR
.sp
\fIobjectName\fR \fBi_ast_pop_rewind/discard\fR
.sp
\fIobjectName\fR \fBi_ast_pop_discard\fR
.sp
\fIobjectName\fR \fBi_ast_pop_discard/rewind\fR
.sp
\fIobjectName\fR \fBi:ok_continue\fR
.sp
\fIobjectName\fR \fBi:fail_continue\fR
.sp
\fIobjectName\fR \fBi:fail_return\fR
.sp
\fIobjectName\fR \fBi:ok_return\fR
.sp
\fIobjectName\fR \fBsi:void_state_push\fR
.sp
\fIobjectName\fR \fBsi:void2_state_push\fR
.sp
\fIobjectName\fR \fBsi:value_state_push\fR
.sp
\fIobjectName\fR \fBsi:void_state_merge\fR
.sp
\fIobjectName\fR \fBsi:void_state_merge_ok\fR
.sp
\fIobjectName\fR \fBsi:value_state_merge\fR
.sp
\fIobjectName\fR \fBsi:value_notahead_start\fR
.sp
\fIobjectName\fR \fBsi:void_notahead_exit\fR
.sp
\fIobjectName\fR \fBsi:value_notahead_exit\fR
.sp
\fIobjectName\fR \fBsi:kleene_abort\fR
.sp
\fIobjectName\fR \fBsi:kleene_close\fR
.sp
\fIobjectName\fR \fBsi:voidvoid_branch\fR
.sp
\fIobjectName\fR \fBsi:voidvalue_branch\fR
.sp
\fIobjectName\fR \fBsi:valuevoid_branch\fR
.sp
\fIobjectName\fR \fBsi:valuevalue_branch\fR
.sp
\fIobjectName\fR \fBsi:voidvoid_part\fR
.sp
\fIobjectName\fR \fBsi:voidvalue_part\fR
.sp
\fIobjectName\fR \fBsi:valuevalue_part\fR
.sp
\fIobjectName\fR \fBsi:value_symbol_start\fR \fIsymbol\fR
.sp
\fIobjectName\fR \fBsi:value_void_symbol_start\fR \fIsymbol\fR
.sp
\fIobjectName\fR \fBsi:void_symbol_start\fR \fIsymbol\fR
.sp
\fIobjectName\fR \fBsi:void_void_symbol_start\fR \fIsymbol\fR
.sp
\fIobjectName\fR \fBsi:reduce_symbol_end\fR \fIsymbol\fR
.sp
\fIobjectName\fR \fBsi:void_leaf_symbol_end\fR \fIsymbol\fR
.sp
\fIobjectName\fR \fBsi:value_leaf_symbol_end\fR \fIsymbol\fR
.sp
\fIobjectName\fR \fBsi:value_clear_symbol_end\fR \fIsymbol\fR
.sp
\fIobjectName\fR \fBsi:void_clear_symbol_end\fR \fIsymbol\fR
.sp
\fIobjectName\fR \fBsi:next_char\fR \fItok\fR
.sp
\fIobjectName\fR \fBsi:next_range\fR \fItoks\fR \fItoke\fR
.sp
\fIobjectName\fR \fBsi:next_alnum\fR
.sp
\fIobjectName\fR \fBsi:next_alpha\fR
.sp
\fIobjectName\fR \fBsi:next_ascii\fR
.sp
\fIobjectName\fR \fBsi:next_ddigit\fR
.sp
\fIobjectName\fR \fBsi:next_digit\fR
.sp
\fIobjectName\fR \fBsi:next_graph\fR
.sp
\fIobjectName\fR \fBsi:next_lower\fR
.sp
\fIobjectName\fR \fBsi:next_print\fR
.sp
\fIobjectName\fR \fBsi:next_punct\fR
.sp
\fIobjectName\fR \fBsi:next_space\fR
.sp
\fIobjectName\fR \fBsi:next_upper\fR
.sp
\fIobjectName\fR \fBsi:next_wordchar\fR
.sp
\fIobjectName\fR \fBsi:next_xdigit\fR
.sp
.BE
.SH DESCRIPTION
.PP
Are you lost ?
Do you have trouble understanding this document ?
In that case please read the overview provided by the
\fIIntroduction to Parser Tools\fR\&. This document is the
entrypoint to the whole system the current package is a part of\&.
.PP
This package provides a class whose instances provide the runtime
support for recursive descent parsers with backtracking, as is needed
for the execution of, for example, parsing expression grammars\&. It
implements the \fIPackRat Machine Specification\fR, as such that
document is \fIrequired\fR reading to understand both this manpage,
and the package itself\&. The description below does make numerous
shorthand references to the PARAM's instructions and the various parts
of its architectural state\&.
.PP
The package resides in the Execution section of the Core Layer of
Parser Tools\&.
.PP
IMAGE: arch_core_transform
.PP
.PP
Note: This package not only has the standard Tcl implementation, but
also an accelerator, i\&.e\&. a C implementation, based on Critcl\&.
.PP
.SS "CLASS API"
The package exports the API described here\&.
.TP
\fB::pt::rde\fR \fIobjectName\fR
The command creates a new runtime object for a recursive descent
parser with backtracking and returns the fully qualified name of the
object command as its result\&. The API of this object command is
described in the section \fBObject API\fR\&. It may be used to
invoke various operations on the object\&.
.PP
.SS "OBJECT API"
All objects created by this package provide the following 63 methods
for the manipulation and querying of their state, which is, in essence
the architectural state of a PARAM\&.
.PP
First some general methods and the state accessors\&.
.TP
\fIobjectName\fR \fBdestroy\fR
This method destroys the object, releasing all claimed memory, and
deleting the associated object command\&.
.TP
\fIobjectName\fR \fBreset\fR \fIchan\fR
This method resets the state of the runtme to its defaults, preparing
it for the parsing of the character in the channel \fIchan\fR, which
becomes IN\&.
.sp
Note here that the Parser Tools are based on Tcl 8\&.5+\&. In other words,
the channel argument is not restricted to files, sockets, etc\&. We have
the full power of \fIreflected channels\fR available\&.
.sp
It should also be noted that the parser pulls the characters from the
input stream as it needs them\&. If a parser created by this package has
to be operated in a push aka event-driven manner it will be necessary
to go to Tcl 8\&.6+ and use the \fBcoroutine::auto\fR to wrap it
into a coroutine where \fBread\fR is properly changed for
push-operation\&.
.TP
\fIobjectName\fR \fBcomplete\fR
This method completes parsing, either returning the AST made from the
elements of ARS, or throwing an error containing the current ER\&.
.TP
\fIobjectName\fR \fBchan\fR
This method returns the handle of the channel which is IN\&.
.TP
\fIobjectName\fR \fBline\fR
This method returns the line number for the position IN is currently
at\&. Note that this may not match with the line number for CL, due to
backtracking\&.
.TP
\fIobjectName\fR \fBcolumn\fR
This method returns the column for the position IN is currently
at\&. Note that this may not match with the column for CL, due to
backtracking\&.
.TP
\fIobjectName\fR \fBcurrent\fR
This method returns CC\&.
.TP
\fIobjectName\fR \fBlocation\fR
This method returns CL\&.
.TP
\fIobjectName\fR \fBlocations\fR
This method returns the LS\&. The topmost entry of the stack will be the
first element of the returned list\&.
.TP
\fIobjectName\fR \fBok\fR
This method returns ST\&.
.TP
\fIobjectName\fR \fBvalue\fR
This method returns SV\&.
.TP
\fIobjectName\fR \fBerror\fR
This method returns ER\&. This is either the empty string for an empty
ER, or a list of 2 elements, the location the error is for, and a set
of messages which specify which symbols were expected at the
location\&. The messages are encoded as one of the possible atomic
parsing expressions (special operators, terminal, range, and
nonterminal operator)\&.
.TP
\fIobjectName\fR \fBerrors\fR
This method returns ES\&. The topmost entry of the stack will be the
first element of the returned list\&. Each entry is encoded as described
for \fBerror\fR\&.
.TP
\fIobjectName\fR \fBtokens\fR ?\fIfrom\fR ?\fIto\fR??
This method returns the part of TC for the range of locations of IN
starting at \fIfrom\fR and ending at \fIto\fR\&. If \fIto\fR is not
specified it is taken as identical to \fIfrom\fR\&. If neither argument
is specified the whole of TC is returned\&.
.sp
Each token in the returned list is a list of three elements itself,
containing the character at the location, and the associated line and
column numbers, in this order\&.
.TP
\fIobjectName\fR \fBsymbols\fR
This method returns a dictionary containing NC\&. Keys are two-element
lists containing nonterminal symbol and location, in this order\&. The
values are 4-tuples containing CL, ST, ER, and SV, in this order\&. ER
is encoded as specified for the method \fBerror\fR\&.
.TP
\fIobjectName\fR \fBknown\fR
This method returns a list containing the keys of SC\&. They are
encoded in the same manner as is done by method \fBsymbols\fR\&.
.TP
\fIobjectName\fR \fBreducible\fR
This method returns ARS\&. The topmost entry of the stack will be the
first element of the returned list
.TP
\fIobjectName\fR \fBasts\fR
This method returns AS\&. The topmost entry of the stack will be the
first element of the returned list
.TP
\fIobjectName\fR \fBast\fR
This is a convenience method returning the topmost element of ARS\&.
.TP
\fIobjectName\fR \fBposition\fR \fIloc\fR
This method returns the line and column numbers for the specified
location of IN, assuming that this location has already been reached
during the parsing process\&.
.PP
The following methods implement all PARAM instructions\&. They all have
the prefix "i_"\&.
.PP
The control flow is mainly provided by Tcl's builtin commands, like
\fBif\fR, \fBwhile\fR, etc\&., plus a few guarded variants of PARAM
instructions and Tcl commands\&.\&. That means that these instruction
variants will do nothing if their guard condition is not
fulfilled\&. They can be recognized by the prefix "i:ok_" and "i:fail_",
which denote the value ST has to have for the instruction to execute\&.
.PP
The instructions are listed in the same order they occur in the
\fIPackRat Machine Specification\fR, with the guard variants
listed after their regular implementation, if any, or in their place\&.
.TP
\fIobjectName\fR \fBi_input_next\fR \fImsg\fR
This method implements the PARAM instruction \fBinput_next\fR\&.
.TP
\fIobjectName\fR \fBi_test_alnum\fR
This method implements the PARAM instruction \fBtest_alnum\fR\&.
.TP
\fIobjectName\fR \fBi_test_alpha\fR
This method implements the PARAM instruction \fBtest_alpha\fR\&.
.TP
\fIobjectName\fR \fBi_test_ascii\fR
This method implements the PARAM instruction \fBtest_ascii\fR\&.
.TP
\fIobjectName\fR \fBi_test_char\fR \fIchar\fR
This method implements the PARAM instruction \fBtest_char\fR\&.
.TP
\fIobjectName\fR \fBi_test_ddigit\fR
This method implements the PARAM instruction \fBtest_ddigit\fR\&.
.TP
\fIobjectName\fR \fBi_test_digit\fR
This method implements the PARAM instruction \fBtest_digit\fR\&.
.TP
\fIobjectName\fR \fBi_test_graph\fR
This method implements the PARAM instruction \fBtest_graph\fR\&.
.TP
\fIobjectName\fR \fBi_test_lower\fR
This method implements the PARAM instruction \fBtest_lower\fR\&.
.TP
\fIobjectName\fR \fBi_test_print\fR
This method implements the PARAM instruction \fBtest_print\fR\&.
.TP
\fIobjectName\fR \fBi_test_punct\fR
This method implements the PARAM instruction \fBtest_punct\fR\&.
.TP
\fIobjectName\fR \fBi_test_range\fR \fIchars\fR \fIchare\fR
This method implements the PARAM instruction \fBtest_range\fR\&.
.TP
\fIobjectName\fR \fBi_test_space\fR
This method implements the PARAM instruction \fBtest_space\fR\&.
.TP
\fIobjectName\fR \fBi_test_upper\fR
This method implements the PARAM instruction \fBtest_upper\fR\&.
.TP
\fIobjectName\fR \fBi_test_wordchar\fR
This method implements the PARAM instruction \fBtest_wordchar\fR\&.
.TP
\fIobjectName\fR \fBi_test_xdigit\fR
This method implements the PARAM instruction \fBtest_xdigit\fR\&.
.TP
\fIobjectName\fR \fBi_error_clear\fR
This method implements the PARAM instruction \fBerror_clear\fR\&.
.TP
\fIobjectName\fR \fBi_error_push\fR
This method implements the PARAM instruction \fBerror_push\fR\&.
.TP
\fIobjectName\fR \fBi_error_pop_merge\fR
This method implements the PARAM instruction \fBerror_pop_merge\fR\&.
.TP
\fIobjectName\fR \fBi_error_nonterminal\fR \fIsymbol\fR
This method implements the PARAM instruction \fBerror_nonterminal\fR\&.
.TP
\fIobjectName\fR \fBi_status_ok\fR
This method implements the PARAM instruction \fBstatus_ok\fR\&.
.TP
\fIobjectName\fR \fBi_status_fail\fR
This method implements the PARAM instruction \fBstatus_fail\fR\&.
.TP
\fIobjectName\fR \fBi_status_negate\fR
This method implements the PARAM instruction \fBstatus_negate\fR\&.
.TP
\fIobjectName\fR \fBi_loc_push\fR
This method implements the PARAM instruction \fBloc_push\fR\&.
.TP
\fIobjectName\fR \fBi_loc_pop_discard\fR
This method implements the PARAM instruction \fBloc_pop_discard\fR\&.
.TP
\fIobjectName\fR \fBi_loc_pop_rewind\fR
This method implements the PARAM instruction \fBloc_pop_rewind\fR\&.
.TP
\fIobjectName\fR \fBi:ok_loc_pop_rewind\fR
This guarded method, a variant of \fBi_loc_pop_rewind\fR, executes only
for "ST == ok"\&.
.TP
\fIobjectName\fR \fBi_loc_pop_rewind/discard\fR
This method is a convenient combination of control flow and the two
PARAM instructions \fBloc_pop_rewind\fR and \fBloc_pop_discard\fR\&. The former
is executed for "ST == fail", the latter for "ST == ok"\&.
.TP
\fIobjectName\fR \fBi_symbol_restore\fR \fIsymbol\fR
This method implements the PARAM instruction \fBsymbol_restore\fR\&.
.sp
The boolean result of the check is returned as the result of
the method and can be used with standard Tcl control flow commands\&.
.TP
\fIobjectName\fR \fBi_symbol_save\fR \fIsymbol\fR
This method implements the PARAM instruction \fBsymbol_save\fR\&.
.TP
\fIobjectName\fR \fBi_value_clear\fR
This method implements the PARAM instruction \fBvalue_clear\fR\&.
.TP
\fIobjectName\fR \fBi_value_clear/leaf\fR
This method is a convenient combination of control flow and the two
PARAM instructions \fBvalue_clear\fR and \fBvalue_leaf\fR\&. The former
is executed for "ST == fail", the latter for "ST == ok"\&.
.TP
\fIobjectName\fR \fBi_value_clear/reduce\fR
This method is a convenient combination of control flow and the two
PARAM instructions \fBvalue_clear\fR and \fBvalue_reduce\fR\&. The former
is executed for "ST == fail", the latter for "ST == ok"\&.
.TP
\fIobjectName\fR \fBi:ok_ast_value_push\fR
This method implements a guarded variant of the the PARAM instruction
\fBast_value_push\fR, which executes only for "ST == ok"\&.
.TP
\fIobjectName\fR \fBi_ast_push\fR
This method implements the PARAM instruction \fBast_push\fR\&.
.TP
\fIobjectName\fR \fBi_ast_pop_rewind\fR
This method implements the PARAM instruction \fBast_pop_rewind\fR\&.
.TP
\fIobjectName\fR \fBi:fail_ast_pop_rewind\fR
This guarded method, a variant of \fBi_ast_pop_rewind\fR, executes only
for "ST == fail"\&.
.TP
\fIobjectName\fR \fBi_ast_pop_rewind/discard\fR
This method is a convenient combination of control flow and the two
PARAM instructions \fBast_pop_rewind\fR and \fBast_pop_discard\fR\&. The former
is executed for "ST == fail", the latter for "ST == ok"\&.
.TP
\fIobjectName\fR \fBi_ast_pop_discard\fR
This method implements the PARAM instruction \fBast_pop_discard\fR\&.
.TP
\fIobjectName\fR \fBi_ast_pop_discard/rewind\fR
This method is a convenient combination of control flow and the two
PARAM instructions \fBast_pop_discard\fR and \fBast_pop_rewind\fR\&. The former
is executed for "ST == fail", the latter for "ST == ok"\&.
.TP
\fIobjectName\fR \fBi:ok_continue\fR
This guarded method executes only for "ST == ok"\&. Then it aborts the
current iteration of the innermost loop in the calling Tcl procedure\&.
.TP
\fIobjectName\fR \fBi:fail_continue\fR
This guarded method executes only for "ST == fail"\&. Then it aborts the
current iteration of the innermost loop in the calling Tcl procedure\&.
.TP
\fIobjectName\fR \fBi:fail_return\fR
This guarded method executes only for "ST == fail"\&. Then it aborts the
calling Tcl procedure\&.
.TP
\fIobjectName\fR \fBi:ok_return\fR
This guarded method executes only for "ST == ok"\&. Then it aborts the
calling Tcl procedure\&.
.PP
.PP
The next set of methods are \fIsuper instructions\fR, meaning that
each implements a longer sequence of instructions commonly used in
parsers\&. The combinated instructions of the previous set, i\&.e\&. those
with names matching the pattern "i_*/*", are actually super
instructions as well, albeit with limited scope, handling 2
instructions with their control flow\&. The upcoming set is much broader
in scope, folding as much as six or more PARAM instructions into a
single method call\&.
.PP
In this we can see the reasoning behind their use well:
.IP [1]
By using less instructions the generated parsers become smaller, as
the common parts are now truly part of the common runtime, and not
explicitly written in the parser's code over and over again\&.
.IP [2]
Using less instructions additionally reduces the overhead associated
with calls into the runtime, i\&.e\&. the cost of method dispatch and of
setting up the variable context\&.
.IP [3]
Another effect of the super instructions is that their internals can
be optimized as well, especially regarding control flow, and stack
use, as the runtime internals are accessible to all instructions
folded into the sequence\&.
.PP
.PP
.TP
\fIobjectName\fR \fBsi:void_state_push\fR
This method combines
.CS


i_loc_push
i_error_clear
i_error_push

.CE
.IP
Parsers use it at the beginning of \fIvoid\fR sequences and choices
with a \fIvoid\fR initial branch\&.
.TP
\fIobjectName\fR \fBsi:void2_state_push\fR
This method combines
.CS


i_loc_push
i_error_clear
i_error_push

.CE
.IP
Parsers use it at the beginning of optional and repeated expressions\&.
.TP
\fIobjectName\fR \fBsi:value_state_push\fR
This method combines
.CS


i_ast_push
i_loc_push
i_error_clear
i_error_push

.CE
.IP
Parsers use it at the beginning of sequences generating an AST and
choices with an initial branch generating an AST\&.
.TP
\fIobjectName\fR \fBsi:void_state_merge\fR
This method combines
.CS


i_error_pop_merge
i_loc_pop_rewind/discard

.CE
.IP
Parsers use it at the end of void sequences and choices whose last
branch is void\&.
.TP
\fIobjectName\fR \fBsi:void_state_merge_ok\fR
This method combines
.CS


i_error_pop_merge
i_loc_pop_rewind/discard
i_status_ok

.CE
.IP
Parsers use it at the end of optional expressions
.TP
\fIobjectName\fR \fBsi:value_state_merge\fR
This method combines
.CS


i_error_pop_merge
i_ast_pop_rewind/discard
i_loc_pop_rewind/discard

.CE
.IP
Parsers use it at the end of sequences generating ASTs and choices
whose last branch generates an AST
.TP
\fIobjectName\fR \fBsi:value_notahead_start\fR
This method combines
.CS


i_loc_push
i_ast_push

.CE
.IP
Parsers use it at the beginning of negative lookahead predicates which
generate ASTs\&.
.TP
\fIobjectName\fR \fBsi:void_notahead_exit\fR
This method combines
.CS


i_loc_pop_rewind
i_status_negate

.CE
.IP
Parsers use it at the end of void negative lookahead predicates\&.
.TP
\fIobjectName\fR \fBsi:value_notahead_exit\fR
This method combines
.CS


i_ast_pop_discard/rewind
i_loc_pop_rewind
i_status_negate

.CE
.IP
Parsers use it at the end of negative lookahead predicates which
generate ASTs\&.
.TP
\fIobjectName\fR \fBsi:kleene_abort\fR
This method combines
.CS


i_loc_pop_rewind/discard
i:fail_return

.CE
.IP
Parsers use it to stop a positive repetition when its first, required, expression fails\&.
.TP
\fIobjectName\fR \fBsi:kleene_close\fR
This method combines
.CS


i_error_pop_merge
i_loc_pop_rewind/discard
i:fail_status_ok
i:fail_return

.CE
.IP
Parsers use it at the end of repetitions\&.
.TP
\fIobjectName\fR \fBsi:voidvoid_branch\fR
This method combines
.CS


i_error_pop_merge
i:ok_loc_pop_discard
i:ok_return
i_loc_rewind
i_error_push

.CE
.IP
Parsers use it when transiting between branches of a choice when both are void\&.
.TP
\fIobjectName\fR \fBsi:voidvalue_branch\fR
This method combines
.CS


i_error_pop_merge
i:ok_loc_pop_discard
i:ok_return
i_ast_push
i_loc_rewind
i_error_push

.CE
.IP
Parsers use it when transiting between branches of a choice when the
failing branch is void, and the next to test generates an AST\&.
.TP
\fIobjectName\fR \fBsi:valuevoid_branch\fR
This method combines
.CS


i_error_pop_merge
i_ast_pop_rewind/discard
i:ok_loc_pop_discard
i:ok_return
i_loc_rewind
i_error_push

.CE
.IP
Parsers use it when transiting between branches of a choice when the
failing branch generates an AST, and the next to test is void\&.
.TP
\fIobjectName\fR \fBsi:valuevalue_branch\fR
This method combines
.CS


i_error_pop_merge
i_ast_pop_discard
i:ok_loc_pop_discard
i:ok_return
i_ast_rewind
i_loc_rewind
i_error_push

.CE
.IP
Parsers use it when transiting between branches of a choice when both
generate ASTs\&.
.TP
\fIobjectName\fR \fBsi:voidvoid_part\fR
This method combines
.CS


i_error_pop_merge
i:fail_loc_pop_rewind
i:fail_return
i_error_push

.CE
.IP
Parsers use it when transiting between parts of a sequence and both
are void\&.
.TP
\fIobjectName\fR \fBsi:voidvalue_part\fR
This method combines
.CS


i_error_pop_merge
i:fail_loc_pop_rewind
i:fail_return
i_ast_push
i_error_push

.CE
.IP
Parsers use it when transiting between parts of a sequence and the
sucessfully matched part is void, and after it an AST is generated\&.
.TP
\fIobjectName\fR \fBsi:valuevalue_part\fR
This method combines
.CS


i_error_pop_merge
i:fail_ast_pop_rewind
i:fail_loc_pop_rewind
i:fail_return
i_error_push

.CE
.IP
Parsers use it when transiting between parts of a sequence and both
parts generate ASTs\&.
.TP
\fIobjectName\fR \fBsi:value_symbol_start\fR \fIsymbol\fR
This method combines
.CS


if/found? i_symbol_restore $symbol
i:found:ok_ast_value_push
i:found_return
i_loc_push
i_ast_push

.CE
.IP
Parsers use it at the beginning of a nonterminal symbol generating an
AST, whose right-hand side may have generated an AST as well\&.
.TP
\fIobjectName\fR \fBsi:value_void_symbol_start\fR \fIsymbol\fR
This method combines
.CS


if/found? i_symbol_restore $symbol
i:found:ok_ast_value_push
i:found_return
i_loc_push
i_ast_push

.CE
.IP
Parsers use it at the beginning of a void nonterminal symbol whose
right-hand side may generate an AST\&.
.TP
\fIobjectName\fR \fBsi:void_symbol_start\fR \fIsymbol\fR
This method combines
.CS


if/found? i_symbol_restore $symbol
i:found_return
i_loc_push
i_ast_push

.CE
.IP
Parsers use it at the beginning of a nonterminal symbol generating an
AST whose right-hand side is void\&.
.TP
\fIobjectName\fR \fBsi:void_void_symbol_start\fR \fIsymbol\fR
This method combines
.CS


if/found? i_symbol_restore $symbol
i:found_return
i_loc_push

.CE
.IP
Parsers use it at  the beginning of a void nonterminal symbol whose
right-hand side is void as well\&.
.TP
\fIobjectName\fR \fBsi:reduce_symbol_end\fR \fIsymbol\fR
This method combines
.CS


i_value_clear/reduce $symbol
i_symbol_save        $symbol
i_error_nonterminal  $symbol
i_ast_pop_rewind
i_loc_pop_discard
i:ok_ast_value_push

.CE
.IP
Parsers use it at the end of a non-terminal symbol generating an AST
using the AST generated by the right-hand side as child\&.
.TP
\fIobjectName\fR \fBsi:void_leaf_symbol_end\fR \fIsymbol\fR
This method combines
.CS


i_value_clear/leaf  $symbol
i_symbol_save       $symbol
i_error_nonterminal $symbol
i_loc_pop_discard
i:ok_ast_value_push

.CE
.IP
Parsers use it at the end of a non-terminal symbol generating an AST
whose right-hand side is void\&.
.TP
\fIobjectName\fR \fBsi:value_leaf_symbol_end\fR \fIsymbol\fR
This method combines
.CS


i_value_clear/leaf  $symbol
i_symbol_save       $symbol
i_error_nonterminal $symbol
i_loc_pop_discard
i_ast_pop_rewind
i:ok_ast_value_push

.CE
.IP
Parsers use it at the end of a non-terminal symbol generating an AST
discarding the AST generated by the right-hand side\&.
.TP
\fIobjectName\fR \fBsi:value_clear_symbol_end\fR \fIsymbol\fR
This method combines
.CS


i_value_clear
i_symbol_save       $symbol
i_error_nonterminal $symbol
i_loc_pop_discard
i_ast_pop_rewind

.CE
.IP
Parsers use it at the end of a void non-terminal symbol, discarding
the AST generated by the right-hand side\&.
.TP
\fIobjectName\fR \fBsi:void_clear_symbol_end\fR \fIsymbol\fR
This method combines
.CS


i_value_clear
i_symbol_save       $symbol
i_error_nonterminal $symbol
i_loc_pop_discard

.CE
.IP
Parsers use it at the end of a void non-terminal symbol with a void
right-hand side\&.
.TP
\fIobjectName\fR \fBsi:next_char\fR \fItok\fR
.TP
\fIobjectName\fR \fBsi:next_range\fR \fItoks\fR \fItoke\fR
.TP
\fIobjectName\fR \fBsi:next_alnum\fR
.TP
\fIobjectName\fR \fBsi:next_alpha\fR
.TP
\fIobjectName\fR \fBsi:next_ascii\fR
.TP
\fIobjectName\fR \fBsi:next_ddigit\fR
.TP
\fIobjectName\fR \fBsi:next_digit\fR
.TP
\fIobjectName\fR \fBsi:next_graph\fR
.TP
\fIobjectName\fR \fBsi:next_lower\fR
.TP
\fIobjectName\fR \fBsi:next_print\fR
.TP
\fIobjectName\fR \fBsi:next_punct\fR
.TP
\fIobjectName\fR \fBsi:next_space\fR
.TP
\fIobjectName\fR \fBsi:next_upper\fR
.TP
\fIobjectName\fR \fBsi:next_wordchar\fR
.TP
\fIobjectName\fR \fBsi:next_xdigit\fR
These methods all combine
.CS


i_input_next $msg
i:fail_return

.CE
.IP
with the appropriate \fBi_test_xxx\fR instruction\&. Parsers use them for
handling atomic expressions\&.
.PP
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fIpt\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.SH KEYWORDS
EBNF, LL(k), PEG, TDPL, context-free languages, expression, grammar, matching, parser, parsing expression, parsing expression grammar, push down automaton, recursive descent, state, top-down parsing languages, transducer
.SH CATEGORY
Parsing and Grammars
.SH COPYRIGHT
.nf
Copyright (c) 2009 Andreas Kupries <andreas_kupries@users\&.sourceforge\&.net>

.fi