/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import org.languagetool.Experimental;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;

@Experimental
public class RuleInformation {
    private static final Set<Key> rules = RuleInformation.loadRules();

    private static Set<Key> loadRules() {
        HashSet<Key> result = new HashSet<Key>();
        String path = "incomplete_sentence_ignore_rules.txt";
        InputStream stream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(path);
        try (Scanner sc = new Scanner(stream);){
            while (sc.hasNext()) {
                String line = sc.nextLine();
                if (line.startsWith("#") || line.isEmpty()) continue;
                String[] parts = line.split("\t");
                if (parts.length != 2) {
                    throw new RuntimeException("Unexpected format in " + path + ", expected two tabulator-separated parts: '" + line + "'");
                }
                result.add(new Key(parts[0], parts[1]));
            }
        }
        return result;
    }

    private RuleInformation() {
    }

    public static boolean ignoreForIncompleteSentences(String ruleId, Language lang) {
        return rules.contains(new Key(lang.getShortCode(), ruleId));
    }

    static class Key {
        private String langCode;
        private String ruleId;

        Key(String ruleId, String langCode) {
            this.ruleId = Objects.requireNonNull(ruleId);
            this.langCode = Objects.requireNonNull(langCode);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.langCode, key.langCode) && Objects.equals(this.ruleId, key.ruleId);
        }

        public int hashCode() {
            return Objects.hash(this.langCode, this.ruleId);
        }
    }
}

