# Base Io build system
# Written by Jeremy Tregunna <jeremy.tregunna@me.com>
#
# Find libsamplerate.

FIND_PATH(SAMPLERATE_INCLUDE_DIR samplerate.h)

SET(SAMPLERATE_NAMES ${SAMPLERATE_NAMES} samplerate libsamplerate)
FIND_LIBRARY(SAMPLERATE_LIBRARY NAMES ${SAMPLERATE_NAMES} PATH)

IF(SAMPLERATE_INCLUDE_DIR AND SAMPLERATE_LIBRARY)
	SET(SAMPLERATE_FOUND TRUE)
ENDIF(SAMPLERATE_INCLUDE_DIR AND SAMPLERATE_LIBRARY)

IF(SAMPLERATE_FOUND)
	IF(NOT SampleRate_FIND_QUIETLY)
		MESSAGE(STATUS "Found SampleRate: ${SAMPLERATE_LIBRARY}")
	ENDIF (NOT SampleRate_FIND_QUIETLY)
ELSE(SAMPLERATE_FOUND)
	IF(SampleRate_FIND_REQUIRED)
		MESSAGE(FATAL_ERROR "Could not find samplerate")
	ENDIF(SampleRate_FIND_REQUIRED)
ENDIF (SAMPLERATE_FOUND)
