# Base Io build system
# Written by Jeremy Tregunna <jeremy.tregunna@me.com>
#
# Find libqdbm.

FIND_PATH(QDBM_INCLUDE_DIR depot.h cabin.h villa.h)

SET(QDBM_NAMES ${QDBM_NAMES} qdbm libqdbm)
FIND_LIBRARY(QDBM_LIBRARY NAMES ${QDBM_NAMES} PATH)

IF(QDBM_INCLUDE_DIR AND QDBM_LIBRARY)
	SET(QDBM_FOUND TRUE)
ENDIF(QDBM_INCLUDE_DIR AND QDBM_LIBRARY)

IF(QDBM_FOUND)
	IF(NOT QDBM_FIND_QUIETLY)
		MESSAGE(STATUS "Found QDBM: ${QDBM_LIBRARY}")
	ENDIF (NOT QDBM_FIND_QUIETLY)
ELSE(QDBM_FOUND)
	IF(QDBM_FIND_REQUIRED)
		MESSAGE(FATAL_ERROR "Could not find qdbm")
	ENDIF(QDBM_FIND_REQUIRED)
ENDIF (QDBM_FOUND)
