/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.driver;

import java.awt.Component;
import javax.accessibility.AccessibleAction;
import org.fest.swing.annotation.RunsInCurrentThread;
import org.fest.swing.exception.ActionFailedException;
import org.fest.swing.format.Formatting;
import org.fest.util.Strings;

class ComponentPerformDefaultAccessibleActionTask {
    private static final int DEFAULT_ACTION_INDEX = 0;

    ComponentPerformDefaultAccessibleActionTask() {
    }

    @RunsInCurrentThread
    static void performDefaultAccessibleAction(Component c) {
        AccessibleAction action = c.getAccessibleContext().getAccessibleAction();
        if (action == null || action.getAccessibleActionCount() == 0) {
            throw ActionFailedException.actionFailure(Strings.concat((Object[])new Object[]{"Unable to perform accessible action for ", Formatting.format(c)}));
        }
        action.doAccessibleAction(0);
    }
}

