/*
 * Decompiled with CFR 0.152.
 */
package org.fest.assertions;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.fest.assertions.ArrayAssert;
import org.fest.assertions.Condition;
import org.fest.assertions.Description;
import org.fest.assertions.ErrorMessages;
import org.fest.assertions.Formatting;
import org.fest.util.Collections;
import org.fest.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectArrayAssert
extends ArrayAssert<Object[]> {
    protected ObjectArrayAssert(Object ... actual) {
        super(actual);
    }

    public ObjectArrayAssert as(String description) {
        this.description(description);
        return this;
    }

    public ObjectArrayAssert describedAs(String description) {
        return this.as(description);
    }

    public ObjectArrayAssert as(Description description) {
        this.description(description);
        return this;
    }

    public ObjectArrayAssert describedAs(Description description) {
        return this.as(description);
    }

    public ObjectArrayAssert hasAllElementsOfType(Class<?> type) {
        this.validateIsNotNull(type);
        this.isNotNull();
        for (Object o : (Object[])this.actual) {
            if (type.isInstance(o)) continue;
            this.failIfCustomMessageIsSet();
            this.fail(Strings.concat((Object[])new Object[]{"not all elements in array:", this.actualInBrackets(), " belong to the type:", Formatting.inBrackets(type)}));
        }
        return this;
    }

    public ObjectArrayAssert hasAtLeastOneElementOfType(Class<?> type) {
        this.validateIsNotNull(type);
        this.isNotNull();
        boolean found = false;
        for (Object o : (Object[])this.actual) {
            if (!type.isInstance(o)) continue;
            found = true;
            break;
        }
        if (found) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"array:", this.actualInBrackets(), " does not have any elements of type:", Formatting.inBrackets(type)}));
    }

    private void validateIsNotNull(Class<?> type) {
        if (type == null) {
            throw new NullPointerException(ErrorMessages.unexpectedNullType(this.rawDescription()));
        }
    }

    public ObjectArrayAssert contains(Object ... objects) {
        this.isNotNull();
        this.validateIsNotNull(objects);
        this.assertContains(Collections.list((Object[])objects));
        return this;
    }

    public ObjectArrayAssert containsOnly(Object ... objects) {
        this.isNotNull();
        this.validateIsNotNull(objects);
        this.assertContainsOnly(Collections.list((Object[])objects));
        return this;
    }

    public ObjectArrayAssert excludes(Object ... objects) {
        this.isNotNull();
        this.validateIsNotNull(objects);
        this.assertExcludes(Collections.list((Object[])objects));
        return this;
    }

    private void validateIsNotNull(Object[] objects) {
        if (objects == null) {
            throw new NullPointerException(this.formattedErrorMessage("the given array of objects should not be null"));
        }
    }

    public ObjectArrayAssert doesNotHaveDuplicates() {
        this.isNotNull();
        List actualAsList = Collections.list((Object[])((Object[])this.actual));
        Collection duplicates = Collections.duplicatesFrom((Collection)actualAsList);
        if (duplicates.isEmpty()) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(Strings.concat((Object[])new Object[]{"array:", this.actualInBrackets(), " contains duplicate(s):", Formatting.inBrackets(duplicates)}));
    }

    public ObjectArrayAssert satisfies(Condition<Object[]> condition) {
        this.assertSatisfies(condition);
        return this;
    }

    public ObjectArrayAssert doesNotSatisfy(Condition<Object[]> condition) {
        this.assertDoesNotSatisfy(condition);
        return this;
    }

    public ObjectArrayAssert is(Condition<Object[]> condition) {
        this.assertIs(condition);
        return this;
    }

    public ObjectArrayAssert isNot(Condition<Object[]> condition) {
        this.assertIsNot(condition);
        return this;
    }

    public ObjectArrayAssert isNotNull() {
        this.assertThatActualIsNotNull();
        return this;
    }

    public ObjectArrayAssert isNotEmpty() {
        this.assertThatActualIsNotEmpty();
        return this;
    }

    public ObjectArrayAssert isEqualTo(Object[] expected) {
        if (Arrays.deepEquals((Object[])this.actual, expected)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedNotEqual(this.actual, expected));
    }

    public ObjectArrayAssert isNotEqualTo(Object[] array) {
        if (!Arrays.deepEquals((Object[])this.actual, array)) {
            return this;
        }
        this.failIfCustomMessageIsSet();
        throw this.failure(ErrorMessages.unexpectedEqual(this.actual, array));
    }

    public ObjectArrayAssert hasSize(int expected) {
        this.assertThatActualHasSize(expected);
        return this;
    }

    public ObjectArrayAssert isSameAs(Object[] expected) {
        this.assertSameAs(expected);
        return this;
    }

    public ObjectArrayAssert isNotSameAs(Object[] expected) {
        this.assertNotSameAs(expected);
        return this;
    }

    public ObjectArrayAssert overridingErrorMessage(String message) {
        this.replaceDefaultErrorMessagesWith(message);
        return this;
    }
}

