# Suricata Reporter for IPFire

Suricata Reporter is a lightweight utility for IPFire that collects, parses,
and visualizes alerts generated by Suricata.

It provides administrators with a clear overview of detected threats and
network anomalies directly from EVE JSON logs, without requiring external log
management systems.

## Features

- Parses Suricata EVE JSON logs in realtime
- Sends email reports for each alert
- Summarizes alerts by:
  - Severity
  - Signature / Rule
  - Source and destination hosts
- Generates human-readable reports for IPFire’s web interface or CLI
  in PDF format
- Provides filtering and aggregation to identify recurring attack patterns
- Lightweight and implemented in pure Python

## Requirements

### Runtime

- Suricata
- Python >= 3.10
  - reportlab
  - sqlite3

### Build (from source)

- GNU Autotools (autoconf, automake)
- make

## Build & Install

Clone the repository:
    git clone https://git.ipfire.org/pub/git/suricata-reporter.git
    cd suricata-reporter

Bootstrap autotools:
    ./autogen.sh

Configure:
    ./configure --prefix=/usr

Build and install:
    make
    sudo make install

## Integration with IPFire

- Suricata Reporter can be managed in the IPFire web interface under:
  Firewall -> Intrusion Prevention
- For automation or custom workflows, the CLI tool can be used directly on the IPFire system.

## Contributing

We welcome contributions! Please send patches to the IPFire development mailing list:

  https://www.ipfire.org/docs/devel/mailing-lists
