/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.lang;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.BeginExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.ModuleBody;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.kawa.functions.ConstantFunction0;
import gnu.kawa.lispexpr.LangPrimType;
import gnu.kawa.reflect.ClassMethodProc;
import gnu.lists.AbstractFormat;
import gnu.lists.Consumer;
import gnu.mapping.CallContext;
import gnu.mapping.CharArrayInPort;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.InPort;
import gnu.mapping.Namespace;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.Values;
import gnu.math.DFloNum;
import gnu.math.IntNum;
import gnu.math.Numeric;
import gnu.text.Char;
import gnu.text.Lexer;
import gnu.text.SourceMessages;
import gnu.text.SyntaxException;
import gnu.xml.SName;
import gnu.xml.XMLPrinter;
import gnu.xquery.lang.Prompter;
import gnu.xquery.lang.XQParser;
import gnu.xquery.lang.XQResolveNames;
import gnu.xquery.util.BooleanValue;
import gnu.xquery.util.XMLFormat;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Vector;
import kawa.standard.Scheme;

public class XQuery
extends Language {
    public static final String XQUERY_FUNCTION_NAMESPACE = "http://www.w3.org/2004/10/xpath-functions";
    public static final String KAWA_FUNCTION_NAMESPACE = "http://kawa.gnu.org/";
    public static final String QEXO_FUNCTION_NAMESPACE = "http://qexo.gnu.org/";
    public static final String LOCAL_NAMESPACE = "http://www.w3.org/2004/10/xquery-local-functions";
    public static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    public static final Namespace xqueryFunctionNamespace = Namespace.getInstance("http://www.w3.org/2004/10/xpath-functions");
    public static final Namespace kawaFunctionNamespace = Namespace.getInstance("http://kawa.gnu.org/");
    public static final Namespace qexoFunctionNamespace = Namespace.getInstance("http://qexo.gnu.org/");
    public static final Namespace[] defaultFunctionNamespacePath = new Namespace[]{qexoFunctionNamespace, xqueryFunctionNamespace, Namespace.EmptyNamespace, kawaFunctionNamespace};
    static boolean charIsInt = false;
    public static final String DEFAULT_ELEMENT_PREFIX = "elements$";
    public static final String DEFAULT_FUNCTION_PREFIX = "functions$";
    Namespace defaultNamespace;
    public static final int PARSE_WITH_FOCUS = 65536;
    static int envCounter = 0;
    public static Environment extensionsEnvEnv = Environment.getInstance("http://kawa.gnu.org/");
    public static final Environment xqEnvironment = Environment.make("http://www.w3.org/2004/10/xpath-functions");
    static final XQuery instance = new XQuery();
    public static final ConstantFunction0 falseFunction;
    public static final ConstantFunction0 trueFunction;
    public static final XMLFormat writeFormat;
    LangPrimType booleanType;
    static Object[] typeMap;

    public boolean hasSeparateFunctionNamespace() {
        return true;
    }

    public static Numeric asNumber(Object object2) {
        if (object2 instanceof Char) {
            return IntNum.make(((Char)object2).intValue());
        }
        return (Numeric)object2;
    }

    public static char asChar(Object object2) {
        if (object2 instanceof Char) {
            return ((Char)object2).charValue();
        }
        int n = object2 instanceof Numeric ? ((Numeric)object2).intValue() : -1;
        if (n < 0 || n > 65535) {
            throw new ClassCastException("not a character value");
        }
        return (char)n;
    }

    public boolean isTrue(Object object2) {
        return BooleanValue.booleanValue(object2);
    }

    public Lexer getLexer(InPort inPort, SourceMessages sourceMessages) {
        return new XQParser(inPort, sourceMessages, this);
    }

    public Compilation parse(Lexer lexer, int n) throws IOException, SyntaxException {
        XQParser xQParser = (XQParser)lexer;
        Compilation.defaultCallConvention = 2;
        Compilation compilation = new Compilation(this, xQParser.getMessages(), xQParser.lexical);
        compilation.immediate = (n & 1) != 0;
        XQResolveNames xQResolveNames = new XQResolveNames(compilation);
        xQResolveNames.functionNamespacePath = xQParser.functionNamespacePath;
        ModuleExp moduleExp = new ModuleExp();
        moduleExp.setFile(lexer.getName());
        compilation.push(moduleExp);
        compilation.mustCompileHere();
        ((XQParser)lexer).resolver = xQResolveNames;
        xQResolveNames.parser = (XQParser)lexer;
        if ((n & 2) != 0) {
            Expression expression = ((XQParser)lexer).parse(compilation);
            if (expression == null) {
                return null;
            }
            moduleExp.body = expression;
        } else if ((n & 0x10000) != 0) {
            LambdaExp lambdaExp = new LambdaExp(3);
            Declaration declaration = lambdaExp.addDeclaration(XQParser.DOT_VARNAME);
            declaration.setFlag(262144);
            declaration.noteValue(null);
            lambdaExp.addDeclaration(XQParser.POSITION_VARNAME, Type.int_type);
            lambdaExp.addDeclaration(XQParser.LAST_VARNAME, Type.int_type);
            compilation.push(lambdaExp);
            lambdaExp.body = ((XQParser)lexer).parse(compilation);
            compilation.pop(lambdaExp);
            moduleExp.body = lambdaExp;
        } else {
            Expression expression;
            Vector<Expression> vector = new Vector<Expression>(10);
            while ((expression = ((XQParser)lexer).parse(compilation)) != null) {
                vector.addElement(expression);
            }
            int n2 = vector.size();
            if (n2 == 0) {
                moduleExp.body = QuoteExp.voidExp;
            } else if (n2 == 1) {
                moduleExp.body = (Expression)vector.elementAt(0);
            } else {
                Object[] objectArray = new Expression[n2];
                vector.copyInto(objectArray);
                moduleExp.body = new BeginExp((Expression[])objectArray);
            }
        }
        compilation.pop(moduleExp);
        xQResolveNames.resolveModule(moduleExp);
        return compilation;
    }

    public int getNamespaceOf(Declaration declaration) {
        return declaration.isProcedureDecl() ? 2 : 1;
    }

    public Symbol getSymbol(String string) {
        return Symbol.make(this.defaultNamespace, string);
    }

    public void define(String string, Object object2) {
        Symbol symbol = Symbol.make(this.defaultNamespace, string);
        Object object3 = object2 instanceof Procedure ? EnvironmentKey.FUNCTION : null;
        this.environ.define(symbol, object3, object2);
    }

    protected void define_method(String string, String string2, String string3) {
        Symbol symbol = Symbol.make(this.defaultNamespace, string);
        ClassMethodProc classMethodProc = ClassMethodProc.make(ClassType.make(string2), string3);
        classMethodProc.setSymbol(symbol);
        this.environ.define(symbol, EnvironmentKey.FUNCTION, classMethodProc);
    }

    public String getName() {
        return "XQuery";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyWithFocus(Procedure procedure, Object object2, int n, int n2, Consumer consumer) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        procedure.check3(object2, IntNum.make(n), IntNum.make(n2), callContext);
        Consumer consumer2 = callContext.consumer;
        try {
            callContext.consumer = consumer;
            callContext.runUntilDone();
        }
        finally {
            callContext.consumer = consumer2;
        }
    }

    public Object applyWithFocus(Procedure procedure, Object object2, int n, int n2) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        int n3 = callContext.startFromContext();
        try {
            procedure.check3(object2, IntNum.make(n), IntNum.make(n2), callContext);
            return callContext.getFromContext(n3);
        }
        catch (Throwable throwable) {
            callContext.cleanupFromContext(n3);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyWithFocus(Procedure procedure, Object object2, Consumer consumer) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        Consumer consumer2 = callContext.consumer;
        try {
            callContext.consumer = consumer;
            this.applyWithFocus$X(procedure, object2, callContext);
        }
        finally {
            callContext.consumer = consumer2;
        }
    }

    public Object applyWithFocus(Procedure procedure, Object object2) throws Throwable {
        CallContext callContext = CallContext.getInstance();
        int n = callContext.startFromContext();
        try {
            this.applyWithFocus$X(procedure, object2, callContext);
            return callContext.getFromContext(n);
        }
        catch (Throwable throwable) {
            callContext.cleanupFromContext(n);
            throw throwable;
        }
    }

    public void applyWithFocus$X(Procedure procedure, Object object2, CallContext callContext) throws Throwable {
        if (object2 instanceof Values) {
            Values values = (Values)object2;
            int n = values.size();
            if (n == 0) {
                return;
            }
            int n2 = 0;
            IntNum intNum = IntNum.make(n);
            int n3 = 1;
            while (true) {
                procedure.check3(values.getPosNext(n2), IntNum.make(n3), intNum, callContext);
                callContext.runUntilDone();
                if (n3 != n) {
                    n2 = values.nextPos(n2);
                    ++n3;
                    continue;
                }
                break;
            }
        } else {
            IntNum intNum = IntNum.one();
            procedure.check3(object2, intNum, intNum, callContext);
            callContext.runUntilDone();
        }
    }

    public Procedure evalToFocusProc(String string) throws Throwable {
        SourceMessages sourceMessages = new SourceMessages();
        Procedure procedure = this.evalToFocusProc(new CharArrayInPort(string), sourceMessages);
        if (sourceMessages.seenErrors()) {
            throw new RuntimeException("invalid syntax in eval form:\n" + sourceMessages.toString(20));
        }
        return procedure;
    }

    public Procedure evalToFocusProc(Reader reader, SourceMessages sourceMessages) throws Throwable {
        InPort inPort = reader instanceof InPort ? (InPort)reader : new InPort(reader);
        Compilation compilation = this.parse(inPort, sourceMessages, 65537);
        CallContext callContext = CallContext.getInstance();
        int n = callContext.startFromContext();
        try {
            ModuleExp.evalModule(Environment.getCurrent(), callContext, compilation);
            return (Procedure)callContext.getFromContext(n);
        }
        catch (Throwable throwable) {
            callContext.cleanupFromContext(n);
            throw throwable;
        }
    }

    public void evalWithFocus(Reader reader, SourceMessages sourceMessages, Object object2, Consumer consumer) throws Throwable {
        this.applyWithFocus(this.evalToFocusProc(reader, sourceMessages), object2, consumer);
    }

    public Object evalWithFocus(String string, Object object2) throws Throwable {
        return this.applyWithFocus(this.evalToFocusProc(string), object2);
    }

    public Object evalWithFocus(String string, Object object2, int n, int n2) throws Throwable {
        return this.applyWithFocus(this.evalToFocusProc(string), object2, n, n2);
    }

    public void evalWithFocus(Reader reader, SourceMessages sourceMessages, Object object2, int n, int n2, Consumer consumer) throws Throwable {
        this.applyWithFocus(this.evalToFocusProc(reader, sourceMessages), object2, n, n2, consumer);
    }

    public void eval_with_focus$X(String string, Object object2, CallContext callContext) throws Throwable {
        this.applyWithFocus$X(this.evalToFocusProc(string), object2, callContext);
    }

    public void eval_with_focus$X(String string, Object object2, int n, int n2, CallContext callContext) throws Throwable {
        Procedure procedure = this.evalToFocusProc(string);
        procedure.check3(object2, IntNum.make(n), IntNum.make(n2), callContext);
    }

    public XQuery() {
        this.environ = xqEnvironment;
        this.defaultNamespace = xqueryFunctionNamespace;
    }

    private void initXQuery() {
        ModuleBody.setMainPrintValues(true);
        this.defProcStFld("unescaped-data", "gnu.kawa.xml.MakeUnescapedData", "unescapedData");
        this.defProcStFld("item-at", "gnu.xquery.util.ItemAt", "itemAt");
        this.defProcStFld("count", "gnu.kawa.functions.CountValues", "countValues");
        this.defProcStFld("min", "gnu.xquery.util.MinMax", "min");
        this.defProcStFld("max", "gnu.xquery.util.MinMax", "max");
        this.defProcStFld("sum", "gnu.xquery.util.Reduce", "sum");
        this.defProcStFld("avg", "gnu.xquery.util.Average", "avg");
        this.defProcStFld("index-of", "gnu.xquery.util.IndexOf", "indexOf");
        this.defProcStFld("last-index-of", "gnu.xquery.util.LastIndexOf", "lastIndexOf");
        this.defProcStFld("sublist", "gnu.xquery.util.SubList", "subList");
        this.define_method("empty", "gnu.xquery.util.SequenceUtils", "isEmptySequence");
        this.define_method("exists", "gnu.xquery.util.SequenceUtils", "exists");
        this.define_method("reverse", "gnu.xquery.util.SequenceUtils", "reverse");
        this.defProcStFld("false", "gnu.xquery.lang.XQuery", "falseFunction");
        this.defProcStFld("true", "gnu.xquery.lang.XQuery", "trueFunction");
        this.defProcStFld("number", "gnu.xquery.util.NumberValue", "numberValue");
        this.defProcStFld("string-value", "gnu.xquery.util.StringValue", "stringValue");
        this.defProcStFld("string", "gnu.xquery.util.StringValue", "string");
        this.define_method("trace", "gnu.xquery.util.Debug", "trace");
        this.defProcStFld("write-to", "gnu.kawa.xml.WriteTo", "writeTo");
        this.defProcStFld("iterator-items", "gnu.kawa.xml.IteratorItems", "iteratorItems");
        this.defProcStFld("list-items", "gnu.kawa.xml.ListItems", "listItems");
        this.defProcStFld("base-uri", "gnu.kawa.functions.BaseUri", "baseUri");
        this.define_method("node-name", "gnu.kawa.xml.NodeName", "nodeName");
        this.define_method("lower-case", "gnu.xquery.util.StringValue", "lowerCase");
        this.define_method("upper-case", "gnu.xquery.util.StringValue", "upperCase");
        this.define_method("substring", "gnu.xquery.util.StringValue", "substring");
        this.define_method("string-length", "gnu.xquery.util.StringValue", "stringLength");
        this.define_method("substring-before", "gnu.xquery.util.StringValue", "substringBefore");
        this.define_method("substring-after", "gnu.xquery.util.StringValue", "substringAfter");
        this.define_method("translate", "gnu.xquery.util.StringValue", "translate");
        this.define_method("string-pad", "gnu.xquery.util.StringValue", "stringPad");
        this.define_method("contains", "gnu.xquery.util.StringValue", "contains");
        this.define_method("starts-with", "gnu.xquery.util.StringValue", "startsWith");
        this.define_method("ends-with", "gnu.xquery.util.StringValue", "endsWith");
        this.define_method("string-join", "gnu.xquery.util.StringValue", "stringJoin");
        this.define_method("concat", "gnu.xquery.util.StringValue", "concat");
        this.define_method("QName", "gnu.xquery.util.QNameUtils", "makeQName");
        this.define_method("prefix-from-QName", "gnu.xquery.util.QNameUtils", "prefixFromQName");
        this.define_method("local-name-from-QName", "gnu.xquery.util.QNameUtils", "localNameFromQName");
        this.define_method("namespace-uri-from-QName", "gnu.xquery.util.QNameUtils", "namespaceURIFromQName");
        this.define_method("namespace-uri-for-prefix", "gnu.xquery.util.QNameUtils", "namespaceURIForPrefix");
        this.defProcStFld("distinct-nodes", "gnu.kawa.xml.SortNodes", "sortNodes");
        this.defProcStFld("children", "gnu.kawa.xml.Children", "children");
        this.defProcStFld("not", "kawa.standard.Scheme");
        this.defaultNamespace = qexoFunctionNamespace;
        this.defProcStFld("response-header", "gnu.kawa.slib.HTTP");
        this.defProcStFld("response-content-type", "gnu.kawa.slib.HTTP");
        this.defProcStFld("response-status", "gnu.kawa.slib.HTTP");
        this.defProcStFld("error-response", "gnu.kawa.slib.HTTP");
        this.defProcStFld("current-servlet", "gnu.kawa.slib.HTTP");
        this.defProcStFld("current-servlet-context", "gnu.kawa.slib.HTTP");
        this.defProcStFld("current-servlet-config", "gnu.kawa.slib.HTTP");
        this.defProcStFld("servlet-context-realpath", "gnu.kawa.slib.HTTP");
        this.defProcStFld("get-response", "gnu.kawa.slib.HTTP");
        this.defProcStFld("get-request", "gnu.kawa.slib.HTTP");
        this.defProcStFld("request-method", "gnu.kawa.slib.HTTP");
        this.defProcStFld("request-uri", "gnu.kawa.slib.HTTP");
        this.defProcStFld("request-url", "gnu.kawa.slib.HTTP");
        this.defProcStFld("request-path-info", "gnu.kawa.slib.HTTP");
        this.defProcStFld("request-path-translated", "gnu.kawa.slib.HTTP");
        this.defProcStFld("request-servlet-path", "gnu.kawa.slib.HTTP");
        this.defProcStFld("request-query-string", "gnu.kawa.slib.HTTP");
        this.defProcStFld("request-parameter", "gnu.kawa.slib.HTTP");
        this.defProcStFld("request-parameters", "gnu.kawa.slib.HTTP");
        this.defaultNamespace = xqueryFunctionNamespace;
    }

    public static XQuery getInstance() {
        return instance;
    }

    public static void registerEnvironment() {
        Language.setDefaults(new XQuery());
    }

    public AbstractFormat getFormat(boolean bl) {
        return writeFormat;
    }

    public Consumer getOutputConsumer(Writer writer) {
        return new XMLPrinter(writer, false);
    }

    public Type getTypeFor(String string) {
        if (string == "t") {
            string = "java.lang.Object";
        }
        String string2 = string.startsWith("xs:") ? string.substring(3) : string;
        int n = typeMap.length;
        while ((n -= 2) >= 0) {
            if (!typeMap[n].equals(string2)) continue;
            Object object2 = typeMap[n + 1];
            if (object2 instanceof String) {
                return Scheme.string2Type((String)object2);
            }
            return (Type)object2;
        }
        return Scheme.string2Type(string);
    }

    public Type getTypeFor(Class clazz) {
        if (clazz.isPrimitive()) {
            String string = clazz.getName();
            if (string.equals("boolean")) {
                if (this.booleanType == null) {
                    this.booleanType = new LangPrimType(Type.boolean_type, this);
                }
                return this.booleanType;
            }
            return Scheme.getNamedType(string);
        }
        return Type.make(clazz);
    }

    public Procedure getPrompter() {
        return new Prompter();
    }

    static void mangle(String string, int n, int n2, StringBuffer stringBuffer, char c) {
        int n3 = 80;
        int n4 = stringBuffer.length();
        int n5 = 0;
        while (n5 < n2) {
            boolean bl;
            char c2 = string.charAt(n + n5);
            ++n5;
            if (Character.isUpperCase(c2)) {
                bl = n3 != 85 || n5 < n2 && Character.isLowerCase(string.charAt(n + n5));
                n3 = 85;
            } else if (Character.isLowerCase(c2)) {
                bl = n3 != 76 || n3 != 85;
                n3 = 76;
            } else if (Character.isLetter(c2)) {
                bl = n3 != 79;
                n3 = 79;
            } else if (Character.isDigit(c2)) {
                bl = n3 != 68;
                n3 = 68;
            } else if (Character.isJavaIdentifierPart(c2)) {
                bl = n3 != 68 && n3 != 77;
                n3 = 77;
            } else {
                n3 = 80;
                continue;
            }
            if (bl || c == '_') {
                if (bl && c == '_' && stringBuffer.length() > n4) {
                    stringBuffer.append('_');
                }
                c2 = Character.toUpperCase(c2);
            }
            stringBuffer.append(c2);
        }
    }

    public static String mangle(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        XQuery.mangle(string, 0, string.length(), stringBuffer, 'U');
        return stringBuffer.toString();
    }

    public static Object getExternal(SName sName, Object object2) {
        Symbol symbol;
        Environment environment = Environment.getCurrent();
        Object object3 = environment.get(symbol = sName.getSymbol(), null, null);
        if (object3 == null) {
            throw new RuntimeException("unbound external " + sName);
        }
        if (object2 instanceof ClassType) {
            String string = ((ClassType)object2).getName();
            if ("gnu.math.IntNum".equals(string)) {
                object3 = IntNum.valueOf(object3.toString());
            } else if ("gnu.math.RealNum".equals(string)) {
                object3 = DFloNum.make(Double.parseDouble(object3.toString()));
            } else {
                throw new Error("cast to " + string + " for external " + sName + " not implemented");
            }
        }
        return object3;
    }

    static {
        instance.initXQuery();
        falseFunction = new ConstantFunction0("false", Boolean.FALSE);
        trueFunction = new ConstantFunction0("true", Boolean.TRUE);
        writeFormat = new XMLFormat();
        typeMap = new Object[]{"string", Type.string_type, "boolean", Type.boolean_type, "QName", "gnu.xml.SName", "integer", "gnu.math.IntNum", "positiveInteger", "gnu.math.IntNum", "nonPositiveInteger", "gnu.math.IntNum", "negativeInteger", "gnu.math.IntNum", "nonNegativeInteger", "gnu.math.IntNum", "decimal", "gnu.math.RealNum"};
    }
}

