/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Scope;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.ModuleExp;

public abstract class ScopeExp
extends Expression {
    Declaration decls;
    Declaration last;
    private Scope scope;
    public ScopeExp outer;
    static int counter;
    public int id = ++counter;

    public Declaration firstDecl() {
        return this.decls;
    }

    public Scope getVarScope() {
        Scope scope = this.scope;
        if (scope == null) {
            this.scope = scope = new Scope();
        }
        return scope;
    }

    public void popScope(CodeAttr codeAttr) {
        for (Declaration declaration = this.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            declaration.var = null;
        }
        codeAttr.popScope();
        this.scope = null;
    }

    public void add(Declaration declaration) {
        if (this.last == null) {
            this.decls = declaration;
        } else {
            this.last.next = declaration;
        }
        this.last = declaration;
        declaration.context = this;
    }

    public void add(Declaration declaration, Declaration declaration2) {
        if (declaration == null) {
            declaration2.next = this.decls;
            this.decls = declaration2;
        } else {
            declaration2.next = declaration.next;
            declaration.next = declaration2;
        }
        if (this.last == declaration) {
            this.last = declaration2;
        }
        declaration2.context = this;
    }

    public void replaceFollowing(Declaration declaration, Declaration declaration2) {
        Declaration declaration3;
        if (declaration == null) {
            declaration3 = this.decls;
            this.decls = declaration2;
        } else {
            declaration3 = declaration.next;
            declaration.next = declaration2;
        }
        declaration2.next = declaration3.next;
        if (this.last == declaration3) {
            this.last = declaration2;
        }
        declaration3.next = null;
    }

    public void remove(Declaration declaration) {
        Declaration declaration2 = null;
        for (Declaration declaration3 = this.firstDecl(); declaration3 != null; declaration3 = declaration3.nextDecl()) {
            if (declaration3 == declaration) {
                this.remove(declaration2, declaration);
                return;
            }
            declaration2 = declaration3;
        }
    }

    public void remove(Declaration declaration, Declaration declaration2) {
        if (declaration == null) {
            this.decls = declaration2.next;
        } else {
            declaration.next = declaration2.next;
        }
        if (this.last == declaration2) {
            this.last = declaration;
        }
    }

    public LambdaExp currentLambda() {
        ScopeExp scopeExp = this;
        while (scopeExp != null) {
            if (scopeExp instanceof LambdaExp) {
                return (LambdaExp)scopeExp;
            }
            scopeExp = scopeExp.outer;
        }
        return null;
    }

    public ModuleExp currentModule() {
        ScopeExp scopeExp = this;
        while (scopeExp != null) {
            if (scopeExp instanceof ModuleExp) {
                return (ModuleExp)scopeExp;
            }
            scopeExp = scopeExp.outer;
        }
        return null;
    }

    public Declaration lookup(Object object2) {
        for (Declaration declaration = this.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (declaration.symbol != object2) continue;
            return declaration;
        }
        return null;
    }

    public Declaration lookup(Object object2, Language language, int n) {
        for (Declaration declaration = this.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (declaration.symbol != object2 || (language.getNamespaceOf(declaration) & n) == 0) continue;
            return declaration;
        }
        return null;
    }

    public Declaration getNoDefine(Object object2) {
        Declaration declaration = this.lookup(object2);
        if (declaration == null) {
            declaration = this.addDeclaration(object2);
            declaration.flags |= 0x10200;
        }
        return declaration;
    }

    public Declaration getDefine(Object object2, char c, Compilation compilation) {
        Declaration declaration = this.lookup(object2);
        if (declaration == null) {
            declaration = this.addDeclaration(object2);
        } else if ((declaration.flags & 0x10200) != 0) {
            declaration.flags &= 0xFFFEFDFF;
        } else {
            compilation.error(c, "duplicate definition of '" + object2 + "' here");
            compilation.error(c, declaration, "previous definition of '", "' here");
            declaration = this.addDeclaration(object2);
        }
        return declaration;
    }

    public final Declaration addDeclaration(Object object2) {
        Declaration declaration = new Declaration(object2);
        this.add(declaration);
        return declaration;
    }

    public final Declaration addDeclaration(Object object2, Type type) {
        Declaration declaration = new Declaration(object2, type);
        this.add(declaration);
        return declaration;
    }

    public final void addDeclaration(Declaration declaration) {
        this.add(declaration);
    }

    public int countDecls() {
        int n = 0;
        for (Declaration declaration = this.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            ++n;
        }
        return n;
    }

    public static int nesting(ScopeExp scopeExp) {
        int n = 0;
        while (scopeExp != null) {
            scopeExp = scopeExp.outer;
            ++n;
        }
        return n;
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkScopeExp(this);
    }

    public String toString() {
        return this.getClass().getName() + "#" + this.id;
    }
}

