/* translation of file(s)
	"bpel-abstract.k"
	"bpel-unparse-petri.k"
	"bpel-unparse-petri2.k"
	"bpel-unparse-xml.k"
	"bpel-unparse-cfg.k"
	"ast-printers.k"
 */
/* generated by:
 *  @(#)$Author: Kimwitu++ version 2.3.8 (C) 1998-2003 Humboldt-University of Berlin $
 */
#ifndef KC_TYPES_HEADER
#define KC_TYPES_HEADER

#define KIMWITUVERSIONMAJOR 2
#define KIMWITUVERSIONMINOR 3
#define KIMWITUVERSIONMICRO 8

#include <stdio.h>
#include <stddef.h>
#include <string>

namespace kc {

#ifndef INTEGER
# define INTEGER int
#endif
#ifndef REAL
# define REAL double
#endif

#ifdef KC_UNICODE

#define kc_t(TEXT) L ## TEXT
typedef wchar_t kc_char_t;
typedef std::wstring kc_string_t;

#if defined(_WIN32) && ! defined (__GNUC__)
#define kc_strlen wcslen
#define kc_strcmp wcscmp
#define kc_strcasecmp _wcsicmp
#define kc_strcpy wcscpy
#define kc_strncpy wcsncpy
#define kc_tolower towlower
#define kc_print_integer(buf,number) swprintf(buf,kc_t("%d"),number)
#define kc_print_real(buf,number) swprintf(buf,kc_t("%g"),number)

// needed for printdot and csgio only
inline
std::string kc_to_cstring(const std::wstring& s) {
    USES_CONVERSION;
    return W2CA(s.c_str());
}

// needed for csgio only
inline
std::wstring kc_to_wstring(const std::string& s) {
    USES_CONVERSION;
    return A2CW(s.c_str());
}

#else // !defined(_WIN32) || defined(__GNUC__)
// if you want to use UNICODE on other platforms you have to write
// the following functions on your own
int kc_strlen(const kc_char_t*);
int kc_strcmp(const kc_char_t*,const kc_char_t*);
int kc_strcasecmp(const kc_char_t*,const kc_char_t*);
int kc_strcpy(kc_char_t*,const kc_char_t*);
int kc_strncpy(kc_char_t*,const kc_char_t*, int);
kc_char_t kc_tolower(kc_char_t);
int kc_print_integer(kc_char_t* buffer, INTEGER number );
int kc_print_real(kc_char_t* buffer, REAL number);

// needed for printdot and csgio only
std::string kc_to_cstring(const std::wstring& );
// needed for csgio only
std::wstring kc_to_wstring(const std::string& );

#endif

#else // !KC_UNICODE

#define kc_t(TEXT) TEXT  
typedef char kc_char_t;
typedef std::string kc_string_t;

#define kc_strlen strlen
#define kc_strcmp strcmp
#if defined(_WIN32) && ! defined (__GNUC__)
#define kc_strcasecmp _stricmp
#else
#define kc_strcasecmp strcasecmp
#endif
#define kc_strcpy strcpy
#define kc_strncpy strncpy
#define kc_tolower tolower  
#define kc_print_integer(buf,number) sprintf(buf,kc_t("%d"),number)
#define kc_print_real(buf,number) sprintf(buf,kc_t("%g"),number)
#endif
class uview_class;
typedef uview_class& uview;
typedef const uview_class& c_uview;

typedef class printer_functor_class& printer_functor;
typedef void (*printer_function)(const kc_char_t*, uview);

class rview_class;
typedef rview_class& rview;
typedef const rview_class& c_rview;

}

// Some compilers know __attribute__. Right now we test for the GNU compiler
// and Intel's icc (for ia32) and ecc (for ia64).
#if !defined __GNUC__ && !defined __ICC && !defined __ECC
# define __attribute__(x)
#endif

// Since all definitions are in namespace kc now, there is no need
// give them a kc_ prefix. Old code may still rely on the prefix, so these
// macros are generated for backwards compatibility
#ifdef KC_DEPRECATED
#define kc_PhylumInfo           phylum_info
#define kc_OperatorInfo         operator_info
#define kc_last_uview           last_uview
#define kc_uviews               uviews
#define kc_rviews               rviews
#define kc_ht_reuse             ht_clear
#define kc_ht_clear             ht_clear
#define kc_ht_assign            ht_assign
#define kc_ht_assigned          ht_assigned
#define kc_phylum_nocasestring phylum_nocasestring
#define kc_tag_nocasestring_NoCaseStr impl_nocasestring_NoCaseStr
#define kc_phylum_casestring phylum_casestring
#define kc_tag_casestring__Str impl_casestring__Str
#define kc_phylum_real phylum_real
#define kc_tag_real__Real impl_real__Real
#define kc_phylum_integer phylum_integer
#define kc_tag_integer__Int impl_integer__Int
#define kc_phylum_voidptr phylum_voidptr
#define kc_tag_voidptr__VoidPtr impl_voidptr__VoidPtr
#define kc_phylum_tProcess phylum_tProcess
#define kc_tag_tProcess_Process impl_tProcess_Process
#define kc_phylum_tStop phylum_tStop
#define kc_tag_tStop_StopInProcess impl_tStop_StopInProcess
#define kc_tag_tStop_StopInScope impl_tStop_StopInScope
#define kc_phylum_activity phylum_activity
#define kc_tag_activity_activityEmpty impl_activity_activityEmpty
#define kc_tag_activity_activityInvoke impl_activity_activityInvoke
#define kc_tag_activity_activityReceive impl_activity_activityReceive
#define kc_tag_activity_activityReply impl_activity_activityReply
#define kc_tag_activity_activityAssign impl_activity_activityAssign
#define kc_tag_activity_activityWait impl_activity_activityWait
#define kc_tag_activity_activityThrow impl_activity_activityThrow
#define kc_tag_activity_activityTerminate impl_activity_activityTerminate
#define kc_tag_activity_activityFlow impl_activity_activityFlow
#define kc_tag_activity_activitySwitch impl_activity_activitySwitch
#define kc_tag_activity_activityWhile impl_activity_activityWhile
#define kc_tag_activity_activitySequence impl_activity_activitySequence
#define kc_tag_activity_activityPick impl_activity_activityPick
#define kc_tag_activity_activityScope impl_activity_activityScope
#define kc_tag_activity_activityCompensate impl_activity_activityCompensate
#define kc_phylum_tPartnerLink_list phylum_tPartnerLink_list
#define kc_tag_tPartnerLink_list_NiltPartnerLink_list impl_tPartnerLink_list_NiltPartnerLink_list
#define kc_tag_tPartnerLink_list_ConstPartnerLink_list impl_tPartnerLink_list_ConstPartnerLink_list
#define kc_phylum_tPartnerLink phylum_tPartnerLink
#define kc_tag_tPartnerLink_PartnerLink impl_tPartnerLink_PartnerLink
#define kc_phylum_tPartner_list phylum_tPartner_list
#define kc_tag_tPartner_list_NiltPartner_list impl_tPartner_list_NiltPartner_list
#define kc_tag_tPartner_list_ConstPartner_list impl_tPartner_list_ConstPartner_list
#define kc_phylum_tPartner phylum_tPartner
#define kc_tag_tPartner_Partner impl_tPartner_Partner
#define kc_phylum_tFaultHandlers phylum_tFaultHandlers
#define kc_tag_tFaultHandlers_userDefinedFaultHandler impl_tFaultHandlers_userDefinedFaultHandler
#define kc_tag_tFaultHandlers_implicitFaultHandler impl_tFaultHandlers_implicitFaultHandler
#define kc_phylum_tCatch_list phylum_tCatch_list
#define kc_tag_tCatch_list_NiltCatch_list impl_tCatch_list_NiltCatch_list
#define kc_tag_tCatch_list_ConstCatch_list impl_tCatch_list_ConstCatch_list
#define kc_phylum_tCatch phylum_tCatch
#define kc_tag_tCatch_Catch impl_tCatch_Catch
#define kc_phylum_tCatchAll phylum_tCatchAll
#define kc_tag_tCatchAll_CatchAll impl_tCatchAll_CatchAll
#define kc_tag_tCatchAll_NoCatchAll impl_tCatchAll_NoCatchAll
#define kc_phylum_tEventHandlers phylum_tEventHandlers
#define kc_tag_tEventHandlers_implicitEventHandler impl_tEventHandlers_implicitEventHandler
#define kc_tag_tEventHandlers_userDefinedEventHandler impl_tEventHandlers_userDefinedEventHandler
#define kc_phylum_tOnMessage_list phylum_tOnMessage_list
#define kc_tag_tOnMessage_list_NiltOnMessage_list impl_tOnMessage_list_NiltOnMessage_list
#define kc_tag_tOnMessage_list_ConstOnMessage_list impl_tOnMessage_list_ConstOnMessage_list
#define kc_phylum_tOnAlarm_list phylum_tOnAlarm_list
#define kc_tag_tOnAlarm_list_NiltOnAlarm_list impl_tOnAlarm_list_NiltOnAlarm_list
#define kc_tag_tOnAlarm_list_ConstOnAlarm_list impl_tOnAlarm_list_ConstOnAlarm_list
#define kc_phylum_tOnMessage phylum_tOnMessage
#define kc_tag_tOnMessage_OnMessage impl_tOnMessage_OnMessage
#define kc_phylum_tOnAlarm phylum_tOnAlarm
#define kc_tag_tOnAlarm_OnAlarm impl_tOnAlarm_OnAlarm
#define kc_phylum_tCompensationHandler phylum_tCompensationHandler
#define kc_tag_tCompensationHandler_implicitCompensationHandler impl_tCompensationHandler_implicitCompensationHandler
#define kc_tag_tCompensationHandler_userDefinedCompensationHandler impl_tCompensationHandler_userDefinedCompensationHandler
#define kc_tag_tCompensationHandler_processCompensationHandler impl_tCompensationHandler_processCompensationHandler
#define kc_phylum_tVariable_list phylum_tVariable_list
#define kc_tag_tVariable_list_NiltVariable_list impl_tVariable_list_NiltVariable_list
#define kc_tag_tVariable_list_ConstVariable_list impl_tVariable_list_ConstVariable_list
#define kc_phylum_tVariable phylum_tVariable
#define kc_tag_tVariable_Variable impl_tVariable_Variable
#define kc_phylum_tCorrelationSet_list phylum_tCorrelationSet_list
#define kc_tag_tCorrelationSet_list_NiltCorrelationSet_list impl_tCorrelationSet_list_NiltCorrelationSet_list
#define kc_tag_tCorrelationSet_list_ConstCorrelationSet_list impl_tCorrelationSet_list_ConstCorrelationSet_list
#define kc_phylum_tCorrelationSet phylum_tCorrelationSet
#define kc_tag_tCorrelationSet_CorrelationSet impl_tCorrelationSet_CorrelationSet
#define kc_phylum_tCorrelation_list phylum_tCorrelation_list
#define kc_tag_tCorrelation_list_NiltCorrelation_list impl_tCorrelation_list_NiltCorrelation_list
#define kc_tag_tCorrelation_list_ConstCorrelation_list impl_tCorrelation_list_ConstCorrelation_list
#define kc_phylum_tCorrelation phylum_tCorrelation
#define kc_tag_tCorrelation_Correlation impl_tCorrelation_Correlation
#define kc_phylum_tEmpty phylum_tEmpty
#define kc_tag_tEmpty_Empty impl_tEmpty_Empty
#define kc_phylum_tInvoke phylum_tInvoke
#define kc_tag_tInvoke_Invoke impl_tInvoke_Invoke
#define kc_phylum_tReceive phylum_tReceive
#define kc_tag_tReceive_Receive impl_tReceive_Receive
#define kc_phylum_tReply phylum_tReply
#define kc_tag_tReply_Reply impl_tReply_Reply
#define kc_phylum_tAssign phylum_tAssign
#define kc_tag_tAssign_Assign impl_tAssign_Assign
#define kc_phylum_tCopy_list phylum_tCopy_list
#define kc_tag_tCopy_list_NiltCopy_list impl_tCopy_list_NiltCopy_list
#define kc_tag_tCopy_list_ConstCopy_list impl_tCopy_list_ConstCopy_list
#define kc_phylum_tCopy phylum_tCopy
#define kc_tag_tCopy_Copy impl_tCopy_Copy
#define kc_phylum_tFrom phylum_tFrom
#define kc_tag_tFrom_From impl_tFrom_From
#define kc_phylum_tTo phylum_tTo
#define kc_tag_tTo_To impl_tTo_To
#define kc_phylum_tWait phylum_tWait
#define kc_tag_tWait_WaitFor impl_tWait_WaitFor
#define kc_tag_tWait_WaitUntil impl_tWait_WaitUntil
#define kc_phylum_tThrow phylum_tThrow
#define kc_tag_tThrow_Throw impl_tThrow_Throw
#define kc_phylum_tCompensate phylum_tCompensate
#define kc_tag_tCompensate_Compensate impl_tCompensate_Compensate
#define kc_phylum_tTerminate phylum_tTerminate
#define kc_tag_tTerminate_Terminate impl_tTerminate_Terminate
#define kc_phylum_tFlow phylum_tFlow
#define kc_tag_tFlow_Flow impl_tFlow_Flow
#define kc_phylum_activity_list phylum_activity_list
#define kc_tag_activity_list_Nilactivity_list impl_activity_list_Nilactivity_list
#define kc_tag_activity_list_Consactivity_list impl_activity_list_Consactivity_list
#define kc_phylum_tLink_list phylum_tLink_list
#define kc_tag_tLink_list_NiltLink_list impl_tLink_list_NiltLink_list
#define kc_tag_tLink_list_ConstLink_list impl_tLink_list_ConstLink_list
#define kc_phylum_tLink phylum_tLink
#define kc_tag_tLink_Link impl_tLink_Link
#define kc_phylum_tSwitch phylum_tSwitch
#define kc_tag_tSwitch_Switch impl_tSwitch_Switch
#define kc_phylum_tCase_list phylum_tCase_list
#define kc_tag_tCase_list_NiltCase_list impl_tCase_list_NiltCase_list
#define kc_tag_tCase_list_ConstCase_list impl_tCase_list_ConstCase_list
#define kc_phylum_tCase phylum_tCase
#define kc_tag_tCase_Case impl_tCase_Case
#define kc_phylum_tOtherwise phylum_tOtherwise
#define kc_tag_tOtherwise_Otherwise impl_tOtherwise_Otherwise
#define kc_phylum_tWhile phylum_tWhile
#define kc_tag_tWhile_While impl_tWhile_While
#define kc_phylum_tSequence phylum_tSequence
#define kc_tag_tSequence_Sequence impl_tSequence_Sequence
#define kc_phylum_tPick phylum_tPick
#define kc_tag_tPick_Pick impl_tPick_Pick
#define kc_phylum_tScope phylum_tScope
#define kc_tag_tScope_Scope impl_tScope_Scope
#define kc_phylum_standardElements phylum_standardElements
#define kc_tag_standardElements_StandardElements impl_standardElements_StandardElements
#define kc_phylum_tTarget_list phylum_tTarget_list
#define kc_tag_tTarget_list_NiltTarget_list impl_tTarget_list_NiltTarget_list
#define kc_tag_tTarget_list_ConstTarget_list impl_tTarget_list_ConstTarget_list
#define kc_phylum_tTarget phylum_tTarget
#define kc_tag_tTarget_Target impl_tTarget_Target
#define kc_phylum_tSource_list phylum_tSource_list
#define kc_tag_tSource_list_NiltSource_list impl_tSource_list_NiltSource_list
#define kc_tag_tSource_list_ConstSource_list impl_tSource_list_ConstSource_list
#define kc_phylum_tSource phylum_tSource
#define kc_tag_tSource_Source impl_tSource_Source

#endif // KC_DEPRECATED

// Some compilers are too stupid to detect that a function will always return
// a proper value when it returns one in all branches of an if- or switch-
// statement (with final else or default, of course).
#if !defined __GNUC__
# define NORETURN throw 0;
#else
# define NORETURN
#endif

namespace kc {


typedef enum { one_before_first_phylum = 0 ,
    phylum_nocasestring = 1,
    phylum_casestring = 2,
    phylum_real = 3,
    phylum_integer = 4,
    phylum_voidptr = 5,
    phylum_tProcess = 6,
    phylum_tStop = 7,
    phylum_activity = 8,
    phylum_tPartnerLink_list = 9,
    phylum_tPartnerLink = 10,
    phylum_tPartner_list = 11,
    phylum_tPartner = 12,
    phylum_tFaultHandlers = 13,
    phylum_tCatch_list = 14,
    phylum_tCatch = 15,
    phylum_tCatchAll = 16,
    phylum_tEventHandlers = 17,
    phylum_tOnMessage_list = 18,
    phylum_tOnAlarm_list = 19,
    phylum_tOnMessage = 20,
    phylum_tOnAlarm = 21,
    phylum_tCompensationHandler = 22,
    phylum_tVariable_list = 23,
    phylum_tVariable = 24,
    phylum_tCorrelationSet_list = 25,
    phylum_tCorrelationSet = 26,
    phylum_tCorrelation_list = 27,
    phylum_tCorrelation = 28,
    phylum_tEmpty = 29,
    phylum_tInvoke = 30,
    phylum_tReceive = 31,
    phylum_tReply = 32,
    phylum_tAssign = 33,
    phylum_tCopy_list = 34,
    phylum_tCopy = 35,
    phylum_tFrom = 36,
    phylum_tTo = 37,
    phylum_tWait = 38,
    phylum_tThrow = 39,
    phylum_tCompensate = 40,
    phylum_tTerminate = 41,
    phylum_tFlow = 42,
    phylum_activity_list = 43,
    phylum_tLink_list = 44,
    phylum_tLink = 45,
    phylum_tSwitch = 46,
    phylum_tCase_list = 47,
    phylum_tCase = 48,
    phylum_tOtherwise = 49,
    phylum_tWhile = 50,
    phylum_tSequence = 51,
    phylum_tPick = 52,
    phylum_tScope = 53,
    phylum_standardElements = 54,
    phylum_tTarget_list = 55,
    phylum_tTarget = 56,
    phylum_tSource_list = 57,
    phylum_tSource = 58,
    last_phylum = 59
} enum_phyla;

typedef enum { one_before_first_operator = 0 ,
    sel_NoCaseStr = 1,
    sel__Str = 2,
    sel__Real = 3,
    sel__Int = 4,
    sel__VoidPtr = 5,
    sel_Process = 6,
    sel_StopInProcess = 7,
    sel_StopInScope = 8,
    sel_activityEmpty = 9,
    sel_activityInvoke = 10,
    sel_activityReceive = 11,
    sel_activityReply = 12,
    sel_activityAssign = 13,
    sel_activityWait = 14,
    sel_activityThrow = 15,
    sel_activityTerminate = 16,
    sel_activityFlow = 17,
    sel_activitySwitch = 18,
    sel_activityWhile = 19,
    sel_activitySequence = 20,
    sel_activityPick = 21,
    sel_activityScope = 22,
    sel_activityCompensate = 23,
    sel_NiltPartnerLink_list = 24,
    sel_ConstPartnerLink_list = 25,
    sel_PartnerLink = 26,
    sel_NiltPartner_list = 27,
    sel_ConstPartner_list = 28,
    sel_Partner = 29,
    sel_userDefinedFaultHandler = 30,
    sel_implicitFaultHandler = 31,
    sel_NiltCatch_list = 32,
    sel_ConstCatch_list = 33,
    sel_Catch = 34,
    sel_CatchAll = 35,
    sel_NoCatchAll = 36,
    sel_implicitEventHandler = 37,
    sel_userDefinedEventHandler = 38,
    sel_NiltOnMessage_list = 39,
    sel_ConstOnMessage_list = 40,
    sel_NiltOnAlarm_list = 41,
    sel_ConstOnAlarm_list = 42,
    sel_OnMessage = 43,
    sel_OnAlarm = 44,
    sel_implicitCompensationHandler = 45,
    sel_userDefinedCompensationHandler = 46,
    sel_processCompensationHandler = 47,
    sel_NiltVariable_list = 48,
    sel_ConstVariable_list = 49,
    sel_Variable = 50,
    sel_NiltCorrelationSet_list = 51,
    sel_ConstCorrelationSet_list = 52,
    sel_CorrelationSet = 53,
    sel_NiltCorrelation_list = 54,
    sel_ConstCorrelation_list = 55,
    sel_Correlation = 56,
    sel_Empty = 57,
    sel_Invoke = 58,
    sel_Receive = 59,
    sel_Reply = 60,
    sel_Assign = 61,
    sel_NiltCopy_list = 62,
    sel_ConstCopy_list = 63,
    sel_Copy = 64,
    sel_From = 65,
    sel_To = 66,
    sel_WaitFor = 67,
    sel_WaitUntil = 68,
    sel_Throw = 69,
    sel_Compensate = 70,
    sel_Terminate = 71,
    sel_Flow = 72,
    sel_Nilactivity_list = 73,
    sel_Consactivity_list = 74,
    sel_NiltLink_list = 75,
    sel_ConstLink_list = 76,
    sel_Link = 77,
    sel_Switch = 78,
    sel_NiltCase_list = 79,
    sel_ConstCase_list = 80,
    sel_Case = 81,
    sel_Otherwise = 82,
    sel_While = 83,
    sel_Sequence = 84,
    sel_Pick = 85,
    sel_Scope = 86,
    sel_StandardElements = 87,
    sel_NiltTarget_list = 88,
    sel_ConstTarget_list = 89,
    sel_Target = 90,
    sel_NiltSource_list = 91,
    sel_ConstSource_list = 92,
    sel_Source = 93,
    last_operator = 94
} enum_operators;

class impl_abstract_phylum;
typedef impl_abstract_phylum * abstract_phylum;
typedef const impl_abstract_phylum * c_abstract_phylum;
class impl_abstract_list;
typedef impl_abstract_list * abstract_list;
typedef const impl_abstract_list * c_abstract_list;

template <typename P, typename T>
P phylum_cast(T* t) {
    return static_cast<P>(t);
}
template <typename P, typename T>
const P phylum_cast(const T* t) {
    return static_cast<const P>(t);
}
class impl_nocasestring_NoCaseStr;
class impl_casestring__Str;
class impl_real__Real;
class impl_integer__Int;
class impl_voidptr__VoidPtr;
class impl_tProcess;
class impl_tStop;
class impl_activity;
class impl_tPartnerLink_list;
class impl_tPartnerLink;
class impl_tPartner_list;
class impl_tPartner;
class impl_tFaultHandlers;
class impl_tCatch_list;
class impl_tCatch;
class impl_tCatchAll;
class impl_tEventHandlers;
class impl_tOnMessage_list;
class impl_tOnAlarm_list;
class impl_tOnMessage;
class impl_tOnAlarm;
class impl_tCompensationHandler;
class impl_tVariable_list;
class impl_tVariable;
class impl_tCorrelationSet_list;
class impl_tCorrelationSet;
class impl_tCorrelation_list;
class impl_tCorrelation;
class impl_tEmpty;
class impl_tInvoke;
class impl_tReceive;
class impl_tReply;
class impl_tAssign;
class impl_tCopy_list;
class impl_tCopy;
class impl_tFrom;
class impl_tTo;
class impl_tWait;
class impl_tThrow;
class impl_tCompensate;
class impl_tTerminate;
class impl_tFlow;
class impl_activity_list;
class impl_tLink_list;
class impl_tLink;
class impl_tSwitch;
class impl_tCase_list;
class impl_tCase;
class impl_tOtherwise;
class impl_tWhile;
class impl_tSequence;
class impl_tPick;
class impl_tScope;
class impl_standardElements;
class impl_tTarget_list;
class impl_tTarget;
class impl_tSource_list;
class impl_tSource;


void kc_invalid_operator( const char *kc_func_prefix, enum_phyla kc_phy, int kc_line,
    const char *kc_file, enum_operators kc_oper ) __attribute__ ((noreturn));

typedef enum_phyla *enum_phyla_list;

/*
 * make sure that the first 'real' storage class _always_ gets a value > 0
 * and kc_not_uniq gets a value == 0
 * (because then we can use it as a C boolean)
 */
enum kc_storageclass_t {
    kc_not_uniq,
    uniq,
    last_storageclass
};

typedef struct {
    const char *name;			// name of the phylum
    enum_operators first_operator;	// index in operator_info[]
    enum_operators last_operator;	// index in operator_info[]
    kc_storageclass_t uniq_stored;	// storage class
} KC_PHYLUM_INFO;

typedef struct {
    const char *name;			// name of the operator
    size_t no_sons;			// number of sons
    bool atomicity;			// atomic type or not
    enum_phyla phylum;			// index in phylum_info[]
    enum_phyla_list subphylum;		// indexes in phylum_info[]
    int no_attrs;			// number of attributes
    enum_phyla_list attribute;		// indexes in phylum_info[]
    size_t size;			// size of operator (for statistics)
} KC_OPERATOR_INFO;

typedef enum_phyla_list KC_UNIQ_INFO;

extern KC_OPERATOR_INFO operator_info[];
extern KC_PHYLUM_INFO phylum_info[];
extern KC_UNIQ_INFO kc_UniqInfo[];

#define KC_OP_NAME(op) (operator_info[op].name)
#define KC_NO_SONS(prod) (operator_info[prod].no_sons)
#define KC_ATOMICITY(prod) (operator_info[prod].atomicity)


typedef impl_nocasestring_NoCaseStr *nocasestring;
typedef const impl_nocasestring_NoCaseStr *c_nocasestring;
typedef impl_casestring__Str *casestring;
typedef const impl_casestring__Str *c_casestring;
typedef impl_real__Real *real;
typedef const impl_real__Real *c_real;
typedef impl_integer__Int *integer;
typedef const impl_integer__Int *c_integer;
typedef impl_voidptr__VoidPtr *voidptr;
typedef const impl_voidptr__VoidPtr *c_voidptr;
typedef impl_tProcess *tProcess;
typedef const impl_tProcess *c_tProcess;
typedef impl_tStop *tStop;
typedef const impl_tStop *c_tStop;
typedef impl_activity *activity;
typedef const impl_activity *c_activity;
typedef impl_tPartnerLink_list *tPartnerLink_list;
typedef const impl_tPartnerLink_list *c_tPartnerLink_list;
typedef impl_tPartnerLink *tPartnerLink;
typedef const impl_tPartnerLink *c_tPartnerLink;
typedef impl_tPartner_list *tPartner_list;
typedef const impl_tPartner_list *c_tPartner_list;
typedef impl_tPartner *tPartner;
typedef const impl_tPartner *c_tPartner;
typedef impl_tFaultHandlers *tFaultHandlers;
typedef const impl_tFaultHandlers *c_tFaultHandlers;
typedef impl_tCatch_list *tCatch_list;
typedef const impl_tCatch_list *c_tCatch_list;
typedef impl_tCatch *tCatch;
typedef const impl_tCatch *c_tCatch;
typedef impl_tCatchAll *tCatchAll;
typedef const impl_tCatchAll *c_tCatchAll;
typedef impl_tEventHandlers *tEventHandlers;
typedef const impl_tEventHandlers *c_tEventHandlers;
typedef impl_tOnMessage_list *tOnMessage_list;
typedef const impl_tOnMessage_list *c_tOnMessage_list;
typedef impl_tOnAlarm_list *tOnAlarm_list;
typedef const impl_tOnAlarm_list *c_tOnAlarm_list;
typedef impl_tOnMessage *tOnMessage;
typedef const impl_tOnMessage *c_tOnMessage;
typedef impl_tOnAlarm *tOnAlarm;
typedef const impl_tOnAlarm *c_tOnAlarm;
typedef impl_tCompensationHandler *tCompensationHandler;
typedef const impl_tCompensationHandler *c_tCompensationHandler;
typedef impl_tVariable_list *tVariable_list;
typedef const impl_tVariable_list *c_tVariable_list;
typedef impl_tVariable *tVariable;
typedef const impl_tVariable *c_tVariable;
typedef impl_tCorrelationSet_list *tCorrelationSet_list;
typedef const impl_tCorrelationSet_list *c_tCorrelationSet_list;
typedef impl_tCorrelationSet *tCorrelationSet;
typedef const impl_tCorrelationSet *c_tCorrelationSet;
typedef impl_tCorrelation_list *tCorrelation_list;
typedef const impl_tCorrelation_list *c_tCorrelation_list;
typedef impl_tCorrelation *tCorrelation;
typedef const impl_tCorrelation *c_tCorrelation;
typedef impl_tEmpty *tEmpty;
typedef const impl_tEmpty *c_tEmpty;
typedef impl_tInvoke *tInvoke;
typedef const impl_tInvoke *c_tInvoke;
typedef impl_tReceive *tReceive;
typedef const impl_tReceive *c_tReceive;
typedef impl_tReply *tReply;
typedef const impl_tReply *c_tReply;
typedef impl_tAssign *tAssign;
typedef const impl_tAssign *c_tAssign;
typedef impl_tCopy_list *tCopy_list;
typedef const impl_tCopy_list *c_tCopy_list;
typedef impl_tCopy *tCopy;
typedef const impl_tCopy *c_tCopy;
typedef impl_tFrom *tFrom;
typedef const impl_tFrom *c_tFrom;
typedef impl_tTo *tTo;
typedef const impl_tTo *c_tTo;
typedef impl_tWait *tWait;
typedef const impl_tWait *c_tWait;
typedef impl_tThrow *tThrow;
typedef const impl_tThrow *c_tThrow;
typedef impl_tCompensate *tCompensate;
typedef const impl_tCompensate *c_tCompensate;
typedef impl_tTerminate *tTerminate;
typedef const impl_tTerminate *c_tTerminate;
typedef impl_tFlow *tFlow;
typedef const impl_tFlow *c_tFlow;
typedef impl_activity_list *activity_list;
typedef const impl_activity_list *c_activity_list;
typedef impl_tLink_list *tLink_list;
typedef const impl_tLink_list *c_tLink_list;
typedef impl_tLink *tLink;
typedef const impl_tLink *c_tLink;
typedef impl_tSwitch *tSwitch;
typedef const impl_tSwitch *c_tSwitch;
typedef impl_tCase_list *tCase_list;
typedef const impl_tCase_list *c_tCase_list;
typedef impl_tCase *tCase;
typedef const impl_tCase *c_tCase;
typedef impl_tOtherwise *tOtherwise;
typedef const impl_tOtherwise *c_tOtherwise;
typedef impl_tWhile *tWhile;
typedef const impl_tWhile *c_tWhile;
typedef impl_tSequence *tSequence;
typedef const impl_tSequence *c_tSequence;
typedef impl_tPick *tPick;
typedef const impl_tPick *c_tPick;
typedef impl_tScope *tScope;
typedef const impl_tScope *c_tScope;
typedef impl_standardElements *standardElements;
typedef const impl_standardElements *c_standardElements;
typedef impl_tTarget_list *tTarget_list;
typedef const impl_tTarget_list *c_tTarget_list;
typedef impl_tTarget *tTarget;
typedef const impl_tTarget *c_tTarget;
typedef impl_tSource_list *tSource_list;
typedef const impl_tSource_list *c_tSource_list;
typedef impl_tSource *tSource;
typedef const impl_tSource *c_tSource;

#define KC_NO_OF_OPERATORS 94


} // namespace kc

namespace kc {

#ifndef KC_NO_DEFAULT_IN_WITH
# define KC_NO_DEFAULT_IN_WITH "Internal Error: no default action defined in function %s at %s:%d\n"
#endif
void kc_no_default_in_with (const char*, int, const char*);
void kc_returnless_function (const char *, int, const char*);

#ifndef NDEBUG
# define assertCond(t) do {if (!(t)) kc_assertionFailed(__FILE__,__LINE__);}while(false)
# define assertReason(t,s) do {if (!(t)) kc_assertionReasonFailed(__FILE__,__LINE__,s);}while(false)
# define assertNonNull(p) do {if (p == 0) kc_assertionNonNullFailed(__FILE__,__LINE__,#p);}while(false)
# define assertPhylum(ptr,phy) do { \
    assertNonNull(ptr); \
    if (ptr->phylum()!=phy) \
	kc_assertionOperatorInPhylumFailed(ptr->prod_sel(),#ptr,"->prod_sel()","phy",__FILE__,__LINE__); \
} while(false)
#else
# define assertCond(t)
# define assertReason(t,s)
# define assertNonNull(ptr)
# define assertPhylum(op,phy)
#endif
#define assertionFailed(s) kc_assertionReasonFailed(__FILE__,__LINE__,s)

void kc_assertionFailed (const char*, int) __attribute__ ((noreturn));
void kc_assertionReasonFailed (const char*, int, const char*) __attribute__ ((noreturn));
void kc_assertionNonNullFailed (const char*, int, const char*) __attribute__ ((noreturn));
void kc_assertionOperatorInPhylumFailed (int, const char*, const char*, const char*, const char*, int) __attribute__ ((noreturn));

casestring mkcasestring( const kc_char_t *, int length = -1);
nocasestring mknocasestring( const kc_char_t *, int length = -1);
integer mkinteger( const INTEGER );
real mkreal( const REAL );
inline casestring _Str( const kc_char_t * cc) { return mkcasestring(cc); }
inline nocasestring NoCaseStr( const kc_char_t * cc) { return mknocasestring(cc); }
inline integer _Int( const INTEGER cc) { return mkinteger(cc); }
inline real _Real( const REAL cc) { return mkreal(cc); }
class impl_tProcess_Process* Process (tPartnerLink_list, tPartner_list, tVariable_list, tCorrelationSet_list, tFaultHandlers, tCompensationHandler, tEventHandlers, tStop, activity);
class impl_tStop_StopInProcess* StopInProcess ();
class impl_tStop_StopInScope* StopInScope ();
class impl_activity_activityEmpty* activityEmpty (tEmpty);
class impl_activity_activityInvoke* activityInvoke (tInvoke);
class impl_activity_activityReceive* activityReceive (tReceive);
class impl_activity_activityReply* activityReply (tReply);
class impl_activity_activityAssign* activityAssign (tAssign);
class impl_activity_activityWait* activityWait (tWait);
class impl_activity_activityThrow* activityThrow (tThrow);
class impl_activity_activityTerminate* activityTerminate (tTerminate);
class impl_activity_activityFlow* activityFlow (tFlow);
class impl_activity_activitySwitch* activitySwitch (tSwitch);
class impl_activity_activityWhile* activityWhile (tWhile);
class impl_activity_activitySequence* activitySequence (tSequence);
class impl_activity_activityPick* activityPick (tPick);
class impl_activity_activityScope* activityScope (tScope);
class impl_activity_activityCompensate* activityCompensate (tCompensate);
tPartnerLink_list NiltPartnerLink_list();
tPartnerLink_list ConstPartnerLink_list(tPartnerLink,tPartnerLink_list);
class impl_tPartnerLink_PartnerLink* PartnerLink ();
tPartner_list NiltPartner_list();
tPartner_list ConstPartner_list(tPartner,tPartner_list);
class impl_tPartner_Partner* Partner (tPartnerLink_list);
class impl_tFaultHandlers_userDefinedFaultHandler* userDefinedFaultHandler (tCatch_list, tCatchAll);
class impl_tFaultHandlers_implicitFaultHandler* implicitFaultHandler ();
tCatch_list NiltCatch_list();
tCatch_list ConstCatch_list(tCatch,tCatch_list);
class impl_tCatch_Catch* Catch (activity);
class impl_tCatchAll_CatchAll* CatchAll (activity);
class impl_tCatchAll_NoCatchAll* NoCatchAll ();
class impl_tEventHandlers_implicitEventHandler* implicitEventHandler ();
class impl_tEventHandlers_userDefinedEventHandler* userDefinedEventHandler (tOnMessage_list, tOnAlarm_list);
tOnMessage_list NiltOnMessage_list();
tOnMessage_list ConstOnMessage_list(tOnMessage,tOnMessage_list);
tOnAlarm_list NiltOnAlarm_list();
tOnAlarm_list ConstOnAlarm_list(tOnAlarm,tOnAlarm_list);
class impl_tOnMessage_OnMessage* OnMessage (activity);
class impl_tOnAlarm_OnAlarm* OnAlarm (activity);
class impl_tCompensationHandler_implicitCompensationHandler* implicitCompensationHandler ();
class impl_tCompensationHandler_userDefinedCompensationHandler* userDefinedCompensationHandler (activity);
class impl_tCompensationHandler_processCompensationHandler* processCompensationHandler ();
tVariable_list NiltVariable_list();
tVariable_list ConstVariable_list(tVariable,tVariable_list);
class impl_tVariable_Variable* Variable ();
tCorrelationSet_list NiltCorrelationSet_list();
tCorrelationSet_list ConstCorrelationSet_list(tCorrelationSet,tCorrelationSet_list);
class impl_tCorrelationSet_CorrelationSet* CorrelationSet ();
tCorrelation_list NiltCorrelation_list();
tCorrelation_list ConstCorrelation_list(tCorrelation,tCorrelation_list);
class impl_tCorrelation_Correlation* Correlation ();
class impl_tEmpty_Empty* Empty (standardElements);
class impl_tInvoke_Invoke* Invoke (standardElements, tCorrelation_list);
class impl_tReceive_Receive* Receive (standardElements, tCorrelation_list);
class impl_tReply_Reply* Reply (standardElements, tCorrelation_list);
class impl_tAssign_Assign* Assign (standardElements, tCopy_list);
tCopy_list NiltCopy_list();
tCopy_list ConstCopy_list(tCopy,tCopy_list);
class impl_tCopy_Copy* Copy (tFrom, tTo);
class impl_tFrom_From* From ();
class impl_tTo_To* To ();
class impl_tWait_WaitFor* WaitFor (standardElements);
class impl_tWait_WaitUntil* WaitUntil (standardElements);
class impl_tThrow_Throw* Throw (standardElements);
class impl_tCompensate_Compensate* Compensate (standardElements);
class impl_tTerminate_Terminate* Terminate (standardElements);
class impl_tFlow_Flow* Flow (standardElements, tLink_list, activity_list);
activity_list Nilactivity_list();
activity_list Consactivity_list(activity,activity_list);
tLink_list NiltLink_list();
tLink_list ConstLink_list(tLink,tLink_list);
class impl_tLink_Link* Link ();
class impl_tSwitch_Switch* Switch (standardElements, tCase_list, tOtherwise);
tCase_list NiltCase_list();
tCase_list ConstCase_list(tCase,tCase_list);
class impl_tCase_Case* Case (activity);
class impl_tOtherwise_Otherwise* Otherwise (activity);
class impl_tWhile_While* While (standardElements, activity);
class impl_tSequence_Sequence* Sequence (standardElements, activity_list);
class impl_tPick_Pick* Pick (standardElements, tOnMessage_list, tOnAlarm_list);
class impl_tScope_Scope* Scope (standardElements, tVariable_list, tFaultHandlers, tCompensationHandler, tEventHandlers, tStop, activity);
class impl_standardElements_StandardElements* StandardElements (tTarget_list, tSource_list);
tTarget_list NiltTarget_list();
tTarget_list ConstTarget_list(tTarget,tTarget_list);
class impl_tTarget_Target* Target ();
tSource_list NiltSource_list();
tSource_list ConstSource_list(tSource,tSource_list);
class impl_tSource_Source* Source ();

//namespace Phylum {

class impl_abstract_phylum {
public:
    virtual enum_operators prod_sel() const =0;
    static const enum_phyla phylum_sel_;
    enum_phyla phylum() const;
    const char* phylum_name() const;
    const char* op_name() const;
    virtual abstract_phylum subphylum(int) const;
    virtual void set_subphylum(int, abstract_phylum);
    void free(bool recursive=true);
    bool eq(c_abstract_phylum) const;
    void print();
    void fprint(FILE *);
    abstract_phylum copy(bool kc_copy_attributes) const;
    void unparse(printer_functor pf, uview uv)
	{ do_unparse(pf, uv); }
    void unparse(printer_function opf, uview uv);
    void CSGIOwrite(FILE *) const;
    virtual abstract_phylum rewrite(rview v) { return do_rewrite(v); }
    virtual abstract_phylum do_rewrite(rview) { return this;}
    // called if a subphylum of an op is rewritten and a new op is created by default rule
    virtual void rewrite_members(abstract_phylum from) {} 
    virtual void post_create(){}
    virtual ~impl_abstract_phylum() { }
private:
    virtual void do_unparse(printer_functor, uview) =0;
protected:
    virtual void default_unparse(printer_functor, uview);
};


class impl_abstract_list: public impl_abstract_phylum{
private:
    void fprint_list(FILE *);
    friend class impl_abstract_phylum;
protected:
    abstract_phylum do_concat(c_abstract_phylum other, enum_operators) const;
    abstract_phylum do_reverse(c_abstract_phylum tail, enum_operators) const;
    abstract_phylum do_map(abstract_phylum (*kc_fp)(abstract_phylum), enum_operators);
    abstract_phylum do_filter(bool (*kc_fp)(abstract_phylum), enum_operators);
    abstract_list   do_append(abstract_phylum, abstract_list);
    abstract_phylum do_merge(abstract_list,abstract_phylum (*kc_fp)(abstract_phylum,abstract_phylum), enum_operators);
    abstract_phylum do_reduce(abstract_phylum neutral, abstract_phylum (*kc_fp)(abstract_phylum,abstract_phylum));
public:
    virtual bool is_nil() const =0;
    virtual abstract_list reverse() const =0;
    int length() const;
    abstract_phylum last() const;
    // Non-virtual, non-existing... Type must be known exactly anyway because
    // of the function given as a parameter
    //virtual abstract_list map( abstract_phylum (*)( abstract_phylum )) =0;
    //virtual abstract_list filter(bool (*)(abstract_phylum)) =0;
    void freelist();
};

abstract_phylum kc_create(enum_operators createOp, abstract_phylum=0, abstract_phylum=0, abstract_phylum=0, abstract_phylum=0, abstract_phylum=0, abstract_phylum=0, abstract_phylum=0, abstract_phylum=0, abstract_phylum=0);
abstract_phylum& attributeOf(abstract_phylum kc_p, int no);

class impl_nocasestring_NoCaseStr;
typedef impl_nocasestring_NoCaseStr impl_nocasestring;
class impl_nocasestring_NoCaseStr:public impl_abstract_phylum{
public:
    enum_operators prod_sel() const
	{ return sel_NoCaseStr; }
    static const enum_phyla phylum_sel_;
private:
    explicit impl_nocasestring_NoCaseStr(const kc_char_t*);
    void make_own(int length);
    friend nocasestring mknocasestring(const kc_char_t*, int);
public:
    ~impl_nocasestring_NoCaseStr() {
#if defined (_MSC_VER) && _MSC_VER<1300
	delete [] (kc_char_t*)name;
#else
	delete [] name;
#endif
    }

    nocasestring rewrite( rview )
	{ return this; }
    kc_char_t const* name;
private:
    void do_unparse(printer_functor, uview);
};
class impl_casestring__Str;
typedef impl_casestring__Str impl_casestring;
class impl_casestring__Str:public impl_abstract_phylum{
public:
    enum_operators prod_sel() const
	{ return sel__Str; }
    static const enum_phyla phylum_sel_;
private:
    explicit impl_casestring__Str(const kc_char_t*);
    void make_own(int length);
    friend casestring mkcasestring(const kc_char_t*, int);
public:
    ~impl_casestring__Str() {
#if defined (_MSC_VER) && _MSC_VER<1300
	delete [] (kc_char_t*)name;
#else
	delete [] name;
#endif
    }

    casestring rewrite( rview )
	{ return this; }
    kc_char_t const* name;
private:
    void do_unparse(printer_functor, uview);
};
class impl_real__Real;
typedef impl_real__Real impl_real;
class impl_real__Real:public impl_abstract_phylum{
public:
    enum_operators prod_sel() const
	{ return sel__Real; }
    static const enum_phyla phylum_sel_;
    explicit impl_real__Real(REAL _value);

    real rewrite( rview )
	{ return this; }
    REAL value;
private:
    void do_unparse(printer_functor, uview);
};
class impl_integer__Int;
typedef impl_integer__Int impl_integer;
class impl_integer__Int:public impl_abstract_phylum{
public:
    enum_operators prod_sel() const
	{ return sel__Int; }
    static const enum_phyla phylum_sel_;
    explicit impl_integer__Int(INTEGER _value);

    integer rewrite( rview )
	{ return this; }
    INTEGER value;
private:
    void do_unparse(printer_functor, uview);
};
class impl_voidptr__VoidPtr;
typedef impl_voidptr__VoidPtr impl_voidptr;
class impl_voidptr__VoidPtr:public impl_abstract_phylum{
public:
    enum_operators prod_sel() const
	{ return sel__VoidPtr; }
    static const enum_phyla phylum_sel_;
    explicit impl_voidptr__VoidPtr(void* _pointer);

    voidptr rewrite( rview )
	{ return this; }
    void* pointer;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tProcess: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer id;
    tProcess rewrite(rview) =0;
};
class impl_tProcess_Process:public impl_tProcess{
public:
    enum_operators prod_sel() const
	{ return sel_Process; }
    explicit impl_tProcess_Process(tPartnerLink_list, tPartner_list, tVariable_list, tCorrelationSet_list, tFaultHandlers, tCompensationHandler, tEventHandlers, tStop, activity);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tProcess rewrite( rview );
    impl_tPartnerLink_list* tPartnerLink_list_1;
    impl_tPartner_list* tPartner_list_1;
    impl_tVariable_list* tVariable_list_1;
    impl_tCorrelationSet_list* tCorrelationSet_list_1;
    impl_tFaultHandlers* tFaultHandlers_1;
    impl_tCompensationHandler* tCompensationHandler_1;
    impl_tEventHandlers* tEventHandlers_1;
    impl_tStop* tStop_1;
    impl_activity* activity_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tStop: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    tStop rewrite(rview) =0;
};
class impl_tStop_StopInScope:public impl_tStop{
public:
    enum_operators prod_sel() const
	{ return sel_StopInScope; }
    explicit impl_tStop_StopInScope();

    tStop rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tStop_StopInProcess:public impl_tStop{
public:
    enum_operators prod_sel() const
	{ return sel_StopInProcess; }
    explicit impl_tStop_StopInProcess();

    tStop rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_activity: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer id;
    integer negativeControlFlow;
    integer dpe;
    activity rewrite(rview) =0;
};
class impl_activity_activityCompensate:public impl_activity{
public:
    enum_operators prod_sel() const
	{ return sel_activityCompensate; }
    explicit impl_activity_activityCompensate(tCompensate);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    activity rewrite( rview );
    impl_tCompensate* tCompensate_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_activity_activityScope:public impl_activity{
public:
    enum_operators prod_sel() const
	{ return sel_activityScope; }
    explicit impl_activity_activityScope(tScope);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    activity rewrite( rview );
    impl_tScope* tScope_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_activity_activityPick:public impl_activity{
public:
    enum_operators prod_sel() const
	{ return sel_activityPick; }
    explicit impl_activity_activityPick(tPick);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    activity rewrite( rview );
    impl_tPick* tPick_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_activity_activitySequence:public impl_activity{
public:
    enum_operators prod_sel() const
	{ return sel_activitySequence; }
    explicit impl_activity_activitySequence(tSequence);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    activity rewrite( rview );
    impl_tSequence* tSequence_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_activity_activityWhile:public impl_activity{
public:
    enum_operators prod_sel() const
	{ return sel_activityWhile; }
    explicit impl_activity_activityWhile(tWhile);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    activity rewrite( rview );
    impl_tWhile* tWhile_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_activity_activitySwitch:public impl_activity{
public:
    enum_operators prod_sel() const
	{ return sel_activitySwitch; }
    explicit impl_activity_activitySwitch(tSwitch);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    activity rewrite( rview );
    impl_tSwitch* tSwitch_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_activity_activityFlow:public impl_activity{
public:
    enum_operators prod_sel() const
	{ return sel_activityFlow; }
    explicit impl_activity_activityFlow(tFlow);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    activity rewrite( rview );
    impl_tFlow* tFlow_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_activity_activityTerminate:public impl_activity{
public:
    enum_operators prod_sel() const
	{ return sel_activityTerminate; }
    explicit impl_activity_activityTerminate(tTerminate);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    activity rewrite( rview );
    impl_tTerminate* tTerminate_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_activity_activityThrow:public impl_activity{
public:
    enum_operators prod_sel() const
	{ return sel_activityThrow; }
    explicit impl_activity_activityThrow(tThrow);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    activity rewrite( rview );
    impl_tThrow* tThrow_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_activity_activityWait:public impl_activity{
public:
    enum_operators prod_sel() const
	{ return sel_activityWait; }
    explicit impl_activity_activityWait(tWait);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    activity rewrite( rview );
    impl_tWait* tWait_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_activity_activityAssign:public impl_activity{
public:
    enum_operators prod_sel() const
	{ return sel_activityAssign; }
    explicit impl_activity_activityAssign(tAssign);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    activity rewrite( rview );
    impl_tAssign* tAssign_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_activity_activityReply:public impl_activity{
public:
    enum_operators prod_sel() const
	{ return sel_activityReply; }
    explicit impl_activity_activityReply(tReply);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    activity rewrite( rview );
    impl_tReply* tReply_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_activity_activityReceive:public impl_activity{
public:
    enum_operators prod_sel() const
	{ return sel_activityReceive; }
    explicit impl_activity_activityReceive(tReceive);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    activity rewrite( rview );
    impl_tReceive* tReceive_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_activity_activityInvoke:public impl_activity{
public:
    enum_operators prod_sel() const
	{ return sel_activityInvoke; }
    explicit impl_activity_activityInvoke(tInvoke);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    activity rewrite( rview );
    impl_tInvoke* tInvoke_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_activity_activityEmpty:public impl_activity{
public:
    enum_operators prod_sel() const
	{ return sel_activityEmpty; }
    explicit impl_activity_activityEmpty(tEmpty);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    activity rewrite( rview );
    impl_tEmpty* tEmpty_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tPartnerLink_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NiltPartnerLink_list: sel_ConstPartnerLink_list;
    }
    explicit impl_tPartnerLink_list(tPartnerLink = 0, tPartnerLink_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend tPartnerLink_list concat(c_tPartnerLink_list, c_tPartnerLink_list);
    tPartnerLink_list reverse() const;
    tPartnerLink_list rewrite(rview);
    tPartnerLink last() const;
    tPartnerLink_list append(tPartnerLink);
    tPartnerLink_list map(tPartnerLink (*)(tPartnerLink));
    tPartnerLink_list filter( bool (*)(tPartnerLink));
    tPartnerLink_list merge( tPartnerLink_list, tPartnerLink (*)(tPartnerLink, tPartnerLink));
    tPartnerLink reduce( tPartnerLink, tPartnerLink (*)(tPartnerLink, tPartnerLink));
    bool is_nil() const;
    tPartnerLink tPartnerLink_1;
    tPartnerLink_list tPartnerLink_list_1;
private:
    impl_tPartnerLink_list* nil_rewrite(rview);
    impl_tPartnerLink_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_tPartnerLink: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer id;
    tPartnerLink rewrite(rview) =0;
};
class impl_tPartnerLink_PartnerLink:public impl_tPartnerLink{
public:
    enum_operators prod_sel() const
	{ return sel_PartnerLink; }
    explicit impl_tPartnerLink_PartnerLink();

    tPartnerLink rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tPartner_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NiltPartner_list: sel_ConstPartner_list;
    }
    explicit impl_tPartner_list(tPartner = 0, tPartner_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend tPartner_list concat(c_tPartner_list, c_tPartner_list);
    tPartner_list reverse() const;
    tPartner_list rewrite(rview);
    tPartner last() const;
    tPartner_list append(tPartner);
    tPartner_list map(tPartner (*)(tPartner));
    tPartner_list filter( bool (*)(tPartner));
    tPartner_list merge( tPartner_list, tPartner (*)(tPartner, tPartner));
    tPartner reduce( tPartner, tPartner (*)(tPartner, tPartner));
    bool is_nil() const;
    tPartner tPartner_1;
    tPartner_list tPartner_list_1;
private:
    impl_tPartner_list* nil_rewrite(rview);
    impl_tPartner_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_tPartner: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer id;
    tPartner rewrite(rview) =0;
};
class impl_tPartner_Partner:public impl_tPartner{
public:
    enum_operators prod_sel() const
	{ return sel_Partner; }
    explicit impl_tPartner_Partner(tPartnerLink_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tPartner rewrite( rview );
    impl_tPartnerLink_list* tPartnerLink_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tFaultHandlers: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    bool inProcess;
    integer parentScopeId;
    bool hasCatchAll;
    integer id;
    tFaultHandlers rewrite(rview) =0;
};
class impl_tFaultHandlers_implicitFaultHandler:public impl_tFaultHandlers{
public:
    enum_operators prod_sel() const
	{ return sel_implicitFaultHandler; }
    explicit impl_tFaultHandlers_implicitFaultHandler();

    tFaultHandlers rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tFaultHandlers_userDefinedFaultHandler:public impl_tFaultHandlers{
public:
    enum_operators prod_sel() const
	{ return sel_userDefinedFaultHandler; }
    explicit impl_tFaultHandlers_userDefinedFaultHandler(tCatch_list, tCatchAll);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tFaultHandlers rewrite( rview );
    impl_tCatch_list* tCatch_list_1;
    impl_tCatchAll* tCatchAll_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tCatch_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NiltCatch_list: sel_ConstCatch_list;
    }
    explicit impl_tCatch_list(tCatch = 0, tCatch_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend tCatch_list concat(c_tCatch_list, c_tCatch_list);
    tCatch_list reverse() const;
    tCatch_list rewrite(rview);
    tCatch last() const;
    tCatch_list append(tCatch);
    tCatch_list map(tCatch (*)(tCatch));
    tCatch_list filter( bool (*)(tCatch));
    tCatch_list merge( tCatch_list, tCatch (*)(tCatch, tCatch));
    tCatch reduce( tCatch, tCatch (*)(tCatch, tCatch));
    bool is_nil() const;
    tCatch tCatch_1;
    tCatch_list tCatch_list_1;
private:
    impl_tCatch_list* nil_rewrite(rview);
    impl_tCatch_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_tCatch: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    casestring faultName;
    integer id;
    tCatch rewrite(rview) =0;
};
class impl_tCatch_Catch:public impl_tCatch{
public:
    enum_operators prod_sel() const
	{ return sel_Catch; }
    explicit impl_tCatch_Catch(activity);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tCatch rewrite( rview );
    impl_activity* activity_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tCatchAll: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer id;
    tCatchAll rewrite(rview) =0;
};
class impl_tCatchAll_NoCatchAll:public impl_tCatchAll{
public:
    enum_operators prod_sel() const
	{ return sel_NoCatchAll; }
    explicit impl_tCatchAll_NoCatchAll();

    tCatchAll rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tCatchAll_CatchAll:public impl_tCatchAll{
public:
    enum_operators prod_sel() const
	{ return sel_CatchAll; }
    explicit impl_tCatchAll_CatchAll(activity);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tCatchAll rewrite( rview );
    impl_activity* activity_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tEventHandlers: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer parentScopeId;
    integer id;
    tEventHandlers rewrite(rview) =0;
};
class impl_tEventHandlers_userDefinedEventHandler:public impl_tEventHandlers{
public:
    enum_operators prod_sel() const
	{ return sel_userDefinedEventHandler; }
    explicit impl_tEventHandlers_userDefinedEventHandler(tOnMessage_list, tOnAlarm_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tEventHandlers rewrite( rview );
    impl_tOnMessage_list* tOnMessage_list_1;
    impl_tOnAlarm_list* tOnAlarm_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tEventHandlers_implicitEventHandler:public impl_tEventHandlers{
public:
    enum_operators prod_sel() const
	{ return sel_implicitEventHandler; }
    explicit impl_tEventHandlers_implicitEventHandler();

    tEventHandlers rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tOnMessage_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    integer dpe;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NiltOnMessage_list: sel_ConstOnMessage_list;
    }
    explicit impl_tOnMessage_list(tOnMessage = 0, tOnMessage_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend tOnMessage_list concat(c_tOnMessage_list, c_tOnMessage_list);
    tOnMessage_list reverse() const;
    tOnMessage_list rewrite(rview);
    tOnMessage last() const;
    tOnMessage_list append(tOnMessage);
    tOnMessage_list map(tOnMessage (*)(tOnMessage));
    tOnMessage_list filter( bool (*)(tOnMessage));
    tOnMessage_list merge( tOnMessage_list, tOnMessage (*)(tOnMessage, tOnMessage));
    tOnMessage reduce( tOnMessage, tOnMessage (*)(tOnMessage, tOnMessage));
    bool is_nil() const;
    tOnMessage tOnMessage_1;
    tOnMessage_list tOnMessage_list_1;
private:
    impl_tOnMessage_list* nil_rewrite(rview);
    impl_tOnMessage_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_tOnAlarm_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    integer dpe;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NiltOnAlarm_list: sel_ConstOnAlarm_list;
    }
    explicit impl_tOnAlarm_list(tOnAlarm = 0, tOnAlarm_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend tOnAlarm_list concat(c_tOnAlarm_list, c_tOnAlarm_list);
    tOnAlarm_list reverse() const;
    tOnAlarm_list rewrite(rview);
    tOnAlarm last() const;
    tOnAlarm_list append(tOnAlarm);
    tOnAlarm_list map(tOnAlarm (*)(tOnAlarm));
    tOnAlarm_list filter( bool (*)(tOnAlarm));
    tOnAlarm_list merge( tOnAlarm_list, tOnAlarm (*)(tOnAlarm, tOnAlarm));
    tOnAlarm reduce( tOnAlarm, tOnAlarm (*)(tOnAlarm, tOnAlarm));
    bool is_nil() const;
    tOnAlarm tOnAlarm_1;
    tOnAlarm_list tOnAlarm_list_1;
private:
    impl_tOnAlarm_list* nil_rewrite(rview);
    impl_tOnAlarm_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_tOnMessage: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer dpe;
    integer id;
    tOnMessage rewrite(rview) =0;
};
class impl_tOnMessage_OnMessage:public impl_tOnMessage{
public:
    enum_operators prod_sel() const
	{ return sel_OnMessage; }
    explicit impl_tOnMessage_OnMessage(activity);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tOnMessage rewrite( rview );
    impl_activity* activity_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tOnAlarm: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    casestring For;
    casestring until;
    integer dpe;
    integer id;
    tOnAlarm rewrite(rview) =0;
};
class impl_tOnAlarm_OnAlarm:public impl_tOnAlarm{
public:
    enum_operators prod_sel() const
	{ return sel_OnAlarm; }
    explicit impl_tOnAlarm_OnAlarm(activity);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tOnAlarm rewrite( rview );
    impl_activity* activity_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tCompensationHandler: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer parentScopeId;
    bool compensateWithoutScope;
    bool compensateWithScope;
    integer id;
    tCompensationHandler rewrite(rview) =0;
};
class impl_tCompensationHandler_processCompensationHandler:public impl_tCompensationHandler{
public:
    enum_operators prod_sel() const
	{ return sel_processCompensationHandler; }
    explicit impl_tCompensationHandler_processCompensationHandler();

    tCompensationHandler rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tCompensationHandler_userDefinedCompensationHandler:public impl_tCompensationHandler{
public:
    enum_operators prod_sel() const
	{ return sel_userDefinedCompensationHandler; }
    explicit impl_tCompensationHandler_userDefinedCompensationHandler(activity);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tCompensationHandler rewrite( rview );
    impl_activity* activity_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tCompensationHandler_implicitCompensationHandler:public impl_tCompensationHandler{
public:
    enum_operators prod_sel() const
	{ return sel_implicitCompensationHandler; }
    explicit impl_tCompensationHandler_implicitCompensationHandler();

    tCompensationHandler rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tVariable_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NiltVariable_list: sel_ConstVariable_list;
    }
    explicit impl_tVariable_list(tVariable = 0, tVariable_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend tVariable_list concat(c_tVariable_list, c_tVariable_list);
    tVariable_list reverse() const;
    tVariable_list rewrite(rview);
    tVariable last() const;
    tVariable_list append(tVariable);
    tVariable_list map(tVariable (*)(tVariable));
    tVariable_list filter( bool (*)(tVariable));
    tVariable_list merge( tVariable_list, tVariable (*)(tVariable, tVariable));
    tVariable reduce( tVariable, tVariable (*)(tVariable, tVariable));
    bool is_nil() const;
    tVariable tVariable_1;
    tVariable_list tVariable_list_1;
private:
    impl_tVariable_list* nil_rewrite(rview);
    impl_tVariable_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_tVariable: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer id;
    tVariable rewrite(rview) =0;
};
class impl_tVariable_Variable:public impl_tVariable{
public:
    enum_operators prod_sel() const
	{ return sel_Variable; }
    explicit impl_tVariable_Variable();

    tVariable rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tCorrelationSet_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NiltCorrelationSet_list: sel_ConstCorrelationSet_list;
    }
    explicit impl_tCorrelationSet_list(tCorrelationSet = 0, tCorrelationSet_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend tCorrelationSet_list concat(c_tCorrelationSet_list, c_tCorrelationSet_list);
    tCorrelationSet_list reverse() const;
    tCorrelationSet_list rewrite(rview);
    tCorrelationSet last() const;
    tCorrelationSet_list append(tCorrelationSet);
    tCorrelationSet_list map(tCorrelationSet (*)(tCorrelationSet));
    tCorrelationSet_list filter( bool (*)(tCorrelationSet));
    tCorrelationSet_list merge( tCorrelationSet_list, tCorrelationSet (*)(tCorrelationSet, tCorrelationSet));
    tCorrelationSet reduce( tCorrelationSet, tCorrelationSet (*)(tCorrelationSet, tCorrelationSet));
    bool is_nil() const;
    tCorrelationSet tCorrelationSet_1;
    tCorrelationSet_list tCorrelationSet_list_1;
private:
    impl_tCorrelationSet_list* nil_rewrite(rview);
    impl_tCorrelationSet_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_tCorrelationSet: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer id;
    tCorrelationSet rewrite(rview) =0;
};
class impl_tCorrelationSet_CorrelationSet:public impl_tCorrelationSet{
public:
    enum_operators prod_sel() const
	{ return sel_CorrelationSet; }
    explicit impl_tCorrelationSet_CorrelationSet();

    tCorrelationSet rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tCorrelation_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NiltCorrelation_list: sel_ConstCorrelation_list;
    }
    explicit impl_tCorrelation_list(tCorrelation = 0, tCorrelation_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend tCorrelation_list concat(c_tCorrelation_list, c_tCorrelation_list);
    tCorrelation_list reverse() const;
    tCorrelation_list rewrite(rview);
    tCorrelation last() const;
    tCorrelation_list append(tCorrelation);
    tCorrelation_list map(tCorrelation (*)(tCorrelation));
    tCorrelation_list filter( bool (*)(tCorrelation));
    tCorrelation_list merge( tCorrelation_list, tCorrelation (*)(tCorrelation, tCorrelation));
    tCorrelation reduce( tCorrelation, tCorrelation (*)(tCorrelation, tCorrelation));
    bool is_nil() const;
    tCorrelation tCorrelation_1;
    tCorrelation_list tCorrelation_list_1;
private:
    impl_tCorrelation_list* nil_rewrite(rview);
    impl_tCorrelation_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_tCorrelation: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer id;
    tCorrelation rewrite(rview) =0;
};
class impl_tCorrelation_Correlation:public impl_tCorrelation{
public:
    enum_operators prod_sel() const
	{ return sel_Correlation; }
    explicit impl_tCorrelation_Correlation();

    tCorrelation rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tEmpty: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer negativeControlFlow;
    integer id;
    tEmpty rewrite(rview) =0;
};
class impl_tEmpty_Empty:public impl_tEmpty{
public:
    enum_operators prod_sel() const
	{ return sel_Empty; }
    explicit impl_tEmpty_Empty(standardElements);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tEmpty rewrite( rview );
    impl_standardElements* standardElements_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tInvoke: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer dpe;
    integer negativeControlFlow;
    integer id;
    tInvoke rewrite(rview) =0;
};
class impl_tInvoke_Invoke:public impl_tInvoke{
public:
    enum_operators prod_sel() const
	{ return sel_Invoke; }
    explicit impl_tInvoke_Invoke(standardElements, tCorrelation_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tInvoke rewrite( rview );
    impl_standardElements* standardElements_1;
    impl_tCorrelation_list* tCorrelation_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tReceive: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer negativeControlFlow;
    integer id;
    tReceive rewrite(rview) =0;
};
class impl_tReceive_Receive:public impl_tReceive{
public:
    enum_operators prod_sel() const
	{ return sel_Receive; }
    explicit impl_tReceive_Receive(standardElements, tCorrelation_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tReceive rewrite( rview );
    impl_standardElements* standardElements_1;
    impl_tCorrelation_list* tCorrelation_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tReply: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer negativeControlFlow;
    integer id;
    tReply rewrite(rview) =0;
};
class impl_tReply_Reply:public impl_tReply{
public:
    enum_operators prod_sel() const
	{ return sel_Reply; }
    explicit impl_tReply_Reply(standardElements, tCorrelation_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tReply rewrite( rview );
    impl_standardElements* standardElements_1;
    impl_tCorrelation_list* tCorrelation_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tAssign: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer negativeControlFlow;
    integer id;
    tAssign rewrite(rview) =0;
};
class impl_tAssign_Assign:public impl_tAssign{
public:
    enum_operators prod_sel() const
	{ return sel_Assign; }
    explicit impl_tAssign_Assign(standardElements, tCopy_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tAssign rewrite( rview );
    impl_standardElements* standardElements_1;
    impl_tCopy_list* tCopy_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tCopy_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NiltCopy_list: sel_ConstCopy_list;
    }
    explicit impl_tCopy_list(tCopy = 0, tCopy_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend tCopy_list concat(c_tCopy_list, c_tCopy_list);
    tCopy_list reverse() const;
    tCopy_list rewrite(rview);
    tCopy last() const;
    tCopy_list append(tCopy);
    tCopy_list map(tCopy (*)(tCopy));
    tCopy_list filter( bool (*)(tCopy));
    tCopy_list merge( tCopy_list, tCopy (*)(tCopy, tCopy));
    tCopy reduce( tCopy, tCopy (*)(tCopy, tCopy));
    bool is_nil() const;
    tCopy tCopy_1;
    tCopy_list tCopy_list_1;
private:
    impl_tCopy_list* nil_rewrite(rview);
    impl_tCopy_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_tCopy: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    tCopy rewrite(rview) =0;
};
class impl_tCopy_Copy:public impl_tCopy{
public:
    enum_operators prod_sel() const
	{ return sel_Copy; }
    explicit impl_tCopy_Copy(tFrom, tTo);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tCopy rewrite( rview );
    impl_tFrom* tFrom_1;
    impl_tTo* tTo_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tFrom: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer id;
    tFrom rewrite(rview) =0;
};
class impl_tFrom_From:public impl_tFrom{
public:
    enum_operators prod_sel() const
	{ return sel_From; }
    explicit impl_tFrom_From();

    tFrom rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tTo: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer id;
    tTo rewrite(rview) =0;
};
class impl_tTo_To:public impl_tTo{
public:
    enum_operators prod_sel() const
	{ return sel_To; }
    explicit impl_tTo_To();

    tTo rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tWait: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer negativeControlFlow;
    integer id;
    tWait rewrite(rview) =0;
};
class impl_tWait_WaitUntil:public impl_tWait{
public:
    enum_operators prod_sel() const
	{ return sel_WaitUntil; }
    explicit impl_tWait_WaitUntil(standardElements);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tWait rewrite( rview );
    impl_standardElements* standardElements_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tWait_WaitFor:public impl_tWait{
public:
    enum_operators prod_sel() const
	{ return sel_WaitFor; }
    explicit impl_tWait_WaitFor(standardElements);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tWait rewrite( rview );
    impl_standardElements* standardElements_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tThrow: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer negativeControlFlow;
    integer id;
    tThrow rewrite(rview) =0;
};
class impl_tThrow_Throw:public impl_tThrow{
public:
    enum_operators prod_sel() const
	{ return sel_Throw; }
    explicit impl_tThrow_Throw(standardElements);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tThrow rewrite( rview );
    impl_standardElements* standardElements_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tCompensate: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    bool inFaultHandler;
    integer negativeControlFlow;
    integer id;
    tCompensate rewrite(rview) =0;
};
class impl_tCompensate_Compensate:public impl_tCompensate{
public:
    enum_operators prod_sel() const
	{ return sel_Compensate; }
    explicit impl_tCompensate_Compensate(standardElements);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tCompensate rewrite( rview );
    impl_standardElements* standardElements_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tTerminate: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer negativeControlFlow;
    integer id;
    tTerminate rewrite(rview) =0;
};
class impl_tTerminate_Terminate:public impl_tTerminate{
public:
    enum_operators prod_sel() const
	{ return sel_Terminate; }
    explicit impl_tTerminate_Terminate(standardElements);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tTerminate rewrite( rview );
    impl_standardElements* standardElements_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tFlow: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer dpe;
    integer negativeControlFlow;
    integer id;
    tFlow rewrite(rview) =0;
};
class impl_tFlow_Flow:public impl_tFlow{
public:
    enum_operators prod_sel() const
	{ return sel_Flow; }
    explicit impl_tFlow_Flow(standardElements, tLink_list, activity_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tFlow rewrite( rview );
    impl_standardElements* standardElements_1;
    impl_tLink_list* tLink_list_1;
    impl_activity_list* activity_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_activity_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    integer dpe;
    enum_operators prod_sel() const{
	return is_nil() ? sel_Nilactivity_list: sel_Consactivity_list;
    }
    explicit impl_activity_list(activity = 0, activity_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend activity_list concat(c_activity_list, c_activity_list);
    activity_list reverse() const;
    activity_list rewrite(rview);
    activity last() const;
    activity_list append(activity);
    activity_list map(activity (*)(activity));
    activity_list filter( bool (*)(activity));
    activity_list merge( activity_list, activity (*)(activity, activity));
    activity reduce( activity, activity (*)(activity, activity));
    bool is_nil() const;
    activity activity_1;
    activity_list activity_list_1;
private:
    impl_activity_list* nil_rewrite(rview);
    impl_activity_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_tLink_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NiltLink_list: sel_ConstLink_list;
    }
    explicit impl_tLink_list(tLink = 0, tLink_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend tLink_list concat(c_tLink_list, c_tLink_list);
    tLink_list reverse() const;
    tLink_list rewrite(rview);
    tLink last() const;
    tLink_list append(tLink);
    tLink_list map(tLink (*)(tLink));
    tLink_list filter( bool (*)(tLink));
    tLink_list merge( tLink_list, tLink (*)(tLink, tLink));
    tLink reduce( tLink, tLink (*)(tLink, tLink));
    bool is_nil() const;
    tLink tLink_1;
    tLink_list tLink_list_1;
private:
    impl_tLink_list* nil_rewrite(rview);
    impl_tLink_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_tLink: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer id;
    tLink rewrite(rview) =0;
};
class impl_tLink_Link:public impl_tLink{
public:
    enum_operators prod_sel() const
	{ return sel_Link; }
    explicit impl_tLink_Link();

    tLink rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tSwitch: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer dpe;
    integer negativeControlFlow;
    integer id;
    tSwitch rewrite(rview) =0;
};
class impl_tSwitch_Switch:public impl_tSwitch{
public:
    enum_operators prod_sel() const
	{ return sel_Switch; }
    explicit impl_tSwitch_Switch(standardElements, tCase_list, tOtherwise);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tSwitch rewrite( rview );
    impl_standardElements* standardElements_1;
    impl_tCase_list* tCase_list_1;
    impl_tOtherwise* tOtherwise_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tCase_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    integer dpe;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NiltCase_list: sel_ConstCase_list;
    }
    explicit impl_tCase_list(tCase = 0, tCase_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend tCase_list concat(c_tCase_list, c_tCase_list);
    tCase_list reverse() const;
    tCase_list rewrite(rview);
    tCase last() const;
    tCase_list append(tCase);
    tCase_list map(tCase (*)(tCase));
    tCase_list filter( bool (*)(tCase));
    tCase_list merge( tCase_list, tCase (*)(tCase, tCase));
    tCase reduce( tCase, tCase (*)(tCase, tCase));
    bool is_nil() const;
    tCase tCase_1;
    tCase_list tCase_list_1;
private:
    impl_tCase_list* nil_rewrite(rview);
    impl_tCase_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_tCase: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    casestring condition;
    integer dpe;
    integer id;
    tCase rewrite(rview) =0;
};
class impl_tCase_Case:public impl_tCase{
public:
    enum_operators prod_sel() const
	{ return sel_Case; }
    explicit impl_tCase_Case(activity);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tCase rewrite( rview );
    impl_activity* activity_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tOtherwise: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer dpe;
    tOtherwise rewrite(rview) =0;
};
class impl_tOtherwise_Otherwise:public impl_tOtherwise{
public:
    enum_operators prod_sel() const
	{ return sel_Otherwise; }
    explicit impl_tOtherwise_Otherwise(activity);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tOtherwise rewrite( rview );
    impl_activity* activity_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tWhile: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    casestring condition;
    integer negativeControlFlow;
    integer id;
    tWhile rewrite(rview) =0;
};
class impl_tWhile_While:public impl_tWhile{
public:
    enum_operators prod_sel() const
	{ return sel_While; }
    explicit impl_tWhile_While(standardElements, activity);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tWhile rewrite( rview );
    impl_standardElements* standardElements_1;
    impl_activity* activity_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tSequence: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer negativeControlFlow;
    integer id;
    integer dpe;
    tSequence rewrite(rview) =0;
};
class impl_tSequence_Sequence:public impl_tSequence{
public:
    enum_operators prod_sel() const
	{ return sel_Sequence; }
    explicit impl_tSequence_Sequence(standardElements, activity_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tSequence rewrite( rview );
    impl_standardElements* standardElements_1;
    impl_activity_list* activity_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tPick: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer dpe;
    integer negativeControlFlow;
    integer id;
    tPick rewrite(rview) =0;
};
class impl_tPick_Pick:public impl_tPick{
public:
    enum_operators prod_sel() const
	{ return sel_Pick; }
    explicit impl_tPick_Pick(standardElements, tOnMessage_list, tOnAlarm_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tPick rewrite( rview );
    impl_standardElements* standardElements_1;
    impl_tOnMessage_list* tOnMessage_list_1;
    impl_tOnAlarm_list* tOnAlarm_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tScope: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer negativeControlFlow;
    integer id;
    integer parentScopeId;
    integer dpe;
    tScope rewrite(rview) =0;
};
class impl_tScope_Scope:public impl_tScope{
public:
    enum_operators prod_sel() const
	{ return sel_Scope; }
    explicit impl_tScope_Scope(standardElements, tVariable_list, tFaultHandlers, tCompensationHandler, tEventHandlers, tStop, activity);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    tScope rewrite( rview );
    impl_standardElements* standardElements_1;
    impl_tVariable_list* tVariable_list_1;
    impl_tFaultHandlers* tFaultHandlers_1;
    impl_tCompensationHandler* tCompensationHandler_1;
    impl_tEventHandlers* tEventHandlers_1;
    impl_tStop* tStop_1;
    impl_activity* activity_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_standardElements: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer parentId;
    casestring suppressJoinFailure;
    integer dpe;
    integer negativeControlFlow;
    bool hasTarget;
    standardElements rewrite(rview) =0;
};
class impl_standardElements_StandardElements:public impl_standardElements{
public:
    enum_operators prod_sel() const
	{ return sel_StandardElements; }
    explicit impl_standardElements_StandardElements(tTarget_list, tSource_list);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);

    standardElements rewrite( rview );
    impl_tTarget_list* tTarget_list_1;
    impl_tSource_list* tSource_list_1;
private:
    void do_unparse(printer_functor, uview);
};
class impl_tTarget_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    bool hasTarget;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NiltTarget_list: sel_ConstTarget_list;
    }
    explicit impl_tTarget_list(tTarget = 0, tTarget_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend tTarget_list concat(c_tTarget_list, c_tTarget_list);
    tTarget_list reverse() const;
    tTarget_list rewrite(rview);
    tTarget last() const;
    tTarget_list append(tTarget);
    tTarget_list map(tTarget (*)(tTarget));
    tTarget_list filter( bool (*)(tTarget));
    tTarget_list merge( tTarget_list, tTarget (*)(tTarget, tTarget));
    tTarget reduce( tTarget, tTarget (*)(tTarget, tTarget));
    bool is_nil() const;
    tTarget tTarget_1;
    tTarget_list tTarget_list_1;
private:
    impl_tTarget_list* nil_rewrite(rview);
    impl_tTarget_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_tTarget: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer negativeControlFlow;
    integer id;
    tTarget rewrite(rview) =0;
};
class impl_tTarget_Target:public impl_tTarget{
public:
    enum_operators prod_sel() const
	{ return sel_Target; }
    explicit impl_tTarget_Target();

    tTarget rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};
class impl_tSource_list: public impl_abstract_list{
public:
    static const enum_phyla phylum_sel_;
    integer dpe;
    enum_operators prod_sel() const{
	return is_nil() ? sel_NiltSource_list: sel_ConstSource_list;
    }
    explicit impl_tSource_list(tSource = 0, tSource_list = 0);
    abstract_phylum subphylum(int) const;
    void set_subphylum(int, abstract_phylum);
    friend tSource_list concat(c_tSource_list, c_tSource_list);
    tSource_list reverse() const;
    tSource_list rewrite(rview);
    tSource last() const;
    tSource_list append(tSource);
    tSource_list map(tSource (*)(tSource));
    tSource_list filter( bool (*)(tSource));
    tSource_list merge( tSource_list, tSource (*)(tSource, tSource));
    tSource reduce( tSource, tSource (*)(tSource, tSource));
    bool is_nil() const;
    tSource tSource_1;
    tSource_list tSource_list_1;
private:
    impl_tSource_list* nil_rewrite(rview);
    impl_tSource_list* cons_rewrite(rview);
    void nil_do_unparse(printer_functor, uview);
    void do_unparse(printer_functor, uview);
};
class impl_tSource: public impl_abstract_phylum{
public:
    static const enum_phyla phylum_sel_;
    integer dpe;
    integer negativeControlFlow;
    integer id;
    tSource rewrite(rview) =0;
};
class impl_tSource_Source:public impl_tSource{
public:
    enum_operators prod_sel() const
	{ return sel_Source; }
    explicit impl_tSource_Source();

    tSource rewrite( rview );
private:
    void do_unparse(printer_functor, uview);
};

//} // namespace Phylum


extern bool kc_storageclass_still_uniq[];

typedef struct {
    int created;
    int existing_not_found;
    int free_called[2];
    int freed[2];
} KC_OPERATOR_STATISTICS;

#ifdef KC_STATISTICS
# define print_operator_statistics(kc_f) do_print_operator_statistics(kc_f)
void	do_print_operator_statistics(FILE*);
#else
# define print_operator_statistics(kc_f)
#endif

typedef class hashtable_struct_t* hashtable_t;
void	ht_static (kc_storageclass_t);
void	ht_dynamic (kc_storageclass_t);
void	ht_inc_level (kc_storageclass_t);
void	ht_dec_level (kc_storageclass_t);
void	ht_free_level (kc_storageclass_t);
hashtable_t	ht_create_simple ();
hashtable_t	ht_assign (hashtable_t, kc_storageclass_t, bool still_unique=false);
hashtable_t	ht_assigned (kc_storageclass_t);
void	ht_clear (hashtable_t);
void	ht_delete (hashtable_t);
const char *phylumname_or_error ( enum_phyla );
const char *kc_operatorname_or_error ( enum_operators );


} // namespace kc
#endif // KC_TYPES_HEADER
