/* BEAST - Bedevilled Audio System
 * Copyright (C) 1998 Olaf Hoehmann and Tim Janik
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#ifndef __BST_MENUS_H__
#define __BST_MENUS_H__

#include	<bse/bse.h>
#include	<gtk/gtk.h>
#include	"bstsongshell.h"


#ifdef __cplusplus
extern "C" {
#pragma }
#endif /* __cplusplus */


/* --- prototypes --- */
GtkMenuFactory* bst_menus_create		(void);
void		bst_menus_shutdown		(void);
void		bst_menus_add_items		(GtkMenuEntry	*items,
						 guint		 n_items);
void		bst_menus_adjust_item		(const gchar	*item_path,
						 gboolean	 sensitive,
						 gpointer	 user_data);

/* popups
 */
void		bst_menus_popup_pattern_menu	(guint		 root_x,
						 guint		 root_y,
						 guint		 mouse_button,
						 guint32	 time);

/* get accelerator tables
 */
GtkAcceleratorTable* bst_menus_pattern_menu_table	(void);

/* global links
 */
void		bst_menus_set_fg_song_shell	(BstSongShell	*song_shell);
BstSongShell*	bst_menus_get_fg_song_shell	(void);




#ifdef __cplusplus
#pragma {
}
#endif /* __cplusplus */

#endif /* __BST_MENUS_H__ */
