# Copyright 2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.15.0

EAPI=8

RUST_MIN_VER="1.71.1"

CRATES="
	adler2@2.0.1
	allocator-api2@0.2.21
	anstream@0.6.20
	anstyle-parse@0.2.7
	anstyle-query@1.1.4
	anstyle-wincon@3.0.10
	anstyle@1.0.11
	anyhow@1.0.98
	arc-swap@1.7.1
	autocfg@1.5.0
	bitflags@2.9.1
	block-buffer@0.10.4
	bstr@1.12.0
	byteorder@1.5.0
	bzip2-rs@0.1.2
	cc@1.2.32
	cfg-if@1.0.1
	cfg_aliases@0.2.1
	clap@4.5.43
	clap_builder@4.5.43
	clap_lex@0.7.5
	clru@0.6.2
	colorchoice@1.0.4
	cpufeatures@0.2.17
	crc32fast@1.5.0
	crypto-common@0.1.6
	ctrlc@3.4.7
	curl-sys@0.4.82+curl-8.14.1
	curl@0.4.48
	digest@0.10.7
	displaydoc@0.2.5
	dunce@1.0.5
	encoding_rs@0.8.35
	equivalent@1.0.2
	errno@0.3.13
	faster-hex@0.10.0
	fastrand@2.3.0
	filetime@0.2.25
	flate2@1.1.2
	fnv@1.0.7
	foldhash@0.1.5
	form_urlencoded@1.2.1
	generic-array@0.14.7
	getrandom@0.3.3
	gix-actor@0.35.3
	gix-bitmap@0.2.14
	gix-chunk@0.4.11
	gix-command@0.6.2
	gix-commitgraph@0.29.0
	gix-config-value@0.15.1
	gix-config@0.46.0
	gix-date@0.10.5
	gix-diff@0.53.0
	gix-discover@0.41.0
	gix-features@0.43.1
	gix-fs@0.16.0
	gix-glob@0.21.0
	gix-hash@0.19.0
	gix-hashtable@0.9.0
	gix-index@0.41.0
	gix-lock@18.0.0
	gix-object@0.50.1
	gix-odb@0.70.0
	gix-pack@0.60.0
	gix-packetline@0.19.1
	gix-path@0.10.20
	gix-protocol@0.51.0
	gix-quote@0.6.0
	gix-ref@0.53.0
	gix-refspec@0.31.0
	gix-revision@0.35.0
	gix-revwalk@0.21.0
	gix-sec@0.12.0
	gix-shallow@0.5.0
	gix-tempfile@18.0.0
	gix-trace@0.1.13
	gix-transport@0.48.0
	gix-traverse@0.47.0
	gix-url@0.32.0
	gix-utils@0.3.0
	gix-validate@0.10.0
	gix@0.73.0
	hash32@0.3.1
	hashbrown@0.15.5
	heapless@0.8.0
	hermit-abi@0.5.2
	home@0.5.11
	icu_collections@2.0.0
	icu_locale_core@2.0.0
	icu_normalizer@2.0.0
	icu_normalizer_data@2.0.0
	icu_properties@2.0.1
	icu_properties_data@2.0.1
	icu_provider@2.0.0
	idna@1.0.3
	idna_adapter@1.2.1
	indexmap@2.10.0
	is-terminal@0.4.16
	is_terminal_polyfill@1.70.1
	itoa@1.0.15
	jiff-static@0.2.15
	jiff-tzdb-platform@0.1.3
	jiff-tzdb@0.1.4
	jiff@0.2.15
	libc@0.2.174
	libredox@0.1.9
	libz-rs-sys@0.5.1
	libz-sys@1.1.22
	linux-raw-sys@0.9.4
	litemap@0.8.0
	lock_api@0.4.13
	log@0.4.27
	maybe-async@0.2.10
	memchr@2.7.5
	memmap2@0.9.7
	miniz_oxide@0.8.9
	nix@0.30.1
	once_cell@1.21.3
	once_cell_polyfill@1.70.1
	openssl-probe@0.1.6
	openssl-sys@0.9.109
	parking_lot@0.12.4
	parking_lot_core@0.9.11
	percent-encoding@2.3.1
	pkg-config@0.3.32
	portable-atomic-util@0.2.4
	portable-atomic@1.11.1
	potential_utf@0.1.2
	proc-macro2@1.0.96
	prodash@30.0.1
	quote@1.0.40
	r-efi@5.3.0
	redox_syscall@0.5.17
	regex-automata@0.4.9
	rustix@1.0.8
	ryu@1.0.20
	same-file@1.0.6
	schannel@0.1.27
	scopeguard@1.2.0
	serde@1.0.219
	serde_derive@1.0.219
	serde_json@1.0.142
	sha1-checked@0.10.0
	sha1@0.10.6
	shell-words@1.1.0
	shlex@1.3.0
	smallvec@1.15.1
	socket2@0.5.10
	stable_deref_trait@1.2.0
	strsim@0.11.1
	syn@2.0.104
	synstructure@0.13.2
	tar@0.4.44
	tempfile@3.20.0
	termcolor@1.4.1
	terminal_size@0.4.2
	thiserror-impl@2.0.12
	thiserror@2.0.12
	tinystr@0.8.1
	tinyvec@1.9.0
	tinyvec_macros@0.1.1
	typenum@1.18.0
	unicode-bom@2.0.3
	unicode-ident@1.0.18
	unicode-normalization@0.1.24
	url@2.5.4
	utf8_iter@1.0.4
	utf8parse@0.2.2
	vcpkg@0.2.15
	version_check@0.9.5
	walkdir@2.5.0
	wasi@0.14.2+wasi-0.2.4
	winapi-util@0.1.9
	windows-link@0.1.3
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-sys@0.60.2
	windows-targets@0.52.6
	windows-targets@0.53.3
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_gnullvm@0.53.0
	windows_aarch64_msvc@0.52.6
	windows_aarch64_msvc@0.53.0
	windows_i686_gnu@0.52.6
	windows_i686_gnu@0.53.0
	windows_i686_gnullvm@0.52.6
	windows_i686_gnullvm@0.53.0
	windows_i686_msvc@0.52.6
	windows_i686_msvc@0.53.0
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnu@0.53.0
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_gnullvm@0.53.0
	windows_x86_64_msvc@0.52.6
	windows_x86_64_msvc@0.53.0
	winnow@0.7.12
	wit-bindgen-rt@0.39.0
	writeable@0.6.1
	xattr@1.5.1
	yoke-derive@0.8.0
	yoke@0.8.0
	zerofrom-derive@0.1.6
	zerofrom@0.1.6
	zerotrie@0.2.2
	zerovec-derive@0.11.1
	zerovec@0.11.4
	zlib-rs@0.5.1
"

inherit cargo flag-o-matic

DESCRIPTION="Stack-based patch management for Git"
HOMEPAGE="https://stacked-git.github.io/"
SRC_URI="${CARGO_CRATE_URIS}"
SRC_URI+=" https://github.com/stacked-git/stgit/releases/download/v${PV}/${P}.tar.gz"

LICENSE="GPL-2"
# Dependent crate licenses
LICENSE+=" Apache-2.0 BSD MIT Unicode-3.0 ZLIB"
SLOT="0/2"
KEYWORDS="~amd64 ~arm ~arm64 ~ppc ~ppc64 ~riscv ~x86"
IUSE="doc"

DEPEND="doc? ( app-text/asciidoc )"

# rust does not use *FLAGS from make.conf, silence portage warning
# update with proper path to binaries this crate installs, omit leading /
QA_FLAGS_IGNORED="usr/bin/stg"

src_configure() {
	filter-lto #bug 897692
}

src_compile() {
	cargo_src_compile
	emake completion
	emake contrib
	use doc && emake doc
}

src_install() {
	cargo_src_install
	emake DESTDIR="${D}" prefix="/usr" install-completion
	emake DESTDIR="${D}" prefix="/usr" install-contrib
	if use doc; then
		emake DESTDIR="${D}" prefix="/usr" install-man
		emake DESTDIR="${D}" prefix="/usr" \
			htmldir="/usr/share/doc/${PF}"  \
			install-html
	fi
}
