/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import org.python.core.Py;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.jffi.AbstractMemoryCData;
import org.python.modules.jffi.AllocatedNativeMemory;
import org.python.modules.jffi.CData;
import org.python.modules.jffi.CType;
import org.python.modules.jffi.DirectMemory;
import org.python.modules.jffi.NullMemory;
import org.python.modules.jffi.StringCData$PyExposer;
import org.python.modules.jffi.Util;

@ExposedType(name="jffi.StringCData", base=CData.class)
public class StringCData
extends AbstractMemoryCData {
    public static final PyType TYPE;

    public StringCData(PyType pytype, CType ctype, DirectMemory m) {
        super(pytype, ctype, m);
    }

    @ExposedNew
    public static PyObject StringCData_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        if (args.length == 0) {
            return new StringCData(subtype, CType.typeOf(subtype), NullMemory.INSTANCE);
        }
        byte[] str = args[0].asString().getBytes();
        AllocatedNativeMemory m = AllocatedNativeMemory.allocate(str.length + 1, false);
        m.putZeroTerminatedByteArray(0L, str, 0, str.length);
        return new StringCData(subtype, CType.typeOf(subtype), m);
    }

    public static final PyObject from_address(PyType subtype, PyObject address) {
        DirectMemory m = Util.getMemoryForAddress(address);
        StringCData cdata = new StringCData(subtype, CType.typeOf(subtype), m.getMemory(0L));
        cdata.setReferenceMemory(m);
        return cdata;
    }

    public PyObject getValue() {
        DirectMemory m = this.getMemory();
        return !m.isNull() ? Py.newString(new String(m.getZeroTerminatedByteArray(0L))) : Py.None;
    }

    public void setValue(PyObject value) {
        byte[] str = value.asString().getBytes();
        AllocatedNativeMemory m = AllocatedNativeMemory.allocate(str.length + 1, false);
        m.putZeroTerminatedByteArray(0L, str, 0, str.length);
        this.memory = m;
        if (this.hasReferenceMemory()) {
            this.getReferenceMemory().putAddress(0L, m);
        }
    }

    public final String toString() {
        return this.getType().getName() + "(" + this.getValue().toString() + ")";
    }

    public String asString() {
        DirectMemory m = this.getMemory();
        return !m.isNull() ? new String(m.getZeroTerminatedByteArray(0L)) : null;
    }

    static {
        PyType.addBuilder(StringCData.class, new StringCData$PyExposer());
        TYPE = PyType.fromClass(StringCData.class);
    }
}

