# Copyright 2005-2007 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# Contributed by Roy Marples (uberlord@gentoo.org)

# void system_depend(void)
#
# Sets up the dependancies for the module
system_depend() {
	after interface
	before dhcp
}

# void system_expose(void)
#
# Expose variables that can be configured
system_expose() {
	variables dns_servers dns_domain dns_options dns_search dns_sortlist \
		ntp_servers nis_domain nis_servers
}

system_dns() {
	local iface="$1" ifvar=$(bash_variable "$1") x= domain= search= sortlist= options=
	local buffer=
	local -a servers=()

	servers="dns_servers_${ifvar}[@]"
	[[ -z ${!servers} ]] && servers="dns_servers[@]"

	domain="dns_domain_${ifvar}"
	[[ -z ${!domain} ]] && domain="dns_domain"

	search="dns_search_${ifvar}"
	[[ -z ${!search} ]] && search="dns_search"

	sortlist="dns_sortlist_${ifvar}"
	[[ -z ${!sortlist} ]] && sortlist="dns_sortlist"

	options="dns_options_${ifvar}"
	[[ -z ${!options} ]] && options="dns_options"

	[[ -z ${!servers} && -z ${!domain} && -z ${!search} && -z ${!sortlist} && -z ${!options} ]] && return 0

	buffer="# Generated by net-scripts for interface ${iface}\n"
	[[ -n ${!domain} ]] && buffer="${buffer}domain ${!domain}\n"
	[[ -n ${!search} ]] && buffer="${buffer}search ${!search}\n"

	for x in ${!servers} ; do
		buffer="${buffer}nameserver ${x}\n"
	done

	[[ -n ${!sortlist} ]] && buffer="${buffer}sortlist ${!sortlist}\n"
	[[ -n ${!options} ]] && buffer="${buffer}options ${!options}\n"

	# Support resolvconf if we have it.
	if [[ -x /sbin/resolvconf ]] ; then
		echo -e "${buffer}" | resolvconf -a "${iface}"
	else
		echo -e "${buffer}" > /etc/resolv.conf
		chmod 644 /etc/resolv.conf
	fi
}

system_ntp() {
	local iface="$1" ifvar=$(bash_variable "$1") x= buffer=
	local -a servers=()

	servers="ntp_servers_${ifvar}[@]"
	[[ -z ${!servers} ]] && servers="ntp_servers[@]"
	[[ -z ${!servers} ]] && return 0

	buffer="# Generated by net-scripts for interface ${iface}\n"
	buffer="${buffer}restrict default noquery notrust nomodify\n"
	buffer="${buffer}restrict 127.0.0.1\n"

	for x in ${!servers} ; do
		buffer="${buffer}restrict ${x} nomodify notrap noquery\n"
		buffer="${buffer}server ${x}\n"
	done

	buffer="${buffer}driftfile /var/lib/ntp/ntp.drift\n"
	buffer="${buffer}logfile /var/log/ntp.log\n"

	echo -e "${buffer}" > /etc/ntp.conf
	chmod 644 /etc/ntp.conf
}

system_nis() {
	local iface="$1" ifvar=$(bash_variable "$1") domain= x= buffer=
	local -a servers=()

	servers="nis_servers_${ifvar}[@]"
	[[ -z ${!servers} ]] && servers="nis_servers[@]"
	
	domain="nis_domain_${ifvar}"
	[[ -z ${!domain} ]] && domain="nis_domain"
	
	[[ -z ${!servers} && -z ${!domain} ]] && return 0

	buffer="# Generated by net-scripts for interface ${iface}\n"

	if [[ -n ${!domain} ]] ; then
		hostname -y "${!domain}"
		if [[ -n ${!servers} ]] ; then
			for x in ${!servers} ; do
				buffer="${buffer}domain ${!domain} server ${x}\n"
			done
		else
			buffer="${buffer}domain ${!domain} broadcast\n"
		fi
	else
		for x in ${!servers} ; do
			buffer="${buffer}ypserver ${x}\n"
		done
	fi

	echo -e "${buffer}" > /etc/yp.conf
	chmod 644 /etc/yp.conf
}

# bool system_post_start(char *iface)
#
# Configures the host system for dns, ntp and nis information
# Always returns 0
system_pre_start() {
	local iface="$1"

	system_dns "${iface}"
	system_ntp "${iface}"
	system_nis "${iface}"

	return 0
}

# vim: set ts=4 :
