/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.evpull;

import java.util.Stack;
import net.sf.saxon.evpull.EventIterator;
import net.sf.saxon.evpull.PullEvent;
import net.sf.saxon.trans.XPathException;

public class EventStackIterator
implements EventIterator {
    private Stack<EventIterator> eventStack = new Stack();

    public static EventIterator flatten(EventIterator base) {
        if (base.isFlatSequence()) {
            return base;
        }
        return new EventStackIterator(base);
    }

    private EventStackIterator(EventIterator base) {
        this.eventStack.push(base);
    }

    public PullEvent next() throws XPathException {
        if (this.eventStack.isEmpty()) {
            return null;
        }
        EventIterator iter = this.eventStack.peek();
        PullEvent next = iter.next();
        if (next == null) {
            this.eventStack.pop();
            return this.next();
        }
        if (next instanceof EventIterator) {
            this.eventStack.push((EventIterator)next);
            return this.next();
        }
        return next;
    }

    public boolean isFlatSequence() {
        return true;
    }
}

