/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PathMap;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.DivisibleInstruction;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParentNodeConstructor
extends Instruction
implements DivisibleInstruction {
    protected Expression content;
    private boolean lazyConstruction = false;
    private boolean namespaceSensitiveType;
    int validation = 3;
    private SchemaType schemaType;
    private String baseURI;

    public void setBaseURI(String uri) {
        this.baseURI = uri;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setLazyConstruction(boolean lazy) {
        this.lazyConstruction = lazy;
    }

    public final boolean isLazyConstruction() {
        return this.lazyConstruction;
    }

    public void setSchemaType(SchemaType type) {
        this.schemaType = type;
        this.namespaceSensitiveType = type instanceof SimpleType && ((SimpleType)type).isNamespaceSensitive();
    }

    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    public boolean isNamespaceSensitive() {
        return this.namespaceSensitiveType;
    }

    public void setValidationMode(int mode) {
        this.validation = mode;
    }

    public int getValidationMode() {
        return this.validation;
    }

    public void setContentExpression(Expression content) {
        this.content = content;
        this.adoptChildExpression(content);
    }

    @Override
    public Expression getContentExpression() {
        return this.content;
    }

    @Override
    public int computeCardinality() {
        return 16384;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.content = visitor.simplify(this.content);
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.content = visitor.typeCheck(this.content, contextItemType);
        this.adoptChildExpression(this.content);
        this.verifyLazyConstruction();
        this.checkContentSequence(visitor.getStaticContext());
        return this;
    }

    protected abstract void checkContentSequence(StaticContext var1) throws XPathException;

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.content = visitor.optimize(this.content, contextItemType);
        if (this.content instanceof Block) {
            this.content = ((Block)this.content).mergeAdjacentTextInstructions();
        }
        this.adoptChildExpression(this.content);
        if (visitor.isOptimizeForStreaming()) {
            visitor.getConfiguration().getOptimizer().makeCopyOperationsExplicit(this, this.content);
        }
        return this;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        if (offer.action != 13) {
            this.content = this.doPromotion(this.content, offer);
        }
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return new MonoIterator(this.content);
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.content == original) {
            this.content = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public final boolean createsNewNodes() {
        return true;
    }

    @Override
    public int getCardinality() {
        return 16384;
    }

    void verifyLazyConstruction() {
        if (!this.isLazyConstruction()) {
            return;
        }
        if ((this.getDependencies() & 0xC) != 0) {
            this.setLazyConstruction(false);
        }
        if (this.validation == 1 || this.validation == 2 || this.schemaType != null) {
            this.setLazyConstruction(false);
        }
    }

    @Override
    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        PathMap.PathMapNodeSet result = super.addToPathMap(pathMap, pathMapNodeSet);
        result.setReturnable(false);
        TypeHierarchy th = this.getExecutable().getConfiguration().getTypeHierarchy();
        ItemType type = this.getItemType(th);
        if (th.relationship(type, NodeKindTest.ELEMENT) != 4 || th.relationship(type, NodeKindTest.DOCUMENT) != 4) {
            result.addDescendants();
        }
        return new PathMap.PathMapNodeSet(pathMap.makeNewRoot(this));
    }
}

