/*
 * SPDX-License-Identifier: GPL-3.0-only
 * MuseScore-CLA-applies
 *
 * MuseScore
 * Music Composition & Notation
 *
 * Copyright (C) 2025 MuseScore BVBA and others
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#pragma once

#include "global/async/asyncable.h"

#include "global/modularity/ioc.h"
#include "iaudioconfiguration.h"
#include "iaudiodrivercontroller.h"
#include "audio/common/rpc/irpcchannel.h"

namespace muse::audio {
class AudioOutputDeviceController : public Injectable, public async::Asyncable
{
    Inject<IAudioConfiguration> configuration = { this };
    Inject<IAudioDriverController> audioDriverController = { this };
    Inject<rpc::IRpcChannel> rpcChannel = { this };

public:

    AudioOutputDeviceController(const modularity::ContextPtr& iocCtx)
        : Injectable(iocCtx) {}

    void init();

private:
    void checkConnection();
    void onOutputDeviceChanged();

    IAudioDriverPtr audioDriver() const;
};
}
