// Code generated by protoc-gen-go.
// source: search.proto
// DO NOT EDIT!

/*
Package otsprotocol is a generated protocol buffer package.

It is generated from these files:
	search.proto
	ots_filter.proto
	table_store.proto

It has these top-level messages:
	MatchQuery
	MatchPhraseQuery
	MatchAllQuery
	TermQuery
	TermsQuery
	RangeQuery
	PrefixQuery
	WildcardQuery
	BoolQuery
	ConstScoreQuery
	FieldValueFactor
	FunctionScoreQuery
	NestedQuery
	GeoBoundingBoxQuery
	GeoDistanceQuery
	GeoPolygonQuery
	Query
	Collapse
	NestedFilter
	ScoreSort
	FieldSort
	GeoDistanceSort
	PrimaryKeySort
	Sorter
	Sort
	SearchQuery
	ColumnsToGet
	SearchRequest
	SearchResponse
	FieldSchema
	IndexSchema
	IndexSetting
	CreateSearchIndexRequest
	CreateSearchIndexResponse
	IndexInfo
	ListSearchIndexRequest
	ListSearchIndexResponse
	DeleteSearchIndexRequest
	DeleteSearchIndexResponse
	SyncStat
	DescribeSearchIndexRequest
	DescribeSearchIndexResponse
	ValueTransferRule
	SingleColumnValueFilter
	CompositeColumnValueFilter
	ColumnPaginationFilter
	Filter
	Error
	PrimaryKeySchema
	PartitionRange
	TableOptions
	TableMeta
	Condition
	CapacityUnit
	ReservedThroughputDetails
	ReservedThroughput
	ConsumedCapacity
	StreamSpecification
	StreamDetails
	CreateTableRequest
	CreateTableResponse
	UpdateTableRequest
	UpdateTableResponse
	DescribeTableRequest
	DescribeTableResponse
	ListTableRequest
	ListTableResponse
	DeleteTableRequest
	DeleteTableResponse
	LoadTableRequest
	LoadTableResponse
	UnloadTableRequest
	UnloadTableResponse
	TimeRange
	ReturnContent
	GetRowRequest
	GetRowResponse
	UpdateRowRequest
	UpdateRowResponse
	PutRowRequest
	PutRowResponse
	DeleteRowRequest
	DeleteRowResponse
	TableInBatchGetRowRequest
	BatchGetRowRequest
	RowInBatchGetRowResponse
	TableInBatchGetRowResponse
	BatchGetRowResponse
	RowInBatchWriteRowRequest
	TableInBatchWriteRowRequest
	BatchWriteRowRequest
	RowInBatchWriteRowResponse
	TableInBatchWriteRowResponse
	BatchWriteRowResponse
	GetRangeRequest
	GetRangeResponse
	ListStreamRequest
	Stream
	ListStreamResponse
	StreamShard
	DescribeStreamRequest
	DescribeStreamResponse
	GetShardIteratorRequest
	GetShardIteratorResponse
	GetStreamRecordRequest
	GetStreamRecordResponse
	ComputeSplitPointsBySizeRequest
	ComputeSplitPointsBySizeResponse
	DefinedColumnSchema
	IndexMeta
	CreateIndexRequest
	CreateIndexResponse
	DropIndexRequest
	DropIndexResponse
	StartLocalTransactionRequest
	StartLocalTransactionResponse
	CommitTransactionRequest
	CommitTransactionResponse
	AbortTransactionRequest
	AbortTransactionResponse
*/
package otsprotocol

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type QueryType int32

const (
	QueryType_MATCH_QUERY            QueryType = 1
	QueryType_MATCH_PHRASE_QUERY     QueryType = 2
	QueryType_TERM_QUERY             QueryType = 3
	QueryType_RANGE_QUERY            QueryType = 4
	QueryType_PREFIX_QUERY           QueryType = 5
	QueryType_BOOL_QUERY             QueryType = 6
	QueryType_CONST_SCORE_QUERY      QueryType = 7
	QueryType_FUNCTION_SCORE_QUERY   QueryType = 8
	QueryType_NESTED_QUERY           QueryType = 9
	QueryType_WILDCARD_QUERY         QueryType = 10
	QueryType_MATCH_ALL_QUERY        QueryType = 11
	QueryType_GEO_BOUNDING_BOX_QUERY QueryType = 12
	QueryType_GEO_DISTANCE_QUERY     QueryType = 13
	QueryType_GEO_POLYGON_QUERY      QueryType = 14
	QueryType_TERMS_QUERY            QueryType = 15
)

var QueryType_name = map[int32]string{
	1:  "MATCH_QUERY",
	2:  "MATCH_PHRASE_QUERY",
	3:  "TERM_QUERY",
	4:  "RANGE_QUERY",
	5:  "PREFIX_QUERY",
	6:  "BOOL_QUERY",
	7:  "CONST_SCORE_QUERY",
	8:  "FUNCTION_SCORE_QUERY",
	9:  "NESTED_QUERY",
	10: "WILDCARD_QUERY",
	11: "MATCH_ALL_QUERY",
	12: "GEO_BOUNDING_BOX_QUERY",
	13: "GEO_DISTANCE_QUERY",
	14: "GEO_POLYGON_QUERY",
	15: "TERMS_QUERY",
}
var QueryType_value = map[string]int32{
	"MATCH_QUERY":            1,
	"MATCH_PHRASE_QUERY":     2,
	"TERM_QUERY":             3,
	"RANGE_QUERY":            4,
	"PREFIX_QUERY":           5,
	"BOOL_QUERY":             6,
	"CONST_SCORE_QUERY":      7,
	"FUNCTION_SCORE_QUERY":   8,
	"NESTED_QUERY":           9,
	"WILDCARD_QUERY":         10,
	"MATCH_ALL_QUERY":        11,
	"GEO_BOUNDING_BOX_QUERY": 12,
	"GEO_DISTANCE_QUERY":     13,
	"GEO_POLYGON_QUERY":      14,
	"TERMS_QUERY":            15,
}

func (x QueryType) Enum() *QueryType {
	p := new(QueryType)
	*p = x
	return p
}
func (x QueryType) String() string {
	return proto.EnumName(QueryType_name, int32(x))
}
func (x *QueryType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(QueryType_value, data, "QueryType")
	if err != nil {
		return err
	}
	*x = QueryType(value)
	return nil
}
func (QueryType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type QueryOperator int32

const (
	QueryOperator_OR  QueryOperator = 1
	QueryOperator_AND QueryOperator = 2
)

var QueryOperator_name = map[int32]string{
	1: "OR",
	2: "AND",
}
var QueryOperator_value = map[string]int32{
	"OR":  1,
	"AND": 2,
}

func (x QueryOperator) Enum() *QueryOperator {
	p := new(QueryOperator)
	*p = x
	return p
}
func (x QueryOperator) String() string {
	return proto.EnumName(QueryOperator_name, int32(x))
}
func (x *QueryOperator) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(QueryOperator_value, data, "QueryOperator")
	if err != nil {
		return err
	}
	*x = QueryOperator(value)
	return nil
}
func (QueryOperator) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

type ScoreMode int32

const (
	ScoreMode_SCORE_MODE_NONE  ScoreMode = 1
	ScoreMode_SCORE_MODE_AVG   ScoreMode = 2
	ScoreMode_SCORE_MODE_MAX   ScoreMode = 3
	ScoreMode_SCORE_MODE_TOTAL ScoreMode = 4
	ScoreMode_SCORE_MODE_MIN   ScoreMode = 5
)

var ScoreMode_name = map[int32]string{
	1: "SCORE_MODE_NONE",
	2: "SCORE_MODE_AVG",
	3: "SCORE_MODE_MAX",
	4: "SCORE_MODE_TOTAL",
	5: "SCORE_MODE_MIN",
}
var ScoreMode_value = map[string]int32{
	"SCORE_MODE_NONE":  1,
	"SCORE_MODE_AVG":   2,
	"SCORE_MODE_MAX":   3,
	"SCORE_MODE_TOTAL": 4,
	"SCORE_MODE_MIN":   5,
}

func (x ScoreMode) Enum() *ScoreMode {
	p := new(ScoreMode)
	*p = x
	return p
}
func (x ScoreMode) String() string {
	return proto.EnumName(ScoreMode_name, int32(x))
}
func (x *ScoreMode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ScoreMode_value, data, "ScoreMode")
	if err != nil {
		return err
	}
	*x = ScoreMode(value)
	return nil
}
func (ScoreMode) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type SortOrder int32

const (
	SortOrder_SORT_ORDER_ASC  SortOrder = 0
	SortOrder_SORT_ORDER_DESC SortOrder = 1
)

var SortOrder_name = map[int32]string{
	0: "SORT_ORDER_ASC",
	1: "SORT_ORDER_DESC",
}
var SortOrder_value = map[string]int32{
	"SORT_ORDER_ASC":  0,
	"SORT_ORDER_DESC": 1,
}

func (x SortOrder) Enum() *SortOrder {
	p := new(SortOrder)
	*p = x
	return p
}
func (x SortOrder) String() string {
	return proto.EnumName(SortOrder_name, int32(x))
}
func (x *SortOrder) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(SortOrder_value, data, "SortOrder")
	if err != nil {
		return err
	}
	*x = SortOrder(value)
	return nil
}
func (SortOrder) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

type SortMode int32

const (
	SortMode_SORT_MODE_MIN SortMode = 0
	SortMode_SORT_MODE_MAX SortMode = 1
	SortMode_SORT_MODE_AVG SortMode = 2
)

var SortMode_name = map[int32]string{
	0: "SORT_MODE_MIN",
	1: "SORT_MODE_MAX",
	2: "SORT_MODE_AVG",
}
var SortMode_value = map[string]int32{
	"SORT_MODE_MIN": 0,
	"SORT_MODE_MAX": 1,
	"SORT_MODE_AVG": 2,
}

func (x SortMode) Enum() *SortMode {
	p := new(SortMode)
	*p = x
	return p
}
func (x SortMode) String() string {
	return proto.EnumName(SortMode_name, int32(x))
}
func (x *SortMode) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(SortMode_value, data, "SortMode")
	if err != nil {
		return err
	}
	*x = SortMode(value)
	return nil
}
func (SortMode) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

type GeoDistanceType int32

const (
	GeoDistanceType_GEO_DISTANCE_ARC   GeoDistanceType = 0
	GeoDistanceType_GEO_DISTANCE_PLANE GeoDistanceType = 1
)

var GeoDistanceType_name = map[int32]string{
	0: "GEO_DISTANCE_ARC",
	1: "GEO_DISTANCE_PLANE",
}
var GeoDistanceType_value = map[string]int32{
	"GEO_DISTANCE_ARC":   0,
	"GEO_DISTANCE_PLANE": 1,
}

func (x GeoDistanceType) Enum() *GeoDistanceType {
	p := new(GeoDistanceType)
	*p = x
	return p
}
func (x GeoDistanceType) String() string {
	return proto.EnumName(GeoDistanceType_name, int32(x))
}
func (x *GeoDistanceType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(GeoDistanceType_value, data, "GeoDistanceType")
	if err != nil {
		return err
	}
	*x = GeoDistanceType(value)
	return nil
}
func (GeoDistanceType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type ColumnReturnType int32

const (
	ColumnReturnType_RETURN_ALL       ColumnReturnType = 1
	ColumnReturnType_RETURN_SPECIFIED ColumnReturnType = 2
	ColumnReturnType_RETURN_NONE      ColumnReturnType = 3
)

var ColumnReturnType_name = map[int32]string{
	1: "RETURN_ALL",
	2: "RETURN_SPECIFIED",
	3: "RETURN_NONE",
}
var ColumnReturnType_value = map[string]int32{
	"RETURN_ALL":       1,
	"RETURN_SPECIFIED": 2,
	"RETURN_NONE":      3,
}

func (x ColumnReturnType) Enum() *ColumnReturnType {
	p := new(ColumnReturnType)
	*p = x
	return p
}
func (x ColumnReturnType) String() string {
	return proto.EnumName(ColumnReturnType_name, int32(x))
}
func (x *ColumnReturnType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ColumnReturnType_value, data, "ColumnReturnType")
	if err != nil {
		return err
	}
	*x = ColumnReturnType(value)
	return nil
}
func (ColumnReturnType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

type IndexOptions int32

const (
	IndexOptions_DOCS      IndexOptions = 1
	IndexOptions_FREQS     IndexOptions = 2
	IndexOptions_POSITIONS IndexOptions = 3
	IndexOptions_OFFSETS   IndexOptions = 4
)

var IndexOptions_name = map[int32]string{
	1: "DOCS",
	2: "FREQS",
	3: "POSITIONS",
	4: "OFFSETS",
}
var IndexOptions_value = map[string]int32{
	"DOCS":      1,
	"FREQS":     2,
	"POSITIONS": 3,
	"OFFSETS":   4,
}

func (x IndexOptions) Enum() *IndexOptions {
	p := new(IndexOptions)
	*p = x
	return p
}
func (x IndexOptions) String() string {
	return proto.EnumName(IndexOptions_name, int32(x))
}
func (x *IndexOptions) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(IndexOptions_value, data, "IndexOptions")
	if err != nil {
		return err
	}
	*x = IndexOptions(value)
	return nil
}
func (IndexOptions) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type FieldType int32

const (
	FieldType_LONG      FieldType = 1
	FieldType_DOUBLE    FieldType = 2
	FieldType_BOOLEAN   FieldType = 3
	FieldType_KEYWORD   FieldType = 4
	FieldType_TEXT      FieldType = 5
	FieldType_NESTED    FieldType = 6
	FieldType_GEO_POINT FieldType = 7
)

var FieldType_name = map[int32]string{
	1: "LONG",
	2: "DOUBLE",
	3: "BOOLEAN",
	4: "KEYWORD",
	5: "TEXT",
	6: "NESTED",
	7: "GEO_POINT",
}
var FieldType_value = map[string]int32{
	"LONG":      1,
	"DOUBLE":    2,
	"BOOLEAN":   3,
	"KEYWORD":   4,
	"TEXT":      5,
	"NESTED":    6,
	"GEO_POINT": 7,
}

func (x FieldType) Enum() *FieldType {
	p := new(FieldType)
	*p = x
	return p
}
func (x FieldType) String() string {
	return proto.EnumName(FieldType_name, int32(x))
}
func (x *FieldType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(FieldType_value, data, "FieldType")
	if err != nil {
		return err
	}
	*x = FieldType(value)
	return nil
}
func (FieldType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

type SyncPhase int32

const (
	SyncPhase_FULL SyncPhase = 1
	SyncPhase_INCR SyncPhase = 2
)

var SyncPhase_name = map[int32]string{
	1: "FULL",
	2: "INCR",
}
var SyncPhase_value = map[string]int32{
	"FULL": 1,
	"INCR": 2,
}

func (x SyncPhase) Enum() *SyncPhase {
	p := new(SyncPhase)
	*p = x
	return p
}
func (x SyncPhase) String() string {
	return proto.EnumName(SyncPhase_name, int32(x))
}
func (x *SyncPhase) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(SyncPhase_value, data, "SyncPhase")
	if err != nil {
		return err
	}
	*x = SyncPhase(value)
	return nil
}
func (SyncPhase) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

type MatchQuery struct {
	FieldName          *string        `protobuf:"bytes,1,opt,name=field_name" json:"field_name,omitempty"`
	Text               *string        `protobuf:"bytes,2,opt,name=text" json:"text,omitempty"`
	MinimumShouldMatch *int32         `protobuf:"varint,3,opt,name=minimum_should_match" json:"minimum_should_match,omitempty"`
	Operator           *QueryOperator `protobuf:"varint,4,opt,name=operator,enum=otsprotocol.QueryOperator" json:"operator,omitempty"`
	XXX_unrecognized   []byte         `json:"-"`
}

func (m *MatchQuery) Reset()                    { *m = MatchQuery{} }
func (m *MatchQuery) String() string            { return proto.CompactTextString(m) }
func (*MatchQuery) ProtoMessage()               {}
func (*MatchQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *MatchQuery) GetFieldName() string {
	if m != nil && m.FieldName != nil {
		return *m.FieldName
	}
	return ""
}

func (m *MatchQuery) GetText() string {
	if m != nil && m.Text != nil {
		return *m.Text
	}
	return ""
}

func (m *MatchQuery) GetMinimumShouldMatch() int32 {
	if m != nil && m.MinimumShouldMatch != nil {
		return *m.MinimumShouldMatch
	}
	return 0
}

func (m *MatchQuery) GetOperator() QueryOperator {
	if m != nil && m.Operator != nil {
		return *m.Operator
	}
	return QueryOperator_OR
}

type MatchPhraseQuery struct {
	FieldName        *string `protobuf:"bytes,1,opt,name=field_name" json:"field_name,omitempty"`
	Text             *string `protobuf:"bytes,2,opt,name=text" json:"text,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *MatchPhraseQuery) Reset()                    { *m = MatchPhraseQuery{} }
func (m *MatchPhraseQuery) String() string            { return proto.CompactTextString(m) }
func (*MatchPhraseQuery) ProtoMessage()               {}
func (*MatchPhraseQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *MatchPhraseQuery) GetFieldName() string {
	if m != nil && m.FieldName != nil {
		return *m.FieldName
	}
	return ""
}

func (m *MatchPhraseQuery) GetText() string {
	if m != nil && m.Text != nil {
		return *m.Text
	}
	return ""
}

type MatchAllQuery struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *MatchAllQuery) Reset()                    { *m = MatchAllQuery{} }
func (m *MatchAllQuery) String() string            { return proto.CompactTextString(m) }
func (*MatchAllQuery) ProtoMessage()               {}
func (*MatchAllQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type TermQuery struct {
	FieldName        *string `protobuf:"bytes,1,opt,name=field_name" json:"field_name,omitempty"`
	Term             []byte  `protobuf:"bytes,2,opt,name=term" json:"term,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TermQuery) Reset()                    { *m = TermQuery{} }
func (m *TermQuery) String() string            { return proto.CompactTextString(m) }
func (*TermQuery) ProtoMessage()               {}
func (*TermQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *TermQuery) GetFieldName() string {
	if m != nil && m.FieldName != nil {
		return *m.FieldName
	}
	return ""
}

func (m *TermQuery) GetTerm() []byte {
	if m != nil {
		return m.Term
	}
	return nil
}

type TermsQuery struct {
	FieldName        *string  `protobuf:"bytes,1,opt,name=field_name" json:"field_name,omitempty"`
	Terms            [][]byte `protobuf:"bytes,2,rep,name=terms" json:"terms,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *TermsQuery) Reset()                    { *m = TermsQuery{} }
func (m *TermsQuery) String() string            { return proto.CompactTextString(m) }
func (*TermsQuery) ProtoMessage()               {}
func (*TermsQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *TermsQuery) GetFieldName() string {
	if m != nil && m.FieldName != nil {
		return *m.FieldName
	}
	return ""
}

func (m *TermsQuery) GetTerms() [][]byte {
	if m != nil {
		return m.Terms
	}
	return nil
}

type RangeQuery struct {
	FieldName        *string `protobuf:"bytes,1,opt,name=field_name" json:"field_name,omitempty"`
	RangeFrom        []byte  `protobuf:"bytes,2,opt,name=range_from" json:"range_from,omitempty"`
	RangeTo          []byte  `protobuf:"bytes,3,opt,name=range_to" json:"range_to,omitempty"`
	IncludeLower     *bool   `protobuf:"varint,4,opt,name=include_lower" json:"include_lower,omitempty"`
	IncludeUpper     *bool   `protobuf:"varint,5,opt,name=include_upper" json:"include_upper,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RangeQuery) Reset()                    { *m = RangeQuery{} }
func (m *RangeQuery) String() string            { return proto.CompactTextString(m) }
func (*RangeQuery) ProtoMessage()               {}
func (*RangeQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *RangeQuery) GetFieldName() string {
	if m != nil && m.FieldName != nil {
		return *m.FieldName
	}
	return ""
}

func (m *RangeQuery) GetRangeFrom() []byte {
	if m != nil {
		return m.RangeFrom
	}
	return nil
}

func (m *RangeQuery) GetRangeTo() []byte {
	if m != nil {
		return m.RangeTo
	}
	return nil
}

func (m *RangeQuery) GetIncludeLower() bool {
	if m != nil && m.IncludeLower != nil {
		return *m.IncludeLower
	}
	return false
}

func (m *RangeQuery) GetIncludeUpper() bool {
	if m != nil && m.IncludeUpper != nil {
		return *m.IncludeUpper
	}
	return false
}

type PrefixQuery struct {
	FieldName        *string `protobuf:"bytes,1,opt,name=field_name" json:"field_name,omitempty"`
	Prefix           *string `protobuf:"bytes,2,opt,name=prefix" json:"prefix,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *PrefixQuery) Reset()                    { *m = PrefixQuery{} }
func (m *PrefixQuery) String() string            { return proto.CompactTextString(m) }
func (*PrefixQuery) ProtoMessage()               {}
func (*PrefixQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *PrefixQuery) GetFieldName() string {
	if m != nil && m.FieldName != nil {
		return *m.FieldName
	}
	return ""
}

func (m *PrefixQuery) GetPrefix() string {
	if m != nil && m.Prefix != nil {
		return *m.Prefix
	}
	return ""
}

type WildcardQuery struct {
	FieldName        *string `protobuf:"bytes,1,opt,name=field_name" json:"field_name,omitempty"`
	Value            *string `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *WildcardQuery) Reset()                    { *m = WildcardQuery{} }
func (m *WildcardQuery) String() string            { return proto.CompactTextString(m) }
func (*WildcardQuery) ProtoMessage()               {}
func (*WildcardQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *WildcardQuery) GetFieldName() string {
	if m != nil && m.FieldName != nil {
		return *m.FieldName
	}
	return ""
}

func (m *WildcardQuery) GetValue() string {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return ""
}

type BoolQuery struct {
	MustQueries        []*Query `protobuf:"bytes,1,rep,name=must_queries" json:"must_queries,omitempty"`
	MustNotQueries     []*Query `protobuf:"bytes,2,rep,name=must_not_queries" json:"must_not_queries,omitempty"`
	FilterQueries      []*Query `protobuf:"bytes,3,rep,name=filter_queries" json:"filter_queries,omitempty"`
	ShouldQueries      []*Query `protobuf:"bytes,4,rep,name=should_queries" json:"should_queries,omitempty"`
	MinimumShouldMatch *int32   `protobuf:"varint,5,opt,name=minimum_should_match" json:"minimum_should_match,omitempty"`
	XXX_unrecognized   []byte   `json:"-"`
}

func (m *BoolQuery) Reset()                    { *m = BoolQuery{} }
func (m *BoolQuery) String() string            { return proto.CompactTextString(m) }
func (*BoolQuery) ProtoMessage()               {}
func (*BoolQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *BoolQuery) GetMustQueries() []*Query {
	if m != nil {
		return m.MustQueries
	}
	return nil
}

func (m *BoolQuery) GetMustNotQueries() []*Query {
	if m != nil {
		return m.MustNotQueries
	}
	return nil
}

func (m *BoolQuery) GetFilterQueries() []*Query {
	if m != nil {
		return m.FilterQueries
	}
	return nil
}

func (m *BoolQuery) GetShouldQueries() []*Query {
	if m != nil {
		return m.ShouldQueries
	}
	return nil
}

func (m *BoolQuery) GetMinimumShouldMatch() int32 {
	if m != nil && m.MinimumShouldMatch != nil {
		return *m.MinimumShouldMatch
	}
	return 0
}

type ConstScoreQuery struct {
	Filter           *Query `protobuf:"bytes,1,opt,name=filter" json:"filter,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *ConstScoreQuery) Reset()                    { *m = ConstScoreQuery{} }
func (m *ConstScoreQuery) String() string            { return proto.CompactTextString(m) }
func (*ConstScoreQuery) ProtoMessage()               {}
func (*ConstScoreQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *ConstScoreQuery) GetFilter() *Query {
	if m != nil {
		return m.Filter
	}
	return nil
}

type FieldValueFactor struct {
	FieldName        *string `protobuf:"bytes,1,opt,name=field_name" json:"field_name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *FieldValueFactor) Reset()                    { *m = FieldValueFactor{} }
func (m *FieldValueFactor) String() string            { return proto.CompactTextString(m) }
func (*FieldValueFactor) ProtoMessage()               {}
func (*FieldValueFactor) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *FieldValueFactor) GetFieldName() string {
	if m != nil && m.FieldName != nil {
		return *m.FieldName
	}
	return ""
}

type FunctionScoreQuery struct {
	Query            *Query            `protobuf:"bytes,1,opt,name=query" json:"query,omitempty"`
	FieldValueFactor *FieldValueFactor `protobuf:"bytes,2,opt,name=field_value_factor" json:"field_value_factor,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *FunctionScoreQuery) Reset()                    { *m = FunctionScoreQuery{} }
func (m *FunctionScoreQuery) String() string            { return proto.CompactTextString(m) }
func (*FunctionScoreQuery) ProtoMessage()               {}
func (*FunctionScoreQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *FunctionScoreQuery) GetQuery() *Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *FunctionScoreQuery) GetFieldValueFactor() *FieldValueFactor {
	if m != nil {
		return m.FieldValueFactor
	}
	return nil
}

type NestedQuery struct {
	Path             *string    `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	Query            *Query     `protobuf:"bytes,2,opt,name=query" json:"query,omitempty"`
	ScoreMode        *ScoreMode `protobuf:"varint,3,opt,name=score_mode,enum=otsprotocol.ScoreMode" json:"score_mode,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *NestedQuery) Reset()                    { *m = NestedQuery{} }
func (m *NestedQuery) String() string            { return proto.CompactTextString(m) }
func (*NestedQuery) ProtoMessage()               {}
func (*NestedQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *NestedQuery) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *NestedQuery) GetQuery() *Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *NestedQuery) GetScoreMode() ScoreMode {
	if m != nil && m.ScoreMode != nil {
		return *m.ScoreMode
	}
	return ScoreMode_SCORE_MODE_NONE
}

type GeoBoundingBoxQuery struct {
	FieldName        *string `protobuf:"bytes,1,opt,name=field_name" json:"field_name,omitempty"`
	TopLeft          *string `protobuf:"bytes,2,opt,name=top_left" json:"top_left,omitempty"`
	BottomRight      *string `protobuf:"bytes,3,opt,name=bottom_right" json:"bottom_right,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *GeoBoundingBoxQuery) Reset()                    { *m = GeoBoundingBoxQuery{} }
func (m *GeoBoundingBoxQuery) String() string            { return proto.CompactTextString(m) }
func (*GeoBoundingBoxQuery) ProtoMessage()               {}
func (*GeoBoundingBoxQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *GeoBoundingBoxQuery) GetFieldName() string {
	if m != nil && m.FieldName != nil {
		return *m.FieldName
	}
	return ""
}

func (m *GeoBoundingBoxQuery) GetTopLeft() string {
	if m != nil && m.TopLeft != nil {
		return *m.TopLeft
	}
	return ""
}

func (m *GeoBoundingBoxQuery) GetBottomRight() string {
	if m != nil && m.BottomRight != nil {
		return *m.BottomRight
	}
	return ""
}

type GeoDistanceQuery struct {
	FieldName        *string  `protobuf:"bytes,1,opt,name=field_name" json:"field_name,omitempty"`
	CenterPoint      *string  `protobuf:"bytes,2,opt,name=center_point" json:"center_point,omitempty"`
	Distance         *float64 `protobuf:"fixed64,3,opt,name=distance" json:"distance,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *GeoDistanceQuery) Reset()                    { *m = GeoDistanceQuery{} }
func (m *GeoDistanceQuery) String() string            { return proto.CompactTextString(m) }
func (*GeoDistanceQuery) ProtoMessage()               {}
func (*GeoDistanceQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *GeoDistanceQuery) GetFieldName() string {
	if m != nil && m.FieldName != nil {
		return *m.FieldName
	}
	return ""
}

func (m *GeoDistanceQuery) GetCenterPoint() string {
	if m != nil && m.CenterPoint != nil {
		return *m.CenterPoint
	}
	return ""
}

func (m *GeoDistanceQuery) GetDistance() float64 {
	if m != nil && m.Distance != nil {
		return *m.Distance
	}
	return 0
}

type GeoPolygonQuery struct {
	FieldName        *string  `protobuf:"bytes,1,opt,name=field_name" json:"field_name,omitempty"`
	Points           []string `protobuf:"bytes,2,rep,name=points" json:"points,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *GeoPolygonQuery) Reset()                    { *m = GeoPolygonQuery{} }
func (m *GeoPolygonQuery) String() string            { return proto.CompactTextString(m) }
func (*GeoPolygonQuery) ProtoMessage()               {}
func (*GeoPolygonQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *GeoPolygonQuery) GetFieldName() string {
	if m != nil && m.FieldName != nil {
		return *m.FieldName
	}
	return ""
}

func (m *GeoPolygonQuery) GetPoints() []string {
	if m != nil {
		return m.Points
	}
	return nil
}

type Query struct {
	Type             *QueryType `protobuf:"varint,1,opt,name=type,enum=otsprotocol.QueryType" json:"type,omitempty"`
	Query            []byte     `protobuf:"bytes,2,opt,name=query" json:"query,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *Query) Reset()                    { *m = Query{} }
func (m *Query) String() string            { return proto.CompactTextString(m) }
func (*Query) ProtoMessage()               {}
func (*Query) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *Query) GetType() QueryType {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return QueryType_MATCH_QUERY
}

func (m *Query) GetQuery() []byte {
	if m != nil {
		return m.Query
	}
	return nil
}

type Collapse struct {
	FieldName        *string `protobuf:"bytes,1,opt,name=field_name" json:"field_name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *Collapse) Reset()                    { *m = Collapse{} }
func (m *Collapse) String() string            { return proto.CompactTextString(m) }
func (*Collapse) ProtoMessage()               {}
func (*Collapse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *Collapse) GetFieldName() string {
	if m != nil && m.FieldName != nil {
		return *m.FieldName
	}
	return ""
}

type NestedFilter struct {
	Path             *string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	Filter           *Query  `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *NestedFilter) Reset()                    { *m = NestedFilter{} }
func (m *NestedFilter) String() string            { return proto.CompactTextString(m) }
func (*NestedFilter) ProtoMessage()               {}
func (*NestedFilter) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *NestedFilter) GetPath() string {
	if m != nil && m.Path != nil {
		return *m.Path
	}
	return ""
}

func (m *NestedFilter) GetFilter() *Query {
	if m != nil {
		return m.Filter
	}
	return nil
}

type ScoreSort struct {
	Order            *SortOrder `protobuf:"varint,1,opt,name=order,enum=otsprotocol.SortOrder" json:"order,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *ScoreSort) Reset()                    { *m = ScoreSort{} }
func (m *ScoreSort) String() string            { return proto.CompactTextString(m) }
func (*ScoreSort) ProtoMessage()               {}
func (*ScoreSort) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *ScoreSort) GetOrder() SortOrder {
	if m != nil && m.Order != nil {
		return *m.Order
	}
	return SortOrder_SORT_ORDER_ASC
}

type FieldSort struct {
	FieldName        *string       `protobuf:"bytes,1,opt,name=field_name" json:"field_name,omitempty"`
	Order            *SortOrder    `protobuf:"varint,2,opt,name=order,enum=otsprotocol.SortOrder" json:"order,omitempty"`
	Mode             *SortMode     `protobuf:"varint,3,opt,name=mode,enum=otsprotocol.SortMode" json:"mode,omitempty"`
	NestedFilter     *NestedFilter `protobuf:"bytes,4,opt,name=nested_filter" json:"nested_filter,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *FieldSort) Reset()                    { *m = FieldSort{} }
func (m *FieldSort) String() string            { return proto.CompactTextString(m) }
func (*FieldSort) ProtoMessage()               {}
func (*FieldSort) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *FieldSort) GetFieldName() string {
	if m != nil && m.FieldName != nil {
		return *m.FieldName
	}
	return ""
}

func (m *FieldSort) GetOrder() SortOrder {
	if m != nil && m.Order != nil {
		return *m.Order
	}
	return SortOrder_SORT_ORDER_ASC
}

func (m *FieldSort) GetMode() SortMode {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return SortMode_SORT_MODE_MIN
}

func (m *FieldSort) GetNestedFilter() *NestedFilter {
	if m != nil {
		return m.NestedFilter
	}
	return nil
}

type GeoDistanceSort struct {
	FieldName        *string          `protobuf:"bytes,1,opt,name=field_name" json:"field_name,omitempty"`
	Points           []string         `protobuf:"bytes,2,rep,name=points" json:"points,omitempty"`
	Order            *SortOrder       `protobuf:"varint,3,opt,name=order,enum=otsprotocol.SortOrder" json:"order,omitempty"`
	Mode             *SortMode        `protobuf:"varint,4,opt,name=mode,enum=otsprotocol.SortMode" json:"mode,omitempty"`
	DistanceType     *GeoDistanceType `protobuf:"varint,5,opt,name=distance_type,enum=otsprotocol.GeoDistanceType" json:"distance_type,omitempty"`
	NestedFilter     *NestedFilter    `protobuf:"bytes,6,opt,name=nested_filter" json:"nested_filter,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *GeoDistanceSort) Reset()                    { *m = GeoDistanceSort{} }
func (m *GeoDistanceSort) String() string            { return proto.CompactTextString(m) }
func (*GeoDistanceSort) ProtoMessage()               {}
func (*GeoDistanceSort) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *GeoDistanceSort) GetFieldName() string {
	if m != nil && m.FieldName != nil {
		return *m.FieldName
	}
	return ""
}

func (m *GeoDistanceSort) GetPoints() []string {
	if m != nil {
		return m.Points
	}
	return nil
}

func (m *GeoDistanceSort) GetOrder() SortOrder {
	if m != nil && m.Order != nil {
		return *m.Order
	}
	return SortOrder_SORT_ORDER_ASC
}

func (m *GeoDistanceSort) GetMode() SortMode {
	if m != nil && m.Mode != nil {
		return *m.Mode
	}
	return SortMode_SORT_MODE_MIN
}

func (m *GeoDistanceSort) GetDistanceType() GeoDistanceType {
	if m != nil && m.DistanceType != nil {
		return *m.DistanceType
	}
	return GeoDistanceType_GEO_DISTANCE_ARC
}

func (m *GeoDistanceSort) GetNestedFilter() *NestedFilter {
	if m != nil {
		return m.NestedFilter
	}
	return nil
}

type PrimaryKeySort struct {
	Order            *SortOrder `protobuf:"varint,1,opt,name=order,enum=otsprotocol.SortOrder" json:"order,omitempty"`
	XXX_unrecognized []byte     `json:"-"`
}

func (m *PrimaryKeySort) Reset()                    { *m = PrimaryKeySort{} }
func (m *PrimaryKeySort) String() string            { return proto.CompactTextString(m) }
func (*PrimaryKeySort) ProtoMessage()               {}
func (*PrimaryKeySort) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *PrimaryKeySort) GetOrder() SortOrder {
	if m != nil && m.Order != nil {
		return *m.Order
	}
	return SortOrder_SORT_ORDER_ASC
}

type Sorter struct {
	FieldSort        *FieldSort       `protobuf:"bytes,1,opt,name=field_sort" json:"field_sort,omitempty"`
	GeoDistanceSort  *GeoDistanceSort `protobuf:"bytes,2,opt,name=geo_distance_sort" json:"geo_distance_sort,omitempty"`
	ScoreSort        *ScoreSort       `protobuf:"bytes,3,opt,name=score_sort" json:"score_sort,omitempty"`
	PkSort           *PrimaryKeySort  `protobuf:"bytes,4,opt,name=pk_sort" json:"pk_sort,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *Sorter) Reset()                    { *m = Sorter{} }
func (m *Sorter) String() string            { return proto.CompactTextString(m) }
func (*Sorter) ProtoMessage()               {}
func (*Sorter) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *Sorter) GetFieldSort() *FieldSort {
	if m != nil {
		return m.FieldSort
	}
	return nil
}

func (m *Sorter) GetGeoDistanceSort() *GeoDistanceSort {
	if m != nil {
		return m.GeoDistanceSort
	}
	return nil
}

func (m *Sorter) GetScoreSort() *ScoreSort {
	if m != nil {
		return m.ScoreSort
	}
	return nil
}

func (m *Sorter) GetPkSort() *PrimaryKeySort {
	if m != nil {
		return m.PkSort
	}
	return nil
}

type Sort struct {
	Sorter           []*Sorter `protobuf:"bytes,1,rep,name=sorter" json:"sorter,omitempty"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *Sort) Reset()                    { *m = Sort{} }
func (m *Sort) String() string            { return proto.CompactTextString(m) }
func (*Sort) ProtoMessage()               {}
func (*Sort) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *Sort) GetSorter() []*Sorter {
	if m != nil {
		return m.Sorter
	}
	return nil
}

type SearchQuery struct {
	Offset           *int32    `protobuf:"varint,1,opt,name=offset" json:"offset,omitempty"`
	Limit            *int32    `protobuf:"varint,2,opt,name=limit" json:"limit,omitempty"`
	Query            *Query    `protobuf:"bytes,4,opt,name=query" json:"query,omitempty"`
	Collapse         *Collapse `protobuf:"bytes,5,opt,name=collapse" json:"collapse,omitempty"`
	Sort             *Sort     `protobuf:"bytes,6,opt,name=sort" json:"sort,omitempty"`
	GetTotalCount    *bool     `protobuf:"varint,8,opt,name=getTotalCount" json:"getTotalCount,omitempty"`
	Token            []byte    `protobuf:"bytes,9,opt,name=token" json:"token,omitempty"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *SearchQuery) Reset()                    { *m = SearchQuery{} }
func (m *SearchQuery) String() string            { return proto.CompactTextString(m) }
func (*SearchQuery) ProtoMessage()               {}
func (*SearchQuery) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *SearchQuery) GetOffset() int32 {
	if m != nil && m.Offset != nil {
		return *m.Offset
	}
	return 0
}

func (m *SearchQuery) GetLimit() int32 {
	if m != nil && m.Limit != nil {
		return *m.Limit
	}
	return 0
}

func (m *SearchQuery) GetQuery() *Query {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *SearchQuery) GetCollapse() *Collapse {
	if m != nil {
		return m.Collapse
	}
	return nil
}

func (m *SearchQuery) GetSort() *Sort {
	if m != nil {
		return m.Sort
	}
	return nil
}

func (m *SearchQuery) GetGetTotalCount() bool {
	if m != nil && m.GetTotalCount != nil {
		return *m.GetTotalCount
	}
	return false
}

func (m *SearchQuery) GetToken() []byte {
	if m != nil {
		return m.Token
	}
	return nil
}

type ColumnsToGet struct {
	ReturnType       *ColumnReturnType `protobuf:"varint,1,opt,name=return_type,enum=otsprotocol.ColumnReturnType" json:"return_type,omitempty"`
	ColumnNames      []string          `protobuf:"bytes,2,rep,name=column_names" json:"column_names,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *ColumnsToGet) Reset()                    { *m = ColumnsToGet{} }
func (m *ColumnsToGet) String() string            { return proto.CompactTextString(m) }
func (*ColumnsToGet) ProtoMessage()               {}
func (*ColumnsToGet) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *ColumnsToGet) GetReturnType() ColumnReturnType {
	if m != nil && m.ReturnType != nil {
		return *m.ReturnType
	}
	return ColumnReturnType_RETURN_ALL
}

func (m *ColumnsToGet) GetColumnNames() []string {
	if m != nil {
		return m.ColumnNames
	}
	return nil
}

type SearchRequest struct {
	TableName        *string       `protobuf:"bytes,1,opt,name=table_name" json:"table_name,omitempty"`
	IndexName        *string       `protobuf:"bytes,2,opt,name=index_name" json:"index_name,omitempty"`
	ColumnsToGet     *ColumnsToGet `protobuf:"bytes,3,opt,name=columns_to_get" json:"columns_to_get,omitempty"`
	SearchQuery      []byte        `protobuf:"bytes,4,opt,name=search_query" json:"search_query,omitempty"`
	RoutingValues    [][]byte      `protobuf:"bytes,5,rep,name=routing_values" json:"routing_values,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *SearchRequest) Reset()                    { *m = SearchRequest{} }
func (m *SearchRequest) String() string            { return proto.CompactTextString(m) }
func (*SearchRequest) ProtoMessage()               {}
func (*SearchRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *SearchRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *SearchRequest) GetIndexName() string {
	if m != nil && m.IndexName != nil {
		return *m.IndexName
	}
	return ""
}

func (m *SearchRequest) GetColumnsToGet() *ColumnsToGet {
	if m != nil {
		return m.ColumnsToGet
	}
	return nil
}

func (m *SearchRequest) GetSearchQuery() []byte {
	if m != nil {
		return m.SearchQuery
	}
	return nil
}

func (m *SearchRequest) GetRoutingValues() [][]byte {
	if m != nil {
		return m.RoutingValues
	}
	return nil
}

type SearchResponse struct {
	TotalHits        *int64   `protobuf:"varint,1,opt,name=total_hits" json:"total_hits,omitempty"`
	Rows             [][]byte `protobuf:"bytes,2,rep,name=rows" json:"rows,omitempty"`
	IsAllSucceeded   *bool    `protobuf:"varint,3,opt,name=is_all_succeeded" json:"is_all_succeeded,omitempty"`
	NextToken        []byte   `protobuf:"bytes,6,opt,name=next_token" json:"next_token,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *SearchResponse) Reset()                    { *m = SearchResponse{} }
func (m *SearchResponse) String() string            { return proto.CompactTextString(m) }
func (*SearchResponse) ProtoMessage()               {}
func (*SearchResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *SearchResponse) GetTotalHits() int64 {
	if m != nil && m.TotalHits != nil {
		return *m.TotalHits
	}
	return 0
}

func (m *SearchResponse) GetRows() [][]byte {
	if m != nil {
		return m.Rows
	}
	return nil
}

func (m *SearchResponse) GetIsAllSucceeded() bool {
	if m != nil && m.IsAllSucceeded != nil {
		return *m.IsAllSucceeded
	}
	return false
}

func (m *SearchResponse) GetNextToken() []byte {
	if m != nil {
		return m.NextToken
	}
	return nil
}

type FieldSchema struct {
	FieldName        *string        `protobuf:"bytes,1,opt,name=field_name" json:"field_name,omitempty"`
	FieldType        *FieldType     `protobuf:"varint,2,opt,name=field_type,enum=otsprotocol.FieldType" json:"field_type,omitempty"`
	IndexOptions     *IndexOptions  `protobuf:"varint,3,opt,name=index_options,enum=otsprotocol.IndexOptions" json:"index_options,omitempty"`
	Analyzer         *string        `protobuf:"bytes,4,opt,name=analyzer" json:"analyzer,omitempty"`
	Index            *bool          `protobuf:"varint,5,opt,name=index" json:"index,omitempty"`
	DocValues        *bool          `protobuf:"varint,6,opt,name=doc_values" json:"doc_values,omitempty"`
	Store            *bool          `protobuf:"varint,7,opt,name=store" json:"store,omitempty"`
	FieldSchemas     []*FieldSchema `protobuf:"bytes,8,rep,name=field_schemas" json:"field_schemas,omitempty"`
	IsArray          *bool          `protobuf:"varint,9,opt,name=is_array" json:"is_array,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *FieldSchema) Reset()                    { *m = FieldSchema{} }
func (m *FieldSchema) String() string            { return proto.CompactTextString(m) }
func (*FieldSchema) ProtoMessage()               {}
func (*FieldSchema) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *FieldSchema) GetFieldName() string {
	if m != nil && m.FieldName != nil {
		return *m.FieldName
	}
	return ""
}

func (m *FieldSchema) GetFieldType() FieldType {
	if m != nil && m.FieldType != nil {
		return *m.FieldType
	}
	return FieldType_LONG
}

func (m *FieldSchema) GetIndexOptions() IndexOptions {
	if m != nil && m.IndexOptions != nil {
		return *m.IndexOptions
	}
	return IndexOptions_DOCS
}

func (m *FieldSchema) GetAnalyzer() string {
	if m != nil && m.Analyzer != nil {
		return *m.Analyzer
	}
	return ""
}

func (m *FieldSchema) GetIndex() bool {
	if m != nil && m.Index != nil {
		return *m.Index
	}
	return false
}

func (m *FieldSchema) GetDocValues() bool {
	if m != nil && m.DocValues != nil {
		return *m.DocValues
	}
	return false
}

func (m *FieldSchema) GetStore() bool {
	if m != nil && m.Store != nil {
		return *m.Store
	}
	return false
}

func (m *FieldSchema) GetFieldSchemas() []*FieldSchema {
	if m != nil {
		return m.FieldSchemas
	}
	return nil
}

func (m *FieldSchema) GetIsArray() bool {
	if m != nil && m.IsArray != nil {
		return *m.IsArray
	}
	return false
}

type IndexSchema struct {
	FieldSchemas     []*FieldSchema `protobuf:"bytes,1,rep,name=field_schemas" json:"field_schemas,omitempty"`
	IndexSetting     *IndexSetting  `protobuf:"bytes,2,opt,name=index_setting" json:"index_setting,omitempty"`
	IndexSort        *Sort          `protobuf:"bytes,3,opt,name=index_sort" json:"index_sort,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *IndexSchema) Reset()                    { *m = IndexSchema{} }
func (m *IndexSchema) String() string            { return proto.CompactTextString(m) }
func (*IndexSchema) ProtoMessage()               {}
func (*IndexSchema) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

func (m *IndexSchema) GetFieldSchemas() []*FieldSchema {
	if m != nil {
		return m.FieldSchemas
	}
	return nil
}

func (m *IndexSchema) GetIndexSetting() *IndexSetting {
	if m != nil {
		return m.IndexSetting
	}
	return nil
}

func (m *IndexSchema) GetIndexSort() *Sort {
	if m != nil {
		return m.IndexSort
	}
	return nil
}

type IndexSetting struct {
	NumberOfShards       *int32   `protobuf:"varint,1,opt,name=number_of_shards" json:"number_of_shards,omitempty"`
	RoutingFields        []string `protobuf:"bytes,2,rep,name=routing_fields" json:"routing_fields,omitempty"`
	RoutingPartitionSize *int32   `protobuf:"varint,3,opt,name=routing_partition_size" json:"routing_partition_size,omitempty"`
	XXX_unrecognized     []byte   `json:"-"`
}

func (m *IndexSetting) Reset()                    { *m = IndexSetting{} }
func (m *IndexSetting) String() string            { return proto.CompactTextString(m) }
func (*IndexSetting) ProtoMessage()               {}
func (*IndexSetting) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{31} }

func (m *IndexSetting) GetNumberOfShards() int32 {
	if m != nil && m.NumberOfShards != nil {
		return *m.NumberOfShards
	}
	return 0
}

func (m *IndexSetting) GetRoutingFields() []string {
	if m != nil {
		return m.RoutingFields
	}
	return nil
}

func (m *IndexSetting) GetRoutingPartitionSize() int32 {
	if m != nil && m.RoutingPartitionSize != nil {
		return *m.RoutingPartitionSize
	}
	return 0
}

type CreateSearchIndexRequest struct {
	TableName        *string      `protobuf:"bytes,1,req,name=table_name" json:"table_name,omitempty"`
	IndexName        *string      `protobuf:"bytes,2,req,name=index_name" json:"index_name,omitempty"`
	Schema           *IndexSchema `protobuf:"bytes,3,opt,name=schema" json:"schema,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *CreateSearchIndexRequest) Reset()                    { *m = CreateSearchIndexRequest{} }
func (m *CreateSearchIndexRequest) String() string            { return proto.CompactTextString(m) }
func (*CreateSearchIndexRequest) ProtoMessage()               {}
func (*CreateSearchIndexRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{32} }

func (m *CreateSearchIndexRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *CreateSearchIndexRequest) GetIndexName() string {
	if m != nil && m.IndexName != nil {
		return *m.IndexName
	}
	return ""
}

func (m *CreateSearchIndexRequest) GetSchema() *IndexSchema {
	if m != nil {
		return m.Schema
	}
	return nil
}

type CreateSearchIndexResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *CreateSearchIndexResponse) Reset()                    { *m = CreateSearchIndexResponse{} }
func (m *CreateSearchIndexResponse) String() string            { return proto.CompactTextString(m) }
func (*CreateSearchIndexResponse) ProtoMessage()               {}
func (*CreateSearchIndexResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{33} }

type IndexInfo struct {
	TableName        *string `protobuf:"bytes,1,opt,name=table_name" json:"table_name,omitempty"`
	IndexName        *string `protobuf:"bytes,2,opt,name=index_name" json:"index_name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *IndexInfo) Reset()                    { *m = IndexInfo{} }
func (m *IndexInfo) String() string            { return proto.CompactTextString(m) }
func (*IndexInfo) ProtoMessage()               {}
func (*IndexInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{34} }

func (m *IndexInfo) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *IndexInfo) GetIndexName() string {
	if m != nil && m.IndexName != nil {
		return *m.IndexName
	}
	return ""
}

type ListSearchIndexRequest struct {
	TableName        *string `protobuf:"bytes,1,opt,name=table_name" json:"table_name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *ListSearchIndexRequest) Reset()                    { *m = ListSearchIndexRequest{} }
func (m *ListSearchIndexRequest) String() string            { return proto.CompactTextString(m) }
func (*ListSearchIndexRequest) ProtoMessage()               {}
func (*ListSearchIndexRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{35} }

func (m *ListSearchIndexRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

type ListSearchIndexResponse struct {
	Indices          []*IndexInfo `protobuf:"bytes,1,rep,name=indices" json:"indices,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *ListSearchIndexResponse) Reset()                    { *m = ListSearchIndexResponse{} }
func (m *ListSearchIndexResponse) String() string            { return proto.CompactTextString(m) }
func (*ListSearchIndexResponse) ProtoMessage()               {}
func (*ListSearchIndexResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{36} }

func (m *ListSearchIndexResponse) GetIndices() []*IndexInfo {
	if m != nil {
		return m.Indices
	}
	return nil
}

type DeleteSearchIndexRequest struct {
	TableName        *string `protobuf:"bytes,1,opt,name=table_name" json:"table_name,omitempty"`
	IndexName        *string `protobuf:"bytes,2,opt,name=index_name" json:"index_name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *DeleteSearchIndexRequest) Reset()                    { *m = DeleteSearchIndexRequest{} }
func (m *DeleteSearchIndexRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteSearchIndexRequest) ProtoMessage()               {}
func (*DeleteSearchIndexRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{37} }

func (m *DeleteSearchIndexRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *DeleteSearchIndexRequest) GetIndexName() string {
	if m != nil && m.IndexName != nil {
		return *m.IndexName
	}
	return ""
}

type DeleteSearchIndexResponse struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *DeleteSearchIndexResponse) Reset()                    { *m = DeleteSearchIndexResponse{} }
func (m *DeleteSearchIndexResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteSearchIndexResponse) ProtoMessage()               {}
func (*DeleteSearchIndexResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{38} }

type SyncStat struct {
	SyncPhase            *SyncPhase `protobuf:"varint,1,opt,name=sync_phase,enum=otsprotocol.SyncPhase" json:"sync_phase,omitempty"`
	CurrentSyncTimestamp *int64     `protobuf:"varint,2,opt,name=current_sync_timestamp" json:"current_sync_timestamp,omitempty"`
	XXX_unrecognized     []byte     `json:"-"`
}

func (m *SyncStat) Reset()                    { *m = SyncStat{} }
func (m *SyncStat) String() string            { return proto.CompactTextString(m) }
func (*SyncStat) ProtoMessage()               {}
func (*SyncStat) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{39} }

func (m *SyncStat) GetSyncPhase() SyncPhase {
	if m != nil && m.SyncPhase != nil {
		return *m.SyncPhase
	}
	return SyncPhase_FULL
}

func (m *SyncStat) GetCurrentSyncTimestamp() int64 {
	if m != nil && m.CurrentSyncTimestamp != nil {
		return *m.CurrentSyncTimestamp
	}
	return 0
}

type DescribeSearchIndexRequest struct {
	TableName        *string `protobuf:"bytes,1,opt,name=table_name" json:"table_name,omitempty"`
	IndexName        *string `protobuf:"bytes,2,opt,name=index_name" json:"index_name,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *DescribeSearchIndexRequest) Reset()                    { *m = DescribeSearchIndexRequest{} }
func (m *DescribeSearchIndexRequest) String() string            { return proto.CompactTextString(m) }
func (*DescribeSearchIndexRequest) ProtoMessage()               {}
func (*DescribeSearchIndexRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{40} }

func (m *DescribeSearchIndexRequest) GetTableName() string {
	if m != nil && m.TableName != nil {
		return *m.TableName
	}
	return ""
}

func (m *DescribeSearchIndexRequest) GetIndexName() string {
	if m != nil && m.IndexName != nil {
		return *m.IndexName
	}
	return ""
}

type DescribeSearchIndexResponse struct {
	Schema           *IndexSchema `protobuf:"bytes,1,opt,name=schema" json:"schema,omitempty"`
	SyncStat         *SyncStat    `protobuf:"bytes,2,opt,name=sync_stat" json:"sync_stat,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *DescribeSearchIndexResponse) Reset()                    { *m = DescribeSearchIndexResponse{} }
func (m *DescribeSearchIndexResponse) String() string            { return proto.CompactTextString(m) }
func (*DescribeSearchIndexResponse) ProtoMessage()               {}
func (*DescribeSearchIndexResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{41} }

func (m *DescribeSearchIndexResponse) GetSchema() *IndexSchema {
	if m != nil {
		return m.Schema
	}
	return nil
}

func (m *DescribeSearchIndexResponse) GetSyncStat() *SyncStat {
	if m != nil {
		return m.SyncStat
	}
	return nil
}

func init() {
	proto.RegisterType((*MatchQuery)(nil), "otsprotocol.MatchQuery")
	proto.RegisterType((*MatchPhraseQuery)(nil), "otsprotocol.MatchPhraseQuery")
	proto.RegisterType((*MatchAllQuery)(nil), "otsprotocol.MatchAllQuery")
	proto.RegisterType((*TermQuery)(nil), "otsprotocol.TermQuery")
	proto.RegisterType((*TermsQuery)(nil), "otsprotocol.TermsQuery")
	proto.RegisterType((*RangeQuery)(nil), "otsprotocol.RangeQuery")
	proto.RegisterType((*PrefixQuery)(nil), "otsprotocol.PrefixQuery")
	proto.RegisterType((*WildcardQuery)(nil), "otsprotocol.WildcardQuery")
	proto.RegisterType((*BoolQuery)(nil), "otsprotocol.BoolQuery")
	proto.RegisterType((*ConstScoreQuery)(nil), "otsprotocol.ConstScoreQuery")
	proto.RegisterType((*FieldValueFactor)(nil), "otsprotocol.FieldValueFactor")
	proto.RegisterType((*FunctionScoreQuery)(nil), "otsprotocol.FunctionScoreQuery")
	proto.RegisterType((*NestedQuery)(nil), "otsprotocol.NestedQuery")
	proto.RegisterType((*GeoBoundingBoxQuery)(nil), "otsprotocol.GeoBoundingBoxQuery")
	proto.RegisterType((*GeoDistanceQuery)(nil), "otsprotocol.GeoDistanceQuery")
	proto.RegisterType((*GeoPolygonQuery)(nil), "otsprotocol.GeoPolygonQuery")
	proto.RegisterType((*Query)(nil), "otsprotocol.Query")
	proto.RegisterType((*Collapse)(nil), "otsprotocol.Collapse")
	proto.RegisterType((*NestedFilter)(nil), "otsprotocol.NestedFilter")
	proto.RegisterType((*ScoreSort)(nil), "otsprotocol.ScoreSort")
	proto.RegisterType((*FieldSort)(nil), "otsprotocol.FieldSort")
	proto.RegisterType((*GeoDistanceSort)(nil), "otsprotocol.GeoDistanceSort")
	proto.RegisterType((*PrimaryKeySort)(nil), "otsprotocol.PrimaryKeySort")
	proto.RegisterType((*Sorter)(nil), "otsprotocol.Sorter")
	proto.RegisterType((*Sort)(nil), "otsprotocol.Sort")
	proto.RegisterType((*SearchQuery)(nil), "otsprotocol.SearchQuery")
	proto.RegisterType((*ColumnsToGet)(nil), "otsprotocol.ColumnsToGet")
	proto.RegisterType((*SearchRequest)(nil), "otsprotocol.SearchRequest")
	proto.RegisterType((*SearchResponse)(nil), "otsprotocol.SearchResponse")
	proto.RegisterType((*FieldSchema)(nil), "otsprotocol.FieldSchema")
	proto.RegisterType((*IndexSchema)(nil), "otsprotocol.IndexSchema")
	proto.RegisterType((*IndexSetting)(nil), "otsprotocol.IndexSetting")
	proto.RegisterType((*CreateSearchIndexRequest)(nil), "otsprotocol.CreateSearchIndexRequest")
	proto.RegisterType((*CreateSearchIndexResponse)(nil), "otsprotocol.CreateSearchIndexResponse")
	proto.RegisterType((*IndexInfo)(nil), "otsprotocol.IndexInfo")
	proto.RegisterType((*ListSearchIndexRequest)(nil), "otsprotocol.ListSearchIndexRequest")
	proto.RegisterType((*ListSearchIndexResponse)(nil), "otsprotocol.ListSearchIndexResponse")
	proto.RegisterType((*DeleteSearchIndexRequest)(nil), "otsprotocol.DeleteSearchIndexRequest")
	proto.RegisterType((*DeleteSearchIndexResponse)(nil), "otsprotocol.DeleteSearchIndexResponse")
	proto.RegisterType((*SyncStat)(nil), "otsprotocol.SyncStat")
	proto.RegisterType((*DescribeSearchIndexRequest)(nil), "otsprotocol.DescribeSearchIndexRequest")
	proto.RegisterType((*DescribeSearchIndexResponse)(nil), "otsprotocol.DescribeSearchIndexResponse")
	proto.RegisterEnum("otsprotocol.QueryType", QueryType_name, QueryType_value)
	proto.RegisterEnum("otsprotocol.QueryOperator", QueryOperator_name, QueryOperator_value)
	proto.RegisterEnum("otsprotocol.ScoreMode", ScoreMode_name, ScoreMode_value)
	proto.RegisterEnum("otsprotocol.SortOrder", SortOrder_name, SortOrder_value)
	proto.RegisterEnum("otsprotocol.SortMode", SortMode_name, SortMode_value)
	proto.RegisterEnum("otsprotocol.GeoDistanceType", GeoDistanceType_name, GeoDistanceType_value)
	proto.RegisterEnum("otsprotocol.ColumnReturnType", ColumnReturnType_name, ColumnReturnType_value)
	proto.RegisterEnum("otsprotocol.IndexOptions", IndexOptions_name, IndexOptions_value)
	proto.RegisterEnum("otsprotocol.FieldType", FieldType_name, FieldType_value)
	proto.RegisterEnum("otsprotocol.SyncPhase", SyncPhase_name, SyncPhase_value)
}

func init() { proto.RegisterFile("search.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1930 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xa4, 0x58, 0xe9, 0x72, 0xdb, 0xd6,
	0x15, 0x0e, 0xb8, 0x89, 0x3c, 0x5c, 0x04, 0x5f, 0xcb, 0x2a, 0x6d, 0x67, 0x51, 0x91, 0xa6, 0xd1,
	0xb0, 0xae, 0xd3, 0x28, 0xe9, 0x64, 0x3a, 0xd3, 0x99, 0x94, 0x22, 0x41, 0x86, 0x13, 0x09, 0xa0,
	0x01, 0xca, 0x96, 0x7f, 0xc1, 0x30, 0x78, 0x29, 0xa2, 0x01, 0x71, 0xe9, 0x8b, 0xcb, 0xc6, 0xf4,
	0x03, 0xf4, 0x15, 0xda, 0x3f, 0x7d, 0x16, 0xff, 0xec, 0x33, 0xf4, 0x0d, 0xfa, 0x18, 0x9d, 0xbb,
	0x80, 0x3b, 0x65, 0x75, 0xf2, 0xcf, 0x38, 0xfc, 0xce, 0xf6, 0x9d, 0xe5, 0x1e, 0x0b, 0x2a, 0x09,
	0xf6, 0x69, 0x30, 0x7e, 0x3a, 0xa5, 0x84, 0x11, 0x54, 0x26, 0x2c, 0x11, 0xff, 0x0a, 0x48, 0x64,
	0xbc, 0x03, 0xb8, 0xf4, 0x59, 0x30, 0x7e, 0x36, 0xc3, 0x74, 0x8e, 0x10, 0xc0, 0x28, 0xc4, 0xd1,
	0xd0, 0x8b, 0xfd, 0x09, 0xae, 0x6b, 0x27, 0xda, 0x69, 0x09, 0x55, 0x20, 0xc7, 0xf0, 0x5b, 0x56,
	0xcf, 0x88, 0xaf, 0x8f, 0xe1, 0x68, 0x12, 0xc6, 0xe1, 0x64, 0x36, 0xf1, 0x92, 0x31, 0x99, 0x45,
	0x43, 0x6f, 0xc2, 0xd5, 0xeb, 0xd9, 0x13, 0xed, 0x34, 0x8f, 0x9e, 0x40, 0x91, 0x4c, 0x31, 0xf5,
	0x19, 0xa1, 0xf5, 0xdc, 0x89, 0x76, 0x5a, 0x3b, 0x7b, 0xf4, 0x74, 0xc5, 0xdb, 0x53, 0xe1, 0xc5,
	0x56, 0x08, 0xe3, 0x5b, 0xd0, 0x85, 0xef, 0xfe, 0x98, 0xfa, 0x09, 0xbe, 0x63, 0x04, 0xc6, 0x21,
	0x54, 0x85, 0x56, 0x33, 0x8a, 0x84, 0x8a, 0xf1, 0x7b, 0x28, 0x0d, 0x30, 0x9d, 0x7c, 0x40, 0x9f,
	0x4e, 0x84, 0x7e, 0xc5, 0xf8, 0x0a, 0x80, 0xc3, 0x93, 0xfd, 0xf8, 0x2a, 0xe4, 0x39, 0x3e, 0xa9,
	0x67, 0x4e, 0xb2, 0xa7, 0x15, 0x83, 0x01, 0x38, 0x7e, 0x7c, 0x73, 0x4b, 0x80, 0x08, 0x80, 0x72,
	0x84, 0x37, 0xa2, 0x44, 0xb9, 0x41, 0x3a, 0x14, 0xa5, 0x8c, 0x11, 0x41, 0x4e, 0x05, 0x3d, 0x80,
	0x6a, 0x18, 0x07, 0xd1, 0x6c, 0x88, 0xbd, 0x88, 0xfc, 0x8c, 0x25, 0x43, 0xc5, 0x55, 0xf1, 0x6c,
	0x3a, 0xc5, 0xb4, 0x9e, 0xe7, 0x62, 0xe3, 0x6b, 0x28, 0xf7, 0x29, 0x1e, 0x85, 0x6f, 0xf7, 0xbb,
	0xad, 0x41, 0x61, 0x2a, 0x20, 0x8a, 0x99, 0x33, 0xa8, 0xbe, 0x08, 0xa3, 0x61, 0xe0, 0xd3, 0xe1,
	0xad, 0xc9, 0xfd, 0xcd, 0x8f, 0x66, 0x58, 0xe9, 0xfc, 0x47, 0x83, 0xd2, 0x39, 0x21, 0x92, 0x4a,
	0x74, 0x0a, 0x95, 0xc9, 0x2c, 0x61, 0xde, 0x9b, 0x19, 0xa6, 0x21, 0x4e, 0xea, 0xda, 0x49, 0xf6,
	0xb4, 0x7c, 0x86, 0xb6, 0x6b, 0x88, 0x9e, 0x80, 0x2e, 0x90, 0x31, 0x59, 0xa2, 0x33, 0x7b, 0xd1,
	0x0d, 0xa8, 0x8d, 0xc2, 0x88, 0x61, 0xba, 0xc0, 0x66, 0x6f, 0xc3, 0xaa, 0xce, 0x4a, 0xb1, 0xb9,
	0xbd, 0xd8, 0x7d, 0xdd, 0xc8, 0x29, 0xcc, 0x1b, 0x7f, 0x84, 0xc3, 0x16, 0x89, 0x13, 0xe6, 0x06,
	0x84, 0xaa, 0xea, 0x19, 0x50, 0x90, 0x81, 0x08, 0x36, 0x76, 0x1a, 0x35, 0x7e, 0x0b, 0x7a, 0x87,
	0xb3, 0xf6, 0x9c, 0xd3, 0xd4, 0xf1, 0x03, 0x46, 0xe8, 0x2e, 0x26, 0x0d, 0x0a, 0xa8, 0x33, 0x8b,
	0x03, 0x16, 0x92, 0x78, 0xc5, 0xc3, 0xaf, 0x21, 0xcf, 0xe3, 0x9e, 0xef, 0x77, 0x80, 0xfe, 0x04,
	0x48, 0x1a, 0x13, 0x85, 0xf0, 0x46, 0xc2, 0x85, 0xa8, 0x47, 0xf9, 0xec, 0x93, 0x35, 0xfc, 0x66,
	0x1c, 0xc6, 0x5f, 0xa1, 0x6c, 0xe1, 0x84, 0x61, 0x55, 0xe0, 0x0a, 0xe4, 0xa6, 0x3e, 0x1b, 0xab,
	0xd2, 0x2e, 0x5c, 0x67, 0xf6, 0xba, 0x6e, 0x00, 0x24, 0x3c, 0x56, 0x6f, 0x42, 0x86, 0x58, 0xf4,
	0x65, 0xed, 0xec, 0x78, 0x0d, 0x27, 0x52, 0xb9, 0x24, 0x43, 0x6c, 0x3c, 0x83, 0xfb, 0x5d, 0x4c,
	0xce, 0xc9, 0x2c, 0x1e, 0x86, 0xf1, 0xcd, 0x39, 0xb9, 0xa5, 0x13, 0x75, 0x28, 0x32, 0x32, 0xf5,
	0x22, 0x3c, 0x4a, 0xf7, 0xc4, 0x11, 0x54, 0x5e, 0x13, 0xc6, 0xc8, 0xc4, 0xa3, 0xe1, 0xcd, 0x98,
	0x09, 0x57, 0x25, 0xc3, 0x02, 0xbd, 0x8b, 0x49, 0x3b, 0x4c, 0x98, 0x1f, 0x07, 0xb7, 0x0c, 0xd4,
	0x11, 0x54, 0x02, 0x1c, 0xf3, 0x7e, 0x99, 0x92, 0x30, 0x4e, 0x6d, 0xea, 0x50, 0x1c, 0x2a, 0x55,
	0x61, 0x4f, 0xe3, 0x15, 0xee, 0x62, 0xd2, 0x27, 0xd1, 0xfc, 0x86, 0xc4, 0xb7, 0x0f, 0x0a, 0xb7,
	0x23, 0x5b, 0xb4, 0x64, 0xfc, 0x19, 0xf2, 0x12, 0xfc, 0x1b, 0xc8, 0xb1, 0xf9, 0x54, 0xc2, 0x36,
	0x89, 0x10, 0x88, 0xc1, 0x7c, 0x8a, 0xf9, 0xc8, 0x2c, 0x79, 0xad, 0x18, 0x9f, 0x42, 0xb1, 0x45,
	0xa2, 0xc8, 0x9f, 0x26, 0x78, 0x67, 0x5f, 0xfc, 0x05, 0x2a, 0xb2, 0x46, 0x1d, 0xd1, 0x69, 0x1b,
	0x45, 0x5a, 0x76, 0xe0, 0xde, 0x2a, 0x19, 0x67, 0x50, 0x12, 0x65, 0x70, 0x09, 0x65, 0xe8, 0x0b,
	0xc8, 0x13, 0x3a, 0x54, 0x1d, 0xbb, 0x55, 0x2d, 0x42, 0x99, 0xcd, 0x7f, 0x35, 0xfe, 0xa5, 0x41,
	0x49, 0xb4, 0x8b, 0x50, 0xda, 0xc5, 0xc2, 0xc2, 0x50, 0xe6, 0x36, 0x43, 0xe8, 0x73, 0xc8, 0xad,
	0x34, 0xc7, 0x83, 0x2d, 0x14, 0xef, 0x0d, 0xf4, 0x07, 0xa8, 0xc6, 0x22, 0x47, 0x4f, 0x25, 0x93,
	0x13, 0xc9, 0x3c, 0x5c, 0x43, 0xaf, 0xb2, 0x60, 0xfc, 0x57, 0x13, 0xb5, 0x4a, 0x6b, 0xbf, 0x37,
	0xca, 0x8d, 0x5a, 0x2d, 0xa3, 0xce, 0xde, 0x29, 0xea, 0xdc, 0x6d, 0x51, 0x7f, 0x03, 0xd5, 0xb4,
	0x81, 0x3c, 0x51, 0xf7, 0xbc, 0x40, 0x7f, 0xbc, 0x86, 0x5e, 0x09, 0x52, 0x54, 0x7f, 0x2b, 0xd5,
	0xc2, 0x87, 0x52, 0xfd, 0x0e, 0x6a, 0x7d, 0x1a, 0x4e, 0x7c, 0x3a, 0xff, 0x11, 0xcf, 0xff, 0x9f,
	0x1a, 0xfe, 0x5b, 0x83, 0x02, 0xff, 0xc2, 0x94, 0x0f, 0xaa, 0xa4, 0x26, 0x21, 0x94, 0xa9, 0x5d,
	0x72, 0xbc, 0xbd, 0x1b, 0x84, 0xf5, 0xef, 0xe0, 0xde, 0x0d, 0x26, 0xde, 0x22, 0x35, 0xa1, 0x22,
	0xbb, 0x6b, 0x6f, 0x6a, 0x42, 0x71, 0xb1, 0x0d, 0x84, 0x46, 0x76, 0x87, 0x93, 0x65, 0x1b, 0x3e,
	0x81, 0x83, 0xe9, 0x4f, 0x12, 0x28, 0x6b, 0xfd, 0x78, 0x0d, 0xb8, 0x9e, 0xb0, 0xf1, 0x3b, 0xc8,
	0x09, 0xad, 0xcf, 0xa1, 0x90, 0x88, 0x84, 0xd4, 0x53, 0x72, 0x7f, 0x2b, 0x73, 0x4c, 0x8d, 0xf7,
	0x1a, 0x94, 0x5d, 0x71, 0xa1, 0xc8, 0xa9, 0xac, 0x41, 0x81, 0x8c, 0x46, 0x09, 0x96, 0x79, 0xe7,
	0xf9, 0xfc, 0x45, 0xe1, 0x24, 0x94, 0x39, 0xe5, 0x97, 0x6b, 0x2e, 0xb7, 0x77, 0xcd, 0x7d, 0x09,
	0xc5, 0x40, 0x8d, 0xa8, 0xa8, 0x71, 0x79, 0xa3, 0x23, 0x16, 0xf3, 0xfb, 0x19, 0xe4, 0x44, 0x4a,
	0xb2, 0xa6, 0xf7, 0xb6, 0xa2, 0xe3, 0xaf, 0xf3, 0x0d, 0x66, 0x03, 0xc2, 0xfc, 0xa8, 0x45, 0x66,
	0x31, 0xab, 0x17, 0xc5, 0xa3, 0xcd, 0x4f, 0x04, 0xf2, 0x13, 0x8e, 0xeb, 0x25, 0xb1, 0x12, 0xae,
	0xa1, 0xd2, 0x22, 0xd1, 0x6c, 0x12, 0x27, 0x03, 0xd2, 0xc5, 0x0c, 0x9d, 0x41, 0x99, 0x62, 0x36,
	0xa3, 0xb1, 0xb7, 0xb2, 0x5e, 0x3e, 0xd9, 0x0c, 0x61, 0x36, 0x89, 0x1d, 0x81, 0x12, 0x7d, 0xc6,
	0x77, 0x9e, 0x90, 0x89, 0x69, 0x48, 0x57, 0xd5, 0x3f, 0x35, 0xa8, 0x4a, 0x6e, 0x1c, 0xfc, 0x66,
	0x86, 0x13, 0x31, 0x34, 0xcc, 0x7f, 0x1d, 0xe1, 0x8d, 0x03, 0x24, 0x8c, 0x87, 0xf8, 0xad, 0x94,
	0xc9, 0x6d, 0xf9, 0x35, 0xd4, 0xa4, 0xbd, 0xc4, 0x63, 0xc4, 0xbb, 0xc1, 0x69, 0x81, 0x1f, 0xee,
	0x08, 0x43, 0x85, 0x7d, 0x94, 0x5e, 0x8a, 0xde, 0x92, 0xe0, 0x0a, 0x3a, 0x86, 0x1a, 0x25, 0x33,
	0x16, 0xc6, 0x37, 0xf2, 0xc1, 0x4a, 0xea, 0x79, 0x71, 0x17, 0xbd, 0x82, 0x5a, 0x1a, 0x59, 0x32,
	0x25, 0xb1, 0xdc, 0x86, 0x8c, 0x33, 0xe5, 0x8d, 0x43, 0x96, 0x88, 0xd0, 0xb2, 0x7c, 0xfb, 0x51,
	0xf2, 0xb3, 0xba, 0xa5, 0x50, 0x1d, 0xf4, 0x30, 0xf1, 0xfc, 0x28, 0xf2, 0x92, 0x59, 0x10, 0x60,
	0x3c, 0xc4, 0x43, 0x11, 0x56, 0x91, 0xeb, 0xc6, 0xf8, 0x2d, 0xf3, 0x24, 0xad, 0x05, 0x41, 0xeb,
	0xdf, 0x33, 0x50, 0x96, 0x6d, 0x1e, 0x8c, 0xf1, 0xc4, 0xdf, 0xb9, 0x2f, 0x16, 0x83, 0x22, 0x98,
	0xde, 0xb5, 0xda, 0x84, 0x85, 0x74, 0x94, 0x25, 0x4d, 0x64, 0xca, 0x5f, 0xed, 0x44, 0xed, 0x94,
	0x75, 0x46, 0x7a, 0x1c, 0x61, 0x4b, 0x00, 0x7f, 0x72, 0xfc, 0xd8, 0x8f, 0xe6, 0xef, 0xd4, 0x8a,
	0x13, 0xf7, 0x93, 0xb0, 0x21, 0xcf, 0x34, 0x1e, 0xd2, 0x90, 0x04, 0x29, 0x31, 0x85, 0xb4, 0x39,
	0x12, 0x46, 0x28, 0xae, 0x1f, 0x88, 0xcf, 0xaf, 0xa0, 0xaa, 0x46, 0x59, 0x64, 0x91, 0xd4, 0x8b,
	0x62, 0x14, 0xea, 0x3b, 0xa6, 0x59, 0xa6, 0xa9, 0x43, 0x91, 0x93, 0x44, 0xa9, 0x3f, 0x17, 0xfd,
	0x55, 0x34, 0xfe, 0xa1, 0x41, 0x59, 0xc4, 0xa5, 0x10, 0x5b, 0x26, 0xb5, 0x0f, 0x98, 0x5c, 0x64,
	0x9e, 0x60, 0xc6, 0x2b, 0xa9, 0xd6, 0xc3, 0x8e, 0xcc, 0x5d, 0x09, 0x40, 0x5f, 0xa4, 0x2d, 0xb5,
	0xb2, 0x1b, 0xb6, 0xe7, 0xc3, 0x78, 0x05, 0x95, 0x35, 0xb5, 0x3a, 0xe8, 0xf1, 0x6c, 0xf2, 0x1a,
	0x53, 0x8f, 0x8c, 0xbc, 0x64, 0xec, 0xd3, 0x61, 0xa2, 0xa6, 0x78, 0xa5, 0x8d, 0x44, 0xec, 0xe9,
	0x82, 0xff, 0x14, 0x8e, 0x53, 0xf9, 0xd4, 0xa7, 0x2c, 0xe4, 0xc4, 0x7b, 0x49, 0xf8, 0x4e, 0xbe,
	0x40, 0x79, 0x23, 0x82, 0x7a, 0x8b, 0x62, 0x9f, 0x61, 0xd9, 0x6c, 0xc2, 0xdb, 0xbe, 0x59, 0xc8,
	0xec, 0x98, 0x05, 0x2e, 0x3b, 0x85, 0x82, 0x64, 0x4a, 0x25, 0x52, 0xdf, 0x91, 0xb7, 0xf8, 0xdd,
	0x78, 0x0c, 0x0f, 0x77, 0x78, 0x93, 0xfd, 0x6d, 0x7c, 0x03, 0x25, 0x21, 0xe8, 0xc5, 0x23, 0x72,
	0xd7, 0x39, 0x34, 0x9e, 0xc0, 0xf1, 0x45, 0x98, 0xb0, 0x3b, 0x44, 0xcf, 0xd1, 0xe7, 0xf0, 0xab,
	0x2d, 0xb4, 0x9a, 0xae, 0x2f, 0xe1, 0x20, 0x8c, 0x87, 0x61, 0xb0, 0xb8, 0xcb, 0x8f, 0xb7, 0xb3,
	0xe0, 0x91, 0x19, 0xe7, 0x50, 0x6f, 0xe3, 0x08, 0xdf, 0x89, 0xb1, 0x7d, 0x51, 0x3f, 0x86, 0x87,
	0x3b, 0x6c, 0x28, 0x1e, 0x9e, 0x43, 0xd1, 0x9d, 0xc7, 0x81, 0xcb, 0x7c, 0xf9, 0x86, 0xcc, 0xe3,
	0xc0, 0x9b, 0x8e, 0xfd, 0x64, 0xf7, 0x21, 0xc5, 0xa1, 0x7d, 0xfe, 0x2b, 0x2f, 0x75, 0x30, 0xa3,
	0x14, 0xc7, 0xcc, 0x13, 0x3a, 0x2c, 0x9c, 0xe0, 0x84, 0xf9, 0x93, 0xa9, 0x70, 0x9a, 0x35, 0xda,
	0xf0, 0xa8, 0x8d, 0x93, 0x80, 0x86, 0xaf, 0x7f, 0x49, 0xe8, 0x6f, 0xe0, 0xf1, 0x4e, 0x2b, 0x8a,
	0xc6, 0x65, 0x2f, 0x68, 0xb7, 0xf7, 0x02, 0x3a, 0x85, 0x92, 0x08, 0x33, 0x61, 0x7e, 0xfa, 0x9e,
	0x3e, 0xd8, 0xca, 0x8c, 0x93, 0xd0, 0x78, 0x9f, 0x81, 0xd2, 0xf2, 0x5e, 0x3c, 0x84, 0xf2, 0x65,
	0x73, 0xd0, 0xfa, 0xc1, 0x7b, 0x76, 0x65, 0x3a, 0x2f, 0x75, 0x0d, 0x1d, 0x03, 0x92, 0x82, 0xfe,
	0x0f, 0x4e, 0xd3, 0x35, 0x95, 0x3c, 0x83, 0x6a, 0x00, 0x03, 0xd3, 0xb9, 0x54, 0xdf, 0x59, 0xae,
	0xe8, 0x34, 0xad, 0x6e, 0x0a, 0xc8, 0x21, 0x1d, 0x2a, 0x7d, 0xc7, 0xec, 0xf4, 0xae, 0x95, 0x24,
	0xcf, 0x55, 0xce, 0x6d, 0xfb, 0x42, 0x7d, 0x17, 0xd0, 0x03, 0xb8, 0xd7, 0xb2, 0x2d, 0x77, 0xe0,
	0xb9, 0x2d, 0xdb, 0x49, 0x15, 0x0f, 0x50, 0x1d, 0x8e, 0x3a, 0x57, 0x56, 0x6b, 0xd0, 0xb3, 0xad,
	0xb5, 0x5f, 0x8a, 0xdc, 0xa4, 0x65, 0xba, 0x03, 0xb3, 0xad, 0x24, 0x9c, 0xc3, 0xda, 0x8b, 0xde,
	0x45, 0xbb, 0xd5, 0x74, 0x52, 0x19, 0xa0, 0xfb, 0x70, 0x28, 0x23, 0x6e, 0x5e, 0xa4, 0xbe, 0xca,
	0xe8, 0x11, 0x1c, 0x77, 0x4d, 0xdb, 0x3b, 0xb7, 0xaf, 0xac, 0x76, 0xcf, 0xea, 0x7a, 0xe7, 0x76,
	0x1a, 0x17, 0x7f, 0x24, 0x10, 0xff, 0xad, 0xdd, 0x73, 0x07, 0x4d, 0xab, 0x95, 0xba, 0xab, 0xf2,
	0xf8, 0xb8, 0xbc, 0x6f, 0x5f, 0xbc, 0xec, 0xda, 0x96, 0x12, 0xd7, 0x78, 0xa6, 0x3c, 0x73, 0x57,
	0x09, 0x0e, 0x1b, 0x27, 0x50, 0x5d, 0xfb, 0xe3, 0x00, 0x2a, 0x40, 0xc6, 0x76, 0x74, 0x0d, 0x1d,
	0x40, 0xb6, 0x69, 0xb5, 0xf5, 0x4c, 0x83, 0xaa, 0xa3, 0x58, 0x5c, 0x72, 0xf7, 0xe1, 0x50, 0xa6,
	0x75, 0x69, 0xb7, 0x4d, 0xcf, 0xb2, 0x2d, 0x53, 0xd7, 0x78, 0x22, 0x2b, 0xc2, 0xe6, 0xf3, 0xae,
	0x9e, 0xd9, 0x90, 0x5d, 0x36, 0xaf, 0xf5, 0x2c, 0x3a, 0x02, 0x7d, 0x45, 0x36, 0xb0, 0x07, 0xcd,
	0x0b, 0x3d, 0xb7, 0x89, 0xec, 0x59, 0x7a, 0xbe, 0xf1, 0x2d, 0x94, 0x96, 0x27, 0x26, 0x07, 0xd8,
	0xce, 0xc0, 0xb3, 0x9d, 0xb6, 0xe9, 0x78, 0x4d, 0xb7, 0xa5, 0x7f, 0x24, 0xe2, 0x58, 0xca, 0xda,
	0xa6, 0xdb, 0xd2, 0xb5, 0x46, 0x0b, 0x8a, 0x8b, 0x93, 0xf3, 0x1e, 0x54, 0x05, 0x60, 0x61, 0xf4,
	0xa3, 0x0d, 0x51, 0xf3, 0x5a, 0xd7, 0xd6, 0x45, 0x22, 0xf0, 0xc6, 0xf7, 0x6b, 0xe7, 0xb2, 0xba,
	0x10, 0xf4, 0x35, 0x8e, 0x9b, 0x0e, 0x0f, 0x61, 0x93, 0xf9, 0xfe, 0x45, 0x93, 0xb3, 0xd1, 0xe8,
	0x81, 0xbe, 0x75, 0x63, 0xd4, 0x00, 0x1c, 0x73, 0x70, 0xe5, 0x58, 0xbc, 0xae, 0xba, 0xc6, 0x2d,
	0xaa, 0x6f, 0xb7, 0x6f, 0xb6, 0x7a, 0x9d, 0x9e, 0xd9, 0xd6, 0x33, 0xa2, 0x0d, 0xa5, 0x54, 0x10,
	0x9b, 0x6d, 0x7c, 0xaf, 0x96, 0x7c, 0xfa, 0x2a, 0x16, 0x21, 0xd7, 0xb6, 0x5b, 0xae, 0xae, 0xa1,
	0x12, 0xe4, 0x3b, 0x8e, 0xf9, 0xcc, 0xd5, 0x33, 0xa8, 0x0a, 0xa5, 0xbe, 0xed, 0xf6, 0x78, 0xcb,
	0xb9, 0x7a, 0x16, 0x95, 0xe1, 0xc0, 0xee, 0x74, 0x5c, 0x73, 0xe0, 0xea, 0xb9, 0xc6, 0x2b, 0xf5,
	0x7f, 0x13, 0x11, 0x44, 0x11, 0x72, 0x17, 0xb6, 0xd5, 0xd5, 0x35, 0x04, 0x50, 0x68, 0xdb, 0x57,
	0xe7, 0x17, 0xa6, 0x9e, 0xe1, 0x78, 0xde, 0xd8, 0x66, 0xd3, 0x92, 0xca, 0x3f, 0x9a, 0x2f, 0x5f,
	0xd8, 0x4e, 0x5b, 0xcf, 0x71, 0xfc, 0xc0, 0xbc, 0x1e, 0xe8, 0x79, 0x8e, 0x97, 0xbd, 0xab, 0x17,
	0xb8, 0x3b, 0xd9, 0x58, 0x3d, 0x6b, 0xa0, 0x1f, 0x34, 0x3e, 0x83, 0xd2, 0x72, 0xcf, 0x14, 0x21,
	0xd7, 0xb9, 0x12, 0x09, 0x16, 0x21, 0xd7, 0xb3, 0x5a, 0x8e, 0x9e, 0xf9, 0x5f, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xe6, 0x50, 0x1e, 0x93, 0x04, 0x13, 0x00, 0x00,
}
