/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.script.runtime.internal.engine;

import com.google.inject.Inject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.IResourceServiceProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.interpreter.IEvaluationContext;
import org.eclipse.xtext.xbase.interpreter.IEvaluationResult;
import org.eclipse.xtext.xbase.interpreter.IExpressionInterpreter;
import org.openhab.core.model.script.engine.Script;
import org.openhab.core.model.script.engine.ScriptExecutionException;

public class ScriptImpl
implements Script {
    private XExpression xExpression;

    @Inject
    public ScriptImpl() {
    }

    void setXExpression(XExpression xExpression) {
        this.xExpression = xExpression;
    }

    XExpression getXExpression() {
        return this.xExpression;
    }

    public Object execute() throws ScriptExecutionException {
        if (this.xExpression != null) {
            Resource resource = this.xExpression.eResource();
            IEvaluationContext evaluationContext = null;
            if (resource instanceof XtextResource) {
                XtextResource xtextResource = (XtextResource)resource;
                IResourceServiceProvider provider = xtextResource.getResourceServiceProvider();
                evaluationContext = (IEvaluationContext)provider.get(IEvaluationContext.class);
            }
            return this.execute(evaluationContext);
        }
        throw new ScriptExecutionException("Script does not contain any expression");
    }

    public Object execute(IEvaluationContext evaluationContext) throws ScriptExecutionException {
        if (this.xExpression != null) {
            IEvaluationResult result;
            block8: {
                Resource resource = this.xExpression.eResource();
                IExpressionInterpreter interpreter = null;
                if (resource instanceof XtextResource) {
                    XtextResource xtextResource = (XtextResource)resource;
                    IResourceServiceProvider provider = xtextResource.getResourceServiceProvider();
                    interpreter = (IExpressionInterpreter)provider.get(IExpressionInterpreter.class);
                }
                if (interpreter == null) {
                    throw new ScriptExecutionException("Script interpreter couldn't be obtained");
                }
                try {
                    result = interpreter.evaluate(this.xExpression, evaluationContext, CancelIndicator.NullImpl);
                    if (result != null) break block8;
                    return null;
                }
                catch (Throwable e) {
                    if (e instanceof ScriptExecutionException) {
                        ScriptExecutionException exception = (ScriptExecutionException)e;
                        throw exception;
                    }
                    throw new ScriptExecutionException("An error occurred during the script execution: " + e.getMessage(), e);
                }
            }
            if (result.getException() != null) {
                throw new ScriptExecutionException(result.getException().getMessage(), result.getException());
            }
            return result.getResult();
        }
        throw new ScriptExecutionException("Script does not contain any expression");
    }
}

