/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.navigator;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolder;
import org.jkiss.dbeaver.ui.controls.folders.ITabbedFolderContainer;
import org.jkiss.dbeaver.ui.editors.MultiPageAbstractEditor;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;

public class NavigatorPropertyTester
extends PropertyTester {
    public static final String NAMESPACE = "org.jkiss.dbeaver.core.navigator";
    public static final String PROP_ACTIVE = "active";
    public static final String PROP_FOCUSED = "focused";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        INavigatorModelView nmv = NavigatorPropertyTester.getActiveNavigator((IWorkbenchPart)receiver);
        return nmv != null && this.checkNavigatorProperty(nmv, property, expectedValue);
    }

    private boolean checkNavigatorProperty(INavigatorModelView rsv, String property, Object expectedValue) {
        switch (property) {
            case "active": {
                return true;
            }
            case "focused": {
                Viewer viewer = rsv.getNavigatorViewer();
                return viewer != null && viewer.getControl() != null && !viewer.getControl().isDisposed() && viewer.getControl().isFocusControl();
            }
        }
        return false;
    }

    public static INavigatorModelView getActiveNavigator(IWorkbenchPart activePart) {
        if (activePart == null) {
            return null;
        }
        if (activePart instanceof INavigatorModelView) {
            return (INavigatorModelView)activePart;
        }
        if (activePart instanceof MultiPageAbstractEditor) {
            return NavigatorPropertyTester.getActiveNavigator((IWorkbenchPart)((MultiPageAbstractEditor)activePart).getActiveEditor());
        }
        if (activePart instanceof ITabbedFolderContainer) {
            ITabbedFolder activeFolder = ((ITabbedFolderContainer)activePart).getActiveFolder();
            if (activeFolder instanceof INavigatorModelView) {
                return (INavigatorModelView)activeFolder;
            }
            if (activeFolder instanceof IWorkbenchPart) {
                return NavigatorPropertyTester.getActiveNavigator((IWorkbenchPart)activeFolder);
            }
        }
        return (INavigatorModelView)activePart.getAdapter(INavigatorModelView.class);
    }
}

