/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_fy extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "Arabysk";
        final String metaValue_ban = "Balineesk";
        final String metaValue_bax = "Bamoun";
        final String metaValue_zbl = "Blissymbolen";
        final String metaValue_bug = "Bugineesk";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Koptysk";
        final String metaValue_ka = "Georgysk";
        final String metaValue_got = "Gothysk";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebreeuwsk";
        final String metaValue_jv = "Javaansk";
        final String metaValue_ja = "Japans";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Koreaansk";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_la = "Latyn";
        final String metaValue_men = "Mende";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongools";
        final String metaValue_or = "Odia";
        final String metaValue_sd = "Sindhi";
        final String metaValue_su = "Soendaneesk";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_tl = "Tagalog";
        final String metaValue_th = "Thais";
        final String metaValue_bo = "Tibetaansk";
        final String metaValue_vai = "Vai";
        final String metaValue_peo = "Aldperzysk";
        final String metaValue_ssy = "Saho";
        final Object[][] data = new Object[][] {
            { "001", "Wrâld" },
            { "002", "Afrika" },
            { "003", "Noard-Amerika" },
            { "005", "Sûd-Amerika" },
            { "009", "Oceanië" },
            { "011", "West-Afrika" },
            { "013", "Midden-Amerika" },
            { "014", "East-Afrika" },
            { "015", "Noard-Afrika" },
            { "017", "Sintraal-Afrika" },
            { "018", "Sûdelijk Afrika" },
            { "019", "Amerika" },
            { "021", "Noardlik Amerika" },
            { "029", "Karibysk gebiet" },
            { "030", "East-Azië" },
            { "034", "Sûd-Azië" },
            { "035", "Sûdoost-Azië" },
            { "039", "Sûd-Europa" },
            { "053", "Australazië" },
            { "054", "Melanesië" },
            { "057", "Micronesyske regio" },
            { "061", "Polynesië" },
            { "142", "Azië" },
            { "143", "Sintraal-Azië" },
            { "145", "West-Azië" },
            { "150", "Europa" },
            { "151", "East-Europa" },
            { "154", "Noard-Europa" },
            { "155", "West-Europa" },
            { "419", "Latynsk-Amearika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "Verenigde Arabyske Emiraten" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua en Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanië" },
            { "AM", "Armenië" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentinië" },
            { "AS", "Amerikaansk Samoa" },
            { "AT", "Eastenryk" },
            { "AU", "Australië" },
            { "AW", "Aruba" },
            { "AX", "Ålân" },
            { "AZ", "Azerbeidzjan" },
            { "BA", "Bosnië en Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "België" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarije" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barthélemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karibysk Nederlân" },
            { "BR", "Brazilië" },
            { "BS", "Bahama’s" },
            { "BT", "Bhutan" },
            { "BV", "Bouveteilân" },
            { "BW", "Botswana" },
            { "BY", "Wit-Ruslân" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Kokosilanen" },
            { "CD", "Congo-Kinshasa" },
            { "CF", "Sintraal-Afrikaanske Republyk" },
            { "CG", "Congo-Brazzaville" },
            { "CH", "Switserlân" },
            { "CI", "Ivoorkust" },
            { "CK", "Cookeilannen" },
            { "CL", "Chili" },
            { "CM", "Kameroen" },
            { "CN", "Sina" },
            { "CO", "Kolombia" },
            { "CP", "Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Kaapverdië" },
            { "CW", "Curaçao" },
            { "CX", "Krysteilan" },
            { "CY", "Syprus" },
            { "CZ", "Tsjechje" },
            { "DE", "Dútslân" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Denemarken" },
            { "DM", "Dominika" },
            { "DO", "Dominikaanske Republyk" },
            { "DZ", "Algerije" },
            { "EA", "Ceuta en Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estlân" },
            { "EG", "Egypte" },
            { "EH", "Westelijke Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Spanje" },
            { "ET", "Ethiopië" },
            { "EU", "Europeeske Unie" },
            { "FI", "Finlân" },
            { "FJ", "Fiji" },
            { "FK", "Falklâneilannen" },
            { "FM", "Micronesië" },
            { "FO", "Faeröer" },
            { "FR", "Frankrijk" },
            { "GA", "Gabon" },
            { "GB", "Verenigd Koninkrijk" },
            { "GD", "Grenada" },
            { "GE", "Georgië" },
            { "GF", "Frans-Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Grienlân" },
            { "GM", "Gambia" },
            { "GN", "Guinee" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatoriaal-Guinea" },
            { "GR", "Grikelân" },
            { "GS", "Sûd-Georgia en Sûdlike Sandwicheilannen" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinee-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkong SAR van Sina" },
            { "HM", "Heard- en McDonaldeilannen" },
            { "HN", "Honduras" },
            { "HR", "Kroatië" },
            { "HT", "Haïti" },
            { "HU", "Hongarije" },
            { "IC", "Kanaryske Eilânnen" },
            { "ID", "Yndonesië" },
            { "IE", "Ierlân" },
            { "IL", "Israël" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Yslân" },
            { "IT", "Italië" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordanië" },
            { "JP", "Japan" },
            { "KE", "Kenia" },
            { "KG", "Kirgizië" },
            { "KH", "Cambodja" },
            { "KI", "Kiribati" },
            { "KM", "Comoren" },
            { "KN", "Saint Kitts en Nevis" },
            { "KP", "Noard-Korea" },
            { "KR", "Sûd-Korea" },
            { "KW", "Koeweit" },
            { "KY", "Caymaneilannen" },
            { "KZ", "Kazachstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litouwen" },
            { "LU", "Luxemburg" },
            { "LV", "Letlân" },
            { "LY", "Libië" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldavië" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "MG", "Madeiaskar" },
            { "MH", "Marshalleilannen" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birma)" },
            { "MN", "Mongolië" },
            { "MO", "Macao SAR van Sina" },
            { "MP", "Noardlike Marianeneilannen" },
            { "MQ", "Martinique" },
            { "MR", "Mauritanië" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldiven" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Maleisië" },
            { "MZ", "Mozambique" },
            { "NA", "Namibië" },
            { "NC", "Nij-Caledonië" },
            { "NE", "Niger" },
            { "NF", "Norfolkeilân" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Nederlân" },
            { "NO", "Noarwegen" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nij-Seelân" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Frans-Polynesië" },
            { "PG", "Papoea-Nij-Guinea" },
            { "PH", "Filipijnen" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "PM", "Saint-Pierre en Miquelon" },
            { "PN", "Pitcairneilannen" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestynske gebieten" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oerig Oceanië" },
            { "RE", "Réunion" },
            { "RO", "Roemenië" },
            { "RS", "Servië" },
            { "RU", "Ruslân" },
            { "RW", "Rwanda" },
            { "SA", "Saoedi-Arabië" },
            { "SB", "Salomonseilannen" },
            { "SC", "Seychellen" },
            { "SD", "Soedan" },
            { "SE", "Zweden" },
            { "SG", "Singapore" },
            { "SH", "Sint-Helena" },
            { "SI", "Slovenië" },
            { "SJ", "Spitsbergen en Jan Mayen" },
            { "SK", "Slowakije" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalië" },
            { "SR", "Suriname" },
            { "SS", "Sûd-Soedan" },
            { "ST", "Sao Tomé en Principe" },
            { "SV", "El Salvador" },
            { "SX", "Sint-Maarten" },
            { "SY", "Syrië" },
            { "SZ", "Swazilân" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- en Caicoseilannen" },
            { "TD", "Tsjaad" },
            { "TF", "Franse Gebieden in de zuidelijke Indyske Oseaan" },
            { "TG", "Togo" },
            { "TH", "Thailân" },
            { "TJ", "Tadzjikistan" },
            { "TK", "Tokelau" },
            { "TL", "East-Timor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunesië" },
            { "TO", "Tonga" },
            { "TR", "Turkije" },
            { "TT", "Trinidad en Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Oekraïne" },
            { "UG", "Oeganda" },
            { "UM", "Lyts ôflizzen eilannen fan de Ferienigde Staten" },
            { "US", "Ferienigde Staten" },
            { "UY", "Uruguay" },
            { "UZ", "Oezbekistan" },
            { "VA", "Vaticaanstêd" },
            { "VC", "Saint Vincent en de Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Britse Maagdeneilannen" },
            { "VI", "Amerikaanske Maagdeneilannen" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis en Futuna" },
            { "WS", "Samoa" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Sûd-Afrika" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Unbekend gebiet" },
            { "aa", "Afar" },
            { "ab", "Abchazysk" },
            { "ae", "Avestysk" },
            { "af", "Afrikaansk" },
            { "ak", "Akan" },
            { "am", "Amhaarsk" },
            { "an", "Aragoneesk" },
            { "ar", metaValue_ar },
            { "as", "Assameesk" },
            { "av", "Avarysk" },
            { "ay", "Aymara" },
            { "az", "Azerbeidzjaansk" },
            { "ba", "Basjkiersk" },
            { "be", "Wyt-Russysk" },
            { "bg", "Bulgaarsk" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", "Bengaalsk" },
            { "bo", metaValue_bo },
            { "br", "Bretonsk" },
            { "bs", "Bosnysk" },
            { "ca", "Katalaansk" },
            { "ce", "Tsjetsjeensk" },
            { "ch", "Chamorro" },
            { "co", "Korsikaansk" },
            { "cr", "Cree" },
            { "cs", "Tsjechysk" },
            { "cu", "Kerkslavysk" },
            { "cv", "Tsjoevasjysk" },
            { "cy", "Welsk" },
            { "da", "Deensk" },
            { "de", "Dútsk" },
            { "dv", "Divehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", "Gryks" },
            { "en", "Ingelsk" },
            { "eo", "Esperanto" },
            { "es", "Spaansk" },
            { "et", "Estlânsk" },
            { "eu", "Baskysk" },
            { "fa", "Perzysk" },
            { "ff", "Fulah" },
            { "fi", "Finsk" },
            { "fj", "Fijysk" },
            { "fo", "Faeröersk" },
            { "fr", "Frânsk" },
            { "fy", "Frysk" },
            { "ga", "Iersk" },
            { "gd", "Schotsk Gaelic" },
            { "gl", "Galisysk" },
            { "gn", "Guaraní" },
            { "gu", metaValue_gu },
            { "gv", "Manks" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "ho", "Hiri Motu" },
            { "hr", "Kroatysk" },
            { "ht", "Haïtiaansk" },
            { "hu", "Hongaarsk" },
            { "hy", "Armeensk" },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Yndonezysk" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "ik", "Inupiaq" },
            { "io", "Ido" },
            { "is", "Yslâns" },
            { "it", "Italiaansk" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "Kongo" },
            { "ki", "Kikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Kazachs" },
            { "kl", "Grienlâns" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kasjmiri" },
            { "ku", "Koerdysk" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kirgizysk" },
            { "la", metaValue_la },
            { "lb", "Luxemburgs" },
            { "lg", "Ganda" },
            { "li", "Limburgs" },
            { "ln", "Lingala" },
            { "lo", "Laotiaansk" },
            { "lt", "Litouws" },
            { "lu", "Luba-Katanga" },
            { "lv", "Letlâns" },
            { "mg", "Malagasysk" },
            { "mh", "Marshallees" },
            { "mi", "Maori" },
            { "mk", "Macedonysk" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Maleis" },
            { "mt", "Maltees" },
            { "my", "Birmees" },
            { "na", "Nauruaansk" },
            { "nb", "Noors - Bokmål" },
            { "nd", "Noard-Ndbele" },
            { "ne", "Nepalees" },
            { "ng", "Ndonga" },
            { "nl", "Nederlânsk" },
            { "nn", "Noors - Nynorsk" },
            { "no", "Noors" },
            { "nr", "Sûd-Ndbele" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Occitaansk" },
            { "oj", "Ojibwa" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Ossetysk" },
            { "pa", "Punjabi" },
            { "pi", "Pali" },
            { "pl", "Poalsk" },
            { "ps", "Pasjtoe" },
            { "pt", "Portugeesk" },
            { "qu", "Quechua" },
            { "rm", "Reto-Romaansk" },
            { "rn", "Kirundi" },
            { "ro", "Roemeensk" },
            { "ru", "Russysk" },
            { "rw", "Kinyarwanda" },
            { "sa", "Sanskriet" },
            { "sc", "Sardinysk" },
            { "sd", metaValue_sd },
            { "se", "Noard-Samysk" },
            { "sg", "Sango" },
            { "sh", "Servokroatysk" },
            { "si", "Singalees" },
            { "sk", "Slowaaks" },
            { "sl", "Sloveensk" },
            { "sm", "Samoaansk" },
            { "sn", "Shona" },
            { "so", "Somalysk" },
            { "sq", "Albaneesk" },
            { "sr", "Servysk" },
            { "ss", "Swazi" },
            { "st", "Sûd-Sotho" },
            { "su", metaValue_su },
            { "sv", "Zweeds" },
            { "sw", "Swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "Tadzjieks" },
            { "th", metaValue_th },
            { "ti", "Tigrinya" },
            { "tk", "Turkmeens" },
            { "tl", metaValue_tl },
            { "tn", "Tswana" },
            { "to", "Tongaansk" },
            { "tr", "Turks" },
            { "ts", "Tsonga" },
            { "tt", "Tataars" },
            { "tw", "Twi" },
            { "ty", "Tahitysk" },
            { "ug", "Oeigoers" },
            { "uk", "Oekraïens" },
            { "ur", "Urdu" },
            { "uz", "Oezbeeks" },
            { "ve", "Venda" },
            { "vi", "Vietnamees" },
            { "vo", "Volapük" },
            { "wa", "Waals" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Jiddysk" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", "Sineesk" },
            { "zu", "Zulu" },
            { "ace", "Atjeesk" },
            { "ach", "Akoli" },
            { "ada", "Adangme" },
            { "ady", "Adyghe" },
            { "afh", "Afrihili" },
            { "agq", "Aghem" },
            { "ain", "Ainu" },
            { "akk", "Akkadysk" },
            { "ale", "Aleut" },
            { "alt", "Sûd-Altaïsk" },
            { "ang", "âldingelsk" },
            { "anp", "Angika" },
            { "arc", "Arameesk" },
            { "arn", "Araukaansk" },
            { "arp", "Arapaho" },
            { "arw", "Arawak" },
            { "asa", "Asu" },
            { "ast", "Asturysk" },
            { "awa", "Awadhi" },
            { "bal", "Baloetsjysk" },
            { "ban", metaValue_ban },
            { "bas", "Basa" },
            { "bax", metaValue_bax },
            { "bbj", "Ghomala’" },
            { "bej", "Beja" },
            { "bem", "Bemba" },
            { "bez", "Bena" },
            { "bfd", "Bafut" },
            { "bho", "Bhojpuri" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "bkm", "Kom" },
            { "bla", "Siksika" },
            { "bra", "Braj" },
            { "brx", "Bodo" },
            { "bss", "Akoose" },
            { "bua", "Buriat" },
            { "bug", metaValue_bug },
            { "bum", "Bulu" },
            { "byn", "Blin" },
            { "byv", "Medumba" },
            { "cad", "Kaddo" },
            { "car", "Karibysk" },
            { "cay", "Cayuga" },
            { "cch", "Atsam" },
            { "ceb", "Cebuano" },
            { "cgg", "Chiga" },
            { "chb", "Chibcha" },
            { "chg", "Chagatai" },
            { "chk", "Chuukeesk" },
            { "chm", "Mari" },
            { "chn", "Chinook-jargon" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "Cheyenne" },
            { "ckb", "Soranî" },
            { "cop", metaValue_cop },
            { "crh", "Krim-Tataarsk" },
            { "csb", "Kasjoebysk" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "del", "Delaware" },
            { "den", "Slave" },
            { "dgr", "Dogrib" },
            { "din", "Dinka" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Nedersorbysk" },
            { "dua", "Duala" },
            { "dum", "Middelnederlânsk" },
            { "dyo", "Jola-Fonyi" },
            { "dyu", "Dyula" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "egy", "Aldegyptysk" },
            { "eka", "Ekajuk" },
            { "elx", "Elamitysk" },
            { "enm", "Middelingelsk" },
            { "ewo", "Ewondo" },
            { "fan", "Fang" },
            { "fat", "Fanti" },
            { "fil", "Filipynsk" },
            { "fon", "Fon" },
            { "frm", "Middelfrânsk" },
            { "fro", "Aldfrânsk" },
            { "frr", "Noard-Frysk" },
            { "frs", "East-Frysk" },
            { "fur", "Friulysk" },
            { "gaa", "Ga" },
            { "gay", "Gayo" },
            { "gba", "Gbaya" },
            { "gez", "Geez" },
            { "gil", "Gilberteesk" },
            { "gmh", "Middelheechdútsk" },
            { "goh", "Alsheechdútsk" },
            { "gon", "Gondi" },
            { "gor", "Gorontalo" },
            { "got", metaValue_got },
            { "grb", "Grebo" },
            { "grc", "Aldgryks" },
            { "gsw", "Switsers Dútsk" },
            { "guz", "Gusii" },
            { "gwi", "Gwichʼin" },
            { "hai", "Haida" },
            { "haw", "Hawaïaansk" },
            { "hil", "Hiligaynon" },
            { "hit", "Hettitysk" },
            { "hmn", "Hmong" },
            { "hsb", "Oppersorbysk" },
            { "hup", "Hupa" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ilo", "Iloko" },
            { "inh", "Ingoesj" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "jpr", "Judeo-Perzysk" },
            { "jrb", "Judeo-Arabysk" },
            { "kaa", "Karakalpaks" },
            { "kab", "Kabyle" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kaw", "Kawi" },
            { "kbd", "Kabardysk" },
            { "kbl", "Kanembu" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kaapverdysk Creools" },
            { "kfo", "Koro" },
            { "kha", "Khasi" },
            { "kho", "Khotaneesk" },
            { "khq", "Koyra Chiini" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "kok", "Konkani" },
            { "kos", "Kosraeaansk" },
            { "kpe", metaValue_kpe },
            { "krc", "Karachay-Balkar" },
            { "krl", "Karelysk" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
            { "ksh", "Kölsch" },
            { "kum", "Koemuks" },
            { "kut", "Kutenai" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lah", "Lahnda" },
            { "lam", "Lamba" },
            { "lez", "Lezgysk" },
            { "lkt", "Lakota" },
            { "lol", "Mongo" },
            { "loz", "Lozi" },
            { "lua", "Luba-Lulua" },
            { "lui", "Luiseno" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Lushai" },
            { "luy", "Luyia" },
            { "mad", "Madurees" },
            { "maf", "Mafa" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", "Makassaars" },
            { "man", "Mandingo" },
            { "mas", "Masai" },
            { "mde", "Maba" },
            { "mdf", "Moksha" },
            { "mdr", "Mandar" },
            { "men", metaValue_men },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mga", "Middeliers" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta’" },
            { "mic", "Mi’kmaq" },
            { "min", "Minangkabau" },
            { "mnc", "Mantsjoe" },
            { "mni", "Manipoeri" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mua", "Mundang" },
            { "mul", "Meardere talen" },
            { "mus", "Creek" },
            { "mwl", "Mirandees" },
            { "mwr", "Marwari" },
            { "mye", "Myene" },
            { "myv", "Erzja" },
            { "nap", "Napolitaansk" },
            { "naq", "Nama" },
            { "nds", "Laagduits" },
            { "new", "Newari" },
            { "nia", "Nias" },
            { "niu", "Niueaansk" },
            { "nmg", "Ngumba" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "non", "Aldnoarsk" },
            { "nqo", "N’ko" },
            { "nso", "Noard-Sotho" },
            { "nus", "Nuer" },
            { "nwc", "Klassiek Newari" },
            { "nym", "Nyamwezi" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima" },
            { "osa", "Osage" },
            { "ota", "Ottomaansk-Turks" },
            { "pag", "Pangasinan" },
            { "pal", "Pahlavi" },
            { "pam", "Pampanga" },
            { "pap", "Papiaments" },
            { "pau", "Palauaansk" },
            { "peo", metaValue_peo },
            { "phn", "Foenisysk" },
            { "pon", "Pohnpeiaansk" },
            { "pro", "Aldprovençaals" },
            { "raj", "Rajasthani" },
            { "rap", "Rapanui" },
            { "rar", "Rarotongan" },
            { "rof", "Rombo" },
            { "rom", "Romani" },
            { "rup", "Aromaniaansk" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Jakoets" },
            { "sam", "Samaritaansk-Arameesk" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Siciliaansk" },
            { "sco", "Schots" },
            { "see", "Seneca" },
            { "seh", "Sena" },
            { "sel", "Selkup" },
            { "ses", "Koyraboro Senni" },
            { "sga", "Aldyrsk" },
            { "shi", "Tashelhiyt" },
            { "shn", "Shan" },
            { "shu", "Tsjadysk Arabysk" },
            { "sid", "Sidamo" },
            { "sma", "Sûd-Samysk" },
            { "smj", "Lule Sami" },
            { "smn", "Inari Sami" },
            { "sms", "Skolt Sami" },
            { "snk", "Soninke" },
            { "sog", "Sogdysk" },
            { "srn", "Sranantongo" },
            { "srr", "Serer" },
            { "ssy", metaValue_ssy },
            { "suk", "Sukuma" },
            { "sus", "Soesoe" },
            { "sux", "Soemerysk" },
            { "swb", "Shimaore" },
            { "syc", "Klassiek Syrysk" },
            { "syr", "Syrysk" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "ter", "Tereno" },
            { "tet", "Tetun" },
            { "tig", "Tigre" },
            { "tiv", "Tiv" },
            { "tkl", "Tokelaus" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tmh", "Tamashek" },
            { "tog", "Nyasa Tonga" },
            { "tpi", "Tok Pisin" },
            { "trv", "Taroko" },
            { "tsi", "Tsimshian" },
            { "tum", "Toemboeka" },
            { "tvl", "Tuvaluaansk" },
            { "twq", "Tasawaq" },
            { "tyv", "Tuvinysk" },
            { "tzm", "Tamazight (Sintraal-Marokko)" },
            { "udm", "Oedmoerts" },
            { "uga", "Oegaritysk" },
            { "umb", "Umbundu" },
            { "und", "Onbekende taal" },
            { "vai", metaValue_vai },
            { "vot", "Votysk" },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wal", "Walamo" },
            { "war", "Waray" },
            { "was", "Washo" },
            { "xal", "Kalmyk" },
            { "xog", "Soga" },
            { "yao", "Yao" },
            { "yap", "Yapees" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yue", "Kantoneesk" },
            { "zap", "Zapotec" },
            { "zbl", metaValue_zbl },
            { "zen", "Zenaga" },
            { "zgh", "Standert Marokkaanske Tamazight" },
            { "zun", "Zuni" },
            { "zxx", "Gjin linguïstyske ynhâld" },
            { "zza", "Zaza" },
            { "Afak", "Defaka" },
            { "Arab", metaValue_ar },
            { "Armi", "Keizerlijk Aramees" },
            { "Armn", "Armeens" },
            { "Avst", "Avestaansk" },
            { "Bali", metaValue_ban },
            { "Bamu", metaValue_bax },
            { "Bass", "Bassa Vah" },
            { "Batk", "Batak" },
            { "Beng", "Bengalees" },
            { "Blis", metaValue_zbl },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "Buhid" },
            { "Cakm", "Chakma" },
            { "Cans", "Verenigde Canadese Aboriginal-symbolen" },
            { "Cari", "Karysk" },
            { "Cham", "Cham" },
            { "Cher", metaValue_chr },
            { "Cirt", "Cirth" },
            { "Copt", metaValue_cop },
            { "Cprt", "Syprysk" },
            { "Cyrl", "Syrillysk" },
            { "Cyrs", "Aldkerkslavysk Syrillysk" },
            { "Deva", "Devanagari" },
            { "Dsrt", "Deseret" },
            { "Dupl", "Duployan snelschrift" },
            { "Egyd", "Egyptysk demotysk" },
            { "Egyh", "Egyptysk hiëratysk" },
            { "Egyp", "Egyptyske hiërogliefen" },
            { "Ethi", "Ethiopysk" },
            { "Geok", "Georgysk Khutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "Glagolitysk" },
            { "Goth", metaValue_got },
            { "Gran", "Grantha" },
            { "Grek", "Grieks" },
            { "Gujr", metaValue_gu },
            { "Guru", "Gurmukhi" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hano", "Hanunoo" },
            { "Hans", "Ferienfâldigd" },
            { "Hant", "Traditjoneel" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hluw", "Anatolyske hiërogliefen" },
            { "Hmng", "Pahawh Hmong" },
            { "Hrkt", "Katakana of Hiragana" },
            { "Hung", "Aldhongaars" },
            { "Inds", "Indus" },
            { "Ital", "Ald-italysk" },
            { "Jamo", "Jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "Jurchen" },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Khar", "Kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "Khojki" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", metaValue_kpe },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", "Lao" },
            { "Latf", "Gotysk Latyn" },
            { "Latg", "Gaelysk Latyn" },
            { "Latn", metaValue_la },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Lineair A" },
            { "Linb", "Lineair B" },
            { "Lisu", "Fraser" },
            { "Loma", "Loma" },
            { "Lyci", "Lycysk" },
            { "Lydi", "Lydysk" },
            { "Mand", "Mandaeans" },
            { "Mani", "Manicheaansk" },
            { "Maya", "Mayahiërogliefen" },
            { "Mend", metaValue_men },
            { "Merc", "Meroitysk cursief" },
            { "Mero", "Meroïtysk" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "Moon" },
            { "Mroo", "Mro" },
            { "Mtei", "Meitei" },
            { "Mymr", "Myanmar" },
            { "Narb", "Ald Noard-Arabysk" },
            { "Nbat", "Nabateaansk" },
            { "Nkgb", "Naxi Geba" },
            { "Nkoo", "N’Ko" },
            { "Nshu", "Nüshu" },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Chiki" },
            { "Orkh", "Orkhon" },
            { "Orya", metaValue_or },
            { "Osma", "Osmanya" },
            { "Palm", "Palmyreens" },
            { "Perm", "Aldpermysk" },
            { "Phag", "Phags-pa" },
            { "Phli", "Inscriptioneel Pahlavi" },
            { "Phlp", "Psalmen Pahlavi" },
            { "Phlv", "Boek Pahlavi" },
            { "Phnx", "Foenicysk" },
            { "Plrd", "Pollard-fonetysk" },
            { "Prti", "Inscriptioneel Parthysk" },
            { "Rjng", "Rejang" },
            { "Roro", "Rongorongo" },
            { "Runr", "Runic" },
            { "Samr", "Samaritaansk" },
            { "Sara", "Sarati" },
            { "Sarb", "Ald Sûd-Arabysk" },
            { "Saur", "Saurashtra" },
            { "Sgnw", "SignWriting" },
            { "Shaw", "Shavian" },
            { "Shrd", "Sharada" },
            { "Sind", metaValue_sd },
            { "Sinh", "Sinhala" },
            { "Sora", "Sora Sompeng" },
            { "Sund", metaValue_su },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", "Syriac" },
            { "Syre", "Estrangelo Arameesk" },
            { "Syrj", "West-Arameesk" },
            { "Syrn", "East-Arameesk" },
            { "Tagb", "Tagbanwa" },
            { "Takr", "Takri" },
            { "Tale", "Tai Le" },
            { "Talu", "Nij Tai Lue" },
            { "Taml", metaValue_ta },
            { "Tang", "Tangut" },
            { "Tavt", "Tai Viet" },
            { "Telu", metaValue_te },
            { "Teng", "Tengwar" },
            { "Tfng", "Tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "Thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "Tirhuta" },
            { "Ugar", "Ugaritysk" },
            { "Vaii", metaValue_vai },
            { "Visp", "Sichtbere spraak" },
            { "Wara", "Varang Kshiti" },
            { "Wole", "Woleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "Sumero-Akkadian Cuneiform" },
            { "Yiii", "Yi" },
            { "Zinh", "Oergeërfd" },
            { "Zmth", "Wiskundige notatie" },
            { "Zsym", "Symbolen" },
            { "Zxxx", "Ongeschreven" },
            { "Zyyy", "Algemeen" },
            { "Zzzz", "Onbekend schriftsysteem" },
            { "de_AT", "Eastenryks Dútsk" },
            { "de_CH", "Switsersk Heechdútsk" },
            { "en_AU", "Australysk Ingelsk" },
            { "en_CA", "Kanadeesk Ingelsk" },
            { "en_GB", "Britsk Ingelsk" },
            { "en_US", "Amerikaansk Ingelsk" },
            { "es_ES", "Europeesk Spaansk" },
            { "es_MX", "Meksikaansk Spaansk" },
            { "fr_CA", "Kanadeesk Frânsk" },
            { "fr_CH", "Switserse Frânsk" },
            { "nl_BE", "Vlaams" },
            { "pt_BR", "Brazyljaansk Portugees" },
            { "pt_PT", "Europees Portugees" },
            { "ro_MD", "Moldavysk" },
            { "sw_CD", "Congo Swahili" },
            { "%%1901", "Tradisjonele Dútske stavering" },
            { "%%1994", "Standerdisearre Resiaansk stavering" },
            { "%%1996", "Dútske stavering van 1996" },
            { "ar_001", "Modern standert Arabysk" },
            { "es_419", "Latynsk-Amerikaansk Spaansk" },
            { "key.ca", "Kalender" },
            { "key.co", "Sortearfolgorde" },
            { "key.cu", "Valuta" },
            { "key.nu", "Sifers" },
            { "key.tz", "Tijdzone" },
            { "key.va", "Landvariant" },
            { "%%ALUKU", "Aloekoe dialekt" },
            { "%%BISKE", "San Giorgio/Bila-dialekt" },
            { "%%BOONT", "Boontling" },
            { "%%JAUER", "Jauer" },
            { "%%KKCOR", "Algemiene stavering" },
            { "%%KSCOR", "Standert stavering" },
            { "%%LIPAW", "Het Lipovaz-dialekt van het Resiaansk" },
            { "%%NEDIS", "Natisone-dialekt" },
            { "%%NJIVA", "Gniva/Njiva-dialekt" },
            { "%%NULIK", "Modern Volapük" },
            { "%%OSOJS", "Oseacco/Osojane-dialekt" },
            { "%%POSIX", "Computer" },
            { "%%PUTER", "Puter" },
            { "%%RIGIK", "Klassiek Volapük" },
            { "%%ROZAJ", "Resiaansk" },
            { "%%RUMGR", "Rumgr" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "Stolvizza/Solbica-dialekt" },
            { "%%UCCOR", "Ienfoarmige stavering" },
            { "zh_Hans", "Ferienfâldich Sineesk" },
            { "zh_Hant", "Tradisjoneel Sineesk" },
            { "%%DAJNKO", "Dajnko-alfabet" },
            { "%%FONIPA", "Internationaal Fonetysk Alfabet" },
            { "%%FONUPA", "Oeralysk Fonetysk Alfabet" },
            { "%%NDYUKA", "Ndyuka" },
            { "%%PAMAKA", "Pamaka" },
            { "%%PINYIN", "Pinyin" },
            { "%%SCOUSE", "Liverpools (Scouse)" },
            { "%%TARASK", "Taraskievica-stavering" },
            { "%%UCRCOR", "Ienfoarmige stavering (hersjoen)" },
            { "%%ULSTER", "Ulster" },
            { "%%ALALC97", "Romanisering ALA-LC, editie 1997" },
            { "%%AREVELA", "East-Armeensk" },
            { "%%AREVMDA", "West-Armeensk" },
            { "%%BAUDDHA", "Bauddha" },
            { "%%EMODENG", "Vroegmodern Engels" },
            { "%%HEPBURN", "Hepburn-romanisering" },
            { "%%ITIHASA", "Itihasa" },
            { "%%LAUKIKA", "Laukika" },
            { "%%MONOTON", "Monotonaal" },
            { "%%POLYTON", "Polytonaal" },
            { "%%REVISED", "Wizige stavering" },
            { "%%SURSILV", "Sursilvan" },
            { "%%SUTSILV", "Sutsilvan" },
            { "%%VAIDIKA", "Vaidika" },
            { "%%1606NICT", "Let Middelfrânske oant 1606" },
            { "%%1694ACAD", "Betiit modern Frâns" },
            { "%%1959ACAD", "Akademysk" },
            { "%%BAKU1926", "Eenvormig Turkse Latynse alfabet" },
            { "%%BISCAYAN", "Biskajaansk" },
            { "%%FONXSAMP", "Fonxsamp" },
            { "%%HOGNORSK", "Hoognoors" },
            { "%%JYUTPING", "Jyutping" },
            { "%%LUNA1918", "Luna1918" },
            { "%%PETR1708", "Petr1708" },
            { "%%SCOTLAND", "Schots standert-Engels" },
            { "%%SURMIRAN", "Surmiran" },
            { "%%VALENCIA", "Valenciaansk" },
            { "%%VALLADER", "Vallader" },
            { "%%WADEGILE", "Wade-Giles-romanisering" },
            { "type.ca.roc", "Kalinder fan de Sineeske Republyk" },
            { "type.m0.bgn", "BGN" },
            { "type.nu.arab", "Arabysk-Indyske sifers" },
            { "type.nu.armn", "Armeense sifers" },
            { "type.nu.bali", "Balinese sifers" },
            { "type.nu.beng", "Bengaalse sifers" },
            { "type.nu.deva", "Devanagari sifers" },
            { "type.nu.ethi", "Ethiopyske sifers" },
            { "type.nu.geor", "Georgyske sifers" },
            { "type.nu.grek", "Griekse sifers" },
            { "type.nu.gujr", "Gujarati sifers" },
            { "type.nu.guru", "Gurmukhi sifers" },
            { "type.nu.hans", "Ferienfâldigde Sineeske sifers" },
            { "type.nu.hant", "Traditjonele Sineeske sifers" },
            { "type.nu.hebr", "Hebreeuwse sifers" },
            { "type.nu.java", "Javaanske sifers" },
            { "type.nu.jpan", "Japanske sifers" },
            { "type.nu.khmr", "Khmer sifers" },
            { "type.nu.knda", "Kannada sifers" },
            { "type.nu.laoo", "Laotiaanske sifers" },
            { "type.nu.latn", "Westerse sifers" },
            { "type.nu.mlym", "Malayalam sifers" },
            { "type.nu.mong", "Mongoolse sifers" },
            { "type.nu.mymr", "Myanmarese sifers" },
            { "type.nu.orya", "Oriya sifers" },
            { "type.nu.taml", "Tradisjonele Tamil sifers" },
            { "type.nu.telu", "Telugu sifers" },
            { "type.nu.thai", "Thaise sifers" },
            { "type.nu.tibt", "Tibetaanske sifers" },
            { "type.nu.vaii", "Vai-sifers" },
            { "type.co.ducet", "Standert Unikoade-sortearfolgorde" },
            { "type.nu.roman", "Romeinske sifers" },
            { "type.ca.coptic", "Koptyske kalinder" },
            { "type.ca.hebrew", "Hebreeuwse kalinder" },
            { "type.ca.indian", "Indiase natjonale kalinder" },
            { "type.co.pinyin", "Pinyinvolgorde" },
            { "type.co.search", "Algemien sykje" },
            { "type.co.stroke", "Streeksortearfolgorde" },
            { "type.co.unihan", "Sortearfolgorde radicalen/strepen" },
            { "type.d0.fwidth", "Volledige breedte" },
            { "type.d0.hwidth", "Halve breedte" },
            { "type.m0.ungegn", "UNGEGN" },
            { "type.nu.native", "Binnenlânse sifers" },
            { "type.ca.chinese", "Sineeske kalinder" },
            { "type.ca.persian", "Perzyske kalinder" },
            { "type.d0.npinyin", "Numeriek" },
            { "type.nu.arabext", "Utwreide Arabysk-Indyske sifers" },
            { "type.nu.armnlow", "Kleine Armeense sifers" },
            { "type.nu.finance", "Finansjele sifers" },
            { "type.nu.greklow", "Kleine Griekse sifers" },
            { "type.nu.hanidec", "Sineeske desimale tallen" },
            { "type.nu.hansfin", "Ferienfâldigde Sineeske finansjele sifers" },
            { "type.nu.hantfin", "Traditjonele Sineeske finansjele sifers" },
            { "type.nu.jpanfin", "Japanske finansjele sifers" },
            { "type.nu.tamldec", "Tamil sifers" },
            { "type.ca.buddhist", "Boeddhistyske kalinder" },
            { "type.ca.ethiopic", "Ethiopyske kalinder" },
            { "type.ca.japanese", "Japanske kalinder" },
            { "type.co.phonetic", "Fonetyske sortearfolgorde" },
            { "type.co.reformed", "Hersjoen sortearfolgorde" },
            { "type.co.searchjl", "Sykje op earste Hangul-medeklinker" },
            { "type.co.standard", "standert sortearfolgorde" },
            { "type.nu.fullwide", "sifers met volledige breedte" },
            { "type.nu.romanlow", "Lytse Romeinske sifers" },
            { "type.ca.gregorian", "Gregoriaanske kalinder" },
            { "type.co.phonebook", "Telefoanboeksortearfolgorde" },
            { "type.co.dictionary", "Wurdboeksortearfolgorde" },
            { "type.co.traditional", "Tradisjonele sortearfolgorde" },
            { "type.nu.traditional", "Tradisjonele sifers" },
            { "type.ca.ethiopic-amete-alem", "Ethiopyske Amete Alem-kalinder" },
        };
        return data;
    }
}
