/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.effectiveConfiguration;

import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.FileKt;
import org.jetbrains.qodana.effectiveConfiguration.QdVirtualYamlFile;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\t\u0010\u0014\u001a\u00020\u0006H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/qodana/effectiveConfiguration/PhysicalFileImpl;", "Lorg/jetbrains/qodana/effectiveConfiguration/QdVirtualYamlFile;", "file", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "path", "", "getPath", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "reader", "Ljava/io/Reader;", "relativeFile", "toString", "configuration"})
final class PhysicalFileImpl
implements QdVirtualYamlFile {
    @NotNull
    private final Path file;
    @NotNull
    private final String path;

    public PhysicalFileImpl(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.file = file;
        this.path = ((Object)this.file).toString();
    }

    @Override
    @NotNull
    public String getPath() {
        return this.path;
    }

    @Override
    @NotNull
    public Reader reader() {
        Path path = this.file;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        return new InputStreamReader(Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset);
    }

    @Override
    @Nullable
    public QdVirtualYamlFile relativeFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path path2 = Paths.get(path, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
        Path resolved = FileKt.asAbsolutePathFrom(path2, this.file);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.isRegularFile(resolved, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            return null;
        }
        return new PhysicalFileImpl(resolved);
    }

    private final Path component1() {
        return this.file;
    }

    @NotNull
    public final PhysicalFileImpl copy(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new PhysicalFileImpl(file);
    }

    public static /* synthetic */ PhysicalFileImpl copy$default(PhysicalFileImpl physicalFileImpl, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            path = physicalFileImpl.file;
        }
        return physicalFileImpl.copy(path);
    }

    @NotNull
    public String toString() {
        return "PhysicalFileImpl(file=" + this.file + ")";
    }

    public int hashCode() {
        return ((Object)this.file).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof PhysicalFileImpl)) {
            return false;
        }
        PhysicalFileImpl physicalFileImpl = (PhysicalFileImpl)other;
        return Intrinsics.areEqual((Object)this.file, (Object)physicalFileImpl.file);
    }
}

