/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.SslEntityReader;
import com.intellij.openapi.util.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public final class SslUtil {
    public static final String SSL_CA_CERT_PATH = "sslCaCertPath";
    public static final String SSL_CLIENT_CERT_PATH = "sslClientCertPath";
    public static final String SSL_CLIENT_KEY_PATH = "sslClientKeyPath";
    public static final String SSL_TRUST_EVERYBODY = "sslTrustEverybody";
    public static final String SSL_USE_FACTORY = "sslUseFactory";
    private static final Map<String, Pair<Long, List<? extends SslEntityReader.Entity>>> entityCache = new ConcurrentHashMap<String, Pair<Long, List<? extends SslEntityReader.Entity>>>();

    @NotNull
    private static List<? extends SslEntityReader.Entity> readWithCache(@NotNull String path) throws IOException {
        if (path == null) {
            SslUtil.$$$reportNull$$$0(0);
        }
        File file = new File(path);
        long stamp = file.lastModified();
        Pair<Long, List<? extends SslEntityReader.Entity>> cached = entityCache.get(path);
        if (cached != null && ((Long)cached.first).equals(stamp)) {
            List list = (List)cached.second;
            if (list == null) {
                SslUtil.$$$reportNull$$$0(1);
            }
            return list;
        }
        FileInputStream stream = new FileInputStream(file);
        List<? extends SslEntityReader.Entity> res = SslEntityReader.getInstance().read(stream);
        entityCache.put(path, new Pair<Long, List<? extends SslEntityReader.Entity>>(stamp, res));
        List<? extends SslEntityReader.Entity> list = res;
        List<? extends SslEntityReader.Entity> list2 = list;
        if (list2 == null) {
            SslUtil.$$$reportNull$$$0(2);
        }
        return list2;
        finally {
            stream.close();
        }
    }

    @TestOnly
    public static void resetCache() {
        entityCache.clear();
    }

    @NotNull
    public static List<X509Certificate> loadCertificates(@NotNull String caCertPath) throws IOException, CertificateException {
        if (caCertPath == null) {
            SslUtil.$$$reportNull$$$0(3);
        }
        return SslUtil.loadCertificates(SslUtil.readWithCache(caCertPath));
    }

    @NotNull
    public static X509Certificate readCertificate(@NotNull String filePath) throws CertificateException, IOException {
        List<X509Certificate> certificates;
        if (filePath == null) {
            SslUtil.$$$reportNull$$$0(4);
        }
        if ((certificates = SslUtil.loadCertificates(filePath)).isEmpty()) {
            throw new IOException("Certificate not found");
        }
        X509Certificate x509Certificate = certificates.get(0);
        if (x509Certificate == null) {
            SslUtil.$$$reportNull$$$0(5);
        }
        return x509Certificate;
    }

    @NotNull
    public static PrivateKey readPrivateKey(@NotNull String filePath) throws IOException {
        if (filePath == null) {
            SslUtil.$$$reportNull$$$0(6);
        }
        return SslUtil.readPrivateKey(filePath, null);
    }

    @NotNull
    private static List<X509Certificate> loadCertificates(@NotNull List<? extends SslEntityReader.Entity> entities) throws IOException {
        if (entities == null) {
            SslUtil.$$$reportNull$$$0(7);
        }
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (SslEntityReader.Entity entity : entities) {
            if (!(entity instanceof SslEntityReader.CertificateEntity)) continue;
            certs.add(((SslEntityReader.CertificateEntity)entity).get());
        }
        ArrayList<X509Certificate> arrayList = certs;
        if (arrayList == null) {
            SslUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public static Pair<PrivateKey, List<X509Certificate>> readPrivateKeyAndCertificate(@NotNull String filePath, @Nullable char[] password) throws IOException {
        if (filePath == null) {
            SslUtil.$$$reportNull$$$0(9);
        }
        return SslUtil.loadPrivateKeyAndCerts(SslUtil.readWithCache(filePath), filePath, password);
    }

    @NotNull
    private static Pair<PrivateKey, List<X509Certificate>> loadPrivateKeyAndCerts(@NotNull List<? extends SslEntityReader.Entity> entities, @NotNull String filePath, char[] password) throws IOException {
        if (entities == null) {
            SslUtil.$$$reportNull$$$0(10);
        }
        if (filePath == null) {
            SslUtil.$$$reportNull$$$0(11);
        }
        PrivateKey key = null;
        ArrayList<X509Certificate> certs = new ArrayList<X509Certificate>();
        for (SslEntityReader.Entity entity : entities) {
            if (entity instanceof SslEntityReader.EncryptedPrivateKeyEntity) {
                key = ((SslEntityReader.EncryptedPrivateKeyEntity)entity).get(password);
                continue;
            }
            if (entity instanceof SslEntityReader.UnencryptedPrivateKeyEntity) {
                key = ((SslEntityReader.UnencryptedPrivateKeyEntity)entity).get();
                continue;
            }
            if (!(entity instanceof SslEntityReader.CertificateEntity)) continue;
            certs.add(((SslEntityReader.CertificateEntity)entity).get());
        }
        if (key == null) {
            throw new IOException("Failed to find key in file " + filePath);
        }
        Pair pair = Pair.create(key, certs.isEmpty() ? null : certs);
        if (pair == null) {
            SslUtil.$$$reportNull$$$0(12);
        }
        return pair;
    }

    @NotNull
    public static PrivateKey readPrivateKey(@NotNull String filePath, @Nullable char[] password) throws IOException {
        if (filePath == null) {
            SslUtil.$$$reportNull$$$0(13);
        }
        PrivateKey privateKey = (PrivateKey)SslUtil.readPrivateKeyAndCertificate((String)filePath, (char[])password).first;
        if (privateKey == null) {
            SslUtil.$$$reportNull$$$0(14);
        }
        return privateKey;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/rmi/ssl/SslUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caCertPath";
                break;
            }
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/rmi/ssl/SslUtil";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readWithCache";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readCertificate";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCertificates";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPrivateKeyAndCerts";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "readPrivateKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readWithCache";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 14: {
                break;
            }
            case 3: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadCertificates";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "readCertificate";
                break;
            }
            case 6: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readPrivateKey";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readPrivateKeyAndCertificate";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "loadPrivateKeyAndCerts";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class TrustEverybodyManager
    implements X509TrustManager {
        TrustEverybodyManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

