/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.pydev;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.python.PydevBundle;
import com.jetbrains.python.console.pydev.PydevCompletionVariant;
import com.jetbrains.python.debugger.ArrayChunk;
import com.jetbrains.python.debugger.IPyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebuggerException;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyReferringObjectsValue;
import com.jetbrains.python.debugger.PyThreadInfo;
import com.jetbrains.python.debugger.PyUserTypeRenderer;
import com.jetbrains.python.debugger.pydev.AbstractCommand;
import com.jetbrains.python.debugger.pydev.ExceptionBreakpointCommandFactory;
import com.jetbrains.python.debugger.pydev.ProcessDebugger;
import com.jetbrains.python.debugger.pydev.PyDebugCallback;
import com.jetbrains.python.debugger.pydev.RemoteDebugger;
import com.jetbrains.python.debugger.pydev.RemoteDebuggerCloseListener;
import com.jetbrains.python.debugger.pydev.ResumeOrStepCommand;
import com.jetbrains.python.debugger.pydev.dataviewer.DataViewerCommandBuilder;
import com.jetbrains.python.debugger.pydev.dataviewer.DataViewerCommandResult;
import com.jetbrains.python.tables.TableCommandParameters;
import com.jetbrains.python.tables.TableCommandType;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiProcessDebugger
implements ProcessDebugger {
    private static final Logger LOG = Logger.getInstance(MultiProcessDebugger.class);
    private final IPyDebugProcess myDebugProcess;
    private final ServerSocket myServerSocket;
    private final int myTimeoutInMillis;
    private final RemoteDebugger myMainDebugger;
    private final List<RemoteDebugger> myOtherDebuggers;
    @Deprecated(forRemoval=true)
    @Nullable
    private final ServerSocket myDebugServerSocket;
    private DebuggerProcessAcceptor myDebugProcessAcceptor;
    private final List<DebuggerProcessListener> myOtherDebuggerCloseListener;
    private final ThreadRegistry myThreadRegistry;

    @Deprecated
    public MultiProcessDebugger(@NotNull IPyDebugProcess debugProcess, @NotNull ServerSocket serverSocket, int timeoutInMillis, boolean useDispatcher) {
        ServerSocket debugServerSocket;
        if (debugProcess == null) {
            MultiProcessDebugger.$$$reportNull$$$0(0);
        }
        if (serverSocket == null) {
            MultiProcessDebugger.$$$reportNull$$$0(1);
        }
        this.myOtherDebuggers = new ArrayList<RemoteDebugger>();
        this.myOtherDebuggerCloseListener = new ArrayList<DebuggerProcessListener>();
        this.myThreadRegistry = new ThreadRegistry();
        this.myDebugProcess = debugProcess;
        this.myServerSocket = serverSocket;
        this.myTimeoutInMillis = timeoutInMillis;
        if (useDispatcher) {
            try {
                this.myDebugServerSocket = debugServerSocket = MultiProcessDebugger.createServerSocket();
            }
            catch (ExecutionException e) {
                throw new RuntimeException("Failed to start debugger", e);
            }
        } else {
            debugServerSocket = serverSocket;
            this.myDebugServerSocket = null;
        }
        this.myMainDebugger = new RemoteDebugger(this.myDebugProcess, debugServerSocket, this.myTimeoutInMillis);
    }

    @Override
    public boolean isConnected() {
        return this.myMainDebugger.isConnected();
    }

    @Override
    public void waitForConnect() throws Exception {
        if (this.myDebugServerSocket != null) {
            Socket socket = this.myServerSocket.accept();
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    MultiProcessDebugger.sendDebuggerPort(socket, this.myDebugServerSocket, this.myDebugProcess);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        this.myMainDebugger.waitForConnect();
        this.disposeAcceptor();
        this.myDebugProcessAcceptor = new DebuggerProcessAcceptor(this, this.myServerSocket);
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)this.myDebugProcessAcceptor);
    }

    @Deprecated(forRemoval=true)
    private static void sendDebuggerPort(@NotNull Socket socket, @NotNull ServerSocket serverSocket, @NotNull IPyDebugProcess processHandler) throws IOException {
        if (socket == null) {
            MultiProcessDebugger.$$$reportNull$$$0(2);
        }
        if (serverSocket == null) {
            MultiProcessDebugger.$$$reportNull$$$0(3);
        }
        if (processHandler == null) {
            MultiProcessDebugger.$$$reportNull$$$0(4);
        }
        int port = processHandler.handleDebugPort(serverSocket.getLocalPort());
        try (Socket socket2 = socket;
             PrintWriter writer = new PrintWriter(socket.getOutputStream());){
            writer.println("99\t-1\t" + port);
            writer.flush();
        }
    }

    @Deprecated(forRemoval=true)
    @NotNull
    private static ServerSocket createServerSocket() throws ExecutionException {
        ServerSocket serverSocket;
        try {
            serverSocket = new ServerSocket(0, 0, InetAddress.getLoopbackAddress());
        }
        catch (IOException e) {
            throw new ExecutionException(PydevBundle.message("pydev.error.message.failed.to.find.free.socket.port", new Object[0]), (Throwable)e);
        }
        ServerSocket serverSocket2 = serverSocket;
        if (serverSocket2 == null) {
            MultiProcessDebugger.$$$reportNull$$$0(5);
        }
        return serverSocket2;
    }

    @Deprecated(forRemoval=true)
    private boolean useDispatcher() {
        return this.myDebugServerSocket != null;
    }

    @Override
    public void close() {
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.close();
        }
        this.disposeAcceptor();
        if (!this.myServerSocket.isClosed()) {
            try {
                this.myServerSocket.close();
            }
            catch (IOException e) {
                LOG.warn("Error closing socket", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<RemoteDebugger> allDebuggers() {
        ArrayList result2 = Lists.newArrayList((Object[])new RemoteDebugger[]{this.myMainDebugger});
        List<RemoteDebugger> list = this.myOtherDebuggers;
        synchronized (list) {
            result2.addAll(this.myOtherDebuggers);
        }
        return result2;
    }

    @Override
    public void disconnect() {
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.disconnect();
        }
        this.disposeAcceptor();
    }

    private void disposeAcceptor() {
        if (this.myDebugProcessAcceptor != null) {
            this.myDebugProcessAcceptor.disconnect();
            this.myDebugProcessAcceptor = null;
        }
    }

    @Override
    public String handshake() throws PyDebuggerException {
        return this.myMainDebugger.handshake();
    }

    @Override
    public PyDebugValue evaluate(String threadId, String frameId, String expression, boolean execute2, int evaluationTimeout) throws PyDebuggerException {
        return this.debugger(threadId).evaluate(threadId, frameId, expression, execute2, evaluationTimeout);
    }

    @Override
    public PyDebugValue evaluate(String threadId, String frameId, String expression, boolean execute2, int evaluationTimeout, boolean trimResult) throws PyDebuggerException {
        return this.debugger(threadId).evaluate(threadId, frameId, expression, execute2, evaluationTimeout, trimResult);
    }

    @Override
    public void consoleExec(String threadId, String frameId, String expression, PyDebugCallback<String> callback) {
        this.debugger(threadId).consoleExec(threadId, frameId, expression, callback);
    }

    @Override
    public XValueChildrenList loadFrame(String threadId, String frameId, ProcessDebugger.GROUP_TYPE group_type) throws PyDebuggerException {
        return this.debugger(threadId).loadFrame(threadId, frameId, group_type);
    }

    @Override
    @Nullable
    public String execTableCommand(String threadId, String frameId, String command, TableCommandType commandType, TableCommandParameters tableCommandParameters) throws PyDebuggerException {
        return this.debugger(threadId).execTableCommand(threadId, frameId, command, commandType, tableCommandParameters);
    }

    @Override
    @Nullable
    public String execTableImageCommand(String threadId, String frameId, String command, TableCommandType commandType, TableCommandParameters tableCommandParameters) throws PyDebuggerException {
        return this.debugger(threadId).execTableImageCommand(threadId, frameId, command, commandType, tableCommandParameters);
    }

    @Override
    public List<Pair<String, Boolean>> getSmartStepIntoVariants(String threadId, String frameId, int startContextLine, int endContextLine) throws PyDebuggerException {
        return this.debugger(threadId).getSmartStepIntoVariants(threadId, frameId, startContextLine, endContextLine);
    }

    @Override
    public XValueChildrenList loadVariable(String threadId, String frameId, PyDebugValue var) throws PyDebuggerException {
        return this.debugger(threadId).loadVariable(threadId, frameId, var);
    }

    @Override
    public ArrayChunk loadArrayItems(String threadId, String frameId, PyDebugValue var, int rowOffset, int colOffset, int rows, int cols, String format) throws PyDebuggerException {
        return this.debugger(threadId).loadArrayItems(threadId, frameId, var, rowOffset, colOffset, rows, cols, format);
    }

    @Override
    @NotNull
    public DataViewerCommandResult executeDataViewerCommand(@NotNull DataViewerCommandBuilder builder) throws PyDebuggerException {
        if (builder == null) {
            MultiProcessDebugger.$$$reportNull$$$0(6);
        }
        assert (builder.getThreadId() != null);
        DataViewerCommandResult dataViewerCommandResult = this.debugger(builder.getThreadId()).executeDataViewerCommand(builder);
        if (dataViewerCommandResult == null) {
            MultiProcessDebugger.$$$reportNull$$$0(7);
        }
        return dataViewerCommandResult;
    }

    @Override
    public void loadReferrers(String threadId, String frameId, PyReferringObjectsValue var, PyDebugCallback<? super XValueChildrenList> callback) {
        this.debugger(threadId).loadReferrers(threadId, frameId, var, callback);
    }

    @NotNull
    private ProcessDebugger debugger(@NotNull String threadId) {
        RemoteDebugger debugger;
        if (threadId == null) {
            MultiProcessDebugger.$$$reportNull$$$0(8);
        }
        if ((debugger = this.myThreadRegistry.getDebugger(threadId)) != null) {
            RemoteDebugger remoteDebugger = debugger;
            if (remoteDebugger == null) {
                MultiProcessDebugger.$$$reportNull$$$0(9);
            }
            return remoteDebugger;
        }
        for (ProcessDebugger processDebugger : this.myOtherDebuggers) {
            for (PyThreadInfo thread : processDebugger.getThreads()) {
                if (!threadId.equals(thread.getId())) continue;
                ProcessDebugger processDebugger2 = processDebugger;
                if (processDebugger2 == null) {
                    MultiProcessDebugger.$$$reportNull$$$0(10);
                }
                return processDebugger2;
            }
        }
        RemoteDebugger remoteDebugger = this.myMainDebugger;
        if (remoteDebugger == null) {
            MultiProcessDebugger.$$$reportNull$$$0(11);
        }
        return remoteDebugger;
    }

    @Override
    public PyDebugValue changeVariable(String threadId, String frameId, PyDebugValue var, String value) throws PyDebuggerException {
        return this.debugger(threadId).changeVariable(threadId, frameId, var, value);
    }

    @Override
    public void loadFullVariableValues(@NotNull String threadId, @NotNull String frameId, @NotNull List<PyFrameAccessor.PyAsyncValue<String>> vars) throws PyDebuggerException {
        if (threadId == null) {
            MultiProcessDebugger.$$$reportNull$$$0(12);
        }
        if (frameId == null) {
            MultiProcessDebugger.$$$reportNull$$$0(13);
        }
        if (vars == null) {
            MultiProcessDebugger.$$$reportNull$$$0(14);
        }
        this.debugger(threadId).loadFullVariableValues(threadId, frameId, vars);
    }

    @Override
    public String loadSource(String path2) {
        return this.myMainDebugger.loadSource(path2);
    }

    @Override
    public Collection<PyThreadInfo> getThreads() {
        this.cleanOtherDebuggers();
        List<PyThreadInfo> threads = this.collectAllThreads();
        if (!this.myOtherDebuggers.isEmpty()) {
            return Collections.unmodifiableCollection(Collections2.transform(threads, t -> {
                if (t == null) {
                    return null;
                }
                String threadName = ThreadRegistry.threadName(t.getName(), t.getId());
                PyThreadInfo newThread = new PyThreadInfo(t.getId(), threadName, t.getFrames(), t.getStopReason(), t.getMessage());
                newThread.updateState(t.getState(), t.getFrames());
                return newThread;
            }));
        }
        return Collections.unmodifiableCollection(threads);
    }

    private List<PyThreadInfo> collectAllThreads() {
        ArrayList<PyThreadInfo> result2 = new ArrayList<PyThreadInfo>(this.myMainDebugger.getThreads());
        for (RemoteDebugger d : this.myOtherDebuggers) {
            result2.addAll(d.getThreads());
            for (PyThreadInfo t : d.getThreads()) {
                this.myThreadRegistry.register(t.getId(), d);
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOtherDebuggers() {
        List<RemoteDebugger> list = this.myOtherDebuggers;
        synchronized (list) {
            this.removeDisconnected(this.getOtherDebuggers());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeDisconnected(ArrayList<RemoteDebugger> debuggers) {
        boolean allConnected = true;
        for (RemoteDebugger d : debuggers) {
            if (d.isConnected()) continue;
            allConnected = false;
        }
        if (!allConnected) {
            ArrayList<RemoteDebugger> newList = new ArrayList<RemoteDebugger>();
            for (RemoteDebugger d : debuggers) {
                if (!d.isConnected()) continue;
                newList.add(d);
            }
            List<RemoteDebugger> list = this.myOtherDebuggers;
            synchronized (list) {
                this.myOtherDebuggers.clear();
                this.myOtherDebuggers.addAll(newList);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<RemoteDebugger> getOtherDebuggers() {
        List<RemoteDebugger> list = this.myOtherDebuggers;
        synchronized (list) {
            return Lists.newArrayList(this.myOtherDebuggers);
        }
    }

    @Override
    public void execute(@NotNull AbstractCommand command) {
        if (command == null) {
            MultiProcessDebugger.$$$reportNull$$$0(15);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.execute(command);
        }
    }

    @Override
    public void suspendAllThreads() {
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.suspendAllThreads();
        }
    }

    @Override
    public void suspendThread(String threadId) {
        this.debugger(threadId).suspendThread(threadId);
    }

    @Override
    public void run() throws PyDebuggerException {
        this.myMainDebugger.run();
    }

    @Override
    public void smartStepInto(String threadId, String frameId, String functionName, int callOrder, int contextStartLine, int contextEndLine) {
        this.debugger(threadId).smartStepInto(threadId, frameId, functionName, callOrder, contextStartLine, contextEndLine);
    }

    @Override
    public void resumeOrStep(String threadId, ResumeOrStepCommand.Mode mode) {
        this.debugger(threadId).resumeOrStep(threadId, mode);
    }

    @Override
    public void setNextStatement(@NotNull String threadId, @NotNull XSourcePosition sourcePosition, @Nullable String functionName, @NotNull PyDebugCallback<Pair<Boolean, String>> callback) {
        if (threadId == null) {
            MultiProcessDebugger.$$$reportNull$$$0(16);
        }
        if (sourcePosition == null) {
            MultiProcessDebugger.$$$reportNull$$$0(17);
        }
        if (callback == null) {
            MultiProcessDebugger.$$$reportNull$$$0(18);
        }
        this.debugger(threadId).setNextStatement(threadId, sourcePosition, functionName, callback);
    }

    @Override
    public void setTempBreakpoint(@NotNull String type2, @NotNull String file, int line) {
        if (type2 == null) {
            MultiProcessDebugger.$$$reportNull$$$0(19);
        }
        if (file == null) {
            MultiProcessDebugger.$$$reportNull$$$0(20);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.setTempBreakpoint(type2, file, line);
        }
    }

    @Override
    public void removeTempBreakpoint(@NotNull String file, int line) {
        if (file == null) {
            MultiProcessDebugger.$$$reportNull$$$0(21);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.removeTempBreakpoint(file, line);
        }
    }

    @Override
    public void setBreakpoint(@NotNull String typeId, @NotNull String file, int line, @Nullable String condition, @Nullable String logExpression, @Nullable String funcName, @NotNull SuspendPolicy policy) {
        if (typeId == null) {
            MultiProcessDebugger.$$$reportNull$$$0(22);
        }
        if (file == null) {
            MultiProcessDebugger.$$$reportNull$$$0(23);
        }
        if (policy == null) {
            MultiProcessDebugger.$$$reportNull$$$0(24);
        }
        for (ProcessDebugger processDebugger : this.allDebuggers()) {
            processDebugger.setBreakpoint(typeId, file, line, condition, logExpression, funcName, policy);
        }
    }

    @Override
    public void removeBreakpoint(@NotNull String typeId, @NotNull String file, int line) {
        if (typeId == null) {
            MultiProcessDebugger.$$$reportNull$$$0(25);
        }
        if (file == null) {
            MultiProcessDebugger.$$$reportNull$$$0(26);
        }
        this.allDebuggers().forEach(d -> d.removeBreakpoint(typeId, file, line));
    }

    @Override
    public void setUserTypeRenderers(@NotNull @NotNull List<@NotNull PyUserTypeRenderer> renderers) {
        if (renderers == null) {
            MultiProcessDebugger.$$$reportNull$$$0(27);
        }
        this.allDebuggers().forEach(d -> d.setUserTypeRenderers(renderers));
    }

    @Override
    public void setShowReturnValues(boolean isShowReturnValues) {
        this.allDebuggers().forEach(d -> d.setShowReturnValues(isShowReturnValues));
    }

    @Override
    public void setUnitTestDebuggingMode() {
        this.allDebuggers().forEach(d -> d.setUnitTestDebuggingMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addDebugger(RemoteDebugger debugger) {
        List<RemoteDebugger> list = this.myOtherDebuggers;
        synchronized (list) {
            this.myOtherDebuggers.add(debugger);
        }
    }

    @Override
    public void addCloseListener(RemoteDebuggerCloseListener listener2) {
        this.myMainDebugger.addCloseListener(listener2);
    }

    @Override
    public List<PydevCompletionVariant> getCompletions(String threadId, String frameId, String prefix) {
        return this.debugger(threadId).getCompletions(threadId, frameId, prefix);
    }

    @Override
    public String getDescription(String threadId, String frameId, String cmd) {
        return this.debugger(threadId).getDescription(threadId, frameId, cmd);
    }

    @Override
    public void addExceptionBreakpoint(ExceptionBreakpointCommandFactory factory) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.execute(factory.createAddCommand(d));
        }
    }

    @Override
    public void removeExceptionBreakpoint(ExceptionBreakpointCommandFactory factory) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.execute(factory.createRemoveCommand(d));
        }
    }

    @Override
    public void suspendOtherThreads(PyThreadInfo thread) {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.suspendOtherThreads(thread);
        }
    }

    public void addOtherDebuggerCloseListener(DebuggerProcessListener otherDebuggerCloseListener) {
        this.myOtherDebuggerCloseListener.add(otherDebuggerCloseListener);
    }

    @Override
    public void interruptDebugConsole() {
        for (RemoteDebugger d : this.allDebuggers()) {
            d.interruptDebugConsole();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 9, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "debugProcess";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverSocket";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socket";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/pydev/MultiProcessDebugger";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: 
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadId";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frameId";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vars";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourcePosition";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: 
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeId";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "policy";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/pydev/MultiProcessDebugger";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createServerSocket";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "executeDataViewerCommand";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "debugger";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "sendDebuggerPort";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "executeDataViewerCommand";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "debugger";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "loadFullVariableValues";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setNextStatement";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "setTempBreakpoint";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "removeTempBreakpoint";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setBreakpoint";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "removeBreakpoint";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "setUserTypeRenderers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 9, 10, 11 -> new IllegalStateException(string);
        };
    }

    private static class ThreadRegistry {
        private final Map<String, RemoteDebugger> myThreadIdToDebugger = Maps.newHashMap();

        private ThreadRegistry() {
        }

        public void register(String id, RemoteDebugger debugger) {
            this.myThreadIdToDebugger.put(id, debugger);
        }

        public RemoteDebugger getDebugger(String threadId) {
            return this.myThreadIdToDebugger.get(threadId);
        }

        public static String threadName(@NotNull String name2, @NotNull String id) {
            int indx;
            if (name2 == null) {
                ThreadRegistry.$$$reportNull$$$0(0);
            }
            if (id == null) {
                ThreadRegistry.$$$reportNull$$$0(1);
            }
            if ((indx = id.indexOf("_", id.indexOf("_") + 1)) != -1) {
                id = id.substring(0, indx);
            }
            return name2 + "(" + id + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "id";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/debugger/pydev/MultiProcessDebugger$ThreadRegistry";
            objectArray[2] = "threadName";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class DebuggerProcessAcceptor
    implements Runnable {
        private volatile boolean myShouldAccept;
        private final MultiProcessDebugger myMultiProcessDebugger;
        private ServerSocket myServerSocket;

        DebuggerProcessAcceptor(@NotNull MultiProcessDebugger multiProcessDebugger, @NotNull ServerSocket serverSocket) {
            if (multiProcessDebugger == null) {
                DebuggerProcessAcceptor.$$$reportNull$$$0(0);
            }
            if (serverSocket == null) {
                DebuggerProcessAcceptor.$$$reportNull$$$0(1);
            }
            this.myShouldAccept = true;
            this.myMultiProcessDebugger = multiProcessDebugger;
            this.myServerSocket = serverSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.myShouldAccept) {
                try {
                    ServerSocket serverSocketCopy = this.myServerSocket;
                    if (serverSocketCopy == null) break;
                    Socket socket = this.myMultiProcessDebugger.useDispatcher() ? serverSocketCopy.accept() : null;
                    try {
                        ServerSocket serverSocket = socket != null ? MultiProcessDebugger.createServerSocket() : serverSocketCopy;
                        RemoteDebugger debugger = new RemoteDebugger(this.myMultiProcessDebugger.myDebugProcess, serverSocket, this.myMultiProcessDebugger.myTimeoutInMillis);
                        this.addCloseListener(debugger);
                        if (socket != null) {
                            MultiProcessDebugger.sendDebuggerPort(socket, serverSocket, this.myMultiProcessDebugger.myDebugProcess);
                            socket.close();
                        }
                        try {
                            debugger.waitForConnect();
                        }
                        catch (SocketException e) {
                            LOG.info("Socket exception while waiting for debugger connection", (Throwable)e);
                            this.disconnect();
                            if (socket != null && !socket.isClosed()) {
                                socket.close();
                            }
                            return;
                        }
                        debugger.handshake();
                        this.myMultiProcessDebugger.addDebugger(debugger);
                        this.myMultiProcessDebugger.myDebugProcess.init();
                        debugger.run();
                    }
                    catch (Exception e) {
                        LOG.warn((Throwable)e);
                    }
                    finally {
                        if (socket == null || socket.isClosed()) continue;
                        socket.close();
                    }
                }
                catch (Exception ignore) {
                    if (this.myServerSocket != null) continue;
                    this.myShouldAccept = false;
                }
            }
        }

        private void addCloseListener(final @NotNull RemoteDebugger debugger) {
            if (debugger == null) {
                DebuggerProcessAcceptor.$$$reportNull$$$0(2);
            }
            debugger.addCloseListener(new RemoteDebuggerCloseListener(){

                @Override
                public void closed() {
                    this.notifyThreadsClosed(debugger);
                }

                @Override
                public void communicationError() {
                    this.notifyThreadsClosed(debugger);
                }

                @Override
                public void detached() {
                    this.notifyThreadsClosed(debugger);
                }
            });
        }

        private void notifyThreadsClosed(RemoteDebugger debugger) {
            for (DebuggerProcessListener l : this.myMultiProcessDebugger.myOtherDebuggerCloseListener) {
                l.threadsClosed(this.collectThreads(debugger));
            }
        }

        private Set<String> collectThreads(RemoteDebugger debugger) {
            HashSet<String> result2 = new HashSet<String>();
            for (Map.Entry<String, RemoteDebugger> entry : this.myMultiProcessDebugger.myThreadRegistry.myThreadIdToDebugger.entrySet()) {
                if (entry.getValue() != debugger) continue;
                result2.add(entry.getKey());
            }
            return result2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disconnect() {
            DebuggerProcessAcceptor debuggerProcessAcceptor = this;
            synchronized (debuggerProcessAcceptor) {
                this.myShouldAccept = false;
                if (this.myServerSocket != null) {
                    if (!this.myServerSocket.isClosed()) {
                        try {
                            this.myServerSocket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.myServerSocket = null;
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "multiProcessDebugger";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "serverSocket";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "debugger";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/debugger/pydev/MultiProcessDebugger$DebuggerProcessAcceptor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCloseListener";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface DebuggerProcessListener {
        public void threadsClosed(Set<String> var1);
    }
}

