/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.completion.full.line.impl.platform.request.pipeline;

import com.intellij.lang.Language;
import com.intellij.ml.inline.completion.impl.configuration.RedCodePolicy;
import com.intellij.ml.inline.completion.impl.postprocessing.MLCompletionPipelineProvider;
import com.intellij.ml.inline.completion.impl.postprocessing.analyzer.SequentialProposalsAnalyzer;
import com.intellij.ml.inline.completion.impl.postprocessing.filter.InsideCommentFilter;
import com.intellij.ml.inline.completion.impl.postprocessing.filter.NotValuableFilter;
import com.intellij.ml.inline.completion.impl.postprocessing.filter.ProposalFilter;
import com.intellij.ml.inline.completion.impl.relevance.FilterModelProcessing;
import com.intellij.ml.inline.completion.impl.relevance.FilterModelState;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.completion.full.line.request.FullLineRequest;
import org.jetbrains.completion.full.line.settings.FullLineSettings;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\u001e\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u001e\u0010\u001d\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/completion/full/line/impl/platform/request/pipeline/FullLinePipelineProvider;", "Lcom/intellij/ml/inline/completion/impl/postprocessing/MLCompletionPipelineProvider;", "request", "Lorg/jetbrains/completion/full/line/request/FullLineRequest;", "<init>", "(Lorg/jetbrains/completion/full/line/request/FullLineRequest;)V", "settingsSourceLanguage", "Lcom/intellij/lang/Language;", "getSettingsSourceLanguage", "()Lcom/intellij/lang/Language;", "maxSuggestionsForAnalysis", "", "getMaxSuggestionsForAnalysis", "()I", "redCodePolicy", "Lcom/intellij/ml/inline/completion/impl/configuration/RedCodePolicy;", "getRedCodePolicy", "()Lcom/intellij/ml/inline/completion/impl/configuration/RedCodePolicy;", "getAnalyzer", "Lcom/intellij/ml/inline/completion/impl/postprocessing/analyzer/SequentialProposalsAnalyzer;", "getFilterModelProcessing", "Lcom/intellij/ml/inline/completion/impl/relevance/FilterModelProcessing;", "patchHardFilters", "", "filters", "", "Lcom/intellij/ml/inline/completion/impl/postprocessing/filter/ProposalFilter;", "lastLine", "", "patchSoftFilters", "intellij.fullLine.core.impl"})
public final class FullLinePipelineProvider
extends MLCompletionPipelineProvider {
    @NotNull
    private final FullLineRequest request;

    public FullLinePipelineProvider(@NotNull FullLineRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        super(request);
        this.request = request;
    }

    private final Language getSettingsSourceLanguage() {
        return this.request.getSupporterHolder().getLanguage();
    }

    @Override
    protected int getMaxSuggestionsForAnalysis() {
        return FullLineSettings.Companion.getInstance().maxSuggestionsForAnalysis(this.getSettingsSourceLanguage());
    }

    @Override
    @NotNull
    protected RedCodePolicy getRedCodePolicy() {
        return FullLineSettings.Companion.getInstance().incorrectCodePolicy(this.getSettingsSourceLanguage());
    }

    @Override
    @NotNull
    protected SequentialProposalsAnalyzer getAnalyzer() {
        return new SequentialProposalsAnalyzer(this.request.getLanguageKit(), this.request.getParameters(), this.request.getSessionLogger(), this.getRedCodePolicy());
    }

    @Override
    @NotNull
    protected FilterModelProcessing getFilterModelProcessing() {
        return new FilterModelProcessing(this.request.getSupporterHolder().getSupporter(), this.request.getSessionLogger(), this.request.getLanguageKit().getLanguageSettings().getFilterModelState() != FilterModelState.Silent);
    }

    @Override
    protected void patchHardFilters(@NotNull List<ProposalFilter> filters2, @NotNull String lastLine) {
        Intrinsics.checkNotNullParameter(filters2, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)lastLine, (String)"lastLine");
        filters2.add(new InsideCommentFilter(this.request.getParameters()));
    }

    @Override
    protected void patchSoftFilters(@NotNull List<ProposalFilter> filters2, @NotNull String lastLine) {
        Intrinsics.checkNotNullParameter(filters2, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)lastLine, (String)"lastLine");
        filters2.add(new NotValuableFilter(this.request.getLanguageKit().getLanguageSettings().getMinLengthForNotValuableFilter()));
    }
}

