/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.intellij.codeWithMe.ClientId;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListAdapter;
import com.intellij.openapi.vcs.changes.ChangeListAvailabilityListener;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.ChangeListWorker;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsFreezingProcess;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CheckinHandlerFactory;
import com.intellij.openapi.vcs.ex.ChangelistsLocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.LineStatusTracker;
import com.intellij.openapi.vcs.ex.LineStatusTrackerListener;
import com.intellij.openapi.vcs.ex.LocalLineStatusTracker;
import com.intellij.openapi.vcs.ex.LocalLineStatusTrackerImpl;
import com.intellij.openapi.vcs.ex.SimpleLocalLineStatusTracker;
import com.intellij.openapi.vcs.impl.ActiveChangeListTracker;
import com.intellij.openapi.vcs.impl.BaseRevisionStatusTrackerContentLoader;
import com.intellij.openapi.vcs.impl.ChangelistsLocalStatusTrackerProvider;
import com.intellij.openapi.vcs.impl.DefaultLocalStatusTrackerProvider;
import com.intellij.openapi.vcs.impl.LineStatusTrackerContentLoader;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManager;
import com.intellij.openapi.vcs.impl.LineStatusTrackerManagerI;
import com.intellij.openapi.vcs.impl.LineStatusTrackerSettingListener;
import com.intellij.openapi.vcs.impl.LocalLineStatusTrackerProvider;
import com.intellij.openapi.vcs.impl.PartialLineStatusTrackerManagerState;
import com.intellij.openapi.vcs.impl.Result;
import com.intellij.openapi.vcs.impl.SingleThreadLoader;
import com.intellij.openapi.vcs.impl.VcsBaseContentProvider;
import com.intellij.openapi.vcs.impl.VcsBaseContentProviderListener;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.impl.VcsStartupActivity;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.util.SlowOperations;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.commit.AbstractCommitWorkflowHandlerKt;
import com.intellij.vcsUtil.VcsUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\"\u0018\u0000 `2\u00020\u00012\u00020\u0002:\u0017`abcdefghijklmnopqrstuvB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0016J\u0016\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u000fH\u0016J\u0016\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\"2\u0006\u0010$\u001a\u00020\u0019H\u0016J\u0018\u0010%\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\nH\u0017J\u0018\u0010'\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\nH\u0017J\u000e\u0010(\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u000fJ\u0014\u0010)\u001a\u00020\u001f2\n\u0010*\u001a\u00060+j\u0002`,H\u0016J\u0010\u0010-\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0.J\u0016\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u0002012\u0006\u00102\u001a\u00020\u0002J\u0010\u00103\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u000fH\u0003J\b\u00104\u001a\u00020\u001fH\u0003J\u0010\u00105\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\u0019H\u0003J\u0010\u00107\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u0010H\u0002J\u001a\u00109\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u00102\b\b\u0002\u0010:\u001a\u00020\fH\u0002J\u0010\u0010;\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u0010H\u0002J\u0018\u0010<\u001a\u00020\f2\u0006\u00106\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u000fH\u0002J\b\u0010=\u001a\u00020\fH\u0016J\u0010\u0010=\u001a\u00020\f2\u0006\u00106\u001a\u00020\u0019H\u0016J\"\u0010>\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u000f2\b\b\u0002\u0010?\u001a\u00020\fH\u0002J&\u0010@\u001a\b\u0012\u0002\b\u0003\u0018\u00010A2\u0006\u00106\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010B\u001a\u00020CH\u0002J\u001a\u0010D\u001a\u0004\u0018\u00010C2\u0006\u00106\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u000fH\u0002J\u001a\u0010E\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u000f2\b\b\u0002\u0010:\u001a\u00020\fH\u0003J\b\u0010F\u001a\u00020\u001fH\u0002J\b\u0010G\u001a\u00020\u001fH\u0002J\b\u0010H\u001a\u00020IH\u0002J\u001c\u0010J\u001a\u00020\u001f2\n\u0010K\u001a\u0006\u0012\u0002\b\u00030A2\u0006\u0010B\u001a\u00020CH\u0003J\u0018\u0010L\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010M\u001a\u00020NH\u0007J\u001c\u0010O\u001a\u00020\u001f2\b\b\u0001\u0010P\u001a\u00020Q2\b\u0010$\u001a\u0004\u0018\u00010\u0019H\u0002J\u001c\u0010R\u001a\u00020\u001f2\b\b\u0001\u0010P\u001a\u00020Q2\b\u0010#\u001a\u0004\u0018\u00010\u000fH\u0002J\u001c\u0010R\u001a\u00020\u001f2\b\b\u0001\u0010P\u001a\u00020Q2\b\u0010$\u001a\u0004\u0018\u00010\u0019H\u0002J\b\u0010S\u001a\u00020\u001fH\u0007J\u0013\u0010T\u001a\b\u0012\u0004\u0012\u00020U0.H\u0000\u00a2\u0006\u0002\bVJ\u001b\u0010W\u001a\u00020\u001f2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020\u001b0.H\u0001\u00a2\u0006\u0002\bYJ\u0015\u0010Z\u001a\u00020\u001f2\u0006\u00106\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b[J\b\u0010\\\u001a\u00020\u001fH\u0002J\b\u0010]\u001a\u00020\u001fH\u0003J\b\u0010^\u001a\u00020\u001fH\u0007J\b\u0010_\u001a\u00020\u001fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u00120\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u001b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001c\u001a\u00060\u001dR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006w"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManagerI;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "LOCK", "", "isDisposed", "", "trackers", "Ljava/util/HashMap;", "Lcom/intellij/openapi/editor/Document;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "forcedDocuments", "Lcom/google/common/collect/Multiset;", "partialChangeListsEnabled", "documentsInDefaultChangeList", "Ljava/util/HashSet;", "clmFreezeCounter", "", "filesWithDamagedInactiveRanges", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileStatesAwaitingRefresh", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$State;", "loader", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyBaseRevisionLoader;", "startListenForEditors", "", "dispose", "getLineStatusTracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "document", "file", "requestTrackerFor", "requester", "releaseTrackerFor", "hasPendingUpdate", "invokeAfterUpdate", "task", "Ljava/lang/Runnable;", "Lkotlinx/coroutines/Runnable;", "getTrackers", "", "addTrackerListener", "listener", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "disposable", "checkIfTrackerCanBeReleased", "onEverythingChanged", "onFileChanged", "virtualFile", "registerTrackerInCLM", "data", "unregisterTrackerInCLM", "wasUnbound", "reregisterTrackerInCLM", "canCreateTrackerFor", "arePartialChangelistsEnabled", "switchTracker", "refreshExisting", "installTracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "provider", "Lcom/intellij/openapi/vcs/impl/LocalLineStatusTrackerProvider;", "getTrackerProvider", "releaseTracker", "updatePartialChangeListsAvailability", "updateTrackingSettings", "getTrackingMode", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker$Mode;", "refreshTracker", "tracker", "offerTrackerContent", "text", "", "log", "message", "", "warn", "resetExcludedFromCommitMarkers", "collectPartiallyChangedFilesStates", "Lcom/intellij/openapi/vcs/ex/ChangelistsLocalLineStatusTracker$FullState;", "collectPartiallyChangedFilesStates$intellij_platform_vcs_impl", "restoreTrackersForPartiallyChangedFiles", "trackerStates", "restoreTrackersForPartiallyChangedFiles$intellij_platform_vcs_impl", "notifyInactiveRangesDamaged", "notifyInactiveRangesDamaged$intellij_platform_vcs_impl", "showInactiveRangesDamagedNotification", "expireInactiveRangesDamagedNotifications", "waitUntilBaseContentsLoaded", "releaseAllTrackers", "Companion", "MyStartupActivity", "ListenerAdapter", "Listener", "MyBaseRevisionLoader", "MyFileStatusListener", "BaseContentProviderListener", "MyEditorFactoryListener", "MyVirtualFileListener", "MyFileDocumentManagerListener", "MyDocumentListener", "MyTrackerStateListener", "MyApplicationListener", "MyLineStatusTrackerSettingListener", "MyChangeListListener", "MyChangeListAvailabilityListener", "MyCommandListener", "CheckinFactory", "MyFreezeListener", "TrackerData", "RefreshRequest", "RefreshData", "InactiveRangesDamagedNotification", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nLineStatusTrackerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,1530:1\n1563#2:1531\n1634#2,3:1532\n12637#3,2:1535\n2353#3,5:1538\n13472#3,2:1543\n13472#3,2:1545\n1#4:1537\n14#5:1547\n*S KotlinDebug\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager\n*L\n235#1:1531\n235#1:1532,3\n403#1:1535,2\n1116#1:1538,5\n1119#1:1543,2\n1133#1:1545,2\n102#1:1547\n*E\n"})
public final class LineStatusTrackerManager
implements LineStatusTrackerManagerI,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Object LOCK;
    private boolean isDisposed;
    @NotNull
    private final HashMap<Document, TrackerData> trackers;
    @NotNull
    private final HashMap<Document, Multiset<Object>> forcedDocuments;
    private boolean partialChangeListsEnabled;
    @NotNull
    private final HashSet<Document> documentsInDefaultChangeList;
    private int clmFreezeCounter;
    @NotNull
    private final HashSet<VirtualFile> filesWithDamagedInactiveRanges;
    @NotNull
    private final HashMap<VirtualFile, ChangelistsLocalLineStatusTracker.State> fileStatesAwaitingRefresh;
    @NotNull
    private final MyBaseRevisionLoader loader;
    @NotNull
    private static final Logger LOG;
    @Topic.ProjectLevel
    @NotNull
    private static final Topic<Listener> TOPIC;

    public LineStatusTrackerManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.coroutineScope = coroutineScope;
        this.LOCK = new Object();
        this.trackers = new HashMap();
        this.forcedDocuments = new HashMap();
        this.documentsInDefaultChangeList = new HashSet();
        this.filesWithDamagedInactiveRanges = new HashSet();
        this.fileStatesAwaitingRefresh = new HashMap();
        this.loader = new MyBaseRevisionLoader();
    }

    private final void startListenForEditors() {
        SimpleMessageBusConnection connection = this.project.getMessageBus().connect(this.coroutineScope);
        Topic topic = LineStatusTrackerSettingListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new MyLineStatusTrackerSettingListener());
        connection.subscribe(VcsFreezingProcess.Listener.TOPIC, (Object)new MyFreezeListener());
        Topic topic2 = CommandListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        connection.subscribe(topic2, (Object)new MyCommandListener());
        Topic topic3 = ChangeListListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic3, (String)"TOPIC");
        connection.subscribe(topic3, (Object)new MyChangeListListener());
        Topic topic4 = ChangeListAvailabilityListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic4, (String)"TOPIC");
        connection.subscribe(topic4, (Object)new MyChangeListAvailabilityListener());
        Topic topic5 = FileStatusListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic5, (String)"TOPIC");
        connection.subscribe(topic5, (Object)new MyFileStatusListener());
        Topic<VcsBaseContentProviderListener> topic6 = VcsBaseContentProviderListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic6, (String)"TOPIC");
        connection.subscribe(topic6, (Object)new BaseContentProviderListener());
        SimpleMessageBusConnection simpleMessageBusConnection = ApplicationManager.getApplication().getMessageBus().connect(this.coroutineScope);
        Topic topic7 = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic7, (String)"VFS_CHANGES");
        simpleMessageBusConnection.subscribe(topic7, (Object)new MyVirtualFileListener());
        LocalLineStatusTrackerProvider.Companion.getEP_NAME$intellij_platform_vcs_impl().addChangeListener(() -> LineStatusTrackerManager.startListenForEditors$lambda$0(this), (Disposable)this);
        VcsBaseContentProvider.EP_NAME.addChangeListener((AreaInstance)this.project, () -> LineStatusTrackerManager.startListenForEditors$lambda$1(this), (Disposable)this);
        this.updatePartialChangeListsAvailability();
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ LineStatusTrackerManager this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        ApplicationManager.getApplication().addApplicationListener((ApplicationListener)this.this$0.new MyApplicationListener(), (Disposable)this.this$0);
                        EditorFactory.getInstance().getEventMulticaster().addDocumentListener((DocumentListener)this.this$0.new MyDocumentListener(), (Disposable)this.this$0);
                        this.label = 1;
                        v0 = CoroutinesKt.writeIntentReadAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.openapi.vcs.impl.LineStatusTrackerManager ), ()Lkotlin/Unit;)((LineStatusTrackerManager)this.this$0), (Continuation)((Continuation)this));
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        PartialLineStatusTrackerManagerState.Companion.restoreState$intellij_platform_vcs_impl(LineStatusTrackerManager.access$getProject$p(this.this$0));
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(LineStatusTrackerManager this$0) {
                this$0.new MyEditorFactoryListener().install(this$0);
                LineStatusTrackerManager.access$onEverythingChanged(this$0);
                return Unit.INSTANCE;
            }
        }), (int)2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.isDisposed = true;
        Disposer.dispose((Disposable)this.loader);
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            for (Map.Entry entry : ((Map)this.forcedDocuments).entrySet()) {
                Document document = (Document)entry.getKey();
                Multiset multiset = (Multiset)entry.getValue();
                for (Object requester : multiset.elementSet()) {
                    this.warn("Tracker is being held on dispose by " + requester, document);
                }
            }
            this.forcedDocuments.clear();
            for (Object object2 : this.trackers.values()) {
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"next(...)");
                TrackerData data = (TrackerData)object2;
                LineStatusTrackerManager.unregisterTrackerInCLM$default(this, data, false, 2, null);
                data.getTracker().release();
            }
            this.trackers.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public LineStatusTracker<?> getLineStatusTracker(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            TrackerData trackerData = this.trackers.get(document);
            LineStatusTracker lineStatusTracker = trackerData != null ? trackerData.getTracker() : null;
            return lineStatusTracker;
        }
    }

    @Override
    @Nullable
    public LineStatusTracker<?> getLineStatusTracker(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        return this.getLineStatusTracker(document2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresEdt
    public void requestTrackerFor(@NotNull Document document, @NotNull Object requester) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            if (this.isDisposed) {
                this.warn("Tracker is being requested after dispose by " + requester, document);
                return;
            }
            Multiset multiset = this.forcedDocuments.computeIfAbsent(document, arg_0 -> LineStatusTrackerManager.requestTrackerFor$lambda$6$lambda$5(LineStatusTrackerManager::requestTrackerFor$lambda$6$lambda$4, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)multiset, (String)"computeIfAbsent(...)");
            Multiset multiset2 = multiset;
            multiset2.add(requester);
            if (this.trackers.get(document) == null) {
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
                if (virtualFile == null) {
                    return;
                }
                VirtualFile virtualFile2 = virtualFile;
                LineStatusTrackerManager.switchTracker$default(this, virtualFile2, document, false, 4, null);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @RequiresEdt
    public void releaseTrackerFor(@NotNull Document document, @NotNull Object requester) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)requester, (String)"requester");
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            Multiset<Object> multiset = this.forcedDocuments.get(document);
            if (multiset == null || !multiset.contains(requester)) {
                this.warn("Tracker release underflow by " + requester, document);
                return;
            }
            multiset.remove(requester);
            if (multiset.isEmpty()) {
                this.forcedDocuments.remove(document);
                this.checkIfTrackerCanBeReleased(document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean hasPendingUpdate(@NotNull Document document) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return this.loader.hasRequestFor(document);
    }

    @Override
    public void invokeAfterUpdate(@NotNull Runnable task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        this.loader.addAfterUpdateRunnable(task2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<LineStatusTracker<?>> getTrackers() {
        Object object = this.LOCK;
        synchronized (object) {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Collection<TrackerData> collection = this.trackers.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$map$iv = collection;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                TrackerData trackerData = (TrackerData)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl2 = false;
                collection2.add(it.getTracker());
            }
            List list = (List)destination$iv$iv;
            return list;
        }
    }

    public final void addTrackerListener(@NotNull Listener listener2, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        this.project.getMessageBus().connect(disposable).subscribe(TOPIC, (Object)listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private final void checkIfTrackerCanBeReleased(Document document) {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            TrackerData trackerData = this.trackers.get(document);
            if (trackerData == null) {
                return;
            }
            TrackerData data = trackerData;
            if (this.forcedDocuments.containsKey(document)) {
                return;
            }
            if (data.getTracker() instanceof ChangelistsLocalLineStatusTracker) {
                boolean hasPartialChanges = ((ChangelistsLocalLineStatusTracker)data.getTracker()).hasPartialState$intellij_platform_vcs_impl();
                if (hasPartialChanges) {
                    this.log("checkIfTrackerCanBeReleased - hasPartialChanges", ((ChangelistsLocalLineStatusTracker)data.getTracker()).getVirtualFile());
                    return;
                }
                boolean isLoading = this.loader.hasRequestFor(document);
                if (isLoading) {
                    this.log("checkIfTrackerCanBeReleased - isLoading", ((ChangelistsLocalLineStatusTracker)data.getTracker()).getVirtualFile());
                    if (((ChangelistsLocalLineStatusTracker)data.getTracker()).hasPendingPartialState$intellij_platform_vcs_impl() || this.fileStatesAwaitingRefresh.containsKey(((ChangelistsLocalLineStatusTracker)data.getTracker()).getVirtualFile())) {
                        this.log("checkIfTrackerCanBeReleased - has pending state", ((ChangelistsLocalLineStatusTracker)data.getTracker()).getVirtualFile());
                        return;
                    }
                }
            }
            if (data.getTracker() instanceof SimpleLocalLineStatusTracker) {
                ((SimpleLocalLineStatusTracker)data.getTracker()).hasPartialState();
                return;
            }
            LineStatusTrackerManager.releaseTracker$default(this, document, false, 2, null);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private final void onEverythingChanged() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            if (this.isDisposed) {
                return;
            }
            this.log("onEverythingChanged", null);
            HashSet<VirtualFile> files = new HashSet<VirtualFile>();
            Iterator<TrackerData> iterator = this.trackers.values().iterator();
            while (iterator.hasNext()) {
                TrackerData data;
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                files.add(data.getTracker().getVirtualFile());
            }
            for (TrackerData trackerData : this.forcedDocuments.keySet()) {
                Intrinsics.checkNotNullExpressionValue((Object)trackerData, (String)"next(...)");
                Document document = (Document)trackerData;
                VirtualFile file = FileDocumentManager.getInstance().getFile(document);
                if (file == null) continue;
                files.add(file);
            }
            Iterator iterator2 = files.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            iterator = iterator2;
            while (iterator.hasNext()) {
                VirtualFile file = (VirtualFile)iterator.next();
                this.onFileChanged(file);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    private final void onFileChanged(VirtualFile virtualFile) {
        Document document = FileDocumentManager.getInstance().getCachedDocument(virtualFile);
        if (document == null) {
            return;
        }
        Document document2 = document;
        Object object = this.LOCK;
        synchronized (object) {
            LocalLineStatusTracker<?> tracker;
            boolean bl = false;
            if (this.isDisposed) {
                return;
            }
            this.log("onFileChanged", virtualFile);
            TrackerData trackerData = this.trackers.get(document2);
            LocalLineStatusTracker<Object> localLineStatusTracker = tracker = trackerData != null ? trackerData.getTracker() : null;
            if (tracker != null || this.forcedDocuments.containsKey(document2)) {
                this.switchTracker(virtualFile, document2, true);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void registerTrackerInCLM(TrackerData data) {
        LocalLineStatusTracker<?> tracker = data.getTracker();
        VirtualFile virtualFile = tracker.getVirtualFile();
        if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) {
            return;
        }
        LOG.assertTrue(virtualFile.isInLocalFileSystem(), (Object)virtualFile);
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        FilePath filePath2 = filePath;
        if (data.getClmFilePath() != null) {
            LOG.error("[registerTrackerInCLM] tracker already registered");
            return;
        }
        ChangeListManagerImpl.getInstanceImpl(this.project).registerChangeTracker(filePath2, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
        data.setClmFilePath(filePath2);
    }

    private final void unregisterTrackerInCLM(TrackerData data, boolean wasUnbound) {
        LocalLineStatusTracker<?> tracker = data.getTracker();
        VirtualFile virtualFile = tracker.getVirtualFile();
        if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) {
            return;
        }
        LOG.assertTrue(virtualFile.isInLocalFileSystem(), (Object)virtualFile);
        FilePath filePath = data.getClmFilePath();
        if (filePath == null) {
            LOG.error("[unregisterTrackerInCLM] tracker is not registered");
            return;
        }
        ChangeListManagerImpl.getInstanceImpl(this.project).unregisterChangeTracker(filePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
        data.setClmFilePath(null);
        FilePath filePath2 = VcsUtil.getFilePath((VirtualFile)virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"getFilePath(...)");
        FilePath actualFilePath = filePath2;
        if (!Intrinsics.areEqual((Object)filePath, (Object)actualFilePath) && !wasUnbound) {
            LOG.error("[unregisterTrackerInCLM] unexpected file path: expected: " + filePath + ", actual: " + actualFilePath);
        }
    }

    static /* synthetic */ void unregisterTrackerInCLM$default(LineStatusTrackerManager lineStatusTrackerManager, TrackerData trackerData, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        lineStatusTrackerManager.unregisterTrackerInCLM(trackerData, bl);
    }

    private final void reregisterTrackerInCLM(TrackerData data) {
        LocalLineStatusTracker<?> tracker = data.getTracker();
        VirtualFile virtualFile = tracker.getVirtualFile();
        if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) {
            return;
        }
        LOG.assertTrue(virtualFile.isInLocalFileSystem(), (Object)virtualFile);
        FilePath oldFilePath = data.getClmFilePath();
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)virtualFile);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        FilePath newFilePath = filePath;
        if (oldFilePath == null) {
            LOG.error("[reregisterTrackerInCLM] tracker is not registered");
            return;
        }
        if (!Intrinsics.areEqual((Object)oldFilePath, (Object)newFilePath)) {
            ChangeListManagerImpl.getInstanceImpl(this.project).unregisterChangeTracker(oldFilePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
            ChangeListManagerImpl.getInstanceImpl(this.project).registerChangeTracker(newFilePath, (ChangeListWorker.PartialChangeTracker)((Object)tracker));
            data.setClmFilePath(newFilePath);
        }
    }

    private final boolean canCreateTrackerFor(VirtualFile virtualFile, Document document) {
        if (this.isDisposed) {
            return false;
        }
        return (Boolean)ActionsKt.runReadAction(() -> LineStatusTrackerManager.canCreateTrackerFor$lambda$13(virtualFile, document));
    }

    @Override
    public boolean arePartialChangelistsEnabled() {
        boolean bl;
        block2: {
            if (!this.partialChangeListsEnabled) {
                return false;
            }
            AbstractVcs[] abstractVcsArray = ProjectLevelVcsManager.getInstance((Project)this.project).getAllActiveVcss();
            Intrinsics.checkNotNullExpressionValue((Object)abstractVcsArray, (String)"getAllActiveVcss(...)");
            Object[] $this$any$iv = abstractVcsArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                AbstractVcs it = (AbstractVcs)element$iv;
                boolean bl2 = false;
                if (!it.arePartialChangelistsSupported()) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean arePartialChangelistsEnabled(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (!this.partialChangeListsEnabled) {
            return false;
        }
        AbstractVcs vcs = VcsUtil.getVcsFor((Project)this.project, (VirtualFile)virtualFile);
        return vcs != null && vcs.arePartialChangelistsSupported();
    }

    private final void switchTracker(VirtualFile virtualFile, Document document, boolean refreshExisting) {
        LocalLineStatusTracker<?> oldTracker;
        ThreadingAssertions.assertEventDispatchThread();
        LocalLineStatusTrackerProvider provider = this.getTrackerProvider(virtualFile, document);
        TrackerData trackerData = this.trackers.get(document);
        LocalLineStatusTracker<Object> localLineStatusTracker = oldTracker = trackerData != null ? trackerData.getTracker() : null;
        if (oldTracker != null && provider != null && provider.isMyTracker(oldTracker)) {
            if (refreshExisting) {
                this.refreshTracker(oldTracker, provider);
            }
        } else {
            LineStatusTrackerManager.releaseTracker$default(this, document, false, 2, null);
            if (provider != null) {
                this.installTracker(virtualFile, document, provider);
            }
        }
    }

    static /* synthetic */ void switchTracker$default(LineStatusTrackerManager lineStatusTrackerManager, VirtualFile virtualFile, Document document, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        lineStatusTrackerManager.switchTracker(virtualFile, document, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LocalLineStatusTracker<?> installTracker(VirtualFile virtualFile, Document document, LocalLineStatusTrackerProvider provider) {
        LocalLineStatusTracker<?> localLineStatusTracker;
        ThreadingAssertions.assertEventDispatchThread();
        if (this.isDisposed) {
            return null;
        }
        if (this.trackers.get(document) != null) {
            return null;
        }
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.startSection((String)"vcs.line-status-tracker-provider");
        Throwable throwable = null;
        try {
            LocalLineStatusTracker<?> localLineStatusTracker2;
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            if (provider.createTracker(this.project, virtualFile) == null) {
                LocalLineStatusTracker<?> localLineStatusTracker3 = null;
                return localLineStatusTracker3;
            }
            localLineStatusTracker = localLineStatusTracker2;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        LocalLineStatusTracker<?> tracker = localLineStatusTracker;
        tracker.setMode(this.getTrackingMode());
        tracker.addListener(new MyTrackerStateListener(tracker));
        TrackerData data = new TrackerData(tracker, null, null, 6, null);
        TrackerData replacedData = this.trackers.put(document, data);
        LOG.assertTrue(replacedData == null);
        this.registerTrackerInCLM(data);
        this.refreshTracker(tracker, provider);
        ((Listener)this.project.getMessageBus().syncPublisher(TOPIC)).onTrackerAdded((LineStatusTracker)tracker);
        if (this.clmFreezeCounter > 0) {
            tracker.freeze();
        }
        this.log("Tracker installed", virtualFile);
        return tracker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final LocalLineStatusTrackerProvider getTrackerProvider(VirtualFile virtualFile, Document document) {
        AutoCloseable autoCloseable = (AutoCloseable)SlowOperations.startSection((String)"vcs.line-status-tracker-provider");
        Throwable throwable = null;
        try {
            Object v1;
            block10: {
                AccessToken it = (AccessToken)autoCloseable;
                boolean bl = false;
                if (!this.canCreateTrackerFor(virtualFile, document)) {
                    LocalLineStatusTrackerProvider localLineStatusTrackerProvider = null;
                    return localLineStatusTrackerProvider;
                }
                LocalLineStatusTrackerProvider localLineStatusTrackerProvider = (LocalLineStatusTrackerProvider)LocalLineStatusTrackerProvider.Companion.getEP_NAME$intellij_platform_vcs_impl().findFirstSafe(arg_0 -> LineStatusTrackerManager.getTrackerProvider$lambda$20$lambda$17(arg_0 -> LineStatusTrackerManager.getTrackerProvider$lambda$20$lambda$16(this, virtualFile, arg_0), arg_0));
                if (localLineStatusTrackerProvider != null) {
                    LocalLineStatusTrackerProvider it2 = localLineStatusTrackerProvider;
                    boolean bl2 = false;
                    LocalLineStatusTrackerProvider localLineStatusTrackerProvider2 = it2;
                    return localLineStatusTrackerProvider2;
                }
                Object[] objectArray = new BaseRevisionStatusTrackerContentLoader[]{ChangelistsLocalStatusTrackerProvider.INSTANCE, DefaultLocalStatusTrackerProvider.INSTANCE};
                Iterable iterable = CollectionsKt.listOf((Object[])objectArray);
                for (Object t : iterable) {
                    BaseRevisionStatusTrackerContentLoader it3 = (BaseRevisionStatusTrackerContentLoader)t;
                    boolean bl3 = false;
                    if (!it3.isTrackedFile(this.project, virtualFile)) continue;
                    v1 = t;
                    break block10;
                }
                v1 = null;
            }
            LocalLineStatusTrackerProvider localLineStatusTrackerProvider = v1;
            return localLineStatusTrackerProvider;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @RequiresEdt
    private final void releaseTracker(Document document, boolean wasUnbound) {
        TrackerData trackerData = this.trackers.remove(document);
        if (trackerData == null) {
            return;
        }
        TrackerData data = trackerData;
        if (!this.project.isDisposed()) {
            ((Listener)this.project.getMessageBus().syncPublisher(TOPIC)).onTrackerRemoved((LineStatusTracker)data.getTracker());
        }
        this.unregisterTrackerInCLM(data, wasUnbound);
        data.getTracker().release();
        this.log("Tracker released", data.getTracker().getVirtualFile());
    }

    static /* synthetic */ void releaseTracker$default(LineStatusTrackerManager lineStatusTrackerManager, Document document, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        lineStatusTrackerManager.releaseTracker(document, bl);
    }

    private final void updatePartialChangeListsAvailability() {
        this.partialChangeListsEnabled = VcsApplicationSettings.getInstance().ENABLE_PARTIAL_CHANGELISTS && ChangeListManager.getInstance((Project)this.project).areChangeListsEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateTrackingSettings() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            if (this.isDisposed) {
                return;
            }
            LocalLineStatusTracker.Mode mode = this.getTrackingMode();
            Iterator<TrackerData> iterator = this.trackers.values().iterator();
            while (iterator.hasNext()) {
                TrackerData data;
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                data.getTracker().setMode(mode);
            }
            Unit unit = Unit.INSTANCE;
        }
        this.onEverythingChanged();
    }

    private final LocalLineStatusTracker.Mode getTrackingMode() {
        VcsApplicationSettings settings = VcsApplicationSettings.getInstance();
        return new LocalLineStatusTracker.Mode(settings.SHOW_LST_GUTTER_MARKERS, settings.SHOW_LST_ERROR_STRIPE_MARKERS, settings.SHOW_WHITESPACES_IN_LST);
    }

    @RequiresEdt
    private final void refreshTracker(LocalLineStatusTracker<?> tracker, LocalLineStatusTrackerProvider provider) {
        if (this.isDisposed) {
            return;
        }
        if (!(provider instanceof LineStatusTrackerContentLoader)) {
            return;
        }
        this.loader.scheduleRefresh(new RefreshRequest(tracker.getDocument(), (LineStatusTrackerContentLoader)provider));
        this.log("Refresh queued", tracker.getVirtualFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    @ApiStatus.Internal
    public final void offerTrackerContent(@NotNull Document document, @NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            Ref.ObjectRef tracker = new Ref.ObjectRef();
            Object object = this.LOCK;
            synchronized (object) {
                boolean bl = false;
                TrackerData data = this.trackers.get(document);
                if (data == null || data.getContentInfo() != null) {
                    return;
                }
                tracker.element = data.getTracker();
                Unit unit = Unit.INSTANCE;
            }
            if (tracker.element instanceof LocalLineStatusTrackerImpl) {
                ClientId.Companion.withExplicitClientId(ClientId.Companion.getLocalId(), () -> LineStatusTrackerManager.offerTrackerContent$lambda$23(tracker, text, this));
            }
        }
        catch (Throwable e) {
            LOG.error(e);
        }
    }

    private final void log(@NonNls String message, VirtualFile file) {
        if (LOG.isDebugEnabled()) {
            if (file != null) {
                LOG.debug(message + "; file: " + file.getPath());
            } else {
                LOG.debug(message);
            }
        }
    }

    private final void warn(@NonNls String message, Document document) {
        VirtualFile virtualFile;
        Document document2 = document;
        if (document2 != null) {
            Document it = document2;
            boolean bl = false;
            virtualFile = FileDocumentManager.getInstance().getFile(it);
        } else {
            virtualFile = null;
        }
        VirtualFile file = virtualFile;
        this.warn(message, file);
    }

    private final void warn(@NonNls String message, VirtualFile file) {
        if (file != null) {
            LOG.warn(message + "; file: " + file.getPath());
        } else {
            LOG.warn(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresEdt
    public final void resetExcludedFromCommitMarkers() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            List documents = new ArrayList();
            Iterator<TrackerData> iterator = this.trackers.values().iterator();
            while (iterator.hasNext()) {
                TrackerData data;
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                LocalLineStatusTracker<?> tracker = data.getTracker();
                if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) continue;
                ((ChangelistsLocalLineStatusTracker)tracker).resetExcludedFromCommitMarkers$intellij_platform_vcs_impl();
                documents.add(((ChangelistsLocalLineStatusTracker)tracker).getDocument());
            }
            for (TrackerData trackerData : documents) {
                Intrinsics.checkNotNullExpressionValue((Object)trackerData, (String)"next(...)");
                Document document = (Document)trackerData;
                this.checkIfTrackerCanBeReleased(document);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<ChangelistsLocalLineStatusTracker.FullState> collectPartiallyChangedFilesStates$intellij_platform_vcs_impl() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        List result2 = new ArrayList();
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            Iterator<TrackerData> iterator = this.trackers.values().iterator();
            while (iterator.hasNext()) {
                boolean hasPartialChanges;
                TrackerData data;
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                LocalLineStatusTracker<?> tracker = data.getTracker();
                if (!(tracker instanceof ChangelistsLocalLineStatusTracker) || !(hasPartialChanges = ((ChangelistsLocalLineStatusTracker)tracker).getAffectedChangeListsIds().size() > 1)) continue;
                result2.add(((ChangelistsLocalLineStatusTracker)tracker).storeTrackerState$intellij_platform_vcs_impl());
            }
            Unit unit = Unit.INSTANCE;
        }
        return result2;
    }

    @RequiresEdt
    public final void restoreTrackersForPartiallyChangedFiles$intellij_platform_vcs_impl(@NotNull List<? extends ChangelistsLocalLineStatusTracker.State> trackerStates) {
        Intrinsics.checkNotNullParameter(trackerStates, (String)"trackerStates");
        ActionsKt.runWriteAction(() -> LineStatusTrackerManager.restoreTrackersForPartiallyChangedFiles$lambda$30(this, trackerStates));
        this.onEverythingChanged();
    }

    @RequiresEdt
    public final void notifyInactiveRangesDamaged$intellij_platform_vcs_impl(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        if (this.filesWithDamagedInactiveRanges.contains(virtualFile) || Intrinsics.areEqual((Object)virtualFile, (Object)FileEditorManager.getInstance((Project)this.project).getCurrentFile())) {
            return;
        }
        this.filesWithDamagedInactiveRanges.add(virtualFile);
    }

    private final void showInactiveRangesDamagedNotification() {
        InactiveRangesDamagedNotification lastNotification;
        InactiveRangesDamagedNotification it;
        InactiveRangesDamagedNotification element$iv;
        int n;
        InactiveRangesDamagedNotification[] currentNotifications;
        block4: {
            InactiveRangesDamagedNotification inactiveRangesDamagedNotification;
            Notification[] notificationArray = NotificationsManager.getNotificationsManager().getNotificationsOfType(InactiveRangesDamagedNotification.class, this.project);
            Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsOfType(...)");
            InactiveRangesDamagedNotification[] $this$lastOrNull$iv = currentNotifications = (InactiveRangesDamagedNotification[])notificationArray;
            boolean $i$f$lastOrNull = false;
            n = $this$lastOrNull$iv.length + -1;
            if (0 <= n) {
                do {
                    int index$iv = n--;
                    it = element$iv = $this$lastOrNull$iv[index$iv];
                    boolean bl = false;
                    if (!(!it.isExpired())) continue;
                    inactiveRangesDamagedNotification = element$iv;
                    break block4;
                } while (0 <= n);
            }
            inactiveRangesDamagedNotification = lastNotification = null;
        }
        if (lastNotification != null) {
            this.filesWithDamagedInactiveRanges.addAll((Collection<VirtualFile>)lastNotification.getVirtualFiles());
        }
        InactiveRangesDamagedNotification[] $this$forEach$iv = currentNotifications;
        boolean $i$f$forEach = false;
        int n2 = $this$forEach$iv.length;
        for (n = 0; n < n2; ++n) {
            it = element$iv = $this$forEach$iv[n];
            boolean bl = false;
            it.expire();
        }
        Set files = CollectionsKt.toSet((Iterable)this.filesWithDamagedInactiveRanges);
        this.filesWithDamagedInactiveRanges.clear();
        new InactiveRangesDamagedNotification(this.project, files).notify(this.project);
    }

    @RequiresEdt
    private final void expireInactiveRangesDamagedNotifications() {
        InactiveRangesDamagedNotification[] currentNotifications;
        this.filesWithDamagedInactiveRanges.clear();
        Notification[] notificationArray = NotificationsManager.getNotificationsManager().getNotificationsOfType(InactiveRangesDamagedNotification.class, this.project);
        Intrinsics.checkNotNullExpressionValue((Object)notificationArray, (String)"getNotificationsOfType(...)");
        InactiveRangesDamagedNotification[] $this$forEach$iv = currentNotifications = (InactiveRangesDamagedNotification[])notificationArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            InactiveRangesDamagedNotification element$iv;
            InactiveRangesDamagedNotification it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            it.expire();
        }
    }

    @TestOnly
    public final void waitUntilBaseContentsLoaded() {
        boolean bl = ApplicationManager.getApplication().isUnitTestMode();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        }
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.loader.addAfterUpdateRunnable(() -> LineStatusTrackerManager.waitUntilBaseContentsLoaded$lambda$34(semaphore));
        long start2 = System.currentTimeMillis();
        do {
            if (ApplicationManager.getApplication().isDispatchThread()) {
                UIUtil.dispatchAllInvocationEvents();
            }
            if (!semaphore.waitFor(10L)) continue;
            return;
        } while (System.currentTimeMillis() - start2 <= 10000L);
        this.loader.dumpInternalState();
        System.err.println(ThreadDumper.dumpThreadsToString());
        throw new IllegalStateException("Couldn't await base contents");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public final void releaseAllTrackers() {
        Object object = this.LOCK;
        synchronized (object) {
            boolean bl = false;
            this.forcedDocuments.clear();
            Iterator<TrackerData> iterator = this.trackers.values().iterator();
            while (iterator.hasNext()) {
                TrackerData data;
                Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
                LineStatusTrackerManager.unregisterTrackerInCLM$default(this, data, false, 2, null);
                data.getTracker().release();
            }
            this.trackers.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void startListenForEditors$lambda$0(LineStatusTrackerManager this$0) {
        this$0.updateTrackingSettings();
    }

    private static final void startListenForEditors$lambda$1(LineStatusTrackerManager this$0) {
        this$0.onEverythingChanged();
    }

    private static final Multiset requestTrackerFor$lambda$6$lambda$4(Document it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Multiset)HashMultiset.create();
    }

    private static final Multiset requestTrackerFor$lambda$6$lambda$5(Function1 $tmp0, Object p0) {
        return (Multiset)$tmp0.invoke(p0);
    }

    private static final boolean canCreateTrackerFor$lambda$13(VirtualFile $virtualFile, Document $document) {
        return $virtualFile.isValid() && !$virtualFile.getFileType().isBinary() && !FileDocumentManager.getInstance().isPartialPreviewOfALargeFile($document);
    }

    private static final boolean getTrackerProvider$lambda$20$lambda$16(LineStatusTrackerManager this$0, VirtualFile $virtualFile, LocalLineStatusTrackerProvider it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isTrackedFile(this$0.project, $virtualFile);
    }

    private static final boolean getTrackerProvider$lambda$20$lambda$17(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit offerTrackerContent$lambda$23(Ref.ObjectRef $tracker, CharSequence $text, LineStatusTrackerManager this$0) {
        ((LocalLineStatusTrackerImpl)$tracker.element).setBaseRevision($text);
        this$0.log("Offered content", ((LocalLineStatusTrackerImpl)$tracker.element).getVirtualFile());
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void restoreTrackersForPartiallyChangedFiles$lambda$30$lambda$29$lambda$28(LineStatusTrackerManager this$0) {
        Object object = this$0.LOCK;
        synchronized (object) {
            boolean bl = false;
            this$0.log("State restoration finished", null);
            this$0.fileStatesAwaitingRefresh.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit restoreTrackersForPartiallyChangedFiles$lambda$30(LineStatusTrackerManager this$0, List $trackerStates) {
        Object object = this$0.LOCK;
        synchronized (object) {
            block6: {
                boolean bl = false;
                if (!this$0.isDisposed) break block6;
                Unit unit = Unit.INSTANCE;
                return unit;
            }
            for (ChangelistsLocalLineStatusTracker.State state : $trackerStates) {
                Document document;
                LocalLineStatusTrackerProvider provider;
                VirtualFile virtualFile = state.getVirtualFile();
                if (FileDocumentManager.getInstance().getDocument(virtualFile) == null || !Intrinsics.areEqual((Object)(provider = this$0.getTrackerProvider(virtualFile, document)), (Object)ChangelistsLocalStatusTrackerProvider.INSTANCE)) continue;
                LineStatusTrackerManager.switchTracker$default(this$0, virtualFile, document, false, 4, null);
                TrackerData trackerData = this$0.trackers.get(document);
                LocalLineStatusTracker<Object> tracker = trackerData != null ? trackerData.getTracker() : null;
                if (!(tracker instanceof ChangelistsLocalLineStatusTracker)) continue;
                boolean isLoading = this$0.loader.hasRequestFor(document);
                if (isLoading) {
                    this$0.fileStatesAwaitingRefresh.put(state.getVirtualFile(), state);
                    this$0.log("State restoration scheduled", virtualFile);
                    continue;
                }
                boolean success = ((ChangelistsLocalLineStatusTracker)tracker).restoreState$intellij_platform_vcs_impl(state);
                this$0.log("State restored. success - " + success, virtualFile);
            }
            this$0.loader.addAfterUpdateRunnable(() -> LineStatusTrackerManager.restoreTrackersForPartiallyChangedFiles$lambda$30$lambda$29$lambda$28(this$0));
            Unit unit = Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    private static final void waitUntilBaseContentsLoaded$lambda$34(Semaphore $semaphore) {
        $semaphore.up();
    }

    @JvmStatic
    @NotNull
    public static final LineStatusTrackerManagerI getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    @JvmStatic
    @NotNull
    public static final LineStatusTrackerManager getInstanceImpl(@NotNull Project project) {
        return Companion.getInstanceImpl(project);
    }

    public static final /* synthetic */ void access$startListenForEditors(LineStatusTrackerManager $this) {
        $this.startListenForEditors();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LineStatusTrackerManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        TOPIC = new Topic(Listener.class, Topic.BroadcastDirection.NONE);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$BaseContentProviderListener;", "Lcom/intellij/openapi/vcs/impl/VcsBaseContentProviderListener;", "<init>", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "onFileBaseContentChanged", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "onEverythingChanged", "intellij.platform.vcs.impl"})
    private final class BaseContentProviderListener
    implements VcsBaseContentProviderListener {
        @Override
        public void onFileBaseContentChanged(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            ActionsKt.runInEdt$default(null, () -> BaseContentProviderListener.onFileBaseContentChanged$lambda$0(LineStatusTrackerManager.this, file), (int)1, null);
        }

        @Override
        public void onEverythingChanged() {
            ActionsKt.runInEdt$default(null, () -> BaseContentProviderListener.onEverythingChanged$lambda$1(this), (int)1, null);
        }

        private static final Unit onFileBaseContentChanged$lambda$0(LineStatusTrackerManager this$0, VirtualFile $file) {
            this$0.onFileChanged($file);
            return Unit.INSTANCE;
        }

        private static final Unit onEverythingChanged$lambda$1(BaseContentProviderListener this$0) {
            this$0.onEverythingChanged();
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$CheckinFactory;", "Lcom/intellij/openapi/vcs/checkin/CheckinHandlerFactory;", "<init>", "()V", "createHandler", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler;", "panel", "Lcom/intellij/openapi/vcs/CheckinProjectPanel;", "commitContext", "Lcom/intellij/openapi/vcs/changes/CommitContext;", "intellij.platform.vcs.impl"})
    public static final class CheckinFactory
    extends CheckinHandlerFactory {
        @NotNull
        public CheckinHandler createHandler(@NotNull CheckinProjectPanel panel, @NotNull CommitContext commitContext) {
            Intrinsics.checkNotNullParameter((Object)panel, (String)"panel");
            Intrinsics.checkNotNullParameter((Object)commitContext, (String)"commitContext");
            Project project = panel.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Project project2 = project;
            return new CheckinHandler(project2, panel){
                final /* synthetic */ Project $project;
                final /* synthetic */ CheckinProjectPanel $panel;
                {
                    this.$project = $project;
                    this.$panel = $panel;
                }

                public void checkinSuccessful() {
                    this.resetExcludedFromCommit();
                }

                public void checkinFailed(List<VcsException> exception) {
                    this.resetExcludedFromCommit();
                }

                private final void resetExcludedFromCommit() {
                    ActionsKt.runInEdt$default(null, () -> createHandler.1.resetExcludedFromCommit$lambda$0(this.$project, this.$panel), (int)1, null);
                }

                private static final Unit resetExcludedFromCommit$lambda$0(Project $project, CheckinProjectPanel $panel) {
                    if (!$project.isDisposed() && !AbstractCommitWorkflowHandlerKt.isNonModalCommit($panel)) {
                        LineStatusTrackerManager.Companion.getInstanceImpl($project).resetExcludedFromCommitMarkers();
                    }
                    return Unit.INSTANCE;
                }
            };
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "getTOPIC", "()Lcom/intellij/util/messages/Topic;", "getInstance", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManagerI;", "project", "Lcom/intellij/openapi/project/Project;", "getInstanceImpl", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nLineStatusTrackerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,1530:1\n30#2,2:1531\n*S KotlinDebug\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Companion\n*L\n108#1:1531,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Topic<Listener> getTOPIC() {
            return TOPIC;
        }

        @JvmStatic
        @NotNull
        public final LineStatusTrackerManagerI getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<LineStatusTrackerManagerI> serviceClass$iv = LineStatusTrackerManagerI.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (LineStatusTrackerManagerI)object;
        }

        @JvmStatic
        @NotNull
        public final LineStatusTrackerManager getInstanceImpl(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            LineStatusTrackerManagerI lineStatusTrackerManagerI = this.getInstance(project);
            Intrinsics.checkNotNull((Object)lineStatusTrackerManagerI, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.impl.LineStatusTrackerManager");
            return (LineStatusTrackerManager)lineStatusTrackerManagerI;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$InactiveRangesDamagedNotification;", "Lcom/intellij/notification/Notification;", "project", "Lcom/intellij/openapi/project/Project;", "virtualFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/Set;)V", "getVirtualFiles", "()Ljava/util/Set;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nLineStatusTrackerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$InactiveRangesDamagedNotification\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1530:1\n774#2:1531\n865#2,2:1532\n*S KotlinDebug\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$InactiveRangesDamagedNotification\n*L\n1147#1:1531\n1147#1:1532,2\n*E\n"})
    private static final class InactiveRangesDamagedNotification
    extends Notification {
        @NotNull
        private final Set<VirtualFile> virtualFiles;

        public InactiveRangesDamagedNotification(@NotNull Project project, @NotNull Set<? extends VirtualFile> virtualFiles) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(virtualFiles, (String)"virtualFiles");
            super(VcsNotifier.standardNotification().getDisplayId(), VcsBundle.message((String)"lst.inactive.ranges.damaged.notification", (Object[])new Object[0]), NotificationType.INFORMATION);
            this.virtualFiles = virtualFiles;
            this.setIcon(AllIcons.Toolwindows.ToolWindowChanges);
            this.setDisplayId("vcs.inactive.ranges.damaged");
            this.addAction((AnAction)NotificationAction.createSimple(InactiveRangesDamagedNotification::_init_$lambda$0, () -> InactiveRangesDamagedNotification._init_$lambda$3(project, this)));
        }

        @NotNull
        public final Set<VirtualFile> getVirtualFiles() {
            return this.virtualFiles;
        }

        private static final String _init_$lambda$0() {
            return VcsBundle.message((String)"action.NotificationAction.InactiveRangesDamagedNotification.text.view.changes", (Object[])new Object[0]);
        }

        private static final void lambda$3$lambda$2(Project $project, List $changes) {
            ChangesViewManager.getInstance($project).selectChanges($changes);
        }

        /*
         * WARNING - void declaration
         */
        private static final void _init_$lambda$3(Project $project, InactiveRangesDamagedNotification this$0) {
            ToolWindow window;
            void $this$filterTo$iv$iv;
            LocalChangeList localChangeList = ChangeListManager.getInstance((Project)$project).getDefaultChangeList();
            Intrinsics.checkNotNullExpressionValue((Object)localChangeList, (String)"getDefaultChangeList(...)");
            LocalChangeList defaultList = localChangeList;
            Collection collection = defaultList.getChanges();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getChanges(...)");
            Iterable $this$filter$iv = collection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Change it = (Change)element$iv$iv;
                boolean bl = false;
                if (!CollectionsKt.contains((Iterable)this$0.virtualFiles, (Object)it.getVirtualFile())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List changes = (List)destination$iv$iv;
            ToolWindow toolWindow = window = ChangesViewContentManager.Companion.getToolWindowFor($project, "Local Changes");
            if (toolWindow != null) {
                toolWindow.activate(() -> InactiveRangesDamagedNotification.lambda$3$lambda$2($project, changes));
            }
            this$0.expire();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\u0014\u0010\u0002\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u0014\u0010\u0006\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016J\u0014\u0010\u0007\u001a\u00020\u00032\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "Ljava/util/EventListener;", "onTrackerAdded", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LineStatusTracker;", "onTrackerRemoved", "onTrackerBecomeValid", "intellij.platform.vcs.impl"})
    public static interface Listener
    extends EventListener {
        default public void onTrackerAdded(@NotNull LineStatusTracker<?> tracker) {
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        }

        default public void onTrackerRemoved(@NotNull LineStatusTracker<?> tracker) {
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        }

        default public void onTrackerBecomeValid(@NotNull LineStatusTracker<?> tracker) {
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$ListenerAdapter;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$Listener;", "<init>", "()V", "intellij.platform.vcs.impl"})
    public static class ListenerAdapter
    implements Listener {
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyApplicationListener;", "Lcom/intellij/openapi/application/ApplicationListener;", "<init>", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "afterWriteActionFinished", "", "action", "", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nLineStatusTrackerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyApplicationListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1530:1\n1563#2:1531\n1634#2,3:1532\n*S KotlinDebug\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyApplicationListener\n*L\n860#1:1531\n860#1:1532,3\n*E\n"})
    private final class MyApplicationListener
    implements ApplicationListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        public void afterWriteActionFinished(@NotNull Object action) {
            Intrinsics.checkNotNullParameter((Object)action, (String)"action");
            LineStatusTrackerManager.this.documentsInDefaultChangeList.clear();
            Object object = LineStatusTrackerManager.this.LOCK;
            LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
            Object object2 = object;
            synchronized (object2) {
                void $this$mapTo$iv$iv;
                boolean bl = false;
                Collection collection = lineStatusTrackerManager.trackers.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$map$iv = collection;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    TrackerData trackerData = (TrackerData)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl2 = false;
                    collection2.add(it.getTracker().getDocument());
                }
                List documents = (List)destination$iv$iv;
                for (Document document : documents) {
                    lineStatusTrackerManager.checkIfTrackerCanBeReleased(document);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0082\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u001e\u0010\r\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00022\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0015J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyBaseRevisionLoader;", "Lcom/intellij/openapi/vcs/impl/SingleThreadLoader;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "<init>", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "hasRequestFor", "", "document", "Lcom/intellij/openapi/editor/Document;", "loadRequest", "Lcom/intellij/openapi/vcs/impl/Result;", "request", "handleResult", "", "result", "handleCanceled", "handleError", "handleSuccess", "refreshData", "restorePendingTrackerState", "intellij.platform.vcs.impl"})
    private final class MyBaseRevisionLoader
    extends SingleThreadLoader<RefreshRequest, RefreshData> {
        public final boolean hasRequestFor(@NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            return this.hasRequest(arg_0 -> MyBaseRevisionLoader.hasRequestFor$lambda$0(document, arg_0));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected Result<RefreshData> loadRequest(@NotNull RefreshRequest request) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            if (LineStatusTrackerManager.this.isDisposed) {
                return new Result.Canceled();
            }
            Document document = request.getDocument();
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            LineStatusTrackerContentLoader loader = request.getLoader();
            LineStatusTrackerManager.this.log("Loading started", virtualFile);
            if (virtualFile == null || !virtualFile.isValid()) {
                LineStatusTrackerManager.this.log("Loading error: virtual file is not valid", virtualFile);
                return new Result.Error();
            }
            if (!LineStatusTrackerManager.this.canCreateTrackerFor(virtualFile, document) || !loader.isTrackedFile(LineStatusTrackerManager.this.project, virtualFile)) {
                LineStatusTrackerManager.this.log("Loading error: virtual file is not a tracked file", virtualFile);
                return new Result.Error();
            }
            LineStatusTrackerContentLoader.ContentInfo newContentInfo = loader.getContentInfo(LineStatusTrackerManager.this.project, virtualFile);
            if (newContentInfo == null) {
                LineStatusTrackerManager.this.log("Loading error: base revision not found", virtualFile);
                return new Result.Error();
            }
            Object object = LineStatusTrackerManager.this.LOCK;
            LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
            Object object2 = object;
            synchronized (object2) {
                block11: {
                    TrackerData data;
                    block10: {
                        boolean bl = false;
                        data = (TrackerData)lineStatusTrackerManager.trackers.get(document);
                        if (data != null) break block10;
                        lineStatusTrackerManager.log("Loading cancelled: tracker not found", virtualFile);
                        Result result2 = new Result.Canceled();
                        return result2;
                    }
                    if (loader.shouldBeUpdated(data.getContentInfo(), newContentInfo)) break block11;
                    lineStatusTrackerManager.log("Loading cancelled: no need to update", virtualFile);
                    Result result3 = new Result.Canceled();
                    return result3;
                }
                Unit unit = Unit.INSTANCE;
            }
            LineStatusTrackerContentLoader.TrackerContent content = loader.loadContent(LineStatusTrackerManager.this.project, newContentInfo);
            if (content == null) {
                LineStatusTrackerManager.this.log("Loading error: provider failure", virtualFile);
                return new Result.Error();
            }
            LineStatusTrackerManager.this.log("Loading successful", virtualFile);
            return new Result.Success<RefreshData>(new RefreshData(content, newContentInfo));
        }

        @Override
        @RequiresEdt
        protected void handleResult(@NotNull RefreshRequest request, @NotNull Result<RefreshData> result2) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter(result2, (String)"result");
            Document document = request.getDocument();
            Result<RefreshData> result3 = result2;
            if (result3 instanceof Result.Canceled) {
                this.handleCanceled(document);
            } else if (result3 instanceof Result.Error) {
                this.handleError(request, document);
            } else if (result3 instanceof Result.Success) {
                this.handleSuccess(request, document, (RefreshData)((Result.Success)result2).getData());
            } else {
                throw new NoWhenBranchMatchedException();
            }
            LineStatusTrackerManager.this.checkIfTrackerCanBeReleased(document);
        }

        private final void handleCanceled(Document document) {
            this.restorePendingTrackerState(document);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleError(RefreshRequest request, Document document) {
            Object object = LineStatusTrackerManager.this.LOCK;
            LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                LineStatusTrackerContentLoader loader = request.getLoader();
                TrackerData trackerData = (TrackerData)lineStatusTrackerManager.trackers.get(document);
                if (trackerData == null) {
                    return;
                }
                TrackerData data = trackerData;
                LocalLineStatusTracker<?> tracker = data.getTracker();
                if (loader.isMyTracker(tracker)) {
                    loader.handleLoadingError(tracker);
                }
                data.setContentInfo(null);
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleSuccess(RefreshRequest request, Document document, RefreshData refreshData) {
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
            if (virtualFile == null) {
                LineStatusTrackerManager.this.log("Loading finished: document is not bound", null);
                return;
            }
            LineStatusTrackerContentLoader loader = request.getLoader();
            LocalLineStatusTracker<?> tracker = null;
            Object object = LineStatusTrackerManager.this.LOCK;
            LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                TrackerData data = (TrackerData)lineStatusTrackerManager.trackers.get(document);
                if (data == null) {
                    lineStatusTrackerManager.log("Loading finished: tracker already released", virtualFile);
                    return;
                }
                tracker = data.getTracker();
                if (!loader.isMyTracker(tracker)) {
                    lineStatusTrackerManager.log("Loading finished: wrong tracker. tracker: " + tracker + ", loader: " + loader, virtualFile);
                    return;
                }
                if (!loader.shouldBeUpdated(data.getContentInfo(), refreshData.getContentInfo())) {
                    lineStatusTrackerManager.log("Loading finished: no need to update", virtualFile);
                    return;
                }
                data.setContentInfo(refreshData.getContentInfo());
                Unit unit = Unit.INSTANCE;
            }
            LineStatusTrackerManager.this.log("Loading finished: applying content", virtualFile);
            loader.setLoadedContent(tracker, refreshData.getContent());
            LineStatusTrackerManager.this.log("Loading finished: success", virtualFile);
            this.restorePendingTrackerState(document);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void restorePendingTrackerState(Document document) {
            LineStatusTracker<?> tracker = LineStatusTrackerManager.this.getLineStatusTracker(document);
            if (tracker instanceof ChangelistsLocalLineStatusTracker) {
                ChangelistsLocalLineStatusTracker.State state;
                VirtualFile virtualFile = ((ChangelistsLocalLineStatusTracker)tracker).getVirtualFile();
                Object object = LineStatusTrackerManager.this.LOCK;
                LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    ChangelistsLocalLineStatusTracker.State state2 = (ChangelistsLocalLineStatusTracker.State)lineStatusTrackerManager.fileStatesAwaitingRefresh.remove(virtualFile);
                    if (state2 == null) {
                        return;
                    }
                    state = state2;
                }
                ChangelistsLocalLineStatusTracker.State state3 = state;
                boolean success = ((ChangelistsLocalLineStatusTracker)tracker).restoreState$intellij_platform_vcs_impl(state3);
                LineStatusTrackerManager.this.log("Pending state restored. success - " + success, virtualFile);
            }
        }

        private static final boolean hasRequestFor$lambda$0(Document $document, RefreshRequest it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return Intrinsics.areEqual((Object)it.getDocument(), (Object)$document);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyChangeListAvailabilityListener;", "Lcom/intellij/openapi/vcs/changes/ChangeListAvailabilityListener;", "<init>", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "onBefore", "", "onAfter", "intellij.platform.vcs.impl"})
    private final class MyChangeListAvailabilityListener
    implements ChangeListAvailabilityListener {
        public void onBefore() {
            List<ChangelistsLocalLineStatusTracker.FullState> fileStates;
            if (ChangeListManager.getInstance((Project)LineStatusTrackerManager.this.project).areChangeListsEnabled() && !((Collection)(fileStates = Companion.getInstanceImpl(LineStatusTrackerManager.this.project).collectPartiallyChangedFilesStates$intellij_platform_vcs_impl())).isEmpty()) {
                PartialLineStatusTrackerManagerState.Companion.saveCurrentState$intellij_platform_vcs_impl(LineStatusTrackerManager.this.project, fileStates);
            }
        }

        public void onAfter() {
            LineStatusTrackerManager.this.updatePartialChangeListsAvailability();
            LineStatusTrackerManager.this.onEverythingChanged();
            if (ChangeListManager.getInstance((Project)LineStatusTrackerManager.this.project).areChangeListsEnabled()) {
                PartialLineStatusTrackerManagerState.Companion.restoreState$intellij_platform_vcs_impl(LineStatusTrackerManager.this.project);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyChangeListListener;", "Lcom/intellij/openapi/vcs/changes/ChangeListAdapter;", "<init>", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "defaultListChanged", "", "oldDefaultList", "Lcom/intellij/openapi/vcs/changes/ChangeList;", "newDefaultList", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nLineStatusTrackerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyChangeListListener\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1530:1\n13472#2,2:1531\n*S KotlinDebug\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyChangeListListener\n*L\n883#1:1531,2\n*E\n"})
    private final class MyChangeListListener
    extends ChangeListAdapter {
        public void defaultListChanged(@Nullable ChangeList oldDefaultList, @Nullable ChangeList newDefaultList) {
            ActionsKt.runInEdt((ModalityState)ModalityState.any(), () -> MyChangeListListener.defaultListChanged$lambda$1(LineStatusTrackerManager.this));
        }

        private static final Unit defaultListChanged$lambda$1(LineStatusTrackerManager this$0) {
            if (this$0.project.isDisposed()) {
                return Unit.INSTANCE;
            }
            this$0.expireInactiveRangesDamagedNotifications();
            Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
            Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getAllEditors(...)");
            Object[] $this$forEach$iv = editorArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Editor it = (Editor)element$iv;
                boolean bl = false;
                if (!(it instanceof EditorEx)) continue;
                ((EditorEx)it).getGutterComponentEx().repaint();
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyCommandListener;", "Lcom/intellij/openapi/command/CommandListener;", "<init>", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "commandFinished", "", "event", "Lcom/intellij/openapi/command/CommandEvent;", "intellij.platform.vcs.impl"})
    private final class MyCommandListener
    implements CommandListener {
        public void commandFinished(@NotNull CommandEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            if (CommandProcessor.getInstance().getCurrentCommand() == null && !LineStatusTrackerManager.this.filesWithDamagedInactiveRanges.isEmpty()) {
                LineStatusTrackerManager.this.showInactiveRangesDamagedNotification();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyDocumentListener;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "<init>", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "documentChanged", "", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "intellij.platform.vcs.impl"})
    private final class MyDocumentListener
    implements DocumentListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void documentChanged(@NotNull DocumentEvent event) {
            boolean inAnotherChangelist;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!ApplicationManager.getApplication().isDispatchThread()) {
                return;
            }
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled || LineStatusTrackerManager.this.project.isDisposed()) {
                return;
            }
            Document document = event.getDocument();
            Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
            Document document2 = document;
            if (LineStatusTrackerManager.this.documentsInDefaultChangeList.contains(document2)) {
                return;
            }
            VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document2);
            if (virtualFile == null) {
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            if (!virtualFile2.isInLocalFileSystem()) {
                return;
            }
            if (LineStatusTrackerManager.this.getLineStatusTracker(document2) != null) {
                return;
            }
            LocalChangeList changeList = ChangeListManager.getInstance((Project)LineStatusTrackerManager.this.project).getChangeList(virtualFile2);
            boolean bl = inAnotherChangelist = changeList != null && !ActiveChangeListTracker.Companion.getInstance(LineStatusTrackerManager.this.project).isActiveChangeList(changeList);
            if (inAnotherChangelist) {
                LocalLineStatusTracker localLineStatusTracker;
                LocalLineStatusTrackerProvider provider = LineStatusTrackerManager.this.getTrackerProvider(virtualFile2, document2);
                if (!Intrinsics.areEqual((Object)provider, (Object)ChangelistsLocalStatusTrackerProvider.INSTANCE)) {
                    return;
                }
                LineStatusTrackerManager.this.log("Tracker install from DocumentListener: ", virtualFile2);
                Object object = LineStatusTrackerManager.this.LOCK;
                LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl2 = false;
                    localLineStatusTracker = lineStatusTrackerManager.installTracker(virtualFile2, document2, provider);
                }
                LocalLineStatusTracker tracker = localLineStatusTracker;
                if (tracker instanceof ChangelistsLocalLineStatusTracker) {
                    ((ChangelistsLocalLineStatusTracker)tracker).replayChangesFromDocumentEvents(CollectionsKt.listOf((Object)event));
                }
            } else {
                LineStatusTrackerManager.this.documentsInDefaultChangeList.add(document2);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyEditorFactoryListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "<init>", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "install", "", "disposable", "Lcom/intellij/openapi/Disposable;", "editorCreated", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "editorReleased", "isTrackedEditor", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.vcs.impl"})
    private final class MyEditorFactoryListener
    implements EditorFactoryListener {
        public final void install(@NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            EditorFactory editorFactory = EditorFactory.getInstance();
            for (Editor editor : editorFactory.getEditorList()) {
                Intrinsics.checkNotNull((Object)editor);
                if (!this.isTrackedEditor(editor)) continue;
                Document document = editor.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                LineStatusTrackerManager.this.requestTrackerFor(document, editor);
            }
            editorFactory.addEditorFactoryListener((EditorFactoryListener)this, disposable);
        }

        public void editorCreated(@NotNull EditorFactoryEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            if (this.isTrackedEditor(editor2)) {
                Document document = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                LineStatusTrackerManager.this.requestTrackerFor(document, editor2);
            }
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            Editor editor2 = editor;
            if (this.isTrackedEditor(editor2)) {
                Document document = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
                LineStatusTrackerManager.this.releaseTrackerFor(document, editor2);
            }
        }

        private final boolean isTrackedEditor(Editor editor) {
            return !LineStatusTrackerManager.this.project.isDisposed() && (editor.getProject() == null || Intrinsics.areEqual((Object)editor.getProject(), (Object)LineStatusTrackerManager.this.project)) && FileDocumentManager.getInstance().getFile(editor.getDocument()) != null;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFileDocumentManagerListener;", "Lcom/intellij/openapi/fileEditor/FileDocumentManagerListener;", "<init>", "()V", "afterDocumentUnbound", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.platform.vcs.impl"})
    public static final class MyFileDocumentManagerListener
    implements FileDocumentManagerListener {
        public void afterDocumentUnbound(@NotNull VirtualFile file, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            ProjectManager projectManager = ProjectManager.getInstanceIfCreated();
            if (projectManager == null) {
                return;
            }
            ProjectManager projectManager2 = projectManager;
            for (Project project : projectManager2.getOpenProjects()) {
                LineStatusTrackerManager lstm;
                Intrinsics.checkNotNull((Object)project);
                Project project2 = project;
                Object object = project2.getServiceIfCreated(LineStatusTrackerManagerI.class);
                if ((object instanceof LineStatusTrackerManager ? (LineStatusTrackerManager)object : null) == null) continue;
                lstm = lstm;
                lstm.releaseTracker(document, true);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFileStatusListener;", "Lcom/intellij/openapi/vcs/FileStatusListener;", "<init>", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "fileStatusesChanged", "", "fileStatusChanged", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.vcs.impl"})
    private final class MyFileStatusListener
    implements FileStatusListener {
        public void fileStatusesChanged() {
            LineStatusTrackerManager.this.onEverythingChanged();
        }

        public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
            Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
            LineStatusTrackerManager.this.onFileChanged(virtualFile);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyFreezeListener;", "Lcom/intellij/openapi/vcs/changes/VcsFreezingProcess$Listener;", "<init>", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "onFreeze", "", "onUnfreeze", "intellij.platform.vcs.impl"})
    private final class MyFreezeListener
    implements VcsFreezingProcess.Listener {
        @Override
        public void onFreeze() {
            ActionsKt.runReadAction(() -> MyFreezeListener.onFreeze$lambda$1(LineStatusTrackerManager.this));
        }

        @Override
        public void onUnfreeze() {
            ActionsKt.runInEdt((ModalityState)ModalityState.any(), () -> MyFreezeListener.onUnfreeze$lambda$3(LineStatusTrackerManager.this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final int onFreeze$lambda$1(LineStatusTrackerManager this$0) {
            int n;
            Object object = this$0.LOCK;
            synchronized (object) {
                boolean bl = false;
                if (this$0.clmFreezeCounter == 0) {
                    for (Object v : this$0.trackers.values()) {
                        Intrinsics.checkNotNullExpressionValue(v, (String)"next(...)");
                        TrackerData data = (TrackerData)v;
                        try {
                            data.getTracker().freeze();
                        }
                        catch (Throwable e) {
                            LOG.error(e);
                        }
                    }
                }
                int n2 = this$0.clmFreezeCounter;
                this$0.clmFreezeCounter = n2 + 1;
                n = n2;
            }
            return n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final Unit onUnfreeze$lambda$3(LineStatusTrackerManager this$0) {
            Object object = this$0.LOCK;
            synchronized (object) {
                boolean bl = false;
                int n = this$0.clmFreezeCounter;
                this$0.clmFreezeCounter = n + -1;
                if (this$0.clmFreezeCounter == 0) {
                    for (Object v : this$0.trackers.values()) {
                        Intrinsics.checkNotNullExpressionValue(v, (String)"next(...)");
                        TrackerData data = (TrackerData)v;
                        try {
                            data.getTracker().unfreeze();
                        }
                        catch (Throwable e) {
                            LOG.error(e);
                        }
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyLineStatusTrackerSettingListener;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerSettingListener;", "<init>", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "settingsUpdated", "", "intellij.platform.vcs.impl"})
    private final class MyLineStatusTrackerSettingListener
    implements LineStatusTrackerSettingListener {
        public void settingsUpdated() {
            LineStatusTrackerManager.this.updatePartialChangeListsAvailability();
            LineStatusTrackerManager.this.updateTrackingSettings();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0096@\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyStartupActivity;", "Lcom/intellij/openapi/vcs/impl/VcsStartupActivity;", "<init>", "()V", "order", "", "getOrder", "()I", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nLineStatusTrackerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyStartupActivity\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,1530:1\n75#2:1531\n*S KotlinDebug\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyStartupActivity\n*L\n121#1:1531\n*E\n"})
    public static final class MyStartupActivity
    implements VcsStartupActivity {
        @Override
        public int getOrder() {
            return VcsInitObject.OTHER_INITIALIZATION.getOrder();
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof execute.1)) ** GOTO lbl-1000
            var6_3 = $completion;
            if ((var6_3.label & -2147483648) != 0) {
                var6_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    int I$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ MyStartupActivity this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.execute(null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$serviceAsync$iv = (ComponentManager)project;
                    $i$f$serviceAsync = 0;
                    Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)$this$serviceAsync$iv);
                    $continuation.I$0 = $i$f$serviceAsync;
                    $continuation.label = 1;
                    v0 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(LineStatusTrackerManagerI.class, (Continuation)$continuation);
                    if (v0 == var7_5) {
                        return var7_5;
                    }
                    ** GOTO lbl30
                }
                case 1: {
                    $i$f$serviceAsync = $continuation.I$0;
                    $this$serviceAsync$iv = (ComponentManager)$continuation.L$1;
                    project = (Project)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl30:
                    // 2 sources

                    Intrinsics.checkNotNull((Object)v0, (String)"null cannot be cast to non-null type com.intellij.openapi.vcs.impl.LineStatusTrackerManager");
                    LineStatusTrackerManager.access$startListenForEditors((LineStatusTrackerManager)v0);
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0013\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyTrackerStateListener;", "Lcom/intellij/openapi/vcs/ex/LineStatusTrackerListener;", "tracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "<init>", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;)V", "getTracker", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "onBecomingValid", "", "intellij.platform.vcs.impl"})
    private final class MyTrackerStateListener
    implements LineStatusTrackerListener {
        @NotNull
        private final LocalLineStatusTracker<?> tracker;

        public MyTrackerStateListener(LocalLineStatusTracker<?> tracker) {
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
            this.tracker = tracker;
        }

        @NotNull
        public final LocalLineStatusTracker<?> getTracker() {
            return this.tracker;
        }

        public void onBecomingValid() {
            ((Listener)LineStatusTrackerManager.this.project.getMessageBus().syncPublisher(Companion.getTOPIC())).onTrackerBecomeValid((LineStatusTracker)this.tracker);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0016\u0010\t\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0002J$\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00050\u0010H\u0002\u00a8\u0006\u0012"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyVirtualFileListener;", "Lcom/intellij/openapi/vfs/newvfs/BulkFileListener;", "<init>", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager;)V", "before", "", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "after", "handleFileMovement", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "handleFileDeletion", "forEachTrackerUnder", "action", "Lkotlin/Function1;", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "intellij.platform.vcs.impl"})
    @SourceDebugExtension(value={"SMAP\nLineStatusTrackerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyVirtualFileListener\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,1530:1\n774#2:1531\n865#2,2:1532\n*S KotlinDebug\n*F\n+ 1 LineStatusTrackerManager.kt\ncom/intellij/openapi/vcs/impl/LineStatusTrackerManager$MyVirtualFileListener\n*L\n792#1:1531\n792#1:1532,2\n*E\n"})
    private final class MyVirtualFileListener
    implements BulkFileListener {
        public void before(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            for (VFileEvent vFileEvent : events) {
                if (!(vFileEvent instanceof VFileDeleteEvent)) continue;
                VirtualFile virtualFile = ((VFileDeleteEvent)vFileEvent).getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                this.handleFileDeletion(virtualFile);
            }
        }

        public void after(@NotNull List<? extends VFileEvent> events) {
            Intrinsics.checkNotNullParameter(events, (String)"events");
            for (VFileEvent vFileEvent : events) {
                VFileEvent vFileEvent2 = vFileEvent;
                if (vFileEvent2 instanceof VFilePropertyChangeEvent) {
                    if (Intrinsics.areEqual((Object)"encoding", (Object)((VFilePropertyChangeEvent)vFileEvent).getPropertyName())) {
                        VirtualFile virtualFile = ((VFilePropertyChangeEvent)vFileEvent).getFile();
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                        LineStatusTrackerManager.this.onFileChanged(virtualFile);
                        continue;
                    }
                    if (!((VFilePropertyChangeEvent)vFileEvent).isRename()) continue;
                    VirtualFile virtualFile = ((VFilePropertyChangeEvent)vFileEvent).getFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                    this.handleFileMovement(virtualFile);
                    continue;
                }
                if (!(vFileEvent2 instanceof VFileMoveEvent)) continue;
                VirtualFile virtualFile = ((VFileMoveEvent)vFileEvent).getFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
                this.handleFileMovement(virtualFile);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleFileMovement(VirtualFile file) {
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            Object object = LineStatusTrackerManager.this.LOCK;
            LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                this.forEachTrackerUnder(file, (Function1<? super TrackerData, Unit>)((Function1)arg_0 -> MyVirtualFileListener.handleFileMovement$lambda$1$lambda$0(lineStatusTrackerManager, arg_0)));
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void handleFileDeletion(VirtualFile file) {
            if (!LineStatusTrackerManager.this.partialChangeListsEnabled) {
                return;
            }
            Object object = LineStatusTrackerManager.this.LOCK;
            LineStatusTrackerManager lineStatusTrackerManager = LineStatusTrackerManager.this;
            Object object2 = object;
            synchronized (object2) {
                boolean bl = false;
                this.forEachTrackerUnder(file, (Function1<? super TrackerData, Unit>)((Function1)arg_0 -> MyVirtualFileListener.handleFileDeletion$lambda$3$lambda$2(lineStatusTrackerManager, arg_0)));
                Unit unit = Unit.INSTANCE;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void forEachTrackerUnder(VirtualFile file, Function1<? super TrackerData, Unit> action) {
            if (file.isDirectory()) {
                void $this$filterTo$iv$iv;
                Collection collection = LineStatusTrackerManager.this.trackers.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    TrackerData it = (TrackerData)element$iv$iv;
                    boolean bl = false;
                    if (!VfsUtil.isAncestor((VirtualFile)file, (VirtualFile)it.getTracker().getVirtualFile(), (boolean)false)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List affected = (List)destination$iv$iv;
                for (Object e : affected) {
                    Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                    TrackerData data = (TrackerData)e;
                    action.invoke((Object)data);
                }
            } else {
                Document document = FileDocumentManager.getInstance().getCachedDocument(file);
                if (document == null) {
                    return;
                }
                Document document2 = document;
                TrackerData trackerData = (TrackerData)LineStatusTrackerManager.this.trackers.get(document2);
                if (trackerData == null) {
                    return;
                }
                TrackerData data = trackerData;
                action.invoke((Object)data);
            }
        }

        private static final Unit handleFileMovement$lambda$1$lambda$0(LineStatusTrackerManager this$0, TrackerData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this$0.reregisterTrackerInCLM(data);
            return Unit.INSTANCE;
        }

        private static final Unit handleFileDeletion$lambda$3$lambda$2(LineStatusTrackerManager this$0, TrackerData data) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            LineStatusTrackerManager.releaseTracker$default(this$0, data.getTracker().getDocument(), false, 2, null);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshData;", "", "content", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$TrackerContent;", "contentInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "<init>", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$TrackerContent;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;)V", "getContent", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$TrackerContent;", "getContentInfo", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "intellij.platform.vcs.impl"})
    private static final class RefreshData {
        @NotNull
        private final LineStatusTrackerContentLoader.TrackerContent content;
        @NotNull
        private final LineStatusTrackerContentLoader.ContentInfo contentInfo;

        public RefreshData(@NotNull LineStatusTrackerContentLoader.TrackerContent content, @NotNull LineStatusTrackerContentLoader.ContentInfo contentInfo) {
            Intrinsics.checkNotNullParameter((Object)content, (String)"content");
            Intrinsics.checkNotNullParameter((Object)contentInfo, (String)"contentInfo");
            this.content = content;
            this.contentInfo = contentInfo;
        }

        @NotNull
        public final LineStatusTrackerContentLoader.TrackerContent getContent() {
            return this.content;
        }

        @NotNull
        public final LineStatusTrackerContentLoader.ContentInfo getContentInfo() {
            return this.contentInfo;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$RefreshRequest;", "", "document", "Lcom/intellij/openapi/editor/Document;", "loader", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader;", "<init>", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader;)V", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getLoader", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.vcs.impl"})
    private static final class RefreshRequest {
        @NotNull
        private final Document document;
        @NotNull
        private final LineStatusTrackerContentLoader loader;

        public RefreshRequest(@NotNull Document document, @NotNull LineStatusTrackerContentLoader loader) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
            this.document = document;
            this.loader = loader;
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        @NotNull
        public final LineStatusTrackerContentLoader getLoader() {
            return this.loader;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof RefreshRequest && Intrinsics.areEqual((Object)this.document, (Object)((RefreshRequest)other).document);
        }

        public int hashCode() {
            return this.document.hashCode();
        }

        @NotNull
        public String toString() {
            Object object = FileDocumentManager.getInstance().getFile(this.document);
            if (object == null || (object = object.getPath()) == null) {
                object = "unknown";
            }
            return "RefreshRequest: " + (String)object;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0002\u0018\u00002\u00020\u0001B+\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/impl/LineStatusTrackerManager$TrackerData;", "", "tracker", "Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "contentInfo", "Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "clmFilePath", "Lcom/intellij/openapi/vcs/FilePath;", "<init>", "(Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;Lcom/intellij/openapi/vcs/FilePath;)V", "getTracker", "()Lcom/intellij/openapi/vcs/ex/LocalLineStatusTracker;", "getContentInfo", "()Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;", "setContentInfo", "(Lcom/intellij/openapi/vcs/impl/LineStatusTrackerContentLoader$ContentInfo;)V", "getClmFilePath", "()Lcom/intellij/openapi/vcs/FilePath;", "setClmFilePath", "(Lcom/intellij/openapi/vcs/FilePath;)V", "intellij.platform.vcs.impl"})
    private static final class TrackerData {
        @NotNull
        private final LocalLineStatusTracker<?> tracker;
        @Nullable
        private LineStatusTrackerContentLoader.ContentInfo contentInfo;
        @Nullable
        private FilePath clmFilePath;

        public TrackerData(@NotNull LocalLineStatusTracker<?> tracker, @Nullable LineStatusTrackerContentLoader.ContentInfo contentInfo, @Nullable FilePath clmFilePath) {
            Intrinsics.checkNotNullParameter(tracker, (String)"tracker");
            this.tracker = tracker;
            this.contentInfo = contentInfo;
            this.clmFilePath = clmFilePath;
        }

        public /* synthetic */ TrackerData(LocalLineStatusTracker localLineStatusTracker, LineStatusTrackerContentLoader.ContentInfo contentInfo, FilePath filePath, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                contentInfo = null;
            }
            if ((n & 4) != 0) {
                filePath = null;
            }
            this(localLineStatusTracker, contentInfo, filePath);
        }

        @NotNull
        public final LocalLineStatusTracker<?> getTracker() {
            return this.tracker;
        }

        @Nullable
        public final LineStatusTrackerContentLoader.ContentInfo getContentInfo() {
            return this.contentInfo;
        }

        public final void setContentInfo(@Nullable LineStatusTrackerContentLoader.ContentInfo contentInfo) {
            this.contentInfo = contentInfo;
        }

        @Nullable
        public final FilePath getClmFilePath() {
            return this.clmFilePath;
        }

        public final void setClmFilePath(@Nullable FilePath filePath) {
            this.clmFilePath = filePath;
        }
    }
}

