/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.presentation.rmi;

import com.sun.corba.se.impl.presentation.rmi.IDLType;
import com.sun.corba.se.impl.presentation.rmi.IDLTypeException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashSet;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;

public final class IDLTypesUtil {
    private static final String GET_PROPERTY_PREFIX = "get";
    private static final String SET_PROPERTY_PREFIX = "set";
    private static final String IS_PROPERTY_PREFIX = "is";
    public static final int VALID_TYPE = 0;
    public static final int INVALID_TYPE = 1;
    public static final boolean FOLLOW_RMIC = true;

    public void validateRemoteInterface(Class clazz) throws IDLTypeException {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        if (!clazz.isInterface()) {
            String string = "Class " + clazz + " must be a java interface.";
            throw new IDLTypeException(string);
        }
        if (!Remote.class.isAssignableFrom(clazz)) {
            String string = "Class " + clazz + " must extend java.rmi.Remote, either directly or indirectly.";
            throw new IDLTypeException(string);
        }
        Method[] methodArray = clazz.getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            this.validateExceptions(method);
        }
        this.validateConstants(clazz);
    }

    public boolean isRemoteInterface(Class clazz) {
        boolean bl = true;
        try {
            this.validateRemoteInterface(clazz);
        }
        catch (IDLTypeException iDLTypeException) {
            bl = false;
        }
        return bl;
    }

    public boolean isPrimitive(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        return clazz.isPrimitive();
    }

    public boolean isValue(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        return !clazz.isInterface() && Serializable.class.isAssignableFrom(clazz) && !Remote.class.isAssignableFrom(clazz);
    }

    public boolean isArray(Class clazz) {
        boolean bl = false;
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        if (clazz.isArray()) {
            Class<?> clazz2 = clazz.getComponentType();
            bl = this.isPrimitive(clazz2) || this.isRemoteInterface(clazz2) || this.isEntity(clazz2) || this.isException(clazz2) || this.isValue(clazz2) || this.isObjectReference(clazz2);
        }
        return bl;
    }

    public boolean isException(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        return this.isCheckedException(clazz) && !this.isRemoteException(clazz) && this.isValue(clazz);
    }

    public boolean isRemoteException(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        return RemoteException.class.isAssignableFrom(clazz);
    }

    public boolean isCheckedException(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        return Throwable.class.isAssignableFrom(clazz) && !RuntimeException.class.isAssignableFrom(clazz) && !Error.class.isAssignableFrom(clazz);
    }

    public boolean isObjectReference(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        return clazz.isInterface() && Object.class.isAssignableFrom(clazz);
    }

    public boolean isEntity(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        Class clazz2 = clazz.getSuperclass();
        return !clazz.isInterface() && clazz2 != null && IDLEntity.class.isAssignableFrom(clazz);
    }

    public boolean isPropertyAccessorMethod(Method method, Class clazz) {
        String string = method.getName();
        Class<?> clazz2 = method.getReturnType();
        Class<?>[] classArray = method.getParameterTypes();
        Class<?>[] classArray2 = method.getExceptionTypes();
        String string2 = null;
        if (string.startsWith(GET_PROPERTY_PREFIX)) {
            if (classArray.length == 0 && clazz2 != Void.TYPE && !this.readHasCorrespondingIsProperty(method, clazz)) {
                string2 = GET_PROPERTY_PREFIX;
            }
        } else if (string.startsWith(SET_PROPERTY_PREFIX)) {
            if (clazz2 == Void.TYPE && classArray.length == 1 && (this.hasCorrespondingReadProperty(method, clazz, GET_PROPERTY_PREFIX) || this.hasCorrespondingReadProperty(method, clazz, IS_PROPERTY_PREFIX))) {
                string2 = SET_PROPERTY_PREFIX;
            }
        } else if (string.startsWith(IS_PROPERTY_PREFIX) && classArray.length == 0 && clazz2 == Boolean.TYPE && !this.isHasCorrespondingReadProperty(method, clazz)) {
            string2 = IS_PROPERTY_PREFIX;
        }
        if (!(string2 == null || this.validPropertyExceptions(method) && string.length() > string2.length())) {
            string2 = null;
        }
        return string2 != null;
    }

    private boolean hasCorrespondingReadProperty(Method method, Class clazz, String string) {
        String string2 = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        boolean bl = false;
        try {
            String string3 = string2.replaceFirst(SET_PROPERTY_PREFIX, string);
            Method method2 = clazz.getMethod(string3, new Class[0]);
            bl = this.isPropertyAccessorMethod(method2, clazz) && method2.getReturnType() == classArray[0];
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    private boolean readHasCorrespondingIsProperty(Method method, Class clazz) {
        return false;
    }

    private boolean isHasCorrespondingReadProperty(Method method, Class clazz) {
        String string = method.getName();
        boolean bl = false;
        try {
            String string2 = string.replaceFirst(IS_PROPERTY_PREFIX, GET_PROPERTY_PREFIX);
            Method method2 = clazz.getMethod(string2, new Class[0]);
            bl = this.isPropertyAccessorMethod(method2, clazz);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public String getAttributeNameForProperty(String string) {
        String string2 = null;
        String string3 = null;
        if (string.startsWith(GET_PROPERTY_PREFIX)) {
            string3 = GET_PROPERTY_PREFIX;
        } else if (string.startsWith(SET_PROPERTY_PREFIX)) {
            string3 = SET_PROPERTY_PREFIX;
        } else if (string.startsWith(IS_PROPERTY_PREFIX)) {
            string3 = IS_PROPERTY_PREFIX;
        }
        if (string3 != null && string3.length() < string.length()) {
            String string4 = string.substring(string3.length());
            string2 = string4.length() >= 2 && Character.isUpperCase(string4.charAt(0)) && Character.isUpperCase(string4.charAt(1)) ? string4 : Character.toLowerCase(string4.charAt(0)) + string4.substring(1);
        }
        return string2;
    }

    public IDLType getPrimitiveIDLTypeMapping(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return new IDLType(clazz, "void");
            }
            if (clazz == Boolean.TYPE) {
                return new IDLType(clazz, "boolean");
            }
            if (clazz == Character.TYPE) {
                return new IDLType(clazz, "wchar");
            }
            if (clazz == Byte.TYPE) {
                return new IDLType(clazz, "octet");
            }
            if (clazz == Short.TYPE) {
                return new IDLType(clazz, "short");
            }
            if (clazz == Integer.TYPE) {
                return new IDLType(clazz, "long");
            }
            if (clazz == Long.TYPE) {
                return new IDLType(clazz, "long_long");
            }
            if (clazz == Float.TYPE) {
                return new IDLType(clazz, "float");
            }
            if (clazz == Double.TYPE) {
                return new IDLType(clazz, "double");
            }
        }
        return null;
    }

    public IDLType getSpecialCaseIDLTypeMapping(Class clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException();
        }
        if (clazz == java.lang.Object.class) {
            return new IDLType(clazz, new String[]{"java", "lang"}, "Object");
        }
        if (clazz == String.class) {
            return new IDLType(clazz, new String[]{"CORBA"}, "WStringValue");
        }
        if (clazz == Class.class) {
            return new IDLType(clazz, new String[]{"javax", "rmi", "CORBA"}, "ClassDesc");
        }
        if (clazz == Serializable.class) {
            return new IDLType(clazz, new String[]{"java", "io"}, "Serializable");
        }
        if (clazz == Externalizable.class) {
            return new IDLType(clazz, new String[]{"java", "io"}, "Externalizable");
        }
        if (clazz == Remote.class) {
            return new IDLType(clazz, new String[]{"java", "rmi"}, "Remote");
        }
        if (clazz == Object.class) {
            return new IDLType(clazz, "Object");
        }
        return null;
    }

    private void validateExceptions(Method method) throws IDLTypeException {
        Class<?> clazz;
        int n;
        Class<?>[] classArray = method.getExceptionTypes();
        boolean bl = false;
        for (n = 0; n < classArray.length; ++n) {
            clazz = classArray[n];
            if (!this.isRemoteExceptionOrSuperClass(clazz)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            String string = "Method '" + method + "' must throw at least one exception of type java.rmi.RemoteException or one of its super-classes";
            throw new IDLTypeException(string);
        }
        for (n = 0; n < classArray.length; ++n) {
            clazz = classArray[n];
            if (!this.isCheckedException(clazz) || this.isValue(clazz) || this.isRemoteException(clazz)) continue;
            String string = "Exception '" + clazz + "' on method '" + method + "' is not a allowed RMI/IIOP exception type";
            throw new IDLTypeException(string);
        }
    }

    private boolean validPropertyExceptions(Method method) {
        Class<?>[] classArray = method.getExceptionTypes();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz = classArray[i];
            if (!this.isCheckedException(clazz) || this.isRemoteException(clazz)) continue;
            return false;
        }
        return true;
    }

    private boolean isRemoteExceptionOrSuperClass(Class clazz) {
        return clazz == RemoteException.class || clazz == IOException.class || clazz == Exception.class || clazz == Throwable.class;
    }

    private void validateDirectInterfaces(Class clazz) throws IDLTypeException {
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray.length < 2) {
            return;
        }
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz2 = classArray[i];
            Method[] methodArray = clazz2.getMethods();
            hashSet2.clear();
            for (int j = 0; j < methodArray.length; ++j) {
                hashSet2.add(methodArray[j].getName());
            }
            for (String string : hashSet2) {
                if (hashSet.contains(string)) {
                    String string2 = "Class " + clazz + " inherits method " + string + " from multiple direct interfaces.";
                    throw new IDLTypeException(string2);
                }
                hashSet.add(string);
            }
        }
    }

    private void validateConstants(final Class clazz) throws IDLTypeException {
        Field[] fieldArray = null;
        try {
            fieldArray = (Field[])AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public java.lang.Object run() throws Exception {
                    return clazz.getFields();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            IDLTypeException iDLTypeException = new IDLTypeException();
            iDLTypeException.initCause(privilegedActionException);
            throw iDLTypeException;
        }
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            Class<?> clazz2 = field.getType();
            if (clazz2 == String.class || this.isPrimitive(clazz2)) continue;
            String string = "Constant field '" + field.getName() + "' in class '" + field.getDeclaringClass().getName() + "' has invalid type' " + field.getType() + "'. Constants in RMI/IIOP interfaces can only have primitive types and java.lang.String types.";
            throw new IDLTypeException(string);
        }
    }
}

