// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: quota/quota.proto

/*
	Package quota is a generated protocol buffer package.

	It is generated from these files:
		quota/quota.proto

	It has these top-level messages:
		QuotaInfo
		QuotaRequest
		QuotaConfig
		QuotaStatus
*/
package quota

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import mesos "github.com/mesos/mesos-go/api/v1/lib"
import _ "github.com/gogo/protobuf/gogoproto"

import strings "strings"
import reflect "reflect"
import github_com_gogo_protobuf_sortkeys "github.com/gogo/protobuf/sortkeys"

import io "io"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// *
// Describes the resource guarantees for a role.
// Persisted in the registry.
type QuotaInfo struct {
	Role *string `protobuf:"bytes,1,opt,name=role" json:"role,omitempty"`
	// Principal which set the quota. Currently only operators can set quotas.
	Principal *string          `protobuf:"bytes,2,opt,name=principal" json:"principal,omitempty"`
	Guarantee []mesos.Resource `protobuf:"bytes,3,rep,name=guarantee" json:"guarantee"`
}

func (m *QuotaInfo) Reset()                    { *m = QuotaInfo{} }
func (*QuotaInfo) ProtoMessage()               {}
func (*QuotaInfo) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{0} }

func (m *QuotaInfo) GetRole() string {
	if m != nil && m.Role != nil {
		return *m.Role
	}
	return ""
}

func (m *QuotaInfo) GetPrincipal() string {
	if m != nil && m.Principal != nil {
		return *m.Principal
	}
	return ""
}

func (m *QuotaInfo) GetGuarantee() []mesos.Resource {
	if m != nil {
		return m.Guarantee
	}
	return nil
}

// *
// Describes an update to a role's quota. This is a copy of
// `QuotaInfo` which omits the principal since it is determined
// during authentication. Also allows the user to force the update
// in the case of a guarantee overcommit.
type QuotaRequest struct {
	// See `guarantee` for the behavior of `force`.
	Force *bool   `protobuf:"varint,1,opt,name=force,def=0" json:"force,omitempty"`
	Role  *string `protobuf:"bytes,2,opt,name=role" json:"role,omitempty"`
	// Mesos will try its best to ensure that the role can be
	// allocated at least as many resources as the guarantee.
	// Despite this, it's possible for the guarantee to not be
	// satisfiable, if:
	//   (1) The operator has overcommitted guarantees.
	//   (2) There is a loss of agents that such that the
	//       guarantees overcommit the cluster.
	//   (3) The scheduler is pickier than mesos knows about,
	//       e.g. the scheduler needs resources from agents
	//       with specific attributes.
	//
	// The provided guarantee will be validated to ensure it
	// is not overcommitting the cluster. The operator can
	// disable this via `QuotaRequest.force`.
	//
	// If the guarantee is omitted, there is no guarantee.
	//
	// Operators may want to set up alerting to let them know
	// when a guarantee cannot be satisfied.
	//
	// NOTE: The resources must be scalars without additional
	// metadata like reservations, disk information, etc.
	Guarantee []mesos.Resource `protobuf:"bytes,3,rep,name=guarantee" json:"guarantee"`
}

func (m *QuotaRequest) Reset()                    { *m = QuotaRequest{} }
func (*QuotaRequest) ProtoMessage()               {}
func (*QuotaRequest) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{1} }

const Default_QuotaRequest_Force bool = false

func (m *QuotaRequest) GetForce() bool {
	if m != nil && m.Force != nil {
		return *m.Force
	}
	return Default_QuotaRequest_Force
}

func (m *QuotaRequest) GetRole() string {
	if m != nil && m.Role != nil {
		return *m.Role
	}
	return ""
}

func (m *QuotaRequest) GetGuarantee() []mesos.Resource {
	if m != nil {
		return m.Guarantee
	}
	return nil
}

// *
// Describes a role's quota configuration. This replaces the legacy
// quota related messages: `QuotaInfo` and `QuotaRequest`. This is
// used in both `UPDATE_QUOTA` and `GET_QUOTA` calls as well as persisted
// in the registry.
//
// We use this new message in the new call `UPDATE_QUOTA` instead of reusing
// the legacy `QuotaRequest` message. This avoids confusions with deprecated
// fields and provides a cleaner interface. In `QuotaStatus` returned by
// `GET_QUOTA`, the legacy `infos` field is still filled along side `configs`
// for backwards compatibility.
type QuotaConfig struct {
	Role string `protobuf:"bytes,1,req,name=role" json:"role"`
	// Name-value pairs that define the resource guarantees.
	// Only scalar resources are currently supported.
	//
	// Mesos will try its best to ensure that the role can be
	// allocated at least as many resources as the guarantee.
	// Despite this, it's possible for the guarantee to not be
	// satisfiable, if:
	//   (1) The operator has overcommitted guarantees.
	//   (2) There is a loss of agents that such that the
	//       guarantees overcommit the cluster.
	//   (3) The scheduler is pickier than mesos knows about,
	//       e.g. the scheduler needs resources from agents
	//       with specific attributes.
	//
	// The provided guarantees will be validated to ensure it
	// is not overcommitting the cluster. The operator can
	// disable this via `UpdateQuota.force`.
	//
	// If the guarantee is omitted, there is no guarantee.
	//
	// Operators may want to set up alerting to let them know
	// when a guarantee cannot be satisfied.
	Guarantees map[string]mesos.Value_Scalar `protobuf:"bytes,2,rep,name=guarantees" json:"guarantees" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Name-value pairs that define the resource limits.
	// Only scalar resources are currently supported.
	//
	// Imposes a limit on the amount of resources allocated to the
	// role. Mesos will try its best to ensure that the role does
	// not exceed this limit. Despite this, the limit can be exceeded
	// when:
	//   (1) The limit is lowered below the allocation.
	//   (2) Some agents are partitioned and re-connect with
	//       resources allocated to the role.
	//
	// The provided limits will be validated to ensure it does not
	// exceed the total cluster size. The operator can disable
	// this check via `UpdateQuota.force`.
	//
	// If the limit is omitted, there is no limit.
	//
	// Operators may want to set up alerting to let them know
	// when the limit is exceeded.
	Limits map[string]mesos.Value_Scalar `protobuf:"bytes,3,rep,name=limits" json:"limits" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *QuotaConfig) Reset()                    { *m = QuotaConfig{} }
func (*QuotaConfig) ProtoMessage()               {}
func (*QuotaConfig) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{2} }

func (m *QuotaConfig) GetRole() string {
	if m != nil {
		return m.Role
	}
	return ""
}

func (m *QuotaConfig) GetGuarantees() map[string]mesos.Value_Scalar {
	if m != nil {
		return m.Guarantees
	}
	return nil
}

func (m *QuotaConfig) GetLimits() map[string]mesos.Value_Scalar {
	if m != nil {
		return m.Limits
	}
	return nil
}

// *
// `QuotaStatus` describes the internal representation for the
// /quota/status response and `GET_QUOTA` `master::Response`.
type QuotaStatus struct {
	// Returns all non-default quotas. Those omitted from this
	// list have the default of: no guarantee and no limit.
	//
	// For backwards compatibility, `infos` are still filled along
	// side `configs`. Note, however `infos` will contain less information
	// comparing to `configs` (e.g. info does not contain information
	// regarding quota limits).
	Infos []QuotaInfo `protobuf:"bytes,1,rep,name=infos" json:"infos"`
	// Returns all non-default quotas. Those omitted from this
	// list have the default of: no guarantee and no limit.
	Configs []QuotaConfig `protobuf:"bytes,2,rep,name=configs" json:"configs"`
}

func (m *QuotaStatus) Reset()                    { *m = QuotaStatus{} }
func (*QuotaStatus) ProtoMessage()               {}
func (*QuotaStatus) Descriptor() ([]byte, []int) { return fileDescriptorQuota, []int{3} }

func (m *QuotaStatus) GetInfos() []QuotaInfo {
	if m != nil {
		return m.Infos
	}
	return nil
}

func (m *QuotaStatus) GetConfigs() []QuotaConfig {
	if m != nil {
		return m.Configs
	}
	return nil
}

func init() {
	proto.RegisterType((*QuotaInfo)(nil), "mesos.quota.QuotaInfo")
	proto.RegisterType((*QuotaRequest)(nil), "mesos.quota.QuotaRequest")
	proto.RegisterType((*QuotaConfig)(nil), "mesos.quota.QuotaConfig")
	proto.RegisterType((*QuotaStatus)(nil), "mesos.quota.QuotaStatus")
}
func (this *QuotaInfo) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*QuotaInfo)
	if !ok {
		that2, ok := that.(QuotaInfo)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *QuotaInfo")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *QuotaInfo but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *QuotaInfo but is not nil && this == nil")
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return fmt.Errorf("Role this(%v) Not Equal that(%v)", *this.Role, *that1.Role)
		}
	} else if this.Role != nil {
		return fmt.Errorf("this.Role == nil && that.Role != nil")
	} else if that1.Role != nil {
		return fmt.Errorf("Role this(%v) Not Equal that(%v)", this.Role, that1.Role)
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return fmt.Errorf("Principal this(%v) Not Equal that(%v)", *this.Principal, *that1.Principal)
		}
	} else if this.Principal != nil {
		return fmt.Errorf("this.Principal == nil && that.Principal != nil")
	} else if that1.Principal != nil {
		return fmt.Errorf("Principal this(%v) Not Equal that(%v)", this.Principal, that1.Principal)
	}
	if len(this.Guarantee) != len(that1.Guarantee) {
		return fmt.Errorf("Guarantee this(%v) Not Equal that(%v)", len(this.Guarantee), len(that1.Guarantee))
	}
	for i := range this.Guarantee {
		if !this.Guarantee[i].Equal(&that1.Guarantee[i]) {
			return fmt.Errorf("Guarantee this[%v](%v) Not Equal that[%v](%v)", i, this.Guarantee[i], i, that1.Guarantee[i])
		}
	}
	return nil
}
func (this *QuotaInfo) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*QuotaInfo)
	if !ok {
		that2, ok := that.(QuotaInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return false
		}
	} else if this.Role != nil {
		return false
	} else if that1.Role != nil {
		return false
	}
	if this.Principal != nil && that1.Principal != nil {
		if *this.Principal != *that1.Principal {
			return false
		}
	} else if this.Principal != nil {
		return false
	} else if that1.Principal != nil {
		return false
	}
	if len(this.Guarantee) != len(that1.Guarantee) {
		return false
	}
	for i := range this.Guarantee {
		if !this.Guarantee[i].Equal(&that1.Guarantee[i]) {
			return false
		}
	}
	return true
}
func (this *QuotaRequest) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*QuotaRequest)
	if !ok {
		that2, ok := that.(QuotaRequest)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *QuotaRequest")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *QuotaRequest but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *QuotaRequest but is not nil && this == nil")
	}
	if this.Force != nil && that1.Force != nil {
		if *this.Force != *that1.Force {
			return fmt.Errorf("Force this(%v) Not Equal that(%v)", *this.Force, *that1.Force)
		}
	} else if this.Force != nil {
		return fmt.Errorf("this.Force == nil && that.Force != nil")
	} else if that1.Force != nil {
		return fmt.Errorf("Force this(%v) Not Equal that(%v)", this.Force, that1.Force)
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return fmt.Errorf("Role this(%v) Not Equal that(%v)", *this.Role, *that1.Role)
		}
	} else if this.Role != nil {
		return fmt.Errorf("this.Role == nil && that.Role != nil")
	} else if that1.Role != nil {
		return fmt.Errorf("Role this(%v) Not Equal that(%v)", this.Role, that1.Role)
	}
	if len(this.Guarantee) != len(that1.Guarantee) {
		return fmt.Errorf("Guarantee this(%v) Not Equal that(%v)", len(this.Guarantee), len(that1.Guarantee))
	}
	for i := range this.Guarantee {
		if !this.Guarantee[i].Equal(&that1.Guarantee[i]) {
			return fmt.Errorf("Guarantee this[%v](%v) Not Equal that[%v](%v)", i, this.Guarantee[i], i, that1.Guarantee[i])
		}
	}
	return nil
}
func (this *QuotaRequest) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*QuotaRequest)
	if !ok {
		that2, ok := that.(QuotaRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Force != nil && that1.Force != nil {
		if *this.Force != *that1.Force {
			return false
		}
	} else if this.Force != nil {
		return false
	} else if that1.Force != nil {
		return false
	}
	if this.Role != nil && that1.Role != nil {
		if *this.Role != *that1.Role {
			return false
		}
	} else if this.Role != nil {
		return false
	} else if that1.Role != nil {
		return false
	}
	if len(this.Guarantee) != len(that1.Guarantee) {
		return false
	}
	for i := range this.Guarantee {
		if !this.Guarantee[i].Equal(&that1.Guarantee[i]) {
			return false
		}
	}
	return true
}
func (this *QuotaConfig) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*QuotaConfig)
	if !ok {
		that2, ok := that.(QuotaConfig)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *QuotaConfig")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *QuotaConfig but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *QuotaConfig but is not nil && this == nil")
	}
	if this.Role != that1.Role {
		return fmt.Errorf("Role this(%v) Not Equal that(%v)", this.Role, that1.Role)
	}
	if len(this.Guarantees) != len(that1.Guarantees) {
		return fmt.Errorf("Guarantees this(%v) Not Equal that(%v)", len(this.Guarantees), len(that1.Guarantees))
	}
	for i := range this.Guarantees {
		a := this.Guarantees[i]
		b := that1.Guarantees[i]
		if !(&a).Equal(&b) {
			return fmt.Errorf("Guarantees this[%v](%v) Not Equal that[%v](%v)", i, this.Guarantees[i], i, that1.Guarantees[i])
		}
	}
	if len(this.Limits) != len(that1.Limits) {
		return fmt.Errorf("Limits this(%v) Not Equal that(%v)", len(this.Limits), len(that1.Limits))
	}
	for i := range this.Limits {
		a := this.Limits[i]
		b := that1.Limits[i]
		if !(&a).Equal(&b) {
			return fmt.Errorf("Limits this[%v](%v) Not Equal that[%v](%v)", i, this.Limits[i], i, that1.Limits[i])
		}
	}
	return nil
}
func (this *QuotaConfig) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*QuotaConfig)
	if !ok {
		that2, ok := that.(QuotaConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Role != that1.Role {
		return false
	}
	if len(this.Guarantees) != len(that1.Guarantees) {
		return false
	}
	for i := range this.Guarantees {
		a := this.Guarantees[i]
		b := that1.Guarantees[i]
		if !(&a).Equal(&b) {
			return false
		}
	}
	if len(this.Limits) != len(that1.Limits) {
		return false
	}
	for i := range this.Limits {
		a := this.Limits[i]
		b := that1.Limits[i]
		if !(&a).Equal(&b) {
			return false
		}
	}
	return true
}
func (this *QuotaStatus) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*QuotaStatus)
	if !ok {
		that2, ok := that.(QuotaStatus)
		if ok {
			that1 = &that2
		} else {
			return fmt.Errorf("that is not of type *QuotaStatus")
		}
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *QuotaStatus but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *QuotaStatus but is not nil && this == nil")
	}
	if len(this.Infos) != len(that1.Infos) {
		return fmt.Errorf("Infos this(%v) Not Equal that(%v)", len(this.Infos), len(that1.Infos))
	}
	for i := range this.Infos {
		if !this.Infos[i].Equal(&that1.Infos[i]) {
			return fmt.Errorf("Infos this[%v](%v) Not Equal that[%v](%v)", i, this.Infos[i], i, that1.Infos[i])
		}
	}
	if len(this.Configs) != len(that1.Configs) {
		return fmt.Errorf("Configs this(%v) Not Equal that(%v)", len(this.Configs), len(that1.Configs))
	}
	for i := range this.Configs {
		if !this.Configs[i].Equal(&that1.Configs[i]) {
			return fmt.Errorf("Configs this[%v](%v) Not Equal that[%v](%v)", i, this.Configs[i], i, that1.Configs[i])
		}
	}
	return nil
}
func (this *QuotaStatus) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*QuotaStatus)
	if !ok {
		that2, ok := that.(QuotaStatus)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Infos) != len(that1.Infos) {
		return false
	}
	for i := range this.Infos {
		if !this.Infos[i].Equal(&that1.Infos[i]) {
			return false
		}
	}
	if len(this.Configs) != len(that1.Configs) {
		return false
	}
	for i := range this.Configs {
		if !this.Configs[i].Equal(&that1.Configs[i]) {
			return false
		}
	}
	return true
}
func (this *QuotaInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&quota.QuotaInfo{")
	if this.Role != nil {
		s = append(s, "Role: "+valueToGoStringQuota(this.Role, "string")+",\n")
	}
	if this.Principal != nil {
		s = append(s, "Principal: "+valueToGoStringQuota(this.Principal, "string")+",\n")
	}
	if this.Guarantee != nil {
		s = append(s, "Guarantee: "+fmt.Sprintf("%#v", this.Guarantee)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QuotaRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&quota.QuotaRequest{")
	if this.Force != nil {
		s = append(s, "Force: "+valueToGoStringQuota(this.Force, "bool")+",\n")
	}
	if this.Role != nil {
		s = append(s, "Role: "+valueToGoStringQuota(this.Role, "string")+",\n")
	}
	if this.Guarantee != nil {
		s = append(s, "Guarantee: "+fmt.Sprintf("%#v", this.Guarantee)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QuotaConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&quota.QuotaConfig{")
	s = append(s, "Role: "+fmt.Sprintf("%#v", this.Role)+",\n")
	keysForGuarantees := make([]string, 0, len(this.Guarantees))
	for k, _ := range this.Guarantees {
		keysForGuarantees = append(keysForGuarantees, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForGuarantees)
	mapStringForGuarantees := "map[string]mesos.Value_Scalar{"
	for _, k := range keysForGuarantees {
		mapStringForGuarantees += fmt.Sprintf("%#v: %#v,", k, this.Guarantees[k])
	}
	mapStringForGuarantees += "}"
	if this.Guarantees != nil {
		s = append(s, "Guarantees: "+mapStringForGuarantees+",\n")
	}
	keysForLimits := make([]string, 0, len(this.Limits))
	for k, _ := range this.Limits {
		keysForLimits = append(keysForLimits, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLimits)
	mapStringForLimits := "map[string]mesos.Value_Scalar{"
	for _, k := range keysForLimits {
		mapStringForLimits += fmt.Sprintf("%#v: %#v,", k, this.Limits[k])
	}
	mapStringForLimits += "}"
	if this.Limits != nil {
		s = append(s, "Limits: "+mapStringForLimits+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *QuotaStatus) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&quota.QuotaStatus{")
	if this.Infos != nil {
		s = append(s, "Infos: "+fmt.Sprintf("%#v", this.Infos)+",\n")
	}
	if this.Configs != nil {
		s = append(s, "Configs: "+fmt.Sprintf("%#v", this.Configs)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringQuota(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func (m *QuotaInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Role != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintQuota(dAtA, i, uint64(len(*m.Role)))
		i += copy(dAtA[i:], *m.Role)
	}
	if m.Principal != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuota(dAtA, i, uint64(len(*m.Principal)))
		i += copy(dAtA[i:], *m.Principal)
	}
	if len(m.Guarantee) > 0 {
		for _, msg := range m.Guarantee {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintQuota(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *QuotaRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Force != nil {
		dAtA[i] = 0x8
		i++
		if *m.Force {
			dAtA[i] = 1
		} else {
			dAtA[i] = 0
		}
		i++
	}
	if m.Role != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintQuota(dAtA, i, uint64(len(*m.Role)))
		i += copy(dAtA[i:], *m.Role)
	}
	if len(m.Guarantee) > 0 {
		for _, msg := range m.Guarantee {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintQuota(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *QuotaConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaConfig) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintQuota(dAtA, i, uint64(len(m.Role)))
	i += copy(dAtA[i:], m.Role)
	if len(m.Guarantees) > 0 {
		for k, _ := range m.Guarantees {
			dAtA[i] = 0x12
			i++
			v := m.Guarantees[k]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovQuota(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovQuota(uint64(len(k))) + msgSize
			i = encodeVarintQuota(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuota(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintQuota(dAtA, i, uint64((&v).Size()))
			n1, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n1
		}
	}
	if len(m.Limits) > 0 {
		for k, _ := range m.Limits {
			dAtA[i] = 0x1a
			i++
			v := m.Limits[k]
			msgSize := 0
			if (&v) != nil {
				msgSize = (&v).Size()
				msgSize += 1 + sovQuota(uint64(msgSize))
			}
			mapSize := 1 + len(k) + sovQuota(uint64(len(k))) + msgSize
			i = encodeVarintQuota(dAtA, i, uint64(mapSize))
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuota(dAtA, i, uint64(len(k)))
			i += copy(dAtA[i:], k)
			dAtA[i] = 0x12
			i++
			i = encodeVarintQuota(dAtA, i, uint64((&v).Size()))
			n2, err := (&v).MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n2
		}
	}
	return i, nil
}

func (m *QuotaStatus) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QuotaStatus) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Infos) > 0 {
		for _, msg := range m.Infos {
			dAtA[i] = 0xa
			i++
			i = encodeVarintQuota(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Configs) > 0 {
		for _, msg := range m.Configs {
			dAtA[i] = 0x12
			i++
			i = encodeVarintQuota(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func encodeFixed64Quota(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Quota(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintQuota(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedQuotaInfo(r randyQuota, easy bool) *QuotaInfo {
	this := &QuotaInfo{}
	if r.Intn(10) != 0 {
		v1 := string(randStringQuota(r))
		this.Role = &v1
	}
	if r.Intn(10) != 0 {
		v2 := string(randStringQuota(r))
		this.Principal = &v2
	}
	if r.Intn(10) != 0 {
		v3 := r.Intn(5)
		this.Guarantee = make([]mesos.Resource, v3)
		for i := 0; i < v3; i++ {
			v4 := mesos.NewPopulatedResource(r, easy)
			this.Guarantee[i] = *v4
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedQuotaRequest(r randyQuota, easy bool) *QuotaRequest {
	this := &QuotaRequest{}
	if r.Intn(10) != 0 {
		v5 := bool(bool(r.Intn(2) == 0))
		this.Force = &v5
	}
	if r.Intn(10) != 0 {
		v6 := string(randStringQuota(r))
		this.Role = &v6
	}
	if r.Intn(10) != 0 {
		v7 := r.Intn(5)
		this.Guarantee = make([]mesos.Resource, v7)
		for i := 0; i < v7; i++ {
			v8 := mesos.NewPopulatedResource(r, easy)
			this.Guarantee[i] = *v8
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedQuotaConfig(r randyQuota, easy bool) *QuotaConfig {
	this := &QuotaConfig{}
	this.Role = string(randStringQuota(r))
	if r.Intn(10) != 0 {
		v9 := r.Intn(10)
		this.Guarantees = make(map[string]mesos.Value_Scalar)
		for i := 0; i < v9; i++ {
			this.Guarantees[randStringQuota(r)] = *mesos.NewPopulatedValue_Scalar(r, easy)
		}
	}
	if r.Intn(10) != 0 {
		v10 := r.Intn(10)
		this.Limits = make(map[string]mesos.Value_Scalar)
		for i := 0; i < v10; i++ {
			this.Limits[randStringQuota(r)] = *mesos.NewPopulatedValue_Scalar(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedQuotaStatus(r randyQuota, easy bool) *QuotaStatus {
	this := &QuotaStatus{}
	if r.Intn(10) != 0 {
		v11 := r.Intn(5)
		this.Infos = make([]QuotaInfo, v11)
		for i := 0; i < v11; i++ {
			v12 := NewPopulatedQuotaInfo(r, easy)
			this.Infos[i] = *v12
		}
	}
	if r.Intn(10) != 0 {
		v13 := r.Intn(5)
		this.Configs = make([]QuotaConfig, v13)
		for i := 0; i < v13; i++ {
			v14 := NewPopulatedQuotaConfig(r, easy)
			this.Configs[i] = *v14
		}
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyQuota interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneQuota(r randyQuota) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringQuota(r randyQuota) string {
	v15 := r.Intn(100)
	tmps := make([]rune, v15)
	for i := 0; i < v15; i++ {
		tmps[i] = randUTF8RuneQuota(r)
	}
	return string(tmps)
}
func randUnrecognizedQuota(r randyQuota, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldQuota(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldQuota(dAtA []byte, r randyQuota, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateQuota(dAtA, uint64(key))
		v16 := r.Int63()
		if r.Intn(2) == 0 {
			v16 *= -1
		}
		dAtA = encodeVarintPopulateQuota(dAtA, uint64(v16))
	case 1:
		dAtA = encodeVarintPopulateQuota(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateQuota(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateQuota(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateQuota(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateQuota(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *QuotaInfo) Size() (n int) {
	var l int
	_ = l
	if m.Role != nil {
		l = len(*m.Role)
		n += 1 + l + sovQuota(uint64(l))
	}
	if m.Principal != nil {
		l = len(*m.Principal)
		n += 1 + l + sovQuota(uint64(l))
	}
	if len(m.Guarantee) > 0 {
		for _, e := range m.Guarantee {
			l = e.Size()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	return n
}

func (m *QuotaRequest) Size() (n int) {
	var l int
	_ = l
	if m.Force != nil {
		n += 2
	}
	if m.Role != nil {
		l = len(*m.Role)
		n += 1 + l + sovQuota(uint64(l))
	}
	if len(m.Guarantee) > 0 {
		for _, e := range m.Guarantee {
			l = e.Size()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	return n
}

func (m *QuotaConfig) Size() (n int) {
	var l int
	_ = l
	l = len(m.Role)
	n += 1 + l + sovQuota(uint64(l))
	if len(m.Guarantees) > 0 {
		for k, v := range m.Guarantees {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovQuota(uint64(len(k))) + 1 + l + sovQuota(uint64(l))
			n += mapEntrySize + 1 + sovQuota(uint64(mapEntrySize))
		}
	}
	if len(m.Limits) > 0 {
		for k, v := range m.Limits {
			_ = k
			_ = v
			l = v.Size()
			mapEntrySize := 1 + len(k) + sovQuota(uint64(len(k))) + 1 + l + sovQuota(uint64(l))
			n += mapEntrySize + 1 + sovQuota(uint64(mapEntrySize))
		}
	}
	return n
}

func (m *QuotaStatus) Size() (n int) {
	var l int
	_ = l
	if len(m.Infos) > 0 {
		for _, e := range m.Infos {
			l = e.Size()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	if len(m.Configs) > 0 {
		for _, e := range m.Configs {
			l = e.Size()
			n += 1 + l + sovQuota(uint64(l))
		}
	}
	return n
}

func sovQuota(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozQuota(x uint64) (n int) {
	return sovQuota(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *QuotaInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QuotaInfo{`,
		`Role:` + valueToStringQuota(this.Role) + `,`,
		`Principal:` + valueToStringQuota(this.Principal) + `,`,
		`Guarantee:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Guarantee), "Resource", "mesos.Resource", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QuotaRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QuotaRequest{`,
		`Force:` + valueToStringQuota(this.Force) + `,`,
		`Role:` + valueToStringQuota(this.Role) + `,`,
		`Guarantee:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Guarantee), "Resource", "mesos.Resource", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *QuotaConfig) String() string {
	if this == nil {
		return "nil"
	}
	keysForGuarantees := make([]string, 0, len(this.Guarantees))
	for k, _ := range this.Guarantees {
		keysForGuarantees = append(keysForGuarantees, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForGuarantees)
	mapStringForGuarantees := "map[string]mesos.Value_Scalar{"
	for _, k := range keysForGuarantees {
		mapStringForGuarantees += fmt.Sprintf("%v: %v,", k, this.Guarantees[k])
	}
	mapStringForGuarantees += "}"
	keysForLimits := make([]string, 0, len(this.Limits))
	for k, _ := range this.Limits {
		keysForLimits = append(keysForLimits, k)
	}
	github_com_gogo_protobuf_sortkeys.Strings(keysForLimits)
	mapStringForLimits := "map[string]mesos.Value_Scalar{"
	for _, k := range keysForLimits {
		mapStringForLimits += fmt.Sprintf("%v: %v,", k, this.Limits[k])
	}
	mapStringForLimits += "}"
	s := strings.Join([]string{`&QuotaConfig{`,
		`Role:` + fmt.Sprintf("%v", this.Role) + `,`,
		`Guarantees:` + mapStringForGuarantees + `,`,
		`Limits:` + mapStringForLimits + `,`,
		`}`,
	}, "")
	return s
}
func (this *QuotaStatus) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&QuotaStatus{`,
		`Infos:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Infos), "QuotaInfo", "QuotaInfo", 1), `&`, ``, 1) + `,`,
		`Configs:` + strings.Replace(strings.Replace(fmt.Sprintf("%v", this.Configs), "QuotaConfig", "QuotaConfig", 1), `&`, ``, 1) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringQuota(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *QuotaInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Role = &s
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Principal", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Principal = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Guarantee", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Guarantee = append(m.Guarantee, mesos.Resource{})
			if err := m.Guarantee[len(m.Guarantee)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Force", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Force = &b
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Role = &s
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Guarantee", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Guarantee = append(m.Guarantee, mesos.Resource{})
			if err := m.Guarantee[len(m.Guarantee)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaConfig) Unmarshal(dAtA []byte) error {
	var hasFields [1]uint64
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Role", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Role = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Guarantees", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthQuota
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(dAtA[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			if m.Guarantees == nil {
				m.Guarantees = make(map[string]mesos.Value_Scalar)
			}
			if iNdEx < postIndex {
				var valuekey uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowQuota
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					valuekey |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				var mapmsglen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowQuota
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					mapmsglen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if mapmsglen < 0 {
					return ErrInvalidLengthQuota
				}
				postmsgIndex := iNdEx + mapmsglen
				if mapmsglen < 0 {
					return ErrInvalidLengthQuota
				}
				if postmsgIndex > l {
					return io.ErrUnexpectedEOF
				}
				mapvalue := &mesos.Value_Scalar{}
				if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
					return err
				}
				iNdEx = postmsgIndex
				m.Guarantees[mapkey] = *mapvalue
			} else {
				var mapvalue mesos.Value_Scalar
				m.Guarantees[mapkey] = mapvalue
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limits", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var keykey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				keykey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			var stringLenmapkey uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLenmapkey |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLenmapkey := int(stringLenmapkey)
			if intStringLenmapkey < 0 {
				return ErrInvalidLengthQuota
			}
			postStringIndexmapkey := iNdEx + intStringLenmapkey
			if postStringIndexmapkey > l {
				return io.ErrUnexpectedEOF
			}
			mapkey := string(dAtA[iNdEx:postStringIndexmapkey])
			iNdEx = postStringIndexmapkey
			if m.Limits == nil {
				m.Limits = make(map[string]mesos.Value_Scalar)
			}
			if iNdEx < postIndex {
				var valuekey uint64
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowQuota
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					valuekey |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				var mapmsglen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowQuota
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					mapmsglen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if mapmsglen < 0 {
					return ErrInvalidLengthQuota
				}
				postmsgIndex := iNdEx + mapmsglen
				if mapmsglen < 0 {
					return ErrInvalidLengthQuota
				}
				if postmsgIndex > l {
					return io.ErrUnexpectedEOF
				}
				mapvalue := &mesos.Value_Scalar{}
				if err := mapvalue.Unmarshal(dAtA[iNdEx:postmsgIndex]); err != nil {
					return err
				}
				iNdEx = postmsgIndex
				m.Limits[mapkey] = *mapvalue
			} else {
				var mapvalue mesos.Value_Scalar
				m.Limits[mapkey] = mapvalue
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("role")
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QuotaStatus) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QuotaStatus: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QuotaStatus: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Infos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Infos = append(m.Infos, QuotaInfo{})
			if err := m.Infos[len(m.Infos)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Configs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthQuota
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Configs = append(m.Configs, QuotaConfig{})
			if err := m.Configs[len(m.Configs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipQuota(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthQuota
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipQuota(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowQuota
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowQuota
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthQuota
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowQuota
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipQuota(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthQuota = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowQuota   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("quota/quota.proto", fileDescriptorQuota) }

var fileDescriptorQuota = []byte{
	// 478 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x52, 0x31, 0x6f, 0xd4, 0x30,
	0x14, 0x8e, 0x73, 0x4d, 0x21, 0x2f, 0x48, 0x05, 0x23, 0xa1, 0xe8, 0x40, 0xa6, 0x3a, 0x31, 0x1c,
	0x43, 0x13, 0x28, 0x0c, 0x55, 0xc7, 0xab, 0x10, 0x42, 0x42, 0x95, 0x48, 0x25, 0x06, 0x36, 0x5f,
	0xe4, 0x04, 0x8b, 0x5c, 0x7c, 0xb5, 0x9d, 0x4a, 0x1d, 0x90, 0xf8, 0x09, 0xfc, 0x0c, 0x7e, 0x02,
	0x23, 0x63, 0xc7, 0x8e, 0x4c, 0xd0, 0x98, 0x85, 0xb1, 0x23, 0x23, 0x8a, 0x9d, 0x5e, 0x23, 0x50,
	0x17, 0x58, 0xac, 0xe7, 0x2f, 0xdf, 0xfb, 0xbe, 0xf7, 0x3e, 0x07, 0x6e, 0x1d, 0x36, 0x42, 0xd3,
	0xd4, 0x9e, 0xc9, 0x52, 0x0a, 0x2d, 0x70, 0xb4, 0x60, 0x4a, 0xa8, 0xc4, 0x42, 0xe3, 0x47, 0x25,
	0xd7, 0x6f, 0x9b, 0x79, 0x92, 0x8b, 0x45, 0x6a, 0x71, 0x77, 0x6e, 0x95, 0x22, 0xa5, 0x4b, 0x9e,
	0x1e, 0x3d, 0x4e, 0x2b, 0x3e, 0x77, 0x98, 0x6b, 0x1f, 0x6f, 0x0d, 0x3a, 0x4a, 0x51, 0x8a, 0xd4,
	0xc2, 0xf3, 0xa6, 0xb0, 0x37, 0x7b, 0xb1, 0x95, 0xa3, 0x4f, 0x24, 0x84, 0xaf, 0x3a, 0xa7, 0x17,
	0x75, 0x21, 0x30, 0x86, 0x35, 0x29, 0x2a, 0x16, 0xa3, 0x4d, 0x34, 0x0d, 0x33, 0x5b, 0xe3, 0x7b,
	0x10, 0x2e, 0x25, 0xaf, 0x73, 0xbe, 0xa4, 0x55, 0xec, 0xdb, 0x0f, 0x97, 0x00, 0x7e, 0x02, 0x61,
	0xd9, 0x50, 0x49, 0x6b, 0xcd, 0x58, 0x3c, 0xda, 0x1c, 0x4d, 0xa3, 0xed, 0x8d, 0xc4, 0x8d, 0x93,
	0x31, 0x25, 0x1a, 0x99, 0xb3, 0xd9, 0xda, 0xc9, 0xb7, 0xfb, 0x5e, 0x76, 0xc9, 0x9b, 0x68, 0xb8,
	0x61, 0x3d, 0x33, 0x76, 0xd8, 0x30, 0xa5, 0xf1, 0x5d, 0x08, 0x0a, 0x21, 0x73, 0xe7, 0x7b, 0x7d,
	0x37, 0x28, 0x68, 0xa5, 0x58, 0xe6, 0xb0, 0xd5, 0x4c, 0xfe, 0x60, 0xa6, 0x7f, 0x72, 0xfd, 0xee,
	0x43, 0x64, 0x6d, 0xf7, 0x44, 0x5d, 0xf0, 0x12, 0xc7, 0xab, 0x65, 0xfd, 0x69, 0xd8, 0xd3, 0x9d,
	0xfc, 0x3e, 0xc0, 0xaa, 0x4d, 0xc5, 0xbe, 0xd5, 0x9f, 0x26, 0x83, 0x67, 0x49, 0x06, 0x3a, 0xc9,
	0xf3, 0x15, 0xf5, 0x59, 0xad, 0xe5, 0x71, 0xaf, 0x34, 0x50, 0xc0, 0x33, 0x58, 0xaf, 0xf8, 0x82,
	0x6b, 0xd5, 0xcf, 0xfa, 0xe0, 0x4a, 0xad, 0x97, 0x96, 0x36, 0xd4, 0xe9, 0x3b, 0xc7, 0x19, 0x6c,
	0xfc, 0x61, 0x84, 0x6f, 0xc2, 0xe8, 0x1d, 0x3b, 0xee, 0x1f, 0xab, 0x2b, 0xf1, 0x43, 0x08, 0x8e,
	0x68, 0xd5, 0xb8, 0xb0, 0xa2, 0xed, 0xdb, 0xbd, 0xcf, 0xeb, 0x0e, 0x4b, 0x0e, 0x72, 0x5a, 0x51,
	0x99, 0x39, 0xc6, 0xae, 0xbf, 0x83, 0xc6, 0xfb, 0x10, 0x0d, 0x0c, 0xff, 0x5b, 0x6f, 0xf2, 0xbe,
	0x0f, 0xf8, 0x40, 0x53, 0xdd, 0x28, 0xfc, 0x14, 0x02, 0x5e, 0x17, 0x42, 0xc5, 0xc8, 0x6e, 0x7d,
	0xe7, 0xef, 0xad, 0xbb, 0x9f, 0x6e, 0xb6, 0xde, 0xed, 0x19, 0xa3, 0xcc, 0x91, 0xf1, 0x0e, 0x5c,
	0xcb, 0x6d, 0x18, 0x17, 0xc9, 0xc7, 0x57, 0xa5, 0xd5, 0x27, 0x74, 0x41, 0x9f, 0xed, 0x9d, 0xb6,
	0xc4, 0xfb, 0xda, 0x12, 0xef, 0xac, 0x25, 0xe8, 0xbc, 0x25, 0xe8, 0x57, 0x4b, 0xd0, 0x07, 0x43,
	0xd0, 0x27, 0x43, 0xd0, 0x67, 0x43, 0xbc, 0x2f, 0x86, 0xa0, 0x13, 0x43, 0xd0, 0xa9, 0x21, 0xe8,
	0xcc, 0x10, 0xf4, 0xd3, 0x10, 0xef, 0xdc, 0x10, 0xf4, 0xf1, 0x07, 0xf1, 0xde, 0x04, 0x56, 0xff,
	0x77, 0x00, 0x00, 0x00, 0xff, 0xff, 0x3b, 0x00, 0xeb, 0x59, 0x91, 0x03, 0x00, 0x00,
}
