/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.interact;

import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\"\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\t2\b\b\u0002\u0010\u000b\u001a\u00020\tJ\"\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/letsPlot/core/interact/InteractionUtil;", "", "()V", "viewportFromScale", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "rect", "scale", "", "scaleOrigin", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "viewportFromTransform", "translate", "viewportToTransform", "Lkotlin/Pair;", "viewport", "plot-base"})
public final class InteractionUtil {
    @NotNull
    public static final InteractionUtil INSTANCE = new InteractionUtil();

    private InteractionUtil() {
    }

    @NotNull
    public final DoubleRectangle viewportFromTransform(@NotNull DoubleRectangle rect2, @NotNull DoubleVector scale, @NotNull DoubleVector translate) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        Intrinsics.checkNotNullParameter((Object)translate, (String)"translate");
        DoubleVector origin = rect2.getOrigin().subtract(translate);
        DoubleVector dimension = new DoubleVector(rect2.getDimension().getX() * (1.0 / scale.getX()), rect2.getDimension().getY() * (1.0 / scale.getY()));
        return new DoubleRectangle(origin, dimension);
    }

    public static /* synthetic */ DoubleRectangle viewportFromTransform$default(InteractionUtil interactionUtil, DoubleRectangle doubleRectangle, DoubleVector doubleVector, DoubleVector doubleVector2, int n, Object object) {
        if ((n & 2) != 0) {
            doubleVector = new DoubleVector(1.0, 1.0);
        }
        if ((n & 4) != 0) {
            doubleVector2 = DoubleVector.Companion.getZERO();
        }
        return interactionUtil.viewportFromTransform(doubleRectangle, doubleVector, doubleVector2);
    }

    @NotNull
    public final DoubleRectangle viewportFromScale(@NotNull DoubleRectangle rect2, double scale, @NotNull DoubleVector scaleOrigin) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)scaleOrigin, (String)"scaleOrigin");
        DoubleVector newDim = rect2.getDimension().mul(scale);
        DoubleVector newOrigin = rect2.getOrigin().add(scaleOrigin.subtract(rect2.getOrigin()).mul(1.0 - scale));
        return new DoubleRectangle(newOrigin, newDim);
    }

    @NotNull
    public final Pair<DoubleVector, DoubleVector> viewportToTransform(@NotNull DoubleRectangle rect2, @NotNull DoubleRectangle viewport) {
        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)viewport, (String)"viewport");
        DoubleVector translate = rect2.getOrigin().subtract(viewport.getOrigin());
        DoubleVector scale = new DoubleVector(rect2.getWidth() / viewport.getWidth(), rect2.getHeight() / viewport.getHeight());
        return TuplesKt.to((Object)scale, (Object)translate);
    }
}

