/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.intentions;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSDestructuringArray;
import com.intellij.lang.javascript.psi.JSDestructuringElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.JSVariableDeclaringScope;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiElementFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public class JSVariableInitializationExtractor {
    public static final TokenSet EXPORT_KEYWORD = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.EXPORT_KEYWORD});
    private final JSVarStatement myVarStatement;
    private final Set<JSVariable> myVariablesToExtract;
    private final Set<JSVariable> myVariablesToDelete;
    private final Set<JSVariable> myToBeConst;
    @Nullable
    private JSVarStatement.VarKeyword myNewKeyword;
    private boolean myNotApplicable;
    private Set<String> myNamedToSkip;

    public JSVariableInitializationExtractor(@NotNull List<JSVariable> variables, @NotNull JSVarStatement statement) {
        if (variables == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(1);
        }
        this(statement, variables.toArray(JSVariable.EMPTY_ARRAY));
    }

    public JSVariableInitializationExtractor(JSVariable ... variables) {
        if (variables == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(2);
        }
        this((JSVarStatement)null, variables);
    }

    public JSVariableInitializationExtractor(@Nullable JSVarStatement statement, JSVariable ... variables) {
        if (variables == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(3);
        }
        this.myToBeConst = new HashSet<JSVariable>();
        this.myNamedToSkip = Collections.emptySet();
        this.myVariablesToExtract = ContainerUtil.newHashSet((Object[])variables);
        for (JSVariable variable : variables) {
            if (variable.getParent() instanceof JSDestructuringArray) {
                this.myNotApplicable = true;
                this.myVariablesToExtract.clear();
                this.myVarStatement = null;
                this.myVariablesToDelete = null;
                return;
            }
            assert (variable.getParent() instanceof JSVarStatement);
            assert (statement == null || statement == variable.getParent());
            statement = (JSVarStatement)variable.getParent();
        }
        this.myVarStatement = statement;
        this.myVariablesToDelete = new HashSet<JSVariable>();
    }

    public JSVariableInitializationExtractor withNewKeyword(@NotNull JSVarStatement.VarKeyword keyword) {
        if (keyword == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(4);
        }
        this.myNewKeyword = keyword;
        return this;
    }

    public JSVariableInitializationExtractor withNamesToSkip(@NotNull Set<String> namesToSkip) {
        if (namesToSkip == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(5);
        }
        this.myNamedToSkip = namesToSkip;
        return this;
    }

    public void toBeConst(@NotNull Collection<JSVariable> collection) {
        if (collection == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(6);
        }
        this.myToBeConst.addAll(collection);
        this.myNewKeyword = JSVarStatement.VarKeyword.LET;
    }

    public void deleteExtracted(@NotNull Collection<JSVariable> collection) {
        if (collection == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(7);
        }
        this.myVariablesToDelete.addAll(collection);
    }

    public List<PsiElement> transform() {
        JSVarStatement transformationAnchor;
        if (this.myNotApplicable) {
            return Collections.emptyList();
        }
        FragmentsSplitter fragmentsSplitter = new FragmentsSplitter((Convertor<JSVariable, Boolean>)((Convertor)variable -> {
            boolean flag = this.myVariablesToExtract.contains(variable);
            if (flag && (variable.getInitializer() == null || this.myVariablesToDelete.contains(variable))) {
                return null;
            }
            return flag;
        }));
        JSVariable[] variables = this.myVarStatement.getVariables();
        fragmentsSplitter.split(variables);
        if (this.insideFor()) {
            JSInitializerOwner[] declarations = this.myVarStatement.getDeclarations();
            if (declarations.length > 1) {
                transformationAnchor = this.myVarStatement.getParent();
            } else {
                transformationAnchor = this.myVarStatement;
                if (declarations.length == 1 && this.insideFor()) {
                    if (!fragmentsSplitter.extractFlagList.get(0).booleanValue() || variables.length != 1) {
                        PsiElement keyword = this.myVarStatement.getNode().findChildByType(JSTokenTypes.VAR_MODIFIERS).getPsi();
                        if (keyword == null) {
                            return Collections.emptyList();
                        }
                        PsiElement replacementKeyword = this.createKeyword();
                        if (replacementKeyword == null) {
                            return Collections.emptyList();
                        }
                        return Collections.singletonList(keyword.replace(replacementKeyword));
                    }
                    JSVariable variable2 = this.myVarStatement.getVariables()[0];
                    if (variable2.getInitializer() != null) {
                        this.myVarStatement.replace((PsiElement)JSVariableInitializationExtractor.createInitializer(variable2).getExpression());
                        return Collections.singletonList(this.myVarStatement);
                    }
                    this.deleteOldVarStatement(null);
                    return Collections.emptyList();
                }
            }
        } else {
            transformationAnchor = this.myVarStatement;
        }
        ArrayList<PsiElement> addedElements = new ArrayList<PsiElement>();
        if (!fragmentsSplitter.isEmpty()) {
            fragmentsSplitter.iterate((PairConsumer<Boolean, List<JSVariable>>)((PairConsumer)(arg_0, arg_1) -> this.lambda$transform$2(addedElements, (PsiElement)transformationAnchor, arg_0, arg_1)));
            PsiElement extraWs = this.myVarStatement.getPrevSibling();
            if (extraWs instanceof PsiWhiteSpace && !addedElements.contains(extraWs)) {
                extraWs.delete();
            }
        }
        this.deleteOldVarStatement(addedElements);
        return addedElements;
    }

    private void deleteOldVarStatement(@Nullable List<PsiElement> addedElements) {
        PsiComment comment = JSDocumentationUtils.findDocComment((PsiElement)this.myVarStatement);
        if (comment != null && addedElements != null && !addedElements.isEmpty()) {
            this.moveComment(comment, addedElements);
        }
        this.myVarStatement.delete();
    }

    private void moveComment(@NotNull PsiComment comment, @Nullable List<PsiElement> addedElements) {
        if (comment == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(8);
        }
        PsiElement anchor = null;
        if (addedElements == null || addedElements.isEmpty()) {
            if (this.myVarStatement.getPrevSibling() != null) {
                anchor = PsiTreeUtil.getParentOfType((PsiElement)this.myVarStatement.getPrevSibling(), JSSourceElement.class);
            }
        } else {
            for (PsiElement element2 : addedElements) {
                if (!(element2 instanceof JSVarStatement)) continue;
                anchor = element2;
                break;
            }
            if (anchor == null) {
                anchor = PsiTreeUtil.getParentOfType((PsiElement)addedElements.get(0), JSSourceElement.class);
            }
        }
        if (anchor != null) {
            JSDocumentationUtils.moveJSDoc(comment, anchor);
        }
    }

    private PsiElement createKeyword() {
        JSVarStatement.VarKeyword keyword = this.determineKeyword();
        if (keyword == null) {
            return null;
        }
        JSStatement newSt = JSPsiElementFactory.createJSStatement(keyword.getText() + " a;", (PsiElement)this.myVarStatement);
        return newSt.getNode().findChildByType(JSTokenTypes.VAR_MODIFIERS).getPsi();
    }

    private boolean insideFor() {
        return this.myVarStatement.getParent() instanceof JSVariableDeclaringScope;
    }

    private void addDeclarations(PsiElement transformationAnchor, List<PsiElement> addedElements, List<JSVariable> fragment) {
        if (!this.myToBeConst.isEmpty()) {
            FragmentsSplitter fragmentsSplitter = new FragmentsSplitter((Convertor<JSVariable, Boolean>)((Convertor)this.myToBeConst::contains));
            fragmentsSplitter.split(fragment.toArray(JSVariable.EMPTY_ARRAY));
            fragmentsSplitter.iterate((PairConsumer<Boolean, List<JSVariable>>)((PairConsumer)(flag, innerFragment) -> {
                JSSourceElement statement = this.createLetStatement((List<JSVariable>)innerFragment, flag != false ? JSVarStatement.VarKeyword.CONST : JSVarStatement.VarKeyword.LET);
                addedElements.add(transformationAnchor.getParent().addBefore((PsiElement)statement, transformationAnchor));
            }));
        } else {
            addedElements.add(JSChangeUtil.doDoAddBefore(transformationAnchor.getParent(), (PsiElement)this.createLetStatement(fragment), transformationAnchor));
        }
    }

    private static JSExpressionStatement createInitializer(@NotNull JSVariable variable) {
        if (variable == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(9);
        }
        JSExpressionStatement st = JSPsiElementFactory.createJSStatement(variable.getName() + "= 1" + JSCodeStyleSettings.getSemicolon((PsiElement)variable), (PsiElement)variable, JSExpressionStatement.class);
        JSExpression expression = st.getExpression();
        assert (expression instanceof JSAssignmentExpression);
        ((JSAssignmentExpression)expression).getDefinitionExpression().getInitializer().replace(variable.getInitializer().copy());
        return st;
    }

    private JSSourceElement createLetStatement(@NotNull List<JSVariable> list) {
        if (list == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(10);
        }
        return this.createLetStatement(list, this.determineKeyword());
    }

    private JSSourceElement createLetStatement(@NotNull List<JSVariable> list, @NotNull JSVarStatement.VarKeyword keyword) {
        if (list == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(11);
        }
        if (keyword == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(12);
        }
        String attributes = JSVariableInitializationExtractor.computeAttributes(list);
        StringBuilder builder2 = new StringBuilder(attributes);
        builder2.append(keyword.getText()).append(' ');
        List<? extends JSInitializerOwner> declarations = this.computeDeclarations(list);
        for (int i = 0; i < declarations.size(); ++i) {
            JSInitializerOwner declaration;
            PsiElement copyTextFrom;
            if (i > 0) {
                builder2.append(',');
            }
            if ((copyTextFrom = PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)(declaration = declarations.get(i)))) != null) {
                copyTextFrom = copyTextFrom.getNextSibling();
            }
            if (i == 0) {
                while (copyTextFrom instanceof PsiWhiteSpace) {
                    copyTextFrom = copyTextFrom.getNextSibling();
                }
            }
            if (copyTextFrom != null) {
                JSVariableInitializationExtractor.appendSpacesFromBetween(copyTextFrom, (PsiElement)declaration, builder2);
            }
            builder2.append('a');
            PsiElement copyTextTo = PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)declaration);
            if (copyTextTo == null) continue;
            JSVariableInitializationExtractor.appendSpacesFromBetween(declaration.getNextSibling(), copyTextTo, builder2);
        }
        builder2.append(JSCodeStyleSettings.getSemicolon((PsiElement)this.myVarStatement));
        JSVarStatement statement = JSPsiElementFactory.createJSStatement(builder2.toString(), (PsiElement)this.myVarStatement, JSVarStatement.class);
        JSInitializerOwner[] placeholders = statement.getDeclarations();
        for (int i = 0; i < placeholders.length; ++i) {
            placeholders[i].replace((PsiElement)declarations.get(i));
        }
        return statement;
    }

    @NotNull
    private static String computeAttributes(@NotNull List<JSVariable> list) {
        if (list == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(13);
        }
        for (JSVariable variable : list) {
            String attributeList = JSVariableInitializationExtractor.getAttributeList(variable);
            if (attributeList == null) continue;
            String string = attributeList + " ";
            if (string == null) {
                JSVariableInitializationExtractor.$$$reportNull$$$0(14);
            }
            return string;
        }
        return "";
    }

    private @Unmodifiable @NotNull List<? extends JSInitializerOwner> computeDeclarations(@NotNull List<JSVariable> list) {
        Object[] declarations;
        if (list == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(15);
        }
        if (!ContainerUtil.exists((Object[])(declarations = this.myVarStatement.getDeclarations()), d -> d instanceof JSDestructuringElement)) {
            List<JSVariable> list2 = list;
            if (list2 == null) {
                JSVariableInitializationExtractor.$$$reportNull$$$0(16);
            }
            return list2;
        }
        List list3 = ContainerUtil.filter((Object[])this.myVarStatement.getDeclarations(), declaration -> declaration instanceof JSDestructuringElement && list.stream().anyMatch(e -> PsiTreeUtil.isAncestor((PsiElement)declaration, (PsiElement)e, (boolean)true)));
        if (list3 == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(17);
        }
        return list3;
    }

    private static void appendSpacesFromBetween(@Nullable PsiElement from, @NotNull PsiElement toExcluding, @NotNull StringBuilder builder2) {
        if (toExcluding == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(18);
        }
        if (builder2 == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(19);
        }
        for (PsiElement current = from; current != null && !current.equals(toExcluding); current = current.getNextSibling()) {
            builder2.append(current.getText());
        }
    }

    @Nullable
    private static String getAttributeList(@NotNull JSVariable variable) {
        JSAttributeList attributeList;
        if (variable == null) {
            JSVariableInitializationExtractor.$$$reportNull$$$0(20);
        }
        return (attributeList = variable.getAttributeList()) != null && !StringUtil.isEmptyOrSpaces((String)attributeList.getText()) ? attributeList.getText() : null;
    }

    private JSVarStatement.VarKeyword determineKeyword() {
        if (this.myNewKeyword != null) {
            return this.myNewKeyword;
        }
        JSVarStatement.VarKeyword keyword = this.myVarStatement.getVarKeyword();
        return keyword != null ? keyword : JSVarStatement.VarKeyword.LET;
    }

    private /* synthetic */ void lambda$transform$2(List addedElements, PsiElement transformationAnchor, Boolean flag, List fragment) {
        if (flag.booleanValue()) {
            for (JSVariable variable : fragment) {
                if (variable.getInitializer() == null || this.myNamedToSkip.contains(variable.getName())) continue;
                addedElements.add(transformationAnchor.getParent().addBefore((PsiElement)JSVariableInitializationExtractor.createInitializer(variable), transformationAnchor));
            }
        } else {
            List filtered = ContainerUtil.filter((Collection)fragment, e -> !this.myNamedToSkip.contains(e.getName()));
            if (!filtered.isEmpty()) {
                this.addDeclarations(transformationAnchor, addedElements, filtered);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 4: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesToSkip";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 9: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toExcluding";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeAttributes";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDeclarations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withNewKeyword";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "withNamesToSkip";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "toBeConst";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deleteExtracted";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "moveComment";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createInitializer";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createLetStatement";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeAttributes";
                break;
            }
            case 14: 
            case 16: 
            case 17: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeDeclarations";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "appendSpacesFromBetween";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 16, 17 -> new IllegalStateException(string);
        };
    }

    private static final class FragmentsSplitter {
        @NotNull
        private final Convertor<JSVariable, Boolean> convertor;
        private final List<Boolean> extractFlagList;
        private final List<List<JSVariable>> fragments;

        private FragmentsSplitter(@NotNull Convertor<JSVariable, Boolean> convertor) {
            if (convertor == null) {
                FragmentsSplitter.$$$reportNull$$$0(0);
            }
            this.extractFlagList = new ArrayList<Boolean>();
            this.fragments = new ArrayList<List<JSVariable>>();
            this.convertor = convertor;
        }

        public void split(JSVariable[] variables) {
            ArrayList<JSVariable> current = new ArrayList<JSVariable>();
            boolean currentFlag = false;
            for (JSVariable variable : variables) {
                Boolean futureFlag = (Boolean)this.convertor.convert((Object)variable);
                if (futureFlag == null) continue;
                if (futureFlag != currentFlag) {
                    if (!current.isEmpty()) {
                        this.extractFlagList.add(currentFlag);
                        this.fragments.add(current);
                        current = new ArrayList();
                    }
                    currentFlag = futureFlag;
                }
                current.add(variable);
            }
            if (!current.isEmpty()) {
                this.extractFlagList.add(currentFlag);
                this.fragments.add(current);
            }
            assert (this.fragments.size() == this.extractFlagList.size());
        }

        public void iterate(@NotNull PairConsumer<Boolean, List<JSVariable>> consumer) {
            if (consumer == null) {
                FragmentsSplitter.$$$reportNull$$$0(1);
            }
            for (int i = 0; i < this.fragments.size(); ++i) {
                List<JSVariable> fragment = this.fragments.get(i);
                boolean flag = this.extractFlagList.get(i);
                consumer.consume((Object)flag, fragment);
            }
        }

        public boolean isEmpty() {
            return this.fragments.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "convertor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consumer";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/intentions/JSVariableInitializationExtractor$FragmentsSplitter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "iterate";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

