/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.codeInsight.popularPackages;

import com.google.gson.stream.JsonReader;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.reference.SoftReference;
import com.intellij.util.TimeoutUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public final class PopularNodePackagesProvider {
    private static final Logger LOG = Logger.getInstance(PopularNodePackagesProvider.class);
    private static final String FILE_NAME = "popular-node-packages.json";
    private static final PopularNodePackagesProvider INSTANCE = new PopularNodePackagesProvider();
    private volatile WeakReference<List<NodePackageBasicInfo>> myInfosRef;

    @NotNull
    public static PopularNodePackagesProvider getInstance() {
        PopularNodePackagesProvider popularNodePackagesProvider = INSTANCE;
        if (popularNodePackagesProvider == null) {
            PopularNodePackagesProvider.$$$reportNull$$$0(0);
        }
        return popularNodePackagesProvider;
    }

    @NotNull
    public List<NodePackageBasicInfo> findByPrefix(@NotNull String prefix, int limit, @NotNull Predicate<NodePackageBasicInfo> filter2) {
        List<NodePackageBasicInfo> infos;
        if (prefix == null) {
            PopularNodePackagesProvider.$$$reportNull$$$0(1);
        }
        if (filter2 == null) {
            PopularNodePackagesProvider.$$$reportNull$$$0(2);
        }
        if ((infos = (List<NodePackageBasicInfo>)SoftReference.dereference(this.myInfosRef)) == null) {
            try {
                long startTime = System.nanoTime();
                infos = PopularNodePackagesProvider.parse();
                LOG.info("Popular node package list loaded in " + TimeoutUtil.getDurationMillis((long)startTime) + " ms");
            }
            catch (IOException e) {
                LOG.warn("Cannot parse popular node package list from popular-node-packages.json", (Throwable)e);
                infos = Collections.emptyList();
            }
            this.myInfosRef = new WeakReference<List<NodePackageBasicInfo>>(infos);
        }
        ArrayList<NodePackageBasicInfo> result2 = new ArrayList<NodePackageBasicInfo>();
        for (NodePackageBasicInfo info : infos) {
            if (!info.getName().startsWith(prefix) || !filter2.test(info)) continue;
            result2.add(info);
            if (result2.size() < limit) continue;
            break;
        }
        ArrayList<NodePackageBasicInfo> arrayList = result2;
        if (arrayList == null) {
            PopularNodePackagesProvider.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @NotNull
    static List<NodePackageBasicInfo> parse() throws IOException {
        InputStream stream = PopularNodePackagesProvider.class.getResourceAsStream(FILE_NAME);
        if (stream == null) {
            throw new IOException("NodeJS plugin installation is possibly broken. Cannot find popular-node-packages.json");
        }
        List<NodePackageBasicInfo> list = PopularNodePackagesProvider.doParse(new JsonReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8)));
        List<NodePackageBasicInfo> list2 = list;
        if (list2 == null) {
            PopularNodePackagesProvider.$$$reportNull$$$0(4);
        }
        return list2;
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    LOG.error("Failed to close stream", (Throwable)e);
                }
            }
        }
    }

    @NotNull
    private static List<NodePackageBasicInfo> doParse(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            PopularNodePackagesProvider.$$$reportNull$$$0(5);
        }
        reader.beginArray();
        ArrayList<NodePackageBasicInfo> result2 = new ArrayList<NodePackageBasicInfo>();
        while (reader.hasNext()) {
            reader.beginArray();
            String name = null;
            String description = null;
            if (reader.hasNext()) {
                name = reader.nextString();
            }
            if (reader.hasNext()) {
                description = reader.nextString();
            }
            while (reader.hasNext()) {
                reader.skipValue();
            }
            reader.endArray();
            if (name == null) continue;
            result2.add(new NodePackageBasicInfo(name, description));
        }
        reader.endArray();
        ArrayList<NodePackageBasicInfo> arrayList = result2;
        if (arrayList == null) {
            PopularNodePackagesProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/codeInsight/popularPackages/PopularNodePackagesProvider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/codeInsight/popularPackages/PopularNodePackagesProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "findByPrefix";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "parse";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doParse";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findByPrefix";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doParse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5 -> new IllegalArgumentException(string);
        };
    }
}

