/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgres.plan;

import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.ReusableSmartStatement;
import com.intellij.database.dialects.base.plan.RawPlanData;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.database.remote.jdbc.RemoteResultSet;
import com.intellij.util.ThrowableConsumer;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class PgRawPlanData
extends RawPlanData {
    public String json;

    @Override
    public void load(@NotNull DatabaseConnectionCore connection, final @NotNull String statement, final boolean run2) {
        if (connection == null) {
            PgRawPlanData.$$$reportNull$$$0(0);
        }
        if (statement == null) {
            PgRawPlanData.$$$reportNull$$$0(1);
        }
        this.json = null;
        PgRawPlanData.useStatementWithPreserved(connection, (RawPlanData.ResourceUser<? super ReusableSmartStatement<String>>)new RawPlanData.ResourceUser<ReusableSmartStatement<String>>(){

            @Override
            public void use(ReusableSmartStatement<String> s) throws PlanRetrievalException, SQLException {
                s.noisy().execute("EXPLAIN (FORMAT JSON" + (run2 ? ", ANALYSE" : "") + ") " + statement, PgRawPlanData.processing((ThrowableConsumer<? super RemoteResultSet, ? extends Exception>)rs -> {
                    if (!rs.next()) {
                        PgRawPlanData.failWithEmptyResultSetError();
                    }
                    if (rs.getMetaData().getColumnCount() != 1) {
                        throw new PlanRetrievalException("Database returned data in unknown format");
                    }
                    String res = rs.getString(1);
                    if (res == null) {
                        throw new PlanRetrievalException("Database returned null plan");
                    }
                    if (rs.next()) {
                        throw new PlanRetrievalException("Database returned too many data");
                    }
                    PgRawPlanData.this.json = res;
                }));
            }
        }, new RawPlanData.StateSaver[0]);
    }

    @Override
    public void load(@NotNull String dump) {
        if (dump == null) {
            PgRawPlanData.$$$reportNull$$$0(2);
        }
        this.json = dump;
    }

    @Override
    public String dump() {
        return this.json;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "connection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "statement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "dump";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/postgres/plan/PgRawPlanData";
        objectArray[2] = "load";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

