/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiRecursiveVisitor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Consumer;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.editor.toc.GenerateTableOfContentsAction;
import org.intellij.plugins.markdown.folding.MarkdownFoldingBuilder$HeaderRegionsBuildingVisitor$headersHierarchy$1$invokeSuspend$;
import org.intellij.plugins.markdown.folding.MarkdownFoldingBuilderKt;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownRecursiveElementVisitor;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownBlockQuote;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCodeFence;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownCompositePsiElementBase;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownFile;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDestination;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownParagraph;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownTable;
import org.intellij.plugins.markdown.lang.psi.util.PsiUtilsKt;
import org.intellij.plugins.markdown.settings.MarkdownCodeFoldingSettings;
import org.intellij.plugins.markdown.util.MarkdownPsiStructureUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J.\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J&\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0014R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001f"}, d2={"Lorg/intellij/plugins/markdown/folding/MarkdownFoldingBuilder;", "Lcom/intellij/lang/folding/CustomFoldingBuilder;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "settings", "Lorg/intellij/plugins/markdown/settings/MarkdownCodeFoldingSettings;", "getSettings", "()Lorg/intellij/plugins/markdown/settings/MarkdownCodeFoldingSettings;", "buildLanguageFoldRegions", "", "descriptors", "", "Lcom/intellij/lang/folding/FoldingDescriptor;", "root", "Lcom/intellij/psi/PsiElement;", "document", "Lcom/intellij/openapi/editor/Document;", "quick", "", "processTableOfContents", "file", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownFile;", "getLanguagePlaceholderText", "", "node", "Lcom/intellij/lang/ASTNode;", "range", "Lcom/intellij/openapi/util/TextRange;", "isRegionCollapsedByDefault", "HeaderRegionsBuildingVisitor", "intellij.markdown"})
@SourceDebugExtension(value={"SMAP\nMarkdownFoldingBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownFoldingBuilder.kt\norg/intellij/plugins/markdown/folding/MarkdownFoldingBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,211:1\n1#2:212\n*E\n"})
public final class MarkdownFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    private final MarkdownCodeFoldingSettings getSettings() {
        return MarkdownCodeFoldingSettings.Companion.getInstance();
    }

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        Intrinsics.checkNotNullParameter(descriptors, (String)"descriptors");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        if (root.getLanguage() != root.getContainingFile().getViewProvider().getBaseLanguage()) {
            return;
        }
        root.accept((PsiElementVisitor)new PsiRecursiveVisitor(this, descriptors, document){
            final /* synthetic */ MarkdownFoldingBuilder this$0;
            final /* synthetic */ List<FoldingDescriptor> $descriptors;
            final /* synthetic */ Document $document;
            {
                this.this$0 = $receiver;
                this.$descriptors = $descriptors;
                this.$document = $document;
            }

            public void visitElement(PsiElement element2) {
                Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
                super.visitElement(element2);
                IElementType iElementType = MarkdownElementTypes.FRONT_MATTER_HEADER;
                Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"FRONT_MATTER_HEADER");
                if (PsiUtilsKt.hasType(element2, iElementType)) {
                    this.addDescriptors(element2);
                }
                element2.acceptChildren((PsiElementVisitor)this);
            }

            public void visitList(MarkdownList list2) {
                Intrinsics.checkNotNullParameter((Object)list2, (String)"list");
                PsiElement parent = list2.getParent();
                this.addDescriptors((PsiElement)(parent instanceof MarkdownListItem ? (MarkdownCompositePsiElementBase)parent : (MarkdownCompositePsiElementBase)list2));
                super.visitList(list2);
            }

            public void visitLinkDestination(MarkdownLinkDestination linkDestination) {
                Intrinsics.checkNotNullParameter((Object)linkDestination, (String)"linkDestination");
                ASTNode aSTNode = linkDestination.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
                ASTNode node = aSTNode;
                FoldingDescriptor descriptor = new FoldingDescriptor(node, node.getTextRange(), null, "...", Boolean.valueOf(((MarkdownCodeFoldingSettings.State)MarkdownFoldingBuilder.access$getSettings(this.this$0).getState()).getCollapseLinks() && node.getTextLength() > 10), SetsKt.emptySet());
                this.$descriptors.add(descriptor);
                super.visitLinkDestination(linkDestination);
            }

            public void visitParagraph(MarkdownParagraph paragraph) {
                Intrinsics.checkNotNullParameter((Object)paragraph, (String)"paragraph");
                PsiElement parent = paragraph.getParent();
                if (parent instanceof MarkdownBlockQuote) {
                    PsiElement $this$childrenOfType$iv = parent;
                    boolean $i$f$childrenOfType = false;
                    List list2 = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)$this$childrenOfType$iv, MarkdownParagraph.class);
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getChildrenOfTypeAsList(...)");
                    if (list2.size() <= 1) {
                        return;
                    }
                }
                this.addDescriptors((PsiElement)paragraph);
                super.visitParagraph(paragraph);
            }

            public void visitTable(MarkdownTable table) {
                Intrinsics.checkNotNullParameter((Object)table, (String)"table");
                this.addDescriptors((PsiElement)table);
                super.visitTable(table);
            }

            public void visitBlockQuote(MarkdownBlockQuote blockQuote) {
                Intrinsics.checkNotNullParameter((Object)blockQuote, (String)"blockQuote");
                this.addDescriptors((PsiElement)blockQuote);
                super.visitBlockQuote(blockQuote);
            }

            public void visitCodeFence(MarkdownCodeFence codeFence) {
                Intrinsics.checkNotNullParameter((Object)codeFence, (String)"codeFence");
                this.addDescriptors((PsiElement)codeFence);
                super.visitCodeFence(codeFence);
            }

            private final void addDescriptors(PsiElement element2) {
                TextRange textRange = element2.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
                MarkdownFoldingBuilderKt.access$addDescriptors(element2, textRange, this.$descriptors, this.$document);
            }
        });
        HeaderRegionsBuildingVisitor headerVisitor = new HeaderRegionsBuildingVisitor((Function2<? super PsiElement, ? super TextRange, Unit>)((Function2)(arg_0, arg_1) -> MarkdownFoldingBuilder.buildLanguageFoldRegions$lambda$0(descriptors, document, arg_0, arg_1)));
        root.accept((PsiElementVisitor)headerVisitor);
        headerVisitor.processLastHeaderIfNeeded();
        if (root instanceof MarkdownFile) {
            this.processTableOfContents((MarkdownFile)root, document, descriptors);
        }
    }

    private final void processTableOfContents(MarkdownFile file, Document document, List<FoldingDescriptor> descriptors) {
        Sequence<TextRange> ranges = GenerateTableOfContentsAction.Manager.INSTANCE.findExistingTocs(file);
        FoldingGroup group = FoldingGroup.newGroup((String)"Table of contents");
        boolean shouldCollapse = ((MarkdownCodeFoldingSettings.State)MarkdownCodeFoldingSettings.Companion.getInstance().getState()).getCollapseTableOfContents();
        for (TextRange range : ranges) {
            FoldingDescriptor descriptor = new FoldingDescriptor((ASTNode)file.getNode(), range, group, MarkdownBundle.message("markdown.folding.table.of.contents.name", new Object[0]), Boolean.valueOf(shouldCollapse), SetsKt.emptySet());
            descriptors.add(descriptor);
        }
    }

    @NotNull
    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        Object object;
        block3: {
            String elementText;
            block2: {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)range, (String)"range");
                IElementType elementType = PsiUtilCore.getElementType((ASTNode)node);
                String explicitName = (String)MarkdownFoldingBuilderKt.access$getFoldedElementsPresentations$p().get(elementType);
                String string = StringUtil.shortenTextWithEllipsis((String)node.getText(), (int)30, (int)5);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
                elementText = string;
                object = explicitName;
                if (object == null) break block2;
                String it = object;
                boolean bl = false;
                String string2 = it + ": " + elementText;
                object = string2;
                if (string2 != null) break block3;
            }
            object = elementText;
        }
        return object;
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        IElementType iElementType = node.getElementType();
        return Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.LINK_DESTINATION) ? ((MarkdownCodeFoldingSettings.State)this.getSettings().getState()).getCollapseLinks() : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.FRONT_MATTER_HEADER) ? ((MarkdownCodeFoldingSettings.State)this.getSettings().getState()).getCollapseFrontMatter() : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.TABLE) ? ((MarkdownCodeFoldingSettings.State)this.getSettings().getState()).getCollapseTables() : (Intrinsics.areEqual((Object)iElementType, (Object)MarkdownElementTypes.CODE_FENCE) ? ((MarkdownCodeFoldingSettings.State)this.getSettings().getState()).getCollapseCodeFences() : false)));
    }

    private static final Unit buildLanguageFoldRegions$lambda$0(List $descriptors, Document $document, PsiElement header, TextRange range) {
        Intrinsics.checkNotNullParameter((Object)header, (String)"header");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        MarkdownFoldingBuilderKt.access$addDescriptors(header, range, $descriptors, $document);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ MarkdownCodeFoldingSettings access$getSettings(MarkdownFoldingBuilder $this) {
        return $this.getSettings();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B!\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\nH\u0016J\u0006\u0010\r\u001a\u00020\u0006J\u0012\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\n0\u000f*\u00020\u0004H\u0002J\u001a\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0002R \u0010\u0002\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/folding/MarkdownFoldingBuilder$HeaderRegionsBuildingVisitor;", "Lorg/intellij/plugins/markdown/lang/psi/MarkdownRecursiveElementVisitor;", "regionConsumer", "Lkotlin/Function2;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/util/TextRange;", "", "<init>", "(Lkotlin/jvm/functions/Function2;)V", "lastProcessedHeader", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownHeader;", "visitHeader", "header", "processLastHeaderIfNeeded", "headersHierarchy", "Lkotlin/sequences/Sequence;", "createRegionIfNeeded", "currentHeader", "regionEnd", "intellij.markdown"})
    private static final class HeaderRegionsBuildingVisitor
    extends MarkdownRecursiveElementVisitor {
        @NotNull
        private final Function2<PsiElement, TextRange, Unit> regionConsumer;
        @Nullable
        private MarkdownHeader lastProcessedHeader;

        public HeaderRegionsBuildingVisitor(@NotNull Function2<? super PsiElement, ? super TextRange, Unit> regionConsumer) {
            Intrinsics.checkNotNullParameter(regionConsumer, (String)"regionConsumer");
            this.regionConsumer = regionConsumer;
        }

        @Override
        public void visitHeader(@NotNull MarkdownHeader header) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            MarkdownPsiStructureUtil.processContainer((PsiElement)header, (Consumer<PsiElement>)((Consumer)HeaderRegionsBuildingVisitor::visitHeader$lambda$0), (Consumer<PsiElement>)((Consumer)arg_0 -> HeaderRegionsBuildingVisitor.visitHeader$lambda$1(this, header, arg_0)));
            this.lastProcessedHeader = header;
            super.visitHeader(header);
        }

        public final void processLastHeaderIfNeeded() {
            MarkdownHeader lastHeader = this.lastProcessedHeader;
            if (lastHeader != null) {
                PsiElement lastFileChild = lastHeader.getContainingFile().getLastChild();
                PsiElement regionEnd = Intrinsics.areEqual((Object)PsiUtilCore.getElementType((PsiElement)lastFileChild), (Object)MarkdownTokenTypes.EOL) ? MarkdownFoldingBuilderKt.access$skipNewLinesBackward(lastFileChild) : lastFileChild;
                Sequence<MarkdownHeader> headers = this.headersHierarchy((PsiElement)lastHeader);
                for (MarkdownHeader header : headers) {
                    this.createRegionIfNeeded(header, regionEnd);
                }
            }
        }

        private final Sequence<MarkdownHeader> headersHierarchy(PsiElement $this$headersHierarchy) {
            return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super MarkdownHeader>, Continuation<? super Unit>, Object>($this$headersHierarchy, null){
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                int I$1;
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ PsiElement $this_headersHierarchy;
                {
                    this.$this_headersHierarchy = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object $result) {
                    Object object;
                    MarkdownHeader header;
                    int level;
                    Iterator iterator;
                    int nextMaxLevel;
                    Sequence headers;
                    SequenceScope sequenceScope = (SequenceScope)this.L$0;
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            Sequence $this$filterIsInstance$iv = PsiTreeUtilKt.siblings((PsiElement)this.$this_headersHierarchy, (boolean)false, (boolean)true);
                            boolean $i$f$filterIsInstance = false;
                            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)HeaderRegionsBuildingVisitor$headersHierarchy$1$invokeSuspend$$inlined$filterIsInstance$1.INSTANCE);
                            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
                            headers = sequence;
                            nextMaxLevel = Integer.MAX_VALUE;
                            iterator = headers.iterator();
                            break;
                        }
                        case 1: {
                            level = this.I$1;
                            nextMaxLevel = this.I$0;
                            header = (MarkdownHeader)this.L$3;
                            iterator = (Iterator)this.L$2;
                            headers = (Sequence)this.L$1;
                            ResultKt.throwOnFailure((Object)$result);
                            object = $result;
                            break;
                        }
                        default: {
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }
                    }
                    while (iterator.hasNext()) {
                        void $this$sequence;
                        header = (MarkdownHeader)iterator.next();
                        if (nextMaxLevel <= 1) {
                            return Unit.INSTANCE;
                        }
                        level = header.getLevel();
                        if (level >= nextMaxLevel) continue;
                        nextMaxLevel = level;
                        this.L$0 = $this$sequence;
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)headers);
                        this.L$2 = iterator;
                        this.L$3 = SpillingKt.nullOutSpilledVariable((Object)header);
                        this.I$0 = nextMaxLevel;
                        this.I$1 = level;
                        this.label = 1;
                        object = $this$sequence.yield((Object)header, (Continuation)this);
                        if (object == object2) return object2;
                    }
                    return Unit.INSTANCE;
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(SequenceScope<? super MarkdownHeader> p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }));
        }

        private final void createRegionIfNeeded(MarkdownHeader currentHeader, PsiElement regionEnd) {
            if (regionEnd != null) {
                TextRange textRange = TextRange.create((int)currentHeader.getTextRange().getStartOffset(), (int)regionEnd.getTextRange().getEndOffset());
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
                TextRange range = textRange;
                this.regionConsumer.invoke((Object)currentHeader, (Object)range);
            }
        }

        private static final void visitHeader$lambda$0(PsiElement it) {
        }

        private static final void visitHeader$lambda$1(HeaderRegionsBuildingVisitor this$0, MarkdownHeader $header, PsiElement nextHeader) {
            PsiElement regionEnd = MarkdownFoldingBuilderKt.access$skipNewLinesBackward(nextHeader);
            this$0.createRegionIfNeeded($header, regionEnd);
        }
    }
}

