/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdba.sql;

import com.intellij.database.remote.jdba.sql.TextFileFragment;
import com.intellij.database.remote.jdba.sql.TextFragment;
import com.intellij.database.remote.jdba.util.StringOperator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlStatement {
    final int myRow;
    @NotNull
    final String mySourceText;
    @Nullable
    final String myName;
    @NotNull
    final String myDescription;

    protected SqlStatement(@NotNull TextFragment sourceFragment) {
        String mainDescriptionPart;
        if (sourceFragment == null) {
            SqlStatement.$$$reportNull$$$0(0);
        }
        this.mySourceText = sourceFragment.text;
        this.myRow = sourceFragment.row;
        if (sourceFragment instanceof TextFileFragment) {
            String name;
            TextFileFragment f = (TextFileFragment)sourceFragment;
            this.myName = name = f.getFragmentName();
            if (name == null) {
                name = "SQL fragment";
            }
            mainDescriptionPart = name + " from " + f.getTextName() + ':' + f.row + ':' + f.pos;
        } else {
            TextFragment f = sourceFragment;
            mainDescriptionPart = "SQL statement from " + f.getTextName() + ':' + f.row + ':' + f.pos;
            this.myName = null;
        }
        this.myDescription = mainDescriptionPart;
    }

    protected SqlStatement(@NotNull String sourceText) {
        if (sourceText == null) {
            SqlStatement.$$$reportNull$$$0(1);
        }
        this(sourceText, 1, null);
    }

    protected SqlStatement(@NotNull String sourceText, int row, @Nullable String statementName) {
        if (sourceText == null) {
            SqlStatement.$$$reportNull$$$0(2);
        }
        this(row, sourceText, statementName != null ? statementName : '@' + Integer.toString(row), statementName != null ? statementName : "SQL statement at row " + row);
    }

    protected SqlStatement(int row, @NotNull String sourceText, @Nullable String name, @NotNull String description) {
        if (sourceText == null) {
            SqlStatement.$$$reportNull$$$0(3);
        }
        if (description == null) {
            SqlStatement.$$$reportNull$$$0(4);
        }
        this.myRow = row;
        this.mySourceText = sourceText;
        this.myName = name;
        this.myDescription = description;
    }

    @NotNull
    public abstract SqlStatement rewrite(@NotNull StringOperator var1);

    public int getRow() {
        return this.myRow;
    }

    @NotNull
    public String getSourceText() {
        String string = this.mySourceText;
        if (string == null) {
            SqlStatement.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getDescription() {
        String string = this.myDescription;
        if (string == null) {
            SqlStatement.$$$reportNull$$$0(6);
        }
        return string;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        if (this.myName != null) {
            b.append(this.myName).append(": ");
        }
        b.append(this.myDescription).append(":\n");
        b.append(this.mySourceText);
        return b.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFragment";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/remote/jdba/sql/SqlStatement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/remote/jdba/sql/SqlStatement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

