/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.util;

import com.intellij.mcpserver.util.TruncateMode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\u0000\u001a\u00020\u0001\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\t\u001a\u00020\n*\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\n\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"truncatedMarker", "", "maxTextLength", "", "truncateText", "text", "maxLinesCount", "truncateMode", "Lcom/intellij/mcpserver/util/TruncateMode;", "getWholeLinesTextRange", "Lcom/intellij/openapi/util/TextRange;", "Lcom/intellij/openapi/editor/Document;", "linesRange", "Lkotlin/ranges/IntRange;", "range", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\ntext.util.kt\nKotlin\n*S Kotlin\n*F\n+ 1 text.util.kt\ncom/intellij/mcpserver/util/Text_utilKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class Text_utilKt {
    @NotNull
    public static final String truncatedMarker = "<<<...content truncated...>>>";
    public static final int maxTextLength = 65536;

    @NotNull
    public static final String truncateText(@NotNull String text, int maxLinesCount, int maxTextLength, @NotNull TruncateMode truncateMode, @NotNull String truncatedMarker) {
        String truncatedByLinesText;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)((Object)truncateMode), (String)"truncateMode");
        Intrinsics.checkNotNullParameter((Object)truncatedMarker, (String)"truncatedMarker");
        if (!(maxLinesCount > 2)) {
            boolean $i$a$-require-Text_utilKt$truncateText$22 = false;
            String $i$a$-require-Text_utilKt$truncateText$22 = "maxLinesCount must be greater than 2";
            throw new IllegalArgumentException($i$a$-require-Text_utilKt$truncateText$22.toString());
        }
        String[] $i$a$-require-Text_utilKt$truncateText$22 = new String[]{"\n"};
        List lines = StringsKt.split$default((CharSequence)text, (String[])$i$a$-require-Text_utilKt$truncateText$22, (boolean)false, (int)0, (int)6, null);
        if (lines.size() <= maxLinesCount) {
            v0 = text;
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[truncateMode.ordinal()]) {
                case 1: {
                    v0 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.take((Iterable)lines, (int)(maxLinesCount - 1)), (Object)truncatedMarker), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                    break;
                }
                case 2: {
                    v0 = CollectionsKt.joinToString$default((Iterable)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)truncatedMarker), (Iterable)CollectionsKt.takeLast((List)lines, (int)(maxLinesCount - 1))), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                    break;
                }
                case 3: {
                    List startLines = CollectionsKt.take((Iterable)lines, (int)(maxLinesCount / 2));
                    List endLines = CollectionsKt.takeLast((List)lines, (int)(maxLinesCount / 2 - 1));
                    List strings = CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)startLines, (Object)truncatedMarker), (Iterable)endLines);
                    v0 = CollectionsKt.joinToString$default((Iterable)strings, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                    break;
                }
                default: {
                    v0 = truncatedByLinesText = text;
                }
            }
        }
        if (truncatedByLinesText.length() <= maxTextLength) {
            return truncatedByLinesText;
        }
        return StringsKt.take((String)truncatedByLinesText, (int)maxTextLength) + truncatedMarker;
    }

    public static /* synthetic */ String truncateText$default(String string, int n, int n2, TruncateMode truncateMode, String string2, int n3, Object object) {
        if ((n3 & 4) != 0) {
            n2 = 65536;
        }
        if ((n3 & 8) != 0) {
            truncateMode = TruncateMode.START;
        }
        if ((n3 & 0x10) != 0) {
            string2 = truncatedMarker;
        }
        return Text_utilKt.truncateText(string, n, n2, truncateMode, string2);
    }

    @NotNull
    public static final TextRange getWholeLinesTextRange(@NotNull Document $this$getWholeLinesTextRange, @NotNull IntRange linesRange) {
        Intrinsics.checkNotNullParameter((Object)$this$getWholeLinesTextRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)linesRange, (String)"linesRange");
        int startOffset = $this$getWholeLinesTextRange.getLineStartOffset(RangesKt.coerceIn((int)linesRange.getFirst(), (int)0, (int)($this$getWholeLinesTextRange.getLineCount() - 1)));
        int endOffset = $this$getWholeLinesTextRange.getLineEndOffset(RangesKt.coerceIn((int)linesRange.getLast(), (int)0, (int)($this$getWholeLinesTextRange.getLineCount() - 1)));
        return new TextRange(startOffset, endOffset);
    }

    @NotNull
    public static final TextRange getWholeLinesTextRange(@NotNull Document $this$getWholeLinesTextRange, @NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)$this$getWholeLinesTextRange, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        int startLine = $this$getWholeLinesTextRange.getLineNumber(range.getStartOffset());
        int endLine = $this$getWholeLinesTextRange.getLineNumber(range.getEndOffset());
        return Text_utilKt.getWholeLinesTextRange($this$getWholeLinesTextRange, new IntRange(startLine, endLine));
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TruncateMode.values().length];
            try {
                nArray[TruncateMode.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TruncateMode.END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TruncateMode.MIDDLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

