/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.generator;

import com.intellij.indexing.shared.generator.ErrorsCollector;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.FileBasedIndexEx;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import java.io.FileNotFoundException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/indexing/shared/generator/IndexedFileContentLoader;", "", "project", "Lcom/intellij/openapi/project/Project;", "errorsCollector", "Lcom/intellij/indexing/shared/generator/ErrorsCollector;", "noSizeLimitFileTypes", "", "Lcom/intellij/openapi/fileTypes/FileType;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/indexing/shared/generator/ErrorsCollector;Ljava/util/Set;)V", "createFileContent", "Lcom/intellij/util/indexing/FileContentImpl;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "shouldIgnoreTooLargeFile", "", "intellij.indexing.shared.generator"})
public final class IndexedFileContentLoader {
    @NotNull
    private final Project project;
    @NotNull
    private final ErrorsCollector errorsCollector;
    @NotNull
    private final Set<FileType> noSizeLimitFileTypes;

    public IndexedFileContentLoader(@NotNull Project project, @NotNull ErrorsCollector errorsCollector, @NotNull Set<? extends FileType> noSizeLimitFileTypes) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)errorsCollector, (String)"errorsCollector");
        Intrinsics.checkNotNullParameter(noSizeLimitFileTypes, (String)"noSizeLimitFileTypes");
        this.project = project;
        this.errorsCollector = errorsCollector;
        this.noSizeLimitFileTypes = noSizeLimitFileTypes;
    }

    @Nullable
    public final FileContentImpl createFileContent(@NotNull VirtualFile file) {
        FileContentImpl fileContentImpl;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.isValid() || this.shouldIgnoreTooLargeFile(file)) {
            return null;
        }
        try {
            FileContent fileContent = FileContentImpl.createByFile((VirtualFile)file, (Project)this.project);
            Intrinsics.checkNotNull((Object)fileContent, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileContentImpl");
            fileContentImpl = (FileContentImpl)fileContent;
        }
        catch (FileNotFoundException e) {
            this.errorsCollector.fileContentError(file, e);
            fileContentImpl = null;
        }
        catch (Exception e) {
            this.errorsCollector.fileContentError(file, e);
            fileContentImpl = null;
        }
        return fileContentImpl;
    }

    private final boolean shouldIgnoreTooLargeFile(VirtualFile file) {
        return FileBasedIndexEx.isTooLarge((VirtualFile)file, null, this.noSizeLimitFileTypes);
    }
}

