/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.internal.statistic.StructuredIdeActivity;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DistinctRootsCollections;
import com.jetbrains.plugins.webDeployment.ExecutionContext;
import com.jetbrains.plugins.webDeployment.ProjectDeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.TransferTask;
import com.jetbrains.plugins.webDeployment.UploadCheckinHandlerFactory;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.LoadFilesAction;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.statistic.DeploymentActivitiesUsageTriggerCollector;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Supplier;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UploadFilesAction
extends LoadFilesAction {
    private static final Logger LOG = Logger.getInstance(UploadFilesAction.class);

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    protected Supplier<String> getLoadHereMessage() {
        Supplier<String> supplier = WDBundle.messagePointer("action.title.upload.here", new Object[0]);
        if (supplier == null) {
            UploadFilesAction.$$$reportNull$$$0(0);
        }
        return supplier;
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Sentence)
    @NotNull
    protected Supplier<String> getLoadToServerMessage(WebServerGroupingWrap wrap) {
        Supplier<String> supplier = WDBundle.messagePointer("action.title.upload.to", wrap.getName());
        if (supplier == null) {
            UploadFilesAction.$$$reportNull$$$0(1);
        }
        return supplier;
    }

    @Override
    @Nls(capitalization=Nls.Capitalization.Title)
    @NotNull
    protected String getServerChooserTitle() {
        String string = WDBundle.message("choose.server.to.upload.to", new Object[0]);
        if (string == null) {
            UploadFilesAction.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected void execute(final @NotNull Project project, PublishConfig publishConfig2, @NotNull Deployable server, final Change[] changes, ChangeList[] changeLists, final FileObject[] remoteFiles, final @Nullable RemoteConnection connection, final Collection<VirtualFile> roots) {
        String title;
        if (project == null) {
            UploadFilesAction.$$$reportNull$$$0(3);
        }
        if (server == null) {
            UploadFilesAction.$$$reportNull$$$0(4);
        }
        if (changes != null) {
            title = changeLists != null && changeLists.length == 1 && changeLists[0].getChanges().size() == changes.length ? WDBundle.message("upload.changelist.to", changeLists[0].getName(), StringUtil.notNullize((String)server.getName())) : WDBundle.message("upload.changes.to", changes.length, changes.length == 1 ? 1 : 2, StringUtil.notNullize((String)server.getName()));
            AutoUploadComponent.saveDocumentsSilently(project, changes);
        } else if (roots != null) {
            title = WDBundle.message("upload.to", StringUtil.notNullize((String)server.getName()));
            AutoUploadComponent.saveDocumentsSilently(project, roots);
        } else {
            title = WDBundle.message("upload.to", StringUtil.notNullize((String)server.getName()));
            AutoUploadComponent.saveDocumentsSilently(project, UploadFilesAction.getLocalRoots(publishConfig2, remoteFiles, server));
        }
        TransferTask.ListBased transferTask = new TransferTask.ListBased(project, ConnectionOwnerFactory.createConnectionOwner(project), true, publishConfig2, server, title, true, true, true, ProjectDeploymentRevisionTracker.getInstance(project)){
            private StructuredIdeActivity myActivity;

            @Override
            @NotNull
            protected TransferTask.ListBased.ResultWithErrors buildOperationsList(ExecutionContext context) throws FileSystemException {
                if (changes != null) {
                    TransferTask.ListBased.ResultWithErrors resultWithErrors = UploadCheckinHandlerFactory.doScanFiles(context, Arrays.asList(changes), UploadFilesAction.isSpeculativeQuickUploadMode());
                    if (resultWithErrors == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return resultWithErrors;
                }
                if (roots != null) {
                    if (UploadFilesAction.isSpeculativeQuickUploadMode()) {
                        TransferTask.ListBased.ResultWithErrors resultWithErrors = DeploymentPathUtils.createSpeculativeUploadTransferOperations(context, roots);
                        if (resultWithErrors == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return resultWithErrors;
                    }
                    TransferTask.ListBased.ResultWithErrors resultWithErrors = PublishActionUtil.scanFiles(context, roots);
                    if (resultWithErrors == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return resultWithErrors;
                }
                LOG.assertTrue(remoteFiles != null);
                DistinctRootsCollections.FileObjects uploadRoots = new DistinctRootsCollections.FileObjects(remoteFiles);
                ArrayList<TransferOperation> result = new ArrayList<TransferOperation>();
                DeploymentPathUtils.ErrorsAndExclusions errors = new DeploymentPathUtils.ErrorsAndExclusions();
                if (UploadFilesAction.isSpeculativeQuickUploadMode()) {
                    TransferTask.ListBased.ResultWithErrors resultWithErrors = DeploymentPathUtils.createSpeculativeUploadTransferOperationsOnRemoteFiles(context, (Collection<FileObject>)((Object)uploadRoots));
                    if (resultWithErrors == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return resultWithErrors;
                }
                Iterator iterator = uploadRoots.iterator();
                while (iterator.hasNext()) {
                    FileObject uploadRoot = (FileObject)iterator.next();
                    DeploymentPathUtils.refreshRemoteFile(uploadRoot, context);
                    DeploymentPathUtils.ErrorsAndExclusions e = DeploymentPathUtils.processIncoming(uploadRoot, context, result);
                    errors.addAll(e);
                }
                return new TransferTask.ListBased.ResultWithErrors(result, errors);
            }

            @Override
            protected void assertAllExecuted(int totalProcessed, int failed) {
                if (UploadFilesAction.isSpeculativeQuickUploadMode()) {
                    return;
                }
                super.assertAllExecuted(totalProcessed, failed);
            }

            @Override
            protected RemoteConnection getExistingConnection() {
                return connection;
            }

            @Override
            protected void beforeTaskStarted() {
                this.myActivity = DeploymentActivitiesUsageTriggerCollector.logUploadBegan(project);
            }

            public void onFinished() {
                DeploymentActivitiesUsageTriggerCollector.logUploadFinished(this.myActivity);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction$1", "buildOperationsList"));
            }
        };
        FileTransferToolWindow.printWithTimestamp(project, server, title, ConsoleViewContentType.SYSTEM_OUTPUT, publishConfig2.getTraceLevel());
        ProgressManager.getInstance().run((Task)transferTask);
    }

    public static Collection<VirtualFile> getLocalRoots(PublishConfig publishConfig2, FileObject[] remoteFiles, Deployable server) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        DistinctRootsCollections.FileObjects remoteRoots = new DistinctRootsCollections.FileObjects(remoteFiles);
        Iterator iterator = remoteRoots.iterator();
        while (iterator.hasNext()) {
            FileObject remoteRoot = (FileObject)iterator.next();
            FileName name = remoteRoot.getName();
            DeploymentPathMapping parentMapping = (DeploymentPathMapping)publishConfig2.getNearestMappingDeploy2Local(name, false, (Mappable)server).getFirst();
            if (parentMapping != null) {
                UploadFilesAction.processMapping(result, name, server, parentMapping);
                continue;
            }
            Collection childMappings = (Collection)publishConfig2.getChildMappingsDeploy2Local(name, (Mappable)server).getFirst();
            for (DeploymentPathMapping childMapping : childMappings) {
                UploadFilesAction.processMapping(result, name, server, childMapping);
            }
        }
        return result;
    }

    private static void processMapping(@NotNull Collection<VirtualFile> result, @NotNull FileName remoteRootName, @NotNull Mappable server, @NotNull DeploymentPathMapping parentMapping) {
        VirtualFile localRoot;
        if (result == null) {
            UploadFilesAction.$$$reportNull$$$0(5);
        }
        if (remoteRootName == null) {
            UploadFilesAction.$$$reportNull$$$0(6);
        }
        if (server == null) {
            UploadFilesAction.$$$reportNull$$$0(7);
        }
        if (parentMapping == null) {
            UploadFilesAction.$$$reportNull$$$0(8);
        }
        if ((localRoot = LocalFileSystem.getInstance().findFileByPath(parentMapping.mapToLocalPath(remoteRootName, server))) != null && localRoot.isValid()) {
            result.add(localRoot);
        }
    }

    public static boolean isSpeculativeQuickUploadMode() {
        return Registry.is((String)"ide.deployment.use.speculatively.collecting.upload");
    }

    @Override
    protected boolean supportConfirmation() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 5, 6, 7, 8 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "server";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteRootName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadHereMessage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadToServerMessage";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerChooserTitle";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/actions/UploadFilesAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processMapping";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 5, 6, 7, 8 -> new IllegalArgumentException(string);
        };
    }
}

