/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.diff.merge.MergeResult;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ssh.AuthFailSshTransportException;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.SshException;
import com.intellij.ssh.interaction.ConnectionOwnerFactory;
import com.intellij.ssh.rsync.RsyncStatusService;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.io.HttpRequests;
import com.jetbrains.plugins.webDeployment.CustomFileSystemException;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.TransferOperation;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import java.awt.Component;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import javax.swing.JComponent;
import org.apache.commons.net.ftp.FTPConnectionClosedException;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystem;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.local.DefaultLocalFileProvider;
import org.apache.commons.vfs2.provider.local.LocalFileName;
import org.apache.commons.vfs2.provider.local.LocalFileSystem;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PublishUtils {
    private static final Logger LOG = Logger.getInstance(PublishUtils.class);
    public static final boolean DISABLE_FILESYSTEM_CACHE = Boolean.getBoolean("com.jetbrains.plugins.webDeployment.noCache");
    private static final long TEST_CONNECTION_POLL_TIMEOUT = 100L;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NlsSafe
    @Nullable
    public static String testConnection(Deployable server, JComponent parentComponent, @NlsContexts.ProgressTitle String title, boolean checkUrl) throws FileSystemException {
        Ref error = new Ref();
        @NlsSafe Ref homePath = new Ref();
        Runnable runnable = () -> {
            ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
            LOG.assertTrue(server.validateFast(false) == null);
            try {
                pi.setText(WDBundle.message("validating.server", new Object[0]));
                String e = server.validateSlow(-1L, false);
                if (e != null) {
                    error.set((Object)new CustomFileSystemException(e));
                    return;
                }
            }
            catch (TimeoutException e) {
                LOG.error((Throwable)e);
            }
            Semaphore done = new Semaphore();
            done.down();
            EventDispatcher forceDisconnectDispatcher = EventDispatcher.create(ForceDisconnectListener.class);
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    if (server.getAccessType().isProtocolBased()) {
                        pi.setText(WDBundle.message("connecting.by.0", server.getAccessType().getTitle()));
                        RemoteConnection connection = RemoteConnectionManager.getInstance().openConnection(ConnectionOwnerFactory.createConnectionOwner((Component)parentComponent), title, server, FileTransferConfig.Origin.Unchanged, (EventDispatcher<ForceDisconnectListener>)forceDisconnectDispatcher, pi);
                        try {
                            String rsyncError;
                            connection.executeServerOperation((ThrowableRunnable<? extends FileSystemException>)((ThrowableRunnable)() -> homePath.set((Object)connection.resolveRoot().getCurrentDir())), pi);
                            if (server.isUseRsync() && (rsyncError = RsyncStatusService.validateRsyncCommand()) != null) {
                                error.set((Object)new FileSystemException(rsyncError){

                                    public String getMessage() {
                                        return WDBundle.message("rsync.cannot.be.used", new Object[0]) + ": " + rsyncError;
                                    }
                                });
                            }
                        }
                        finally {
                            connection.release();
                        }
                    }
                    if (checkUrl) {
                        PublishUtils.doCheckUrl(server, pi);
                    }
                }
                catch (FileSystemException e) {
                    error.set((Object)e);
                }
                finally {
                    done.up();
                }
            });
            while (!done.waitFor(100L)) {
                if (!pi.isCanceled()) continue;
                ((ForceDisconnectListener)forceDisconnectDispatcher.getMulticaster()).forceDisconnect();
                break;
            }
        };
        boolean complete = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, title, true, null, parentComponent);
        if (!complete) {
            throw new ProcessCanceledException();
        }
        if (!error.isNull()) {
            throw (FileSystemException)((Object)error.get());
        }
        return (String)homePath.get();
    }

    private static void doCheckUrl(Deployable server, ProgressIndicator pi) throws FileSystemException {
        pi.setText(WDBundle.message("connecting.by.0", server.getUrl().startsWith("https:") ? "HTTPS" : "HTTP"));
        try {
            HttpRequests.request((String)DeploymentPathUtils.joinWebPath(server.getUrl(), "")).productNameAsUserAgent().tryConnect();
        }
        catch (IOException e) {
            throw new CustomFileSystemException(WDBundle.message("page.not.found", new Object[0]), e);
        }
    }

    @NlsContexts.NotificationContent
    @NotNull
    public static String getMessage(Throwable throwable, boolean full) {
        if (throwable instanceof TransferOperation.ParallelFilesUpload.CompositeFileSystemException) {
            StringBuilder stringBuilder = new StringBuilder();
            for (Throwable throwable2 : ((TransferOperation.ParallelFilesUpload.CompositeFileSystemException)((Object)throwable)).getAllExceptions()) {
                stringBuilder.append(PublishUtils.getMessage(throwable2, full));
                stringBuilder.append("\n");
            }
            String string = StringUtil.trimTrailing((String)stringBuilder.toString());
            if (string == null) {
                PublishUtils.$$$reportNull$$$0(0);
            }
            return string;
        }
        while (throwable.getCause() instanceof FileSystemException && throwable.getCause() != throwable) {
            throwable = throwable.getCause();
        }
        if (throwable.getCause() instanceof FTPConnectionClosedException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof FileSystemException && "vfs.provider/set-permissions.error".equals(((FileSystemException)throwable).getCode()) && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        String string = SshConnectionUtil.getMessage((Throwable)throwable, (boolean)full);
        if (string == null) {
            PublishUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    public static boolean isFatal(Throwable t) {
        while (t instanceof FileSystemException) {
            @NonNls String code = ((FileSystemException)t).getCode();
            if (code != null && code.contains("connect.error")) {
                return true;
            }
            if (t.getCause() == t) break;
            t = t.getCause();
        }
        return false;
    }

    public static boolean isProcessCanceledException(FileSystemException e) {
        return e.getCause() instanceof ProcessCanceledException;
    }

    private static boolean isAuthFail(Throwable throwable) {
        while (throwable.getCause() instanceof FileSystemException && throwable.getCause() != throwable) {
            throwable = throwable.getCause();
        }
        if (throwable.getCause() instanceof AuthFailSshTransportException) {
            return true;
        }
        if (throwable.getCause() instanceof SshException && "Auth fail".equals(throwable.getCause().getMessage())) {
            return true;
        }
        return throwable instanceof FileSystemException && "vfs.provider.ftp/login.error".equals(((FileSystemException)throwable).getCode());
    }

    public static void showLoginDialogAfterAuthFail(@NotNull Throwable throwable, @NotNull Deployable deployable) {
        if (throwable == null) {
            PublishUtils.$$$reportNull$$$0(2);
        }
        if (deployable == null) {
            PublishUtils.$$$reportNull$$$0(3);
        }
        if (!deployable.getAccessType().isProtocolBased() || deployable.isAnonymous() || !PublishUtils.isAuthFail(throwable)) {
            return;
        }
        AuthHelper.setDeployableToReAuth(deployable);
    }

    public static FileObject findFile(@NotNull RemoteConnection connection, @NotNull WebServerConfig.RemotePath remotePath, @NotNull Connectable connectable) throws FileSystemException {
        if (connection == null) {
            PublishUtils.$$$reportNull$$$0(4);
        }
        if (remotePath == null) {
            PublishUtils.$$$reportNull$$$0(5);
        }
        if (connectable == null) {
            PublishUtils.$$$reportNull$$$0(6);
        }
        if (connectable.getAccessType().isProtocolBased()) {
            return connection.resolveFile(remotePath.path);
        }
        String path = remotePath.path;
        if (SystemInfo.isWindows) {
            path = RemoteConnectionManager.getInstance().getManager().resolveFile(path).getName().getPath();
        }
        return connection.resolveFile(path);
    }

    public static FileName findRemoteFileName(@NotNull RemoteConnection connection, @NotNull WebServerConfig.RemotePath remotePath, @NotNull Connectable connectable) throws FileSystemException {
        if (connection == null) {
            PublishUtils.$$$reportNull$$$0(7);
        }
        if (remotePath == null) {
            PublishUtils.$$$reportNull$$$0(8);
        }
        if (connectable == null) {
            PublishUtils.$$$reportNull$$$0(9);
        }
        if (connectable.getAccessType().isProtocolBased()) {
            return connection.resolveFileName(remotePath.path);
        }
        String path = remotePath.path;
        if (SystemInfo.isWindows) {
            return RemoteConnectionManager.getInstance().getManager().resolveFile(path).getName();
        }
        return connection.resolveFileName(path);
    }

    public static @NotNull Function<MergeResult, @Nls(capitalization=Nls.Capitalization.Title) String> getMergeResolveCaptions() {
        Function function = result -> switch (result) {
            default -> throw new IncompatibleClassChangeError();
            case MergeResult.CANCEL -> null;
            case MergeResult.LEFT -> WDBundle.message("merge.on.upload.left.button", new Object[0]);
            case MergeResult.RIGHT -> WDBundle.message("merge.on.upload.right.button", new Object[0]);
            case MergeResult.RESOLVED -> WDBundle.message("merge.on.upload.ok.button", new Object[0]);
        };
        if (function == null) {
            PublishUtils.$$$reportNull$$$0(10);
        }
        return function;
    }

    public static boolean needsTransfer(@NotNull AccessType accessType) {
        if (accessType == null) {
            PublishUtils.$$$reportNull$$$0(11);
        }
        return accessType != AccessType.LOCAL;
    }

    @NlsContexts.Label
    public static String formatSize(float size, String bKey, String kbKey, String mbKey) {
        if (size < 1000.0f) {
            return WDBundle.message(bKey, Float.valueOf(size));
        }
        if (size < 1000000.0f) {
            return WDBundle.message(kbKey, Float.valueOf(size / 1000.0f));
        }
        return WDBundle.message(mbKey, Float.valueOf(size / 1000.0f / 1000.0f));
    }

    @Nls(capitalization=Nls.Capitalization.Sentence)
    @Nullable
    public static String validateUrl(@NonNls String url) {
        if (StringUtil.isEmptyOrSpaces((String)url) || "http://".equalsIgnoreCase(url)) {
            return WDBundle.message("url.is.empty", new Object[0]);
        }
        if (!(url = StringUtil.toLowerCase((String)url)).startsWith("http://") && !url.startsWith("https://")) {
            return WDBundle.message("url.is.invalid", new Object[0]);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6, 7, 8, 9, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/plugins/webDeployment/PublishUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deployable";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remotePath";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connectable";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/PublishUtils";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergeResolveCaptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showLoginDialogAfterAuthFail";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteFileName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "needsTransfer";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6, 7, 8, 9, 11 -> new IllegalArgumentException(string);
        };
    }

    public static class RefreshingLocalFileProvider
    extends DefaultLocalFileProvider {
        protected FileSystem doCreateFileSystem(@NotNull FileName name, FileSystemOptions fileSystemOptions) {
            if (name == null) {
                RefreshingLocalFileProvider.$$$reportNull$$$0(0);
            }
            LocalFileName rootName = (LocalFileName)name;
            return new LocalFileSystem((FileName)rootName, rootName.getRootFile(), fileSystemOptions){

                public synchronized FileObject resolveFile(@NotNull FileName name) throws FileSystemException {
                    if (name == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    FileObject file = super.resolveFile(name);
                    if (!DISABLE_FILESYSTEM_CACHE && file != null) {
                        file.refresh();
                    }
                    return file;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/plugins/webDeployment/PublishUtils$RefreshingLocalFileProvider$1", "resolveFile"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/jetbrains/plugins/webDeployment/PublishUtils$RefreshingLocalFileProvider", "doCreateFileSystem"));
        }
    }
}

