/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.navigation.plugins.facts.yaml;

import com.intellij.lang.puppet.ide.navigation.plugins.facts.PuppetFactDataIndexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.util.indexing.FileContent;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLValue;

final class YamlFactIndexer
implements PuppetFactDataIndexer {
    YamlFactIndexer() {
    }

    @NotNull
    public Map<String, Integer> map(@NotNull FileContent inputData) {
        PsiFile file;
        if (inputData == null) {
            YamlFactIndexer.$$$reportNull$$$0(0);
        }
        if (!((file = inputData.getPsiFile()) instanceof YAMLFile)) {
            Map<String, Integer> map = Collections.emptyMap();
            if (map == null) {
                YamlFactIndexer.$$$reportNull$$$0(1);
            }
            return map;
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        List yamlDocuments = ((YAMLFile)file).getDocuments();
        for (YAMLDocument document : yamlDocuments) {
            YAMLValue topValue = document.getTopLevelValue();
            if (!(topValue instanceof YAMLMapping)) continue;
            for (YAMLKeyValue keyValue : ((YAMLMapping)topValue).getKeyValues()) {
                String name = keyValue.getKeyText();
                result.put(name, keyValue.getTextOffset());
            }
        }
        HashMap<String, Integer> hashMap = result;
        if (hashMap == null) {
            YamlFactIndexer.$$$reportNull$$$0(2);
        }
        return hashMap;
    }

    @Override
    public boolean acceptsFile(@NotNull String fileName, @NotNull String parentDirName) {
        if (fileName == null) {
            YamlFactIndexer.$$$reportNull$$$0(3);
        }
        if (parentDirName == null) {
            YamlFactIndexer.$$$reportNull$$$0(4);
        }
        return parentDirName.equals("facts.d") && (StringUtil.endsWithIgnoreCase((String)fileName, (String)".yaml") || StringUtil.endsWithIgnoreCase((String)fileName, (String)".yml"));
    }

    @Override
    @NotNull
    public FileType getSuitableFileType() {
        YAMLFileType yAMLFileType = YAMLFileType.YML;
        if (yAMLFileType == null) {
            YamlFactIndexer.$$$reportNull$$$0(5);
        }
        return yAMLFileType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputData";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/navigation/plugins/facts/yaml/YamlFactIndexer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/navigation/plugins/facts/yaml/YamlFactIndexer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "map";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuitableFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "map";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5 -> new IllegalStateException(string);
        };
    }
}

