/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.ide.completion.providers;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.puppet.ide.completion.PuppetCompletionContributor;
import com.intellij.lang.puppet.ide.completion.PuppetLookupElements;
import com.intellij.lang.puppet.ide.libraries.PuppetLibraryUtil;
import com.intellij.lang.puppet.ide.navigation.plugins.facts.PuppetFactsIndex;
import com.intellij.lang.puppet.ide.navigation.plugins.ruby.PuppetRubyPluginsIndex;
import com.intellij.lang.puppet.psi.PuppetClassDefinition;
import com.intellij.lang.puppet.psi.PuppetDataType;
import com.intellij.lang.puppet.psi.PuppetDataTypeParameterInfo;
import com.intellij.lang.puppet.psi.PuppetDataTypes;
import com.intellij.lang.puppet.psi.PuppetDelegatingLightNamedElement;
import com.intellij.lang.puppet.psi.PuppetElementPatterns;
import com.intellij.lang.puppet.psi.PuppetPsiFileImpl;
import com.intellij.lang.puppet.psi.PuppetResourceDeclarationBase;
import com.intellij.lang.puppet.psi.PuppetResourceInstanceDeclaration;
import com.intellij.lang.puppet.psi.PuppetResourceLikeClassDescription;
import com.intellij.lang.puppet.psi.PuppetTypeDefinition;
import com.intellij.lang.puppet.psi.PuppetVariable;
import com.intellij.lang.puppet.psi.resolve.PuppetResolveUtil;
import com.intellij.lang.puppet.psi.resolve.PuppetVariableScopeProcessor;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetClassStubsIndex;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetFunctionsStubsIndex;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetResourceInstanceByTypeStubsIndex;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetTopLevelVariablesStubsIndex;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetTypeStubIndex;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class PuppetCompletionProviderBase
extends CompletionProvider<CompletionParameters>
implements PuppetElementPatterns {
    private static final Key<Boolean> STARTS_WITH_SEPARATOR = new Key("puppet.completion.separator");

    protected CompletionResultSet adjustPrefixMatcher(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        String text;
        int dummyIndex;
        if (parameters == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(1);
        }
        if (result == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(2);
        }
        if ((dummyIndex = (text = parameters.getPosition().getText()).indexOf(PuppetCompletionContributor.PUPPET_DUMMY_IDENTIFIER)) != -1) {
            text = text.substring(0, dummyIndex);
        }
        if (StringUtil.startsWith((CharSequence)text, (CharSequence)"::")) {
            text = text.substring("::".length());
            context.put(STARTS_WITH_SEPARATOR, (Object)true);
        }
        return result.withPrefixMatcher(text);
    }

    @NotNull
    private static PsiElement getScopeProvider(@NotNull CompletionParameters parameters) {
        PsiElement scopeProvider;
        if (parameters == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(3);
        }
        Object object = (scopeProvider = parameters.getOriginalPosition()) == null ? parameters.getOriginalFile() : scopeProvider;
        if (object == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(4);
        }
        return object;
    }

    protected static void fillWithClasses(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, boolean capitalize) {
        if (parameters == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(5);
        }
        if (result == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(6);
        }
        PsiElement scopeProvider = PuppetCompletionProviderBase.getScopeProvider(parameters);
        PuppetClassStubsIndex.getInstance().processAllElements(scopeProvider.getProject(), scopeProvider, classDefinition -> {
            LookupElement lookupElement = PuppetLookupElements.forClass(classDefinition, capitalize);
            if (lookupElement != null) {
                result.addElement(lookupElement);
            }
            return true;
        });
    }

    protected static void fillWithClassParameters(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(7);
        }
        if (context == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(8);
        }
        if (result == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(9);
        }
        if (context.get(STARTS_WITH_SEPARATOR) != null) {
            return;
        }
        PsiElement position = parameters.getPosition();
        PuppetResourceLikeClassDescription classDescription = (PuppetResourceLikeClassDescription)PsiTreeUtil.getParentOfType((PsiElement)position, PuppetResourceLikeClassDescription.class);
        if (classDescription == null) {
            return;
        }
        PsiElement scopeProvider = PuppetCompletionProviderBase.getScopeProvider(parameters);
        HashSet addedParameters = new HashSet();
        for (String className : classDescription.getNamesList()) {
            for (PuppetClassDefinition classDefinition : PuppetClassStubsIndex.getInstance().find(className, scopeProvider)) {
                classDefinition.processParametersDeclarations(parameterDeclaration -> {
                    String parameterName = parameterDeclaration.getName();
                    if (StringUtil.isNotEmpty((String)parameterName) && addedParameters.add(parameterName)) {
                        result.addElement((LookupElement)PuppetLookupElements.forExternalParameter(parameterName, "", parameterDeclaration));
                    }
                    return true;
                });
            }
        }
    }

    protected static void fillWithTypeParameters(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(10);
        }
        if (context == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(11);
        }
        if (result == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(12);
        }
        if (context.get(STARTS_WITH_SEPARATOR) != null) {
            return;
        }
        PsiElement position = parameters.getPosition();
        PuppetResourceDeclarationBase resourceDeclaration = (PuppetResourceDeclarationBase)PsiTreeUtil.getParentOfType((PsiElement)position, PuppetResourceDeclarationBase.class);
        if (resourceDeclaration == null) {
            return;
        }
        String typeName = resourceDeclaration.getEffectiveTypeName();
        if (StringUtil.isEmpty((String)typeName)) {
            return;
        }
        PuppetCompletionProviderBase.fillWithTypeParameters(typeName, parameters, context, result);
        if (!StringUtil.equals((CharSequence)typeName, (CharSequence)"stub__metaparams__")) {
            PuppetCompletionProviderBase.fillWithTypeParameters("stub__metaparams__", parameters, context, result);
        }
    }

    protected static void fillWithTypeParameters(@NotNull String typeName, @NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (typeName == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(13);
        }
        if (parameters == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(14);
        }
        if (context == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(15);
        }
        if (result == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(16);
        }
        if (context.get(STARTS_WITH_SEPARATOR) != null) {
            return;
        }
        PsiElement scopeProvider = PuppetCompletionProviderBase.getScopeProvider(parameters);
        boolean[] foundInRuby = new boolean[]{false};
        PuppetRubyPluginsIndex.processElementParameters(PuppetRubyPluginsIndex.SymbolType.TYPE, typeName, scopeProvider.getProject(), scopeProvider.getResolveScope(), (name, element) -> {
            foundInRuby[0] = true;
            result.addElement((LookupElement)PuppetLookupElements.forExternalParameter(name, "", element));
        });
        if (foundInRuby[0]) {
            return;
        }
        for (PuppetTypeDefinition typeDefinition : PuppetTypeStubIndex.getInstance().find(typeName, scopeProvider)) {
            typeDefinition.processParametersDeclarations(parameterDeclaration -> {
                String parameterName = parameterDeclaration.getName();
                if (StringUtil.isNotEmpty((String)parameterName)) {
                    result.addElement((LookupElement)PuppetLookupElements.forExternalParameter(parameterName, "", parameterDeclaration));
                }
                return true;
            });
        }
    }

    protected static void fillWithFunctions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(17);
        }
        if (context == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(18);
        }
        if (result == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(19);
        }
        if (context.get(STARTS_WITH_SEPARATOR) != null) {
            return;
        }
        PsiElement scopeProvider = PuppetCompletionProviderBase.getScopeProvider(parameters);
        Project project = scopeProvider.getProject();
        HashMap stubElements = new HashMap();
        HashSet foundNonStubNames = new HashSet();
        PuppetRubyPluginsIndex.processAllElements(PuppetRubyPluginsIndex.SymbolType.FUNCTION, project, scopeProvider.getResolveScope(), (name, element) -> {
            LookupElement lookupElement = PuppetLookupElements.forExternalFunction(name, element);
            if (PuppetLibraryUtil.isFunctionStubElement(element)) {
                stubElements.put(name, lookupElement);
            } else {
                foundNonStubNames.add(name);
                result.addElement(lookupElement);
            }
        });
        for (Map.Entry entry : stubElements.entrySet()) {
            if (foundNonStubNames.contains(entry.getKey())) continue;
            result.addElement((LookupElement)entry.getValue());
        }
        PuppetFunctionsStubsIndex.getInstance().processAllElements(project, scopeProvider, functionDefinition -> {
            String functionName = functionDefinition.getFullQualifiedName();
            assert (functionName != null);
            result.addElement(PuppetLookupElements.forExternalFunction(functionName, functionDefinition));
            return true;
        });
    }

    protected static void fillWithDataTypes(@NotNull CompletionResultSet result) {
        if (result == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(20);
        }
        for (String typeName : PuppetDataTypes.ALL_DATA_TYPES) {
            result.addElement(PuppetLookupElements.forDataType(typeName));
        }
    }

    protected static void fillWithResourceTypes(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result, boolean capitalize) {
        if (parameters == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(21);
        }
        if (context == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(22);
        }
        if (result == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(23);
        }
        boolean onlyPuppetDefined = context.get(STARTS_WITH_SEPARATOR) != null;
        PsiElement scopeProvider = PuppetCompletionProviderBase.getScopeProvider(parameters);
        HashSet rubyDefinedNames = new HashSet();
        if (!onlyPuppetDefined) {
            PuppetRubyPluginsIndex.processAllElements(PuppetRubyPluginsIndex.SymbolType.TYPE, scopeProvider.getProject(), scopeProvider.getResolveScope(), (name, element) -> {
                rubyDefinedNames.add(name);
                result.addElement(PuppetLookupElements.forTypeDefinition(element, name, capitalize));
            });
        }
        PuppetTypeStubIndex.getInstance().processAllElements(scopeProvider.getProject(), scopeProvider, typeDefinition -> {
            LookupElement lookupElement;
            String typeName = typeDefinition.getFullQualifiedName();
            boolean isInStubFile = PuppetPsiFileImpl.isInBuiltInStubsFile(typeDefinition);
            if (!(StringUtil.equals((CharSequence)typeName, (CharSequence)"stub__metaparams__") || rubyDefinedNames.contains(typeName) && isInStubFile || onlyPuppetDefined && isInStubFile || (lookupElement = PuppetLookupElements.forTypeDefinition(typeDefinition, capitalize)) == null)) {
                result.addElement(lookupElement);
            }
            return true;
        });
    }

    protected static void fillWithResourceInstancesByType(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result, String resourceType, boolean filterWords) {
        if (parameters == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(24);
        }
        if (result == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(25);
        }
        if (!filterWords) {
            result = result.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(result.getPrefixMatcher().getPrefix()));
        }
        for (PuppetResourceInstanceDeclaration instanceDeclaration : PuppetResourceInstanceByTypeStubsIndex.getInstance().find(resourceType, PuppetCompletionProviderBase.getScopeProvider(parameters))) {
            for (PuppetDelegatingLightNamedElement element : instanceDeclaration.getLightElementsList()) {
                LookupElement lookupElement = PuppetLookupElements.forResourceInstance(element, resourceType);
                if (lookupElement == null) continue;
                result.addElement(lookupElement);
            }
        }
    }

    protected static void fillWithVariables(@NotNull CompletionParameters parameters, boolean isFullQualified, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(26);
        }
        if (result == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(27);
        }
        if (isFullQualified) {
            PuppetCompletionProviderBase.fillWithFullQualifiedVariables(parameters, result);
        } else {
            PuppetCompletionProviderBase.fillWithNonFullQualifiedVariables(parameters, result);
        }
    }

    private static void fillWithFullQualifiedVariables(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(28);
        }
        if (result == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(29);
        }
        PsiElement scopeProvider = PuppetCompletionProviderBase.getScopeProvider(parameters);
        Project project = scopeProvider.getProject();
        PuppetCompletionProviderBase.fillWithClassesVariables(scopeProvider, result, 0);
        HashSet topLevelNamesSet = new HashSet();
        PuppetFactsIndex.processAllElements(project, scopeProvider.getResolveScope(), (name, fact) -> {
            topLevelNamesSet.add(name);
            result.addElement(PuppetLookupElements.forExternalFact(name, fact));
        });
        PuppetTopLevelVariablesStubsIndex.getInstance().processAllElements(project, scopeProvider, puppetVariable -> {
            LookupElementBuilder lookupElement;
            if ((!puppetVariable.isCoreFact() || topLevelNamesSet.add(puppetVariable.getName())) && (lookupElement = PuppetLookupElements.forVariable(puppetVariable, false)) != null) {
                result.addElement((LookupElement)lookupElement);
            }
            return true;
        });
    }

    private static void fillWithNonFullQualifiedVariables(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        HashSet<PsiElement> addedElements;
        PuppetVariableScopeProcessor completionProcessor;
        PsiElement scopeProvider;
        if (parameters == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(30);
        }
        if (result == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(31);
        }
        if (PuppetResolveUtil.treeWalkUp(scopeProvider = PuppetCompletionProviderBase.getScopeProvider(parameters), completionProcessor = new PuppetVariableScopeProcessor(addedElements = new HashSet<PsiElement>(), result){
            private final Set<String> myNamesSet = new HashSet<String>();
            final /* synthetic */ Set val$addedElements;
            final /* synthetic */ CompletionResultSet val$result;
            {
                this.val$addedElements = set;
                this.val$result = completionResultSet;
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                LookupElementBuilder lookupElement;
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (!(element instanceof PuppetVariable) || !((PuppetVariable)element).isDeclaration()) {
                    return true;
                }
                String name = ((PuppetVariable)element).getName();
                if (StringUtil.isEmpty((String)name)) {
                    return true;
                }
                if (this.myNamesSet.add(name) && (lookupElement = PuppetLookupElements.forVariable((PuppetVariable)element, false)) != null) {
                    this.val$addedElements.add(element);
                    this.val$result.addElement((LookupElement)lookupElement);
                }
                return true;
            }

            @Override
            public void executeWithName(@NotNull String name, @NotNull PsiElement element) {
                if (name == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (element == null) {
                    1.$$$reportNull$$$0(3);
                }
                this.val$addedElements.add(element);
                this.val$result.addElement(PuppetLookupElements.forExternalFact(name, element));
                this.myNamesSet.add(name);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/puppet/ide/completion/providers/PuppetCompletionProviderBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "executeWithName";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })) {
            PuppetResolveUtil.processTopScopeVariablesAndFacts(completionProcessor, scopeProvider);
        }
        PuppetCompletionProviderBase.fillWithClassesVariables(scopeProvider, result, -1, addedElements);
    }

    private static void fillWithClassesVariables(@NotNull PsiElement scopePosition, @NotNull CompletionResultSet resultSet, int weight) {
        if (scopePosition == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(32);
        }
        if (resultSet == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(33);
        }
        PuppetCompletionProviderBase.fillWithClassesVariables(scopePosition, resultSet, weight, null);
    }

    private static void fillWithClassesVariables(@NotNull PsiElement scopePosition, @NotNull CompletionResultSet resultSet, int weight, @Nullable Set<PsiElement> addedElements) {
        if (scopePosition == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(34);
        }
        if (resultSet == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(35);
        }
        PsiElementProcessor variableProcessor = puppetVariable -> {
            LookupElementBuilder lookupElement;
            if (!puppetVariable.isLexicalDeclaration() && (addedElements == null || addedElements.add(puppetVariable)) && (lookupElement = PuppetLookupElements.forVariable(puppetVariable, true)) != null) {
                resultSet.addElement(PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)weight));
            }
            return true;
        };
        PuppetClassStubsIndex.getInstance().processAllElements(scopePosition.getProject(), scopePosition, classDefinition -> classDefinition.processVariablesDeclarations(variableProcessor));
    }

    protected static void computeDataTypeCompletion(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result, boolean capitalize) {
        PsiElement nameElement;
        PuppetDataType containingType;
        if (parameters == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(36);
        }
        if (context == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(37);
        }
        if (result == null) {
            PuppetCompletionProviderBase.$$$reportNull$$$0(38);
        }
        if ((containingType = (PuppetDataType)PsiTreeUtil.getParentOfType((PsiElement)(nameElement = parameters.getPosition()), PuppetDataType.class)) == null) {
            return;
        }
        PuppetDataTypeParameterInfo info = containingType.getParameterInfo(nameElement.getParent());
        if (info == null) {
            return;
        }
        if (info.isResourceType()) {
            PuppetCompletionProviderBase.fillWithResourceTypes(parameters, context, result, capitalize);
        }
        if (info.isDataType()) {
            PuppetCompletionProviderBase.fillWithDataTypes(result);
        }
        if (info.isClass()) {
            PuppetCompletionProviderBase.fillWithClasses(parameters, result, capitalize);
        }
        if (info.isResourceInstance()) {
            PuppetCompletionProviderBase.fillWithResourceInstancesByType(parameters, result, info.getResourceDataType(), PsiUtilCore.getElementType((PsiElement)nameElement) == NAME);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: 
            case 8: 
            case 11: 
            case 15: 
            case 18: 
            case 22: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 12: 
            case 16: 
            case 19: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/puppet/ide/completion/providers/PuppetCompletionProviderBase";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopePosition";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/puppet/ide/completion/providers/PuppetCompletionProviderBase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScopeProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "adjustPrefixMatcher";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getScopeProvider";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillWithClasses";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillWithClassParameters";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fillWithTypeParameters";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "fillWithFunctions";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fillWithDataTypes";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "fillWithResourceTypes";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fillWithResourceInstancesByType";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fillWithVariables";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "fillWithFullQualifiedVariables";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "fillWithNonFullQualifiedVariables";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "fillWithClassesVariables";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "computeDataTypeCompletion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

