/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.css.actions;

import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.actions.CreateFileFromTemplateDialog;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssFileType;
import java.util.Comparator;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;

final class CreateStylesheetFileAction
extends CreateFileFromTemplateAction
implements DumbAware {
    private static final String LAST_SELECTED_TYPE_NAME = "list.type.of.created.stylesheet";

    CreateStylesheetFileAction() {
    }

    protected void buildDialog(@NotNull Project project, @NotNull PsiDirectory directory, @NotNull CreateFileFromTemplateDialog.Builder builder) {
        if (project == null) {
            CreateStylesheetFileAction.$$$reportNull$$$0(0);
        }
        if (directory == null) {
            CreateStylesheetFileAction.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            CreateStylesheetFileAction.$$$reportNull$$$0(2);
        }
        builder.setTitle(CssBundle.message("dialog.title.new.stylesheet", new Object[0]));
        TreeSet<FileType> fileTypes = new TreeSet<FileType>(new LastSelectedFileTypeComparator(CreateStylesheetFileAction.getLastSelectedType(project)));
        fileTypes.add((FileType)CssFileType.INSTANCE);
        for (Language dialect : CSSLanguage.INSTANCE.getDialects()) {
            LanguageFileType type = dialect.getAssociatedFileType();
            if (type == null) continue;
            fileTypes.add((FileType)type);
        }
        for (FileType type : fileTypes) {
            builder.addKind(CssBundle.message("dialog.kind.0.file", type.getName()), type.getIcon(), type.getName() + " File." + type.getDefaultExtension());
        }
    }

    private static FileType getLastSelectedType(Project project) {
        String lastSelectedTypeName = PropertiesComponent.getInstance((Project)project).getValue(LAST_SELECTED_TYPE_NAME);
        FileType lastSelectedType = lastSelectedTypeName != null ? FileTypeManager.getInstance().findFileTypeByName(lastSelectedTypeName) : null;
        return lastSelectedType != null ? lastSelectedType : CssFileType.INSTANCE;
    }

    protected PsiFile createFile(String name, String templateName, PsiDirectory dir) {
        PsiFile createdFile = super.createFile(name, templateName, dir);
        if (createdFile != null) {
            PropertiesComponent.getInstance((Project)createdFile.getProject()).setValue(LAST_SELECTED_TYPE_NAME, createdFile.getFileType().getName());
        }
        return createdFile;
    }

    protected String getActionName(PsiDirectory directory, @NotNull String newName, String templateName) {
        if (newName == null) {
            CreateStylesheetFileAction.$$$reportNull$$$0(3);
        }
        return CssBundle.message("action.name.create.stylesheet.0", newName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/css/actions/CreateStylesheetFileAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getActionName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class LastSelectedFileTypeComparator
    implements Comparator<FileType> {
        private final FileType myLastSelectedType;

        LastSelectedFileTypeComparator(FileType lastSelectedType) {
            this.myLastSelectedType = lastSelectedType;
        }

        @Override
        public int compare(@NotNull FileType o1, @NotNull FileType o2) {
            if (o1 == null) {
                LastSelectedFileTypeComparator.$$$reportNull$$$0(0);
            }
            if (o2 == null) {
                LastSelectedFileTypeComparator.$$$reportNull$$$0(1);
            }
            if (o1 == o2) {
                return 0;
            }
            if (o1 == this.myLastSelectedType) {
                return -1;
            }
            if (o2 == this.myLastSelectedType) {
                return 1;
            }
            return StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "o2";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/css/actions/CreateStylesheetFileAction$LastSelectedFileTypeComparator";
            objectArray[2] = "compare";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

